/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Param;
import com.craftaro.third_party.org.jooq.impl.AbstractField;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Internal;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.math.BigDecimal;

final class Round<T extends Number>
extends AbstractField<T> {
    private static final long serialVersionUID = -7273879239726265322L;
    private final Field<T> argument;
    private final Field<Integer> decimals;

    Round(Field<T> argument) {
        this(argument, null);
    }

    Round(Field<T> argument, Field<Integer> decimals) {
        super(Names.N_ROUND, argument.getDataType());
        this.argument = argument;
        this.decimals = decimals;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                if (this.decimals == null) {
                    ctx.visit(DSL.when(Internal.isub(this.argument, DSL.floor(this.argument)).lessThan(0.5), DSL.floor(this.argument)).otherwise(DSL.ceil(this.argument)));
                    return;
                }
                if (this.decimals instanceof Param) {
                    Integer decimalsValue = (Integer)((Param)this.decimals).getValue();
                    Param<BigDecimal> factor = DSL.val(BigDecimal.ONE.movePointRight(decimalsValue));
                    Field<T> mul = Internal.imul(this.argument, factor);
                    ctx.visit(DSL.when(Internal.isub(mul, DSL.floor(mul)).lessThan(0.5), Internal.idiv(DSL.floor(mul), factor)).otherwise(Internal.idiv(DSL.ceil(mul), factor)));
                    return;
                }
            }
            case POSTGRES: {
                if (this.decimals == null) {
                    ctx.visit(DSL.function("round", this.getDataType(), this.argument));
                } else {
                    ctx.visit(DSL.function("round", this.getDataType(), Tools.castIfNeeded(this.argument, BigDecimal.class), this.decimals));
                }
                return;
            }
        }
        if (this.decimals == null) {
            ctx.visit(DSL.function("round", this.getDataType(), this.argument));
        } else {
            ctx.visit(DSL.function("round", this.getDataType(), this.argument, this.decimals));
        }
    }
}

