/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Cursor;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.impl.AbstractResultQuery;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.Internal;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.tools.jdbc.JDBCUtils;
import com.craftaro.third_party.org.reactivestreams.Subscriber;
import com.craftaro.third_party.org.reactivestreams.Subscription;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

final class R2DBC {
    R2DBC() {
    }

    static final class BlockingRowCountSubscription
    extends AbstractSubscription<Integer> {
        final AbstractRowCountQuery query;

        BlockingRowCountSubscription(AbstractRowCountQuery query, Subscriber<? super Integer> subscriber) {
            super(subscriber);
            this.query = query;
        }

        @Override
        final void request0() {
            try {
                this.subscriber.onNext(this.query.execute());
                this.subscriber.onComplete();
            }
            catch (Throwable t) {
                this.subscriber.onError(t);
            }
        }

        @Override
        final void cancel0() {
        }
    }

    static final class BlockingRecordSubscription<R extends Record>
    extends AbstractSubscription<R> {
        private final AbstractResultQuery<R> query;
        private volatile Cursor<R> c;

        BlockingRecordSubscription(AbstractResultQuery<R> query, Subscriber<? super R> subscriber) {
            super(subscriber);
            this.query = query;
        }

        @Override
        final synchronized void request0() {
            try {
                if (this.c == null) {
                    this.c = this.query.fetchLazyNonAutoClosing();
                }
                while (this.requested.getAndUpdate(l -> Math.max(0L, l - 1L)) > 0L) {
                    R r = this.c.fetchNext();
                    if (r == null) {
                        this.subscriber.onComplete();
                        JDBCUtils.safeClose(this.c);
                        break;
                    }
                    this.subscriber.onNext(r);
                }
            }
            catch (Throwable t) {
                this.subscriber.onError(t);
                JDBCUtils.safeClose(this.c);
            }
        }

        @Override
        final void cancel0() {
            JDBCUtils.safeClose(this.c);
        }
    }

    static abstract class AbstractSubscription<T>
    implements Subscription {
        final AtomicBoolean completed = new AtomicBoolean();
        final AtomicLong requested = new AtomicLong();
        final Subscriber<? super T> subscriber;
        final Tools.ThreadGuard.Guard guard = new Tools.ThreadGuard.Guard();

        AbstractSubscription(Subscriber<? super T> subscriber) {
            this.subscriber = Internal.subscriber(subscriber::onSubscribe, subscriber::onNext, subscriber::onError, () -> {
                this.completed.set(true);
                subscriber.onComplete();
            });
        }

        @Override
        public final void request(long n) {
            if (n <= 0L) {
                this.subscriber.onError(new IllegalArgumentException("Rule 3.9 non-positive request signals are illegal"));
            } else if (!this.completed.get()) {
                this.requested.accumulateAndGet(n, (x, y) -> {
                    long r = x + y;
                    if (((x ^ r) & (y ^ r)) < 0L) {
                        return Long.MAX_VALUE;
                    }
                    return r;
                });
                Tools.ThreadGuard.run(this.guard, this::request0, () -> {});
            }
        }

        @Override
        public final void cancel() {
            if (!this.completed.getAndSet(true)) {
                this.cancel0();
            }
        }

        abstract void request0();

        abstract void cancel0();
    }
}

