/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.impl.AbstractWindowFunction;
import com.craftaro.third_party.org.jooq.impl.DSL;

final class PositionalWindowFunction<T>
extends AbstractWindowFunction<T> {
    private static final long serialVersionUID = -7318928420486422195L;
    private final PositionalFunctionType functionType;
    private final Field<T> arg;
    private final Field<Integer> offset;
    private final Field<T> defaultValue;

    PositionalWindowFunction(PositionalFunctionType functionType, Field<T> arg) {
        this(functionType, arg, null, null);
    }

    PositionalWindowFunction(PositionalFunctionType functionType, Field<T> arg, Field<Integer> offset, Field<T> defaultValue) {
        super(functionType.name, arg.getDataType());
        this.functionType = functionType;
        this.arg = arg;
        this.offset = offset;
        this.defaultValue = defaultValue;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.defaultValue == null) {
            this.accept0(ctx);
        } else {
            switch (ctx.family()) {
                default: 
            }
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        ctx.visit(this.functionType.name).sql('(');
        ctx.visit(this.arg);
        if (this.offset != null) {
            ctx.sql(", ").visit(this.offset);
        }
        if (this.defaultValue != null) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(", ").visit(this.defaultValue);
        }
        ctx.sql(')');
        this.acceptFromFirstOrLast(ctx);
        this.acceptNullTreatment(ctx);
        this.acceptOverClause(ctx);
    }

    final boolean isLeadOrLag() {
        return this.functionType == PositionalFunctionType.LEAD || this.functionType == PositionalFunctionType.LAG;
    }

    static enum PositionalFunctionType {
        LEAD,
        LAG,
        FIRST_VALUE,
        LAST_VALUE,
        NTH_VALUE;

        private final Name name = DSL.unquotedName(this.name());
    }
}

