/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.conf.TransformUnneededArithmeticExpressions;
import com.craftaro.third_party.org.jooq.impl.AbstractTransformable;
import com.craftaro.third_party.org.jooq.impl.ExpressionOperator;
import java.util.Set;

final class Neg<T>
extends AbstractTransformable<T> {
    private static final long serialVersionUID = 7624782102883057433L;
    private static final Set<SQLDialect> EMULATE_BIT_NOT = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final Set<SQLDialect> SUPPORT_BIT_NOT = SQLDialect.supportedBy(SQLDialect.H2);
    private final Field<T> field;
    private final boolean internal;
    private final ExpressionOperator operator;

    Neg(Field<T> field, boolean internal, ExpressionOperator operator) {
        super(operator.toName(), field.getDataType());
        this.field = field;
        this.internal = internal;
        this.operator = operator;
    }

    @Override
    public final Field<?> transform(TransformUnneededArithmeticExpressions transform) {
        return this;
    }

    @Override
    public final void accept0(Context<?> ctx) {
        SQLDialect family = ctx.family();
        if (this.operator == ExpressionOperator.BIT_NOT && EMULATE_BIT_NOT.contains((Object)ctx.dialect())) {
            ctx.sql("(0 - ").visit(this.field).sql(" - 1)");
        } else if (this.operator == ExpressionOperator.BIT_NOT && SUPPORT_BIT_NOT.contains((Object)ctx.dialect())) {
            ctx.sql("bitnot(").visit(this.field).sql(')');
        } else if (this.operator == ExpressionOperator.BIT_NOT && family == SQLDialect.FIREBIRD) {
            ctx.sql("bin_not(").visit(this.field).sql(')');
        } else {
            ctx.sql(this.operator.toSQL()).sql('(').visit(this.field).sql(')');
        }
    }
}

