/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.MigrationContext;
import com.craftaro.third_party.org.jooq.MigrationListener;
import com.craftaro.third_party.org.jooq.MigrationListenerProvider;
import com.craftaro.third_party.org.jooq.conf.InvocationOrder;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Arrays;

class MigrationListeners
implements MigrationListener {
    private final MigrationListener[] listeners;

    MigrationListeners(Configuration configuration) {
        MigrationListenerProvider[] providers = configuration.migrationListenerProviders();
        this.listeners = new MigrationListener[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            this.listeners[i] = providers[i].provide();
        }
    }

    @Override
    public final void migrationStart(MigrationContext ctx) {
        for (MigrationListener listener : ctx.settings().getMigrationListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.migrationStart(ctx);
        }
    }

    @Override
    public final void migrationEnd(MigrationContext ctx) {
        for (MigrationListener listener : ctx.settings().getMigrationListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.migrationEnd(ctx);
        }
    }

    @Override
    public final void queriesStart(MigrationContext ctx) {
        for (MigrationListener listener : ctx.settings().getMigrationListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.queriesStart(ctx);
        }
    }

    @Override
    public final void queriesEnd(MigrationContext ctx) {
        for (MigrationListener listener : ctx.settings().getMigrationListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.queriesEnd(ctx);
        }
    }

    @Override
    public final void queryStart(MigrationContext ctx) {
        for (MigrationListener listener : ctx.settings().getMigrationListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.queryStart(ctx);
        }
    }

    @Override
    public final void queryEnd(MigrationContext ctx) {
        for (MigrationListener listener : ctx.settings().getMigrationListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.queryEnd(ctx);
        }
    }
}

