/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Param;
import com.craftaro.third_party.org.jooq.RenderContext;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.conf.ParamType;
import com.craftaro.third_party.org.jooq.impl.AbstractQueryPart;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Internal;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.impl.Val;
import com.craftaro.third_party.org.jooq.tools.Convert;

final class Limit
extends AbstractQueryPart {
    private static final long serialVersionUID = 2053741242981425602L;
    private static final Param<Integer> ZERO = DSL.zero();
    private static final Param<Integer> ONE = DSL.one();
    private static final Param<Integer> MAX = DSL.inline(Integer.MAX_VALUE);
    Param<?> numberOfRows;
    private Param<?> numberOfRowsOrMax = MAX;
    Param<?> offset;
    private Param<?> offsetOrZero = ZERO;
    private Param<?> offsetPlusOne = ONE;
    private boolean rendersParams;
    boolean withTies;
    boolean percent;

    Limit() {
    }

    @Override
    public final void accept(Context<?> ctx) {
        ParamType paramType = ctx.paramType();
        RenderContext.CastMode castMode = ctx.castMode();
        switch (ctx.dialect()) {
            case CUBRID: {
                ctx.castMode(RenderContext.CastMode.NEVER).formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.offsetOrZero).sql(", ").visit(this.numberOfRowsOrMax).castMode(castMode);
                break;
            }
            case FIREBIRD: 
            case H2: 
            case DERBY: {
                if (ctx.family() == SQLDialect.H2 && !this.withTies() && !this.percent()) {
                    this.acceptDefault(ctx, castMode);
                    break;
                }
                this.acceptStandard(ctx, castMode);
                break;
            }
            case MARIADB: 
            case MYSQL: 
            case SQLITE: {
                ctx.castMode(RenderContext.CastMode.NEVER).formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.numberOfRowsOrMax);
                if (!this.offsetZero()) {
                    ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero);
                }
                ctx.castMode(castMode);
                break;
            }
            default: {
                this.acceptDefault(ctx, castMode);
            }
        }
    }

    private final void acceptStandard(Context<?> ctx, RenderContext.CastMode castMode) {
        ctx.castMode(RenderContext.CastMode.NEVER);
        if (!this.offsetZero()) {
            ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero).sql(' ').visit(Keywords.K_ROWS);
        }
        if (!this.limitZero()) {
            ctx.formatSeparator().visit(Keywords.K_FETCH_NEXT).sql(' ').visit(this.numberOfRows);
            if (this.percent) {
                ctx.sql(' ').visit(Keywords.K_PERCENT);
            }
            ctx.sql(' ').visit(this.withTies ? Keywords.K_ROWS_WITH_TIES : Keywords.K_ROWS_ONLY);
        }
        ctx.castMode(castMode);
    }

    private final void acceptDefault(Context<?> ctx, RenderContext.CastMode castMode) {
        ctx.castMode(RenderContext.CastMode.NEVER);
        if (!this.limitZero()) {
            ctx.formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.numberOfRows);
        }
        if (!this.offsetZero()) {
            ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero);
        }
        ctx.castMode(castMode);
    }

    final boolean limitZero() {
        return this.numberOfRows == null;
    }

    final boolean limitOne() {
        return !this.limitZero() && !this.withTies() && !this.percent() && Long.valueOf(1L).equals(this.numberOfRows.getValue());
    }

    final boolean offsetZero() {
        return this.offset == null;
    }

    final Field<?> getLowerRownum() {
        return this.offsetOrZero;
    }

    final Field<?> getUpperRownum() {
        return Internal.iadd(this.offsetOrZero, this.numberOfRowsOrMax);
    }

    final boolean isApplicable() {
        return this.offset != null || this.numberOfRows != null;
    }

    final boolean rendersParams() {
        return this.rendersParams;
    }

    final void setOffset(Number offset) {
        this.offset = DSL.val((Object)offset.longValue(), SQLDataType.BIGINT);
        this.offsetOrZero = this.offset;
        this.offsetPlusOne = DSL.val((Object)(offset.longValue() + 1L), SQLDataType.BIGINT);
    }

    final void setOffset(Param<?> offset) {
        this.offset = offset;
        this.offsetOrZero = offset;
        this.rendersParams = this.rendersParams |= offset.isInline();
    }

    final void setNumberOfRows(Number numberOfRows) {
        this.numberOfRows = DSL.val((Object)numberOfRows.longValue(), SQLDataType.BIGINT);
        this.numberOfRowsOrMax = this.numberOfRows;
    }

    final void setNumberOfRows(Param<?> numberOfRows) {
        this.numberOfRows = numberOfRows;
        this.numberOfRowsOrMax = numberOfRows;
        this.rendersParams |= numberOfRows.isInline();
    }

    final Long getNumberOfRows() {
        return Convert.convert((this.numberOfRows != null ? this.numberOfRows : this.numberOfRowsOrMax).getValue(), Long.TYPE);
    }

    final void setPercent(boolean percent) {
        this.percent = percent;
    }

    final boolean percent() {
        return this.percent;
    }

    final void setWithTies(boolean withTies) {
        this.withTies = withTies;
    }

    final boolean withTies() {
        return this.withTies;
    }

    final Limit from(Limit limit) {
        if (limit.numberOfRows != null) {
            if (this.numberOfRows == null) {
                this.setNumberOfRows(limit.numberOfRows);
            } else {
                this.setNumberOfRows(((Val)limit.numberOfRows).copy(Math.min(this.getNumberOfRows(), limit.getNumberOfRows())));
            }
        }
        if (limit.offset != null) {
            this.setOffset(limit.offset);
        }
        this.setPercent(limit.percent);
        this.setWithTies(limit.withTies);
        return this;
    }

    final void clear() {
        this.offset = null;
        this.numberOfRows = null;
        this.withTies = false;
        this.percent = false;
    }
}

