/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.JSONExistsOnStep;
import com.craftaro.third_party.org.jooq.Keyword;
import com.craftaro.third_party.org.jooq.impl.AbstractCondition;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.impl.Tools;

final class JSONExists
extends AbstractCondition
implements JSONExistsOnStep {
    private static final long serialVersionUID = 1772007627336725780L;
    private final Field<?> json;
    private final Field<String> path;

    JSONExists(Field<?> json, Field<String> path) {
        this(json, path, null);
    }

    private JSONExists(Field<?> json, Field<String> path, Behaviour onError) {
        this.json = json;
        this.path = path;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: {
                ctx.visit(Names.N_JSON_CONTAINS_PATH).sql('(').visit(this.json).sql(", 'one', ").visit(this.path).sql(')');
                break;
            }
            case POSTGRES: {
                ctx.visit(Names.N_JSONB_PATH_EXISTS).sql('(').visit(Tools.castIfNeeded(this.json, SQLDataType.JSONB)).sql(", ").visit(this.path).sql("::jsonpath)");
                break;
            }
            default: {
                ctx.visit(Keywords.K_JSON_EXISTS).sql('(').visit(this.json).sql(", ");
                ctx.visit(this.path);
                ctx.sql(')');
            }
        }
    }

    static enum Behaviour {
        ERROR,
        TRUE,
        FALSE,
        UNKNOWN;

        final Keyword keyword = DSL.keyword(this.name().toLowerCase());
    }
}

