/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Catalog;
import com.craftaro.third_party.org.jooq.Check;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Domain;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.ForeignKey;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Key;
import com.craftaro.third_party.org.jooq.Param;
import com.craftaro.third_party.org.jooq.Qualified;
import com.craftaro.third_party.org.jooq.Schema;
import com.craftaro.third_party.org.jooq.Sequence;
import com.craftaro.third_party.org.jooq.SortField;
import com.craftaro.third_party.org.jooq.SortOrder;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TableOptions;
import com.craftaro.third_party.org.jooq.UniqueKey;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.tools.Convert;
import com.craftaro.third_party.org.jooq.tools.StringUtils;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.CheckConstraint;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.Column;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.DomainConstraint;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.IndexColumnUsage;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.InformationSchema;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.KeyColumnUsage;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.ReferentialConstraint;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.TableConstraint;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.TableConstraintType;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.TableType;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.View;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class InformationSchemaExport {
    static final InformationSchema exportTables(Configuration configuration, List<Table<?>> tables) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet<Catalog> includedCatalogs = new LinkedHashSet<Catalog>();
        LinkedHashSet<Schema> includedSchemas = new LinkedHashSet<Schema>();
        LinkedHashSet includedTables = new LinkedHashSet(tables);
        for (Table<Object> t : tables) {
            if (t.getSchema() == null) continue;
            includedSchemas.add(t.getSchema());
        }
        for (Schema s : includedSchemas) {
            if (s.getCatalog() == null) continue;
            includedCatalogs.add(s.getCatalog());
        }
        for (Catalog c2 : includedCatalogs) {
            InformationSchemaExport.exportCatalog0(result, c2);
        }
        for (Schema s : includedSchemas) {
            InformationSchemaExport.exportSchema0(result, s);
        }
        for (Table<Object> t : tables) {
            InformationSchemaExport.exportTable0(configuration, result, t, includedTables);
        }
        return result;
    }

    static final InformationSchema exportSchemas(Configuration configuration, List<Schema> schemas) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet<Catalog> includedCatalogs = new LinkedHashSet<Catalog>();
        LinkedHashSet includedTables = new LinkedHashSet();
        for (Schema s : schemas) {
            if (s.getCatalog() != null) {
                includedCatalogs.add(s.getCatalog());
            }
            for (Table<?> table : s.getTables()) {
                includedTables.add(table);
            }
        }
        for (Catalog c2 : includedCatalogs) {
            InformationSchemaExport.exportCatalog0(result, c2);
        }
        for (Schema s : schemas) {
            InformationSchemaExport.exportSchema0(result, s);
            for (Domain domain : s.getDomains()) {
                InformationSchemaExport.exportDomain0(configuration, result, domain);
            }
            for (Table table : s.getTables()) {
                InformationSchemaExport.exportTable0(configuration, result, table, includedTables);
            }
            for (Sequence sequence : s.getSequences()) {
                InformationSchemaExport.exportSequence0(configuration, result, sequence);
            }
        }
        return result;
    }

    static final InformationSchema exportCatalogs(Configuration configuration, List<Catalog> catalogs) {
        InformationSchema result = new InformationSchema();
        LinkedHashSet includedTables = new LinkedHashSet();
        for (Catalog c2 : catalogs) {
            for (Schema s : c2.getSchemas()) {
                for (Table<?> table : s.getTables()) {
                    includedTables.add(table);
                }
            }
        }
        for (Catalog c2 : catalogs) {
            InformationSchemaExport.exportCatalog0(result, c2);
            for (Schema s : c2.getSchemas()) {
                InformationSchemaExport.exportSchema0(result, s);
                for (Domain domain : s.getDomains()) {
                    InformationSchemaExport.exportDomain0(configuration, result, domain);
                }
                for (Table table : s.getTables()) {
                    InformationSchemaExport.exportTable0(configuration, result, table, includedTables);
                }
                for (Sequence sequence : s.getSequences()) {
                    InformationSchemaExport.exportSequence0(configuration, result, sequence);
                }
            }
        }
        return result;
    }

    private static final void exportDomain0(Configuration configuration, InformationSchema result, Domain<?> d) {
        com.craftaro.third_party.org.jooq.util.xml.jaxb.Domain id = new com.craftaro.third_party.org.jooq.util.xml.jaxb.Domain();
        String catalogName = InformationSchemaExport.catalogName(d);
        String schemaName = InformationSchemaExport.schemaName(d);
        String domainName = d.getName();
        if (!StringUtils.isBlank(catalogName)) {
            id.setDomainCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            id.setDomainSchema(schemaName);
        }
        id.setDomainName(domainName);
        id.setDataType(d.getDataType().getTypeName(configuration));
        if (d.getDataType().lengthDefined()) {
            id.setCharacterMaximumLength(d.getDataType().length());
        }
        if (d.getDataType().precisionDefined()) {
            id.setNumericPrecision(d.getDataType().precision());
        }
        if (d.getDataType().scaleDefined()) {
            id.setNumericScale(d.getDataType().scale());
        }
        result.getDomains().add(id);
        for (Check<?> c2 : d.getChecks()) {
            DomainConstraint idc = new DomainConstraint();
            CheckConstraint icc = new CheckConstraint();
            if (!StringUtils.isBlank(catalogName)) {
                idc.setDomainCatalog(catalogName);
                idc.setConstraintCatalog(catalogName);
                icc.setConstraintCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                idc.setDomainSchema(schemaName);
                idc.setConstraintSchema(schemaName);
                icc.setConstraintSchema(schemaName);
            }
            idc.setDomainName(domainName);
            idc.setConstraintName(c2.getName());
            icc.setConstraintName(c2.getName());
            icc.setCheckClause(configuration.dsl().render(c2.condition()));
            result.getDomainConstraints().add(idc);
            result.getCheckConstraints().add(icc);
        }
    }

    private static final void exportSequence0(Configuration configuration, InformationSchema result, Sequence<?> q) {
        com.craftaro.third_party.org.jooq.util.xml.jaxb.Sequence iq = new com.craftaro.third_party.org.jooq.util.xml.jaxb.Sequence();
        String catalogName = InformationSchemaExport.catalogName(q);
        String schemaName = InformationSchemaExport.schemaName(q);
        if (!StringUtils.isBlank(catalogName)) {
            iq.setSequenceCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            iq.setSequenceSchema(schemaName);
        }
        iq.setSequenceName(q.getName());
        iq.setDataType(q.getDataType().getTypeName(configuration));
        if (q.getDataType().lengthDefined()) {
            iq.setCharacterMaximumLength(q.getDataType().length());
        }
        if (q.getDataType().precisionDefined()) {
            iq.setNumericPrecision(q.getDataType().precision());
        }
        if (q.getDataType().scaleDefined()) {
            iq.setNumericScale(q.getDataType().scale());
        }
        if (q.getStartWith() != null) {
            iq.setStartValue(Convert.convert(q.getStartWith() instanceof Param ? ((Param)q.getStartWith()).getValue() : q.getStartWith().toString(), BigInteger.class));
        }
        if (q.getIncrementBy() != null) {
            iq.setIncrement(Convert.convert(q.getIncrementBy() instanceof Param ? ((Param)q.getIncrementBy()).getValue() : q.getIncrementBy().toString(), BigInteger.class));
        }
        if (q.getMinvalue() != null) {
            iq.setMinimumValue(Convert.convert(q.getMinvalue() instanceof Param ? ((Param)q.getMinvalue()).getValue() : q.getMinvalue().toString(), BigInteger.class));
        }
        if (q.getMaxvalue() != null) {
            iq.setMaximumValue(Convert.convert(q.getMaxvalue() instanceof Param ? ((Param)q.getMaxvalue()).getValue() : q.getMaxvalue().toString(), BigInteger.class));
        }
        iq.setCycleOption(q.getCycle());
        if (q.getCache() != null) {
            iq.setCache(Convert.convert(q.getCache() instanceof Param ? ((Param)q.getCache()).getValue() : q.getCache().toString(), BigInteger.class));
        }
        result.getSequences().add(iq);
    }

    private static final void exportCatalog0(InformationSchema result, Catalog c2) {
        com.craftaro.third_party.org.jooq.util.xml.jaxb.Catalog ic = new com.craftaro.third_party.org.jooq.util.xml.jaxb.Catalog();
        if (!StringUtils.isBlank(c2.getName())) {
            ic.setCatalogName(c2.getName());
            ic.setComment(c2.getComment());
            result.getCatalogs().add(ic);
        }
    }

    private static final void exportSchema0(InformationSchema result, Schema s) {
        com.craftaro.third_party.org.jooq.util.xml.jaxb.Schema is = new com.craftaro.third_party.org.jooq.util.xml.jaxb.Schema();
        String catalogName = InformationSchemaExport.catalogName(s);
        if (!StringUtils.isBlank(catalogName)) {
            is.setCatalogName(catalogName);
        }
        if (!StringUtils.isBlank(s.getName())) {
            is.setSchemaName(s.getName());
            is.setComment(s.getComment());
            result.getSchemata().add(is);
        }
    }

    private static final void exportTable0(Configuration configuration, InformationSchema result, Table<?> t, Set<Table<?>> includedTables) {
        com.craftaro.third_party.org.jooq.util.xml.jaxb.Table it = new com.craftaro.third_party.org.jooq.util.xml.jaxb.Table();
        String catalogName = InformationSchemaExport.catalogName(t);
        String schemaName = InformationSchemaExport.schemaName(t);
        if (!StringUtils.isBlank(catalogName)) {
            it.setTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            it.setTableSchema(schemaName);
        }
        switch (t.getOptions().type()) {
            case MATERIALIZED_VIEW: 
            case VIEW: {
                it.setTableType(TableType.VIEW);
                break;
            }
            case TEMPORARY: {
                it.setTableType(TableType.GLOBAL_TEMPORARY);
                break;
            }
            default: {
                it.setTableType(TableType.BASE_TABLE);
            }
        }
        it.setTableName(t.getName());
        it.setComment(t.getComment());
        result.getTables().add(it);
        if (t.getOptions().type() == TableOptions.TableType.VIEW) {
            View iv = new View();
            if (!StringUtils.isBlank(catalogName)) {
                iv.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                iv.setTableSchema(schemaName);
            }
            iv.setTableName(t.getName());
            iv.setViewDefinition(t.getOptions().source());
            result.getViews().add(iv);
        }
        Field<?>[] fields = t.fields();
        for (int i = 0; i < fields.length; ++i) {
            Field<?> field = fields[i];
            Column ic = new Column();
            if (!StringUtils.isBlank(catalogName)) {
                ic.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                ic.setTableSchema(schemaName);
            }
            ic.setTableName(t.getName());
            ic.setColumnName(field.getName());
            ic.setComment(field.getComment());
            ic.setDataType(field.getDataType().getTypeName(configuration));
            if (field.getDataType().lengthDefined()) {
                ic.setCharacterMaximumLength(field.getDataType().length());
            }
            if (field.getDataType().precisionDefined()) {
                ic.setNumericPrecision(field.getDataType().precision());
            }
            if (field.getDataType().scaleDefined()) {
                ic.setNumericScale(field.getDataType().scale());
            }
            ic.setColumnDefault(DSL.using(configuration).render(field.getDataType().defaultValue()));
            ic.setIsNullable(field.getDataType().nullable());
            ic.setOrdinalPosition(i + 1);
            result.getColumns().add(ic);
        }
        for (UniqueKey<?> uniqueKey : t.getKeys()) {
            InformationSchemaExport.exportKey0(result, t, uniqueKey, uniqueKey.isPrimary() ? TableConstraintType.PRIMARY_KEY : TableConstraintType.UNIQUE);
        }
        for (ForeignKey foreignKey : t.getReferences()) {
            if (!includedTables.contains(foreignKey.getKey().getTable())) continue;
            InformationSchemaExport.exportKey0(result, t, foreignKey, TableConstraintType.FOREIGN_KEY);
        }
        for (Check check : t.getChecks()) {
            if (!includedTables.contains(check.getTable())) continue;
            InformationSchemaExport.exportCheck0(configuration, result, t, check);
        }
        for (Index index : t.getIndexes()) {
            InformationSchemaExport.exportIndex0(result, t, index);
        }
    }

    private static final void exportCheck0(Configuration configuration, InformationSchema result, Table<?> t, Check<?> chk) {
        InformationSchemaExport.exportTableConstraint(result, t, chk.getName(), TableConstraintType.CHECK);
        CheckConstraint c2 = new CheckConstraint();
        String catalogName = InformationSchemaExport.catalogName(t);
        String schemaName = InformationSchemaExport.schemaName(t);
        if (!StringUtils.isBlank(catalogName)) {
            c2.setConstraintCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            c2.setConstraintSchema(schemaName);
        }
        c2.setConstraintName(chk.getName());
        c2.setCheckClause(configuration.dsl().render(chk.condition()));
        result.getCheckConstraints().add(c2);
    }

    private static final void exportIndex0(InformationSchema result, Table<?> t, Index index) {
        com.craftaro.third_party.org.jooq.util.xml.jaxb.Index i = new com.craftaro.third_party.org.jooq.util.xml.jaxb.Index();
        String catalogName = InformationSchemaExport.catalogName(t);
        String schemaName = InformationSchemaExport.schemaName(t);
        if (!StringUtils.isBlank(catalogName)) {
            i.withIndexCatalog(catalogName).withTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            i.withIndexSchema(schemaName).withTableSchema(schemaName);
        }
        i.setIndexName(index.getName());
        i.setTableName(t.getName());
        i.setIsUnique(index.getUnique());
        result.getIndexes().add(i);
        int position = 1;
        for (SortField<?> sortField : index.getFields()) {
            IndexColumnUsage ic = new IndexColumnUsage();
            if (!StringUtils.isBlank(catalogName)) {
                ic.withIndexCatalog(catalogName).withTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                ic.withIndexSchema(schemaName).withTableSchema(schemaName);
            }
            ic.setIndexName(index.getName());
            ic.setTableName(t.getName());
            ic.setOrdinalPosition(position++);
            ic.setColumnName(sortField.getName());
            ic.setIsDescending(sortField.getOrder() == SortOrder.DESC);
            result.getIndexColumnUsages().add(ic);
        }
    }

    private static final void exportKey0(InformationSchema result, Table<?> t, Key<?> key, TableConstraintType constraintType) {
        InformationSchemaExport.exportTableConstraint(result, t, key.getName(), constraintType);
        String catalogName = InformationSchemaExport.catalogName(t);
        String schemaName = InformationSchemaExport.schemaName(t);
        int i = 0;
        for (Field field : key.getFields()) {
            KeyColumnUsage kc = new KeyColumnUsage();
            if (!StringUtils.isBlank(catalogName)) {
                kc.setConstraintCatalog(catalogName);
                kc.setTableCatalog(catalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                kc.setConstraintSchema(schemaName);
                kc.setTableSchema(schemaName);
            }
            kc.setColumnName(field.getName());
            kc.setTableName(t.getName());
            kc.setOrdinalPosition(++i);
            kc.setConstraintName(key.getName());
            result.getKeyColumnUsages().add(kc);
        }
        if (constraintType == TableConstraintType.FOREIGN_KEY) {
            ReferentialConstraint rc = new ReferentialConstraint();
            UniqueKey uniqueKey = ((ForeignKey)key).getKey();
            String ukCatalogName = InformationSchemaExport.catalogName(uniqueKey.getTable());
            String ukSchemaName = InformationSchemaExport.schemaName(uniqueKey.getTable());
            if (!StringUtils.isBlank(catalogName)) {
                rc.setConstraintCatalog(catalogName);
            }
            if (!StringUtils.isBlank(ukCatalogName)) {
                rc.setUniqueConstraintCatalog(ukCatalogName);
            }
            if (!StringUtils.isBlank(schemaName)) {
                rc.setConstraintSchema(schemaName);
            }
            if (!StringUtils.isBlank(ukSchemaName)) {
                rc.setUniqueConstraintSchema(ukSchemaName);
            }
            rc.setConstraintName(key.getName());
            rc.setUniqueConstraintName(uniqueKey.getName());
            result.getReferentialConstraints().add(rc);
        }
    }

    private static final void exportTableConstraint(InformationSchema result, Table<?> t, String constraintName, TableConstraintType constraintType) {
        TableConstraint tc = new TableConstraint();
        String catalogName = InformationSchemaExport.catalogName(t);
        String schemaName = InformationSchemaExport.schemaName(t);
        tc.setConstraintName(constraintName);
        tc.setConstraintType(constraintType);
        if (!StringUtils.isBlank(catalogName)) {
            tc.withConstraintCatalog(catalogName).withTableCatalog(catalogName);
        }
        if (!StringUtils.isBlank(schemaName)) {
            tc.withConstraintSchema(schemaName).withTableSchema(schemaName);
        }
        tc.setTableName(t.getName());
        result.getTableConstraints().add(tc);
    }

    private static final String catalogName(Schema s) {
        return s.getCatalog() == null ? null : s.getCatalog().getName();
    }

    private static final String catalogName(Qualified q) {
        return q.getCatalog() == null ? null : q.getCatalog().getName();
    }

    private static final String schemaName(Qualified q) {
        return q.getSchema() == null ? null : q.getSchema().getName();
    }

    private InformationSchemaExport() {
    }
}

