/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Keyword;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.AbstractQueryPart;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.QueryPartCollectionView;
import com.craftaro.third_party.org.jooq.impl.QueryPartList;
import com.craftaro.third_party.org.jooq.impl.TableList;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class ForLock
extends AbstractQueryPart {
    private static final long serialVersionUID = 5315134153342265917L;
    private static final Set<SQLDialect> NO_SUPPORT_FOR_UPDATE_QUALIFIED = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB);
    private static final Set<SQLDialect> NO_SUPPORT_STANDARD_FOR_SHARE = SQLDialect.supportedUntil(SQLDialect.MARIADB);
    QueryPartList<Field<?>> forLockOf;
    TableList forLockOfTables;
    ForLockMode forLockMode;
    ForLockWaitMode forLockWaitMode;
    int forLockWait;

    ForLock() {
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (this.forLockMode) {
            case UPDATE: {
                ctx.formatSeparator().visit(Keywords.K_FOR).sql(' ').visit(this.forLockMode.toKeyword());
                break;
            }
            case SHARE: {
                if (NO_SUPPORT_STANDARD_FOR_SHARE.contains((Object)ctx.dialect())) {
                    ctx.formatSeparator().visit(Keywords.K_LOCK_IN_SHARE_MODE);
                    break;
                }
                ctx.formatSeparator().visit(Keywords.K_FOR).sql(' ').visit(this.forLockMode.toKeyword());
                break;
            }
            default: {
                ctx.formatSeparator().visit(Keywords.K_FOR).sql(' ').visit(this.forLockMode.toKeyword());
            }
        }
        if (Tools.isNotEmpty(this.forLockOf)) {
            boolean unqualified = NO_SUPPORT_FOR_UPDATE_QUALIFIED.contains((Object)ctx.dialect());
            boolean qualify = ctx.qualify();
            if (unqualified) {
                ctx.qualify(false);
            }
            ctx.sql(' ').visit(Keywords.K_OF).sql(' ').visit(this.forLockOf);
            if (unqualified) {
                ctx.qualify(qualify);
            }
        } else if (Tools.isNotEmpty(this.forLockOfTables)) {
            ctx.sql(' ').visit(Keywords.K_OF).sql(' ');
            switch (ctx.family()) {
                case DERBY: {
                    this.forLockOfTables.toSQLFields(ctx);
                    break;
                }
                default: {
                    ctx.visit(QueryPartCollectionView.wrap(this.forLockOfTables).qualify(false).indentSize(0));
                }
            }
        }
        if (ctx.family() == SQLDialect.FIREBIRD) {
            ctx.sql(' ').visit(Keywords.K_WITH_LOCK);
        }
        if (this.forLockWaitMode != null) {
            ctx.sql(' ');
            ctx.visit(this.forLockWaitMode.toKeyword());
            if (this.forLockWaitMode == ForLockWaitMode.WAIT) {
                ctx.sql(' ');
                ctx.sql(this.forLockWait);
            }
        }
    }

    static enum ForLockWaitMode {
        WAIT("wait"),
        NOWAIT("nowait"),
        SKIP_LOCKED("skip locked");

        private final Keyword keyword;

        private ForLockWaitMode(String sql) {
            this.keyword = DSL.keyword(sql);
        }

        public final Keyword toKeyword() {
            return this.keyword;
        }
    }

    static enum ForLockMode {
        UPDATE("update"),
        NO_KEY_UPDATE("no key update"),
        SHARE("share"),
        KEY_SHARE("key share");

        private final Keyword keyword;

        private ForLockMode(String sql) {
            this.keyword = DSL.keyword(sql);
        }

        public final Keyword toKeyword() {
            return this.keyword;
        }
    }
}

