/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DatePart;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Param;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.conf.TransformUnneededArithmeticExpressions;
import com.craftaro.third_party.org.jooq.exception.DataTypeException;
import com.craftaro.third_party.org.jooq.impl.AbstractField;
import com.craftaro.third_party.org.jooq.impl.AbstractTransformable;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.DateAdd;
import com.craftaro.third_party.org.jooq.impl.ExpressionOperator;
import com.craftaro.third_party.org.jooq.impl.Internal;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.types.DayToSecond;
import com.craftaro.third_party.org.jooq.types.Interval;
import com.craftaro.third_party.org.jooq.types.YearToMonth;
import com.craftaro.third_party.org.jooq.types.YearToSecond;
import java.sql.Timestamp;
import java.util.Set;
import java.util.regex.Pattern;

final class Expression<T>
extends AbstractTransformable<T> {
    private static final long serialVersionUID = -5522799070693019771L;
    private static final Set<SQLDialect> SUPPORT_BIT_AND = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.HSQLDB);
    private static final Set<SQLDialect> SUPPORT_BIT_OR_XOR = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.HSQLDB);
    private static final Set<SQLDialect> EMULATE_BIT_XOR = SQLDialect.supportedBy(SQLDialect.SQLITE);
    private static final Set<SQLDialect> EMULATE_SHR_SHL = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final Set<SQLDialect> HASH_OP_FOR_BIT_XOR = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private static final Set<SQLDialect> SUPPORT_YEAR_TO_SECOND = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private final ExpressionOperator operator;
    private final boolean internal;
    private final Field<T> lhs;
    private final Field<?> rhs;
    private static final Pattern TRUNC_TO_MICROS = Pattern.compile("([^.]*\\.\\d{0,6})\\d{0,3}");

    Expression(ExpressionOperator operator, boolean internal, Field<T> lhs, Field<?> rhs) {
        super(DSL.name(operator.toSQL()), lhs.getDataType());
        this.operator = operator;
        this.internal = internal;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    final void accept0(Context<?> ctx) {
        SQLDialect family = ctx.family();
        if (ExpressionOperator.BIT_AND == this.operator && SUPPORT_BIT_AND.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.function("bitand", this.getDataType(), this.lhs, this.rhs));
        } else if (ExpressionOperator.BIT_AND == this.operator && SQLDialect.FIREBIRD == family) {
            ctx.visit(DSL.function("bin_and", this.getDataType(), this.lhs, this.rhs));
        } else if (ExpressionOperator.BIT_XOR == this.operator && SUPPORT_BIT_OR_XOR.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.function("bitxor", this.getDataType(), this.lhs, this.rhs));
        } else if (ExpressionOperator.BIT_XOR == this.operator && SQLDialect.FIREBIRD == family) {
            ctx.visit(DSL.function("bin_xor", this.getDataType(), this.lhs, this.rhs));
        } else if (ExpressionOperator.BIT_OR == this.operator && SUPPORT_BIT_OR_XOR.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.function("bitor", this.getDataType(), this.lhs, this.rhs));
        } else if (ExpressionOperator.BIT_OR == this.operator && SQLDialect.FIREBIRD == family) {
            ctx.visit(DSL.function("bin_or", this.getDataType(), this.lhs, this.rhs));
        } else if (ExpressionOperator.BIT_XOR == this.operator && EMULATE_BIT_XOR.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.bitAnd(DSL.bitNot(DSL.bitAnd(this.lhsAsNumber(), this.rhsAsNumber())), DSL.bitOr(this.lhsAsNumber(), this.rhsAsNumber())));
        } else if (this.operator == ExpressionOperator.SHL || this.operator == ExpressionOperator.SHR) {
            if (family == SQLDialect.H2) {
                ctx.visit(DSL.function(ExpressionOperator.SHL == this.operator ? "lshift" : "rshift", this.getDataType(), this.lhs, this.rhs));
            } else if (SQLDialect.FIREBIRD == family) {
                ctx.visit(DSL.function(ExpressionOperator.SHL == this.operator ? "bin_shl" : "bin_shr", this.getDataType(), this.lhs, this.rhs));
            } else if (ExpressionOperator.SHL == this.operator && EMULATE_SHR_SHL.contains((Object)ctx.dialect())) {
                ctx.visit(Internal.imul(this.lhs, Tools.castIfNeeded(DSL.power(DSL.two(), this.rhsAsNumber()), this.lhs)));
            } else if (ExpressionOperator.SHR == this.operator && EMULATE_SHR_SHL.contains((Object)ctx.dialect())) {
                ctx.visit(Internal.idiv(this.lhs, Tools.castIfNeeded(DSL.power(DSL.two(), this.rhsAsNumber()), this.lhs)));
            } else {
                ctx.visit(new DefaultExpression<T>(this.lhs, this.operator, this.rhs));
            }
        } else if (ExpressionOperator.BIT_NAND == this.operator) {
            ctx.visit(DSL.bitNot(DSL.bitAnd(this.lhsAsNumber(), this.rhsAsNumber())));
        } else if (ExpressionOperator.BIT_NOR == this.operator) {
            ctx.visit(DSL.bitNot(DSL.bitOr(this.lhsAsNumber(), this.rhsAsNumber())));
        } else if (ExpressionOperator.BIT_XNOR == this.operator) {
            ctx.visit(DSL.bitNot(DSL.bitXor(this.lhsAsNumber(), this.rhsAsNumber())));
        } else if ((ExpressionOperator.ADD == this.operator || ExpressionOperator.SUBTRACT == this.operator) && this.lhs.getDataType().isDateTime() && (this.rhs.getDataType().isNumeric() || this.rhs.getDataType().isInterval())) {
            ctx.visit(new DateExpression<T>(this.lhs, this.operator, this.rhs));
        } else {
            ctx.visit(new DefaultExpression<T>(this.lhs, this.operator, this.rhs));
        }
    }

    @Override
    public final Field<?> transform(TransformUnneededArithmeticExpressions transform) {
        return this;
    }

    private final Field<Number> lhsAsNumber() {
        return this.lhs;
    }

    private final Field<Number> rhsAsNumber() {
        return this.rhs;
    }

    private static class DefaultExpression<T>
    extends AbstractField<T> {
        private static final long serialVersionUID = -5105004317793995419L;
        private final Field<T> lhs;
        private final ExpressionOperator operator;
        private final Field<?> rhs;

        DefaultExpression(Field<T> lhs, ExpressionOperator operator, Field<?> rhs) {
            super(operator.toName(), lhs.getDataType());
            this.lhs = lhs;
            this.operator = operator;
            this.rhs = rhs;
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.sql('(');
            DefaultExpression.accept0(ctx, this.operator, this.lhs, this.rhs);
            ctx.sql(')');
        }

        private static final void accept0(Context<?> ctx, ExpressionOperator operator, Field<?> lhs, Field<?> rhs) {
            String op = operator.toSQL();
            if (operator == ExpressionOperator.BIT_XOR && HASH_OP_FOR_BIT_XOR.contains((Object)ctx.dialect())) {
                op = "#";
            }
            boolean associativity = operator.associative() && lhs.getDataType().equals(rhs.getDataType());
            DefaultExpression.accept1(ctx, operator, lhs, associativity);
            ctx.sql(' ').sql(op).sql(' ');
            DefaultExpression.accept1(ctx, operator, rhs, associativity);
        }

        private static final void accept1(Context<?> ctx, ExpressionOperator operator, Field<?> field, boolean associativity) {
            Expression expr;
            if (associativity && field instanceof Expression && operator == (expr = (Expression)field).operator) {
                DefaultExpression.accept0(ctx, expr.operator, expr.lhs, expr.rhs);
                return;
            }
            ctx.visit(field);
        }
    }

    private static class DateExpression<T>
    extends AbstractField<T> {
        private static final long serialVersionUID = 3160679741902222262L;
        private final Field<T> lhs;
        private final ExpressionOperator operator;
        private final Field<?> rhs;

        DateExpression(Field<T> lhs, ExpressionOperator operator, Field<?> rhs) {
            super(DSL.name(operator.toSQL()), lhs.getDataType());
            this.lhs = lhs;
            this.operator = operator;
            this.rhs = rhs;
        }

        private final <U> Field<U> p(U u) {
            Param<U> result = DSL.val(u);
            if (((Param)this.rhs).isInline()) {
                result.setInline(true);
            }
            return result;
        }

        @Override
        public final void accept(Context<?> ctx) {
            if (this.rhs.getType() == YearToSecond.class && !SUPPORT_YEAR_TO_SECOND.contains((Object)ctx.dialect())) {
                this.acceptYTSExpression(ctx);
            } else if (this.rhs.getDataType().isInterval()) {
                this.acceptIntervalExpression(ctx);
            } else {
                this.acceptNumberExpression(ctx);
            }
        }

        private final void acceptYTSExpression(Context<?> ctx) {
            if (this.rhs instanceof Param) {
                YearToSecond yts = this.rhsAsYTS();
                ctx.visit(new DateExpression<T>(new DateExpression<T>(this.lhs, this.operator, this.p(yts.getYearToMonth())), this.operator, this.p(yts.getDayToSecond())));
            } else {
                this.acceptIntervalExpression(ctx);
            }
        }

        private final void acceptIntervalExpression(Context<?> ctx) {
            SQLDialect family = ctx.family();
            int sign = this.operator == ExpressionOperator.ADD ? 1 : -1;
            switch (family) {
                case CUBRID: 
                case MARIADB: 
                case MYSQL: {
                    Interval interval = this.rhsAsInterval();
                    if (this.operator == ExpressionOperator.SUBTRACT) {
                        interval = interval.neg();
                    }
                    if (this.rhs.getType() == YearToMonth.class) {
                        ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(Tools.field((Object)interval, SQLDataType.VARCHAR)).sql(' ').visit(Keywords.K_YEAR_MONTH).sql(')');
                        break;
                    }
                    if (family == SQLDialect.CUBRID) {
                        ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(Tools.field((Object)interval, SQLDataType.VARCHAR)).sql(' ').visit(Keywords.K_DAY_MILLISECOND).sql(')');
                        break;
                    }
                    ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(Tools.field((Object)TRUNC_TO_MICROS.matcher("" + interval).replaceAll("$1"), SQLDataType.VARCHAR)).sql(' ').visit(Keywords.K_DAY_MICROSECOND).sql(')');
                    break;
                }
                case DERBY: {
                    boolean needsCast;
                    boolean bl = needsCast = this.getDataType().getType() != Timestamp.class;
                    if (needsCast) {
                        ctx.visit(Keywords.K_CAST).sql('(');
                    }
                    if (this.rhs.getType() == YearToMonth.class) {
                        ctx.sql("{fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(Names.N_SQL_TSI_MONTH).sql(", ").visit(this.p(sign * this.rhsAsYTM().intValue())).sql(", ").visit(this.lhs).sql(") }");
                    } else {
                        ctx.sql("{fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(Names.N_SQL_TSI_SECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getTotalSeconds())).sql(", {fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(ctx.family() == SQLDialect.DERBY ? Names.N_SQL_TSI_FRAC_SECOND : Names.N_SQL_TSI_MILLI_SECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getMilli() * (ctx.family() == SQLDialect.DERBY ? 1000000L : 1L))).sql(", ").visit(this.lhs).sql(") }) }");
                    }
                    if (!needsCast) break;
                    ctx.sql(' ').visit(Keywords.K_AS).sql(' ').visit(DSL.keyword(this.getDataType().getCastTypeName(ctx.configuration()))).sql(')');
                    break;
                }
                case FIREBIRD: {
                    if (this.rhs.getType() == YearToMonth.class) {
                        ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_MONTH).sql(", ").visit(this.p(sign * this.rhsAsYTM().intValue())).sql(", ").visit(this.lhs).sql(')');
                        break;
                    }
                    if (this.rhsAsDTS().getMilli() > 0) {
                        ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_MILLISECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getMilli())).sql(", ").visit(Names.N_DATEADD).sql('(').visit(Keywords.K_SECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getTotalSeconds())).sql(", ").visit(this.lhs).sql(')').sql(')');
                        break;
                    }
                    ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_SECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getTotalSeconds())).sql(", ").visit(this.lhs).sql(')');
                    break;
                }
                case SQLITE: {
                    boolean ytm = this.rhs.getType() == YearToMonth.class;
                    Field<Object> interval = this.p(ytm ? (double)this.rhsAsYTM().intValue() : this.rhsAsDTS().getTotalSeconds());
                    if (sign < 0) {
                        interval = interval.neg();
                    }
                    interval = interval.concat(DSL.inline(ytm ? " months" : " seconds"));
                    ctx.visit(Names.N_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.lhs).sql(", ").visit(interval).sql(')');
                    break;
                }
                default: {
                    ctx.visit(new DefaultExpression<T>(this.lhs, this.operator, this.rhs));
                }
            }
        }

        private final void acceptNumberExpression(Context<?> ctx) {
            switch (ctx.family()) {
                case FIREBIRD: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_DAY).sql(", ").visit(this.rhsAsNumber()).sql(", ").visit(this.lhs).sql(')');
                        break;
                    }
                    ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_DAY).sql(", ").visit(this.rhsAsNumber().neg()).sql(", ").visit(this.lhs).sql(')');
                    break;
                }
                case HSQLDB: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(this.lhs.add(DSL.field("({0}) day", this.rhsAsNumber())));
                        break;
                    }
                    ctx.visit(this.lhs.sub(DSL.field("({0}) day", this.rhsAsNumber())));
                    break;
                }
                case DERBY: {
                    boolean needsCast;
                    boolean bl = needsCast = this.getDataType().getType() != Timestamp.class;
                    if (needsCast) {
                        ctx.visit(Keywords.K_CAST).sql('(');
                    }
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.sql("{fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(DSL.keyword("sql_tsi_day")).sql(", ").visit(this.rhsAsNumber()).sql(", ").visit(this.lhs).sql(") }");
                    } else {
                        ctx.sql("{fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(DSL.keyword("sql_tsi_day")).sql(", ").visit(this.rhsAsNumber().neg()).sql(", ").visit(this.lhs).sql(") }");
                    }
                    if (!needsCast) break;
                    ctx.sql(' ').visit(Keywords.K_AS).sql(' ').visit(DSL.keyword(this.getDataType().getCastTypeName(ctx.configuration()))).sql(')');
                    break;
                }
                case CUBRID: 
                case MARIADB: 
                case MYSQL: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(this.rhsAsNumber()).sql(' ').visit(Keywords.K_DAY).sql(')');
                        break;
                    }
                    ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(this.rhsAsNumber().neg()).sql(' ').visit(Keywords.K_DAY).sql(')');
                    break;
                }
                case POSTGRES: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(new DateAdd<T>(this.lhs, this.rhsAsNumber(), DatePart.DAY));
                        break;
                    }
                    ctx.visit(new DateAdd<T>(this.lhs, this.rhsAsNumber().neg(), DatePart.DAY));
                    break;
                }
                case SQLITE: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(Names.N_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.lhs).sql(", ").visit(this.rhsAsNumber().concat(DSL.inline(" day"))).sql(')');
                        break;
                    }
                    ctx.visit(Names.N_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.lhs).sql(", ").visit(this.rhsAsNumber().neg().concat(DSL.inline(" day"))).sql(')');
                    break;
                }
                default: {
                    ctx.visit(new DefaultExpression<T>(this.lhs, this.operator, this.rhs));
                }
            }
        }

        private final YearToSecond rhsAsYTS() {
            try {
                return (YearToSecond)((Param)this.rhs).getValue();
            }
            catch (ClassCastException e) {
                throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs, e);
            }
        }

        private final YearToMonth rhsAsYTM() {
            try {
                return (YearToMonth)((Param)this.rhs).getValue();
            }
            catch (ClassCastException e) {
                throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs, e);
            }
        }

        private final DayToSecond rhsAsDTS() {
            try {
                return (DayToSecond)((Param)this.rhs).getValue();
            }
            catch (ClassCastException e) {
                throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs, e);
            }
        }

        private final Interval rhsAsInterval() {
            try {
                return (Interval)((Param)this.rhs).getValue();
            }
            catch (ClassCastException e) {
                throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs, e);
            }
        }

        private final Field<Number> rhsAsNumber() {
            return this.rhs;
        }
    }
}

