/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.ExecuteContext;
import com.craftaro.third_party.org.jooq.ExecuteListener;
import com.craftaro.third_party.org.jooq.ExecuteListenerProvider;
import com.craftaro.third_party.org.jooq.conf.InvocationOrder;
import com.craftaro.third_party.org.jooq.conf.SettingsTools;
import com.craftaro.third_party.org.jooq.impl.DefaultExecuteContext;
import com.craftaro.third_party.org.jooq.impl.DefaultExecuteListener;
import com.craftaro.third_party.org.jooq.impl.FetchServerOutputListener;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.tools.JooqLogger;
import com.craftaro.third_party.org.jooq.tools.LoggerListener;
import java.util.ArrayList;
import java.util.List;

final class ExecuteListeners
implements ExecuteListener {
    private static final long serialVersionUID = 7399239846062763212L;
    private static final ExecuteListener EMPTY_LISTENER = new DefaultExecuteListener();
    private static final JooqLogger LOGGER_LISTENER_LOGGER = JooqLogger.getLogger(LoggerListener.class);
    private final ExecuteListener[][] listeners;
    private boolean resultStart;
    private boolean fetchEnd;

    static ExecuteListener get(ExecuteContext ctx) {
        ExecuteListener[][] listeners = ExecuteListeners.listeners(ctx);
        if (listeners == null) {
            return EMPTY_LISTENER;
        }
        return new ExecuteListeners(listeners);
    }

    static ExecuteListener getAndStart(ExecuteContext ctx) {
        ExecuteListener result = ExecuteListeners.get(ctx);
        result.start(ctx);
        return result;
    }

    private static final ExecuteListener[][] listeners(ExecuteContext ctx) {
        ExecuteListener[] executeListenerArray;
        ExecuteListener[] executeListenerArray2;
        List<ExecuteListener> list = null;
        if (SettingsTools.getFetchServerOutputSize(0, ctx.settings()) > 0) {
            list = ExecuteListeners.init(list);
            list.add(new FetchServerOutputListener());
        }
        if (!Boolean.FALSE.equals(ctx.settings().isExecuteLogging()) && LOGGER_LISTENER_LOGGER.isDebugEnabled()) {
            list = ExecuteListeners.init(list);
            list.add(new LoggerListener());
        }
        for (ExecuteListenerProvider provider : ctx.configuration().executeListenerProviders()) {
            if (provider == null) continue;
            list = ExecuteListeners.init(list);
            list.add(provider.provide());
        }
        if (list == null) {
            return null;
        }
        ExecuteListener[] def = list.toArray(Tools.EMPTY_EXECUTE_LISTENER);
        ExecuteListener[] rev = null;
        ExecuteListener[][] executeListenerArray3 = new ExecuteListener[2][];
        if (ctx.settings().getExecuteListenerStartInvocationOrder() != InvocationOrder.REVERSE) {
            executeListenerArray2 = def;
        } else {
            rev = (ExecuteListener[])Tools.reverse((Object[])def.clone());
            executeListenerArray2 = executeListenerArray3[0] = rev;
        }
        if (ctx.settings().getExecuteListenerEndInvocationOrder() != InvocationOrder.REVERSE) {
            executeListenerArray = def;
        } else if (rev != null) {
            executeListenerArray = rev;
        } else {
            rev = (ExecuteListener[])Tools.reverse((Object[])def.clone());
            executeListenerArray = rev;
        }
        executeListenerArray3[1] = executeListenerArray;
        return executeListenerArray3;
    }

    private static final List<ExecuteListener> init(List<ExecuteListener> result) {
        return result == null ? new ArrayList() : result;
    }

    private ExecuteListeners(ExecuteListener[][] listeners) {
        this.listeners = listeners;
    }

    @Override
    public final void start(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.start(ctx);
        }
    }

    @Override
    public final void renderStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.renderStart(ctx);
        }
    }

    @Override
    public final void renderEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.renderEnd(ctx);
        }
    }

    @Override
    public final void prepareStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.prepareStart(ctx);
        }
    }

    @Override
    public final void prepareEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.prepareEnd(ctx);
        }
    }

    @Override
    public final void bindStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.bindStart(ctx);
        }
    }

    @Override
    public final void bindEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.bindEnd(ctx);
        }
    }

    @Override
    public final void executeStart(ExecuteContext ctx) {
        if (ctx instanceof DefaultExecuteContext) {
            ((DefaultExecuteContext)ctx).incrementStatementExecutionCount();
        }
        for (ExecuteListener listener : this.listeners[0]) {
            listener.executeStart(ctx);
        }
    }

    @Override
    public final void executeEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.executeEnd(ctx);
        }
    }

    @Override
    public final void fetchStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.fetchStart(ctx);
        }
    }

    @Override
    public final void outStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.outStart(ctx);
        }
    }

    @Override
    public final void outEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.outEnd(ctx);
        }
    }

    @Override
    public final void resultStart(ExecuteContext ctx) {
        this.resultStart = true;
        for (ExecuteListener listener : this.listeners[0]) {
            listener.resultStart(ctx);
        }
    }

    @Override
    public final void recordStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.recordStart(ctx);
        }
    }

    @Override
    public final void recordEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.recordEnd(ctx);
        }
    }

    @Override
    public final void resultEnd(ExecuteContext ctx) {
        this.resultStart = false;
        for (ExecuteListener listener : this.listeners[1]) {
            listener.resultEnd(ctx);
        }
        if (this.fetchEnd) {
            this.fetchEnd(ctx);
        }
    }

    @Override
    public final void fetchEnd(ExecuteContext ctx) {
        if (this.resultStart) {
            this.fetchEnd = true;
        } else {
            for (ExecuteListener listener : this.listeners[1]) {
                listener.fetchEnd(ctx);
            }
        }
    }

    @Override
    public final void end(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[1]) {
            listener.end(ctx);
        }
    }

    @Override
    public final void exception(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.exception(ctx);
        }
    }

    @Override
    public final void warning(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners[0]) {
            listener.warning(ctx);
        }
    }
}

