/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DropViewFinalStep;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class DropViewImpl
extends AbstractRowCountQuery
implements DropViewFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_VIEW};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private final Table<?> view;
    private final boolean ifExists;

    DropViewImpl(Configuration configuration, Table<?> view) {
        this(configuration, view, false);
    }

    DropViewImpl(Configuration configuration, Table<?> view, boolean ifExists) {
        super(configuration);
        this.view = view;
        this.ifExists = ifExists;
    }

    final Table<?> $view() {
        return this.view;
    }

    final boolean $ifExists() {
        return this.ifExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.DROP_VIEW);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.DROP_VIEW);
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_VIEW_TABLE).visit(Keywords.K_DROP_VIEW).sql(' ');
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.view);
        ctx.end(Clause.DROP_VIEW_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

