/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Catalog;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DropDatabaseFinalStep;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class DropDatabaseImpl
extends AbstractRowCountQuery
implements DropDatabaseFinalStep {
    private static final long serialVersionUID = 1L;
    private final Catalog database;
    private final boolean dropDatabaseIfExists;
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    DropDatabaseImpl(Configuration configuration, Catalog database, boolean dropDatabaseIfExists) {
        super(configuration);
        this.database = database;
        this.dropDatabaseIfExists = dropDatabaseIfExists;
    }

    final Catalog $database() {
        return this.database;
    }

    final boolean $dropDatabaseIfExists() {
        return this.dropDatabaseIfExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.dropDatabaseIfExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.DROP_DATABASE);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.DROP_DATABASE);
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_DATABASE);
        if (this.dropDatabaseIfExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.database);
    }
}

