/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Attachable;
import com.craftaro.third_party.org.jooq.Binding;
import com.craftaro.third_party.org.jooq.BindingGetResultSetContext;
import com.craftaro.third_party.org.jooq.BindingGetSQLInputContext;
import com.craftaro.third_party.org.jooq.BindingGetStatementContext;
import com.craftaro.third_party.org.jooq.BindingRegisterContext;
import com.craftaro.third_party.org.jooq.BindingSQLContext;
import com.craftaro.third_party.org.jooq.BindingSetSQLOutputContext;
import com.craftaro.third_party.org.jooq.BindingSetStatementContext;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Converter;
import com.craftaro.third_party.org.jooq.Converters;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.EnumType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.JSON;
import com.craftaro.third_party.org.jooq.JSONB;
import com.craftaro.third_party.org.jooq.Param;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.RenderContext;
import com.craftaro.third_party.org.jooq.Result;
import com.craftaro.third_party.org.jooq.Row;
import com.craftaro.third_party.org.jooq.RowId;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Schema;
import com.craftaro.third_party.org.jooq.Scope;
import com.craftaro.third_party.org.jooq.TableRecord;
import com.craftaro.third_party.org.jooq.UDTRecord;
import com.craftaro.third_party.org.jooq.XML;
import com.craftaro.third_party.org.jooq.conf.ParamType;
import com.craftaro.third_party.org.jooq.exception.ControlFlowSignal;
import com.craftaro.third_party.org.jooq.exception.DataTypeException;
import com.craftaro.third_party.org.jooq.exception.MappingException;
import com.craftaro.third_party.org.jooq.exception.SQLDialectNotSupportedException;
import com.craftaro.third_party.org.jooq.impl.AbstractConverter;
import com.craftaro.third_party.org.jooq.impl.AbstractRow;
import com.craftaro.third_party.org.jooq.impl.Cast;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.DateToLocalDateConverter;
import com.craftaro.third_party.org.jooq.impl.DefaultBindingSQLContext;
import com.craftaro.third_party.org.jooq.impl.DefaultDataType;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.RecordOperation;
import com.craftaro.third_party.org.jooq.impl.RowIdImpl;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.impl.TimeToLocalTimeConverter;
import com.craftaro.third_party.org.jooq.impl.TimestampToJavaUtilDateConverter;
import com.craftaro.third_party.org.jooq.impl.TimestampToLocalDateTimeConverter;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.tools.Convert;
import com.craftaro.third_party.org.jooq.tools.JooqLogger;
import com.craftaro.third_party.org.jooq.tools.Longs;
import com.craftaro.third_party.org.jooq.tools.StringUtils;
import com.craftaro.third_party.org.jooq.tools.jdbc.JDBCUtils;
import com.craftaro.third_party.org.jooq.tools.jdbc.MockArray;
import com.craftaro.third_party.org.jooq.tools.reflect.Reflect;
import com.craftaro.third_party.org.jooq.types.DayToSecond;
import com.craftaro.third_party.org.jooq.types.UByte;
import com.craftaro.third_party.org.jooq.types.UInteger;
import com.craftaro.third_party.org.jooq.types.ULong;
import com.craftaro.third_party.org.jooq.types.UShort;
import com.craftaro.third_party.org.jooq.types.YearToMonth;
import com.craftaro.third_party.org.jooq.types.YearToSecond;
import com.craftaro.third_party.org.jooq.util.postgres.PostgresUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

public class DefaultBinding<T, U>
implements Binding<T, U> {
    static final JooqLogger log = JooqLogger.getLogger(DefaultBinding.class);
    private static final long serialVersionUID = -198499389344950496L;
    private static final Set<SQLDialect> REQUIRE_JDBC_DATE_LITERAL = SQLDialect.supportedBy(SQLDialect.MYSQL);
    private static final long PG_DATE_POSITIVE_INFINITY = 9223372036825200000L;
    private static final long PG_DATE_NEGATIVE_INFINITY = -9223372036832400000L;
    final AbstractBinding<T, U> delegate;

    public static final <T, U> Binding<T, U> binding(Converter<T, U> converter) {
        return DefaultBinding.binding(DefaultDataType.getDataType(SQLDialect.DEFAULT, converter.fromType()), converter);
    }

    static final <T> Binding<T, T> binding(DataType<T> dataType) {
        return DefaultBinding.binding(dataType, Converters.identity(dataType.getType()));
    }

    static final <T, U> Binding<T, U> binding(DataType<T> dataType, Converter<T, U> converter) {
        Class<T> type = converter.fromType();
        if (type == BigDecimal.class) {
            return new DefaultBigDecimalBinding<U>((DataType<BigDecimal>)dataType, converter);
        }
        if (type == BigInteger.class) {
            return new DefaultBigIntegerBinding<U>((DataType<BigInteger>)dataType, converter);
        }
        if (type == Blob.class) {
            return new DefaultBlobBinding<U>((DataType<Blob>)dataType, converter);
        }
        if (type == Boolean.class) {
            return new DefaultBooleanBinding<U>((DataType<Boolean>)dataType, converter);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return new DefaultByteBinding<U>((DataType<Byte>)dataType, converter);
        }
        if (type == byte[].class) {
            return new DefaultBytesBinding<U>((DataType<byte[]>)dataType, converter);
        }
        if (type == Clob.class) {
            return new DefaultClobBinding<U>((DataType<Clob>)dataType, converter);
        }
        if (type == java.sql.Date.class) {
            return new DefaultDateBinding<U>((DataType<java.sql.Date>)dataType, converter);
        }
        if (type == DayToSecond.class) {
            return new DefaultDayToSecondBinding<U>((DataType<DayToSecond>)dataType, converter);
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DefaultDoubleBinding<U>((DataType<Double>)dataType, converter);
        }
        if (type == Float.class || type == Float.TYPE) {
            return new DefaultFloatBinding<U>((DataType<Float>)dataType, converter);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new DefaultIntegerBinding<U>((DataType<Integer>)dataType, converter);
        }
        if (type == JSON.class) {
            return new DefaultJSONBinding<U>((DataType<JSON>)dataType, converter);
        }
        if (type == JSONB.class) {
            return new DefaultJSONBBinding<U>((DataType<JSONB>)dataType, converter);
        }
        if (type == XML.class) {
            return new DefaultXMLBinding<U>((DataType<XML>)dataType, converter);
        }
        if (type == LocalDate.class) {
            DateToLocalDateConverter c1 = new DateToLocalDateConverter();
            Converter<T, U> c2 = converter;
            Converter<java.sql.Date, U> c3 = Converters.of(c1, c2);
            return new DelegatingBinding<LocalDate, java.sql.Date, U>(dataType, c1, c2, new DefaultDateBinding<U>(SQLDataType.DATE, c3));
        }
        if (type == LocalDateTime.class) {
            TimestampToLocalDateTimeConverter c1 = new TimestampToLocalDateTimeConverter();
            Converter<T, U> c2 = converter;
            Converter<Timestamp, U> c3 = Converters.of(c1, c2);
            return new DelegatingBinding<LocalDateTime, Timestamp, U>(dataType, c1, c2, new DefaultTimestampBinding<U>(SQLDataType.TIMESTAMP, c3));
        }
        if (type == LocalTime.class) {
            TimeToLocalTimeConverter c1 = new TimeToLocalTimeConverter();
            Converter<T, U> c2 = converter;
            Converter<Time, U> c3 = Converters.of(c1, c2);
            return new DelegatingBinding<LocalTime, Time, U>(dataType, c1, c2, new DefaultTimeBinding<U>(SQLDataType.TIME, c3));
        }
        if (type == Long.class || type == Long.TYPE) {
            return new DefaultLongBinding<U>((DataType<Long>)dataType, converter);
        }
        if (type == OffsetDateTime.class) {
            return new DefaultOffsetDateTimeBinding<U>((DataType<OffsetDateTime>)dataType, converter);
        }
        if (type == OffsetTime.class) {
            return new DefaultOffsetTimeBinding<U>((DataType<OffsetTime>)dataType, converter);
        }
        if (type == Instant.class) {
            return new DefaultInstantBinding<U>((DataType<Instant>)dataType, converter);
        }
        if (type == RowId.class) {
            return new DefaultRowIdBinding<U>((DataType<RowId>)dataType, converter);
        }
        if (type == Short.class || type == Short.TYPE) {
            return new DefaultShortBinding<U>((DataType<Short>)dataType, converter);
        }
        if (type == String.class) {
            if (dataType.isNString()) {
                return new DefaultNStringBinding<U>((DataType<String>)dataType, converter);
            }
            return new DefaultStringBinding<U>((DataType<String>)dataType, converter);
        }
        if (type == Time.class) {
            return new DefaultTimeBinding<U>((DataType<Time>)dataType, converter);
        }
        if (type == Timestamp.class) {
            return new DefaultTimestampBinding<U>((DataType<Timestamp>)dataType, converter);
        }
        if (type == Date.class) {
            return new DefaultTimestampBinding<U>((DataType<Timestamp>)dataType, Converters.of(TimestampToJavaUtilDateConverter.INSTANCE, converter));
        }
        if (type == UByte.class) {
            return new DefaultUByteBinding<U>((DataType<UByte>)dataType, converter);
        }
        if (type == UInteger.class) {
            return new DefaultUIntegerBinding<U>((DataType<UInteger>)dataType, converter);
        }
        if (type == ULong.class) {
            return new DefaultULongBinding<U>((DataType<ULong>)dataType, converter);
        }
        if (type == UShort.class) {
            return new DefaultUShortBinding<U>((DataType<UShort>)dataType, converter);
        }
        if (type == UUID.class) {
            return new DefaultUUIDBinding<U>((DataType<UUID>)dataType, converter);
        }
        if (type == YearToSecond.class) {
            return new DefaultYearToSecondBinding<U>((DataType<YearToSecond>)dataType, converter);
        }
        if (type == YearToMonth.class) {
            return new DefaultYearToMonthBinding<U>((DataType<YearToMonth>)dataType, converter);
        }
        if (type.isArray()) {
            return new DefaultArrayBinding<U>((DataType<Object[]>)dataType, converter);
        }
        if (EnumType.class.isAssignableFrom(type)) {
            return new DefaultEnumTypeBinding<U>((DataType<EnumType>)dataType, converter);
        }
        if (Record.class.isAssignableFrom(type)) {
            return new DefaultRecordBinding<U>((DataType<Record>)dataType, converter);
        }
        if (Result.class.isAssignableFrom(type)) {
            return new DefaultResultBinding<U>((DataType<Result<?>>)dataType, converter);
        }
        return new DefaultOtherBinding<U>(dataType, converter);
    }

    @Deprecated
    public DefaultBinding(Converter<T, U> converter) {
        this.delegate = (AbstractBinding)DefaultBinding.binding(converter);
    }

    static final <T, X, U> Binding<T, U> newBinding(final Converter<X, U> converter, DataType<T> dataType, final Binding<T, X> binding) {
        Binding<Object, Object> theBinding = converter == null && binding == null ? dataType.getBinding() : (converter == null ? binding : (binding == null ? DefaultBinding.binding(dataType, converter) : new Binding<T, U>(){
            private static final long serialVersionUID = 8912340791845209886L;
            final Converter<T, U> theConverter;
            {
                this.theConverter = Converters.of(binding.converter(), converter);
            }

            @Override
            public Converter<T, U> converter() {
                return this.theConverter;
            }

            @Override
            public void sql(BindingSQLContext<U> ctx) throws SQLException {
                binding.sql(ctx.convert(converter));
            }

            @Override
            public void register(BindingRegisterContext<U> ctx) throws SQLException {
                binding.register(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetStatementContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
                binding.set(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetStatementContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }

            @Override
            public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
                binding.get(ctx.convert(converter));
            }
        }));
        return theBinding;
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Configuration configuration) {
        return DefaultBinding.typeMap(type, configuration, new HashMap());
    }

    static final Map<String, Class<?>> typeMap(Class<?> type, Configuration configuration, Map<String, Class<?>> result) {
        try {
            if (UDTRecord.class.isAssignableFrom(type)) {
                Class<?> t = type;
                result.put(Tools.getMappedUDTName(configuration, t), t);
                UDTRecord r = (UDTRecord)t.newInstance();
                for (Field<?> field : r.getUDT().fields()) {
                    DefaultBinding.typeMap(field.getType(), configuration, result);
                }
            }
        }
        catch (Exception e) {
            throw new MappingException("Error while collecting type map", e);
        }
        return result;
    }

    private static final long parse(Class<? extends Date> type, String date) throws SQLException {
        Long number = Longs.tryParse(date);
        if (number != null) {
            return number;
        }
        date = StringUtils.replace(date, "T", " ");
        if (type == Timestamp.class) {
            return Timestamp.valueOf(date).getTime();
        }
        if (type == java.sql.Date.class) {
            return java.sql.Date.valueOf(date.split(" ")[0]).getTime();
        }
        if (type == Time.class) {
            return Time.valueOf(date).getTime();
        }
        throw new SQLException("Could not parse date " + date);
    }

    @Override
    public Converter<T, U> converter() {
        return this.delegate.converter;
    }

    @Override
    public void sql(BindingSQLContext<U> ctx) throws SQLException {
        this.delegate.sql(ctx);
    }

    @Override
    public void register(BindingRegisterContext<U> ctx) throws SQLException {
        this.delegate.register(ctx);
    }

    @Override
    public void set(BindingSetStatementContext<U> ctx) throws SQLException {
        this.delegate.set(ctx);
    }

    @Override
    public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
        this.delegate.set(ctx);
    }

    @Override
    public void get(BindingGetResultSetContext<U> ctx) throws SQLException {
        this.delegate.get(ctx);
    }

    @Override
    public void get(BindingGetStatementContext<U> ctx) throws SQLException {
        this.delegate.get(ctx);
    }

    @Override
    public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
        this.delegate.get(ctx);
    }

    public String toString() {
        return "DefaultBinding [type=" + this.delegate.dataType + ", converter=" + this.delegate.converter + "]";
    }

    static final class DefaultYearToMonthBinding<U>
    extends AbstractBinding<YearToMonth, U> {
        private static final long serialVersionUID = 6417965474063152673L;
        private static final Set<SQLDialect> REQUIRE_PG_INTERVAL = SQLDialect.supportedBy(SQLDialect.POSTGRES);
        private static final Set<SQLDialect> REQUIRE_STANDARD_INTERVAL = SQLDialect.supportedBy(SQLDialect.H2);

        DefaultYearToMonthBinding(DataType<YearToMonth> dataType, Converter<YearToMonth, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, YearToMonth value) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval(value));
            } else {
                ctx.statement().setString(ctx.index(), this.renderYTM(ctx, value));
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, YearToMonth value) throws SQLException {
            ctx.output().writeString(this.renderYTM(ctx, value));
        }

        @Override
        final YearToMonth get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.resultSet().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToMonth(object);
            }
            return this.parseYTM(ctx, ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final YearToMonth get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.statement().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToMonth(object);
            }
            return this.parseYTM(ctx, ctx.statement().getString(ctx.index()));
        }

        @Override
        final YearToMonth get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return this.parseYTM(ctx, ctx.input().readString());
        }

        private final YearToMonth parseYTM(Scope scope, String string) {
            if (string == null) {
                return null;
            }
            if (REQUIRE_STANDARD_INTERVAL.contains((Object)scope.dialect()) && string.startsWith("INTERVAL")) {
                return (YearToMonth)((Param)scope.dsl().parser().parseField(string)).getValue();
            }
            return YearToMonth.valueOf(string);
        }

        private final String renderYTM(Scope scope, YearToMonth ytm) {
            if (ytm == null) {
                return null;
            }
            if (REQUIRE_STANDARD_INTERVAL.contains((Object)scope.dialect())) {
                return "INTERVAL '" + ytm.toString() + "' YEAR TO MONTH";
            }
            return ytm.toString();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultYearToSecondBinding<U>
    extends AbstractBinding<YearToSecond, U> {
        private static final long serialVersionUID = 6417965474063152673L;
        private static final Set<SQLDialect> REQUIRE_PG_INTERVAL = SQLDialect.supportedBy(SQLDialect.POSTGRES);

        DefaultYearToSecondBinding(DataType<YearToSecond> dataType, Converter<YearToSecond, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, YearToSecond value) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval(value));
            } else {
                ctx.statement().setString(ctx.index(), value.toString());
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, YearToSecond value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final YearToSecond get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.resultSet().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToSecond(object);
            }
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : YearToSecond.valueOf(string);
        }

        @Override
        final YearToSecond get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL.contains((Object)ctx.dialect())) {
                Object object = ctx.statement().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toYearToSecond(object);
            }
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : YearToSecond.valueOf(string);
        }

        @Override
        final YearToSecond get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : YearToSecond.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultXMLBinding<U>
    extends AbstractBinding<XML, U> {
        private static final long serialVersionUID = 3430629127218407737L;

        DefaultXMLBinding(DataType<XML> dataType, Converter<XML, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, XML value) throws SQLException {
            ctx.statement().setString(ctx.index(), value.toString());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, XML value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final XML get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : XML.valueOf(string);
        }

        @Override
        final XML get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : XML.valueOf(string);
        }

        @Override
        final XML get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : XML.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultJSONBBinding<U>
    extends AbstractBinding<JSONB, U> {
        private static final long serialVersionUID = 3430629127218407737L;
        private static final Set<SQLDialect> EMULATE_AS_BLOB = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.SQLITE);

        DefaultJSONBBinding(DataType<JSONB> dataType, Converter<JSONB, U> converter) {
            super(dataType, converter);
        }

        @Override
        void sqlInline0(BindingSQLContext<U> ctx, JSONB value) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                this.bytes(ctx.configuration()).sqlInline0(ctx, this.bytesConverter(ctx.configuration()).to(value));
            } else {
                super.sqlInline0(ctx, value);
                if (ctx.family() == SQLDialect.H2 && value != null) {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_FORMAT)).sql(' ')).visit(Keywords.K_JSON);
                }
            }
        }

        @Override
        void sqlBind0(BindingSQLContext<U> ctx, JSONB value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (ctx.family() == SQLDialect.H2 && value != null) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_FORMAT)).sql(' ')).visit(Keywords.K_JSON);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, JSONB value) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                this.bytes(ctx.configuration()).set0(ctx, this.bytesConverter(ctx.configuration()).to(value));
            } else {
                ctx.statement().setString(ctx.index(), value.toString());
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, JSONB value) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                this.bytes(ctx.configuration()).set0(ctx, this.bytesConverter(ctx.configuration()).to(value));
            } else {
                ctx.output().writeString(value.toString());
            }
        }

        @Override
        final JSONB get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                return this.bytesConverter(ctx.configuration()).from(this.bytes(ctx.configuration()).get0(ctx));
            }
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : JSONB.valueOf(string);
        }

        @Override
        final JSONB get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                return this.bytesConverter(ctx.configuration()).from(this.bytes(ctx.configuration()).get0(ctx));
            }
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : JSONB.valueOf(string);
        }

        @Override
        final JSONB get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            if (EMULATE_AS_BLOB.contains((Object)ctx.dialect())) {
                return this.bytesConverter(ctx.configuration()).from(this.bytes(ctx.configuration()).get0(ctx));
            }
            String string = ctx.input().readString();
            return string == null ? null : JSONB.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            if (EMULATE_AS_BLOB.contains((Object)configuration.dialect())) {
                return this.bytes(configuration).sqltype(statement, configuration);
            }
            return 12;
        }

        private final Converter<byte[], JSONB> bytesConverter(final Configuration configuration) {
            return new AbstractConverter<byte[], JSONB>(byte[].class, JSONB.class){

                @Override
                public JSONB from(byte[] t) {
                    return t == null ? null : JSONB.valueOf(new String(t, configuration.charsetProvider().provide()));
                }

                @Override
                public byte[] to(JSONB u) {
                    return u == null ? null : u.toString().getBytes(configuration.charsetProvider().provide());
                }
            };
        }

        private final DefaultBytesBinding<U> bytes(Configuration configuration) {
            return new DefaultBytesBinding<JSONB>(SQLDataType.BLOB, this.bytesConverter(configuration));
        }
    }

    static final class DefaultJSONBinding<U>
    extends AbstractBinding<JSON, U> {
        private static final long serialVersionUID = 3430629127218407737L;

        DefaultJSONBinding(DataType<JSON> dataType, Converter<JSON, U> converter) {
            super(dataType, converter);
        }

        @Override
        void sqlInline0(BindingSQLContext<U> ctx, JSON value) throws SQLException {
            super.sqlInline0(ctx, value);
            if (ctx.family() == SQLDialect.H2 && value != null) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_FORMAT)).sql(' ')).visit(Keywords.K_JSON);
            }
        }

        @Override
        void sqlBind0(BindingSQLContext<U> ctx, JSON value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (ctx.family() == SQLDialect.H2 && value != null) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_FORMAT)).sql(' ')).visit(Keywords.K_JSON);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, JSON value) throws SQLException {
            ctx.statement().setString(ctx.index(), value.toString());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, JSON value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final JSON get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : JSON.valueOf(string);
        }

        @Override
        final JSON get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : JSON.valueOf(string);
        }

        @Override
        final JSON get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : JSON.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultUUIDBinding<U>
    extends AbstractBinding<UUID, U> {
        private static final long serialVersionUID = -6616291625634347383L;

        DefaultUUIDBinding(DataType<UUID> dataType, Converter<UUID, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, UUID value) throws SQLException {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    ctx.statement().setObject(ctx.index(), value);
                    break;
                }
                default: {
                    ctx.statement().setString(ctx.index(), value.toString());
                }
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, UUID value) throws SQLException {
            ctx.output().writeString(value.toString());
        }

        @Override
        final UUID get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    return Convert.convert(ctx.resultSet().getObject(ctx.index()), UUID.class);
                }
            }
            return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), UUID.class);
        }

        @Override
        final UUID get0(BindingGetStatementContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case H2: 
                case POSTGRES: {
                    return (UUID)ctx.statement().getObject(ctx.index());
                }
            }
            return Convert.convert((Object)ctx.statement().getString(ctx.index()), UUID.class);
        }

        @Override
        final UUID get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return Convert.convert((Object)ctx.input().readString(), UUID.class);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            switch (configuration.family()) {
                case POSTGRES: {
                    return 1111;
                }
            }
            return 12;
        }
    }

    static final class DefaultUShortBinding<U>
    extends AbstractBinding<UShort, U> {
        private static final long serialVersionUID = 2539811197808516971L;

        DefaultUShortBinding(DataType<UShort> dataType, Converter<UShort, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, UShort value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, UShort value) throws SQLException {
            ctx.statement().setInt(ctx.index(), value.intValue());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, UShort value) throws SQLException {
            ctx.output().writeInt(value.intValue());
        }

        @Override
        final UShort get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : UShort.valueOf(string);
        }

        @Override
        final UShort get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : UShort.valueOf(string);
        }

        @Override
        final UShort get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : UShort.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 4;
        }
    }

    static final class DefaultULongBinding<U>
    extends AbstractBinding<ULong, U> {
        private static final long serialVersionUID = 4891128447530113299L;

        DefaultULongBinding(DataType<ULong> dataType, Converter<ULong, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, ULong value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, ULong value) throws SQLException {
            ctx.statement().setBigDecimal(ctx.index(), new BigDecimal(value.toString()));
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, ULong value) throws SQLException {
            ctx.output().writeBigDecimal(new BigDecimal(value.toString()));
        }

        @Override
        final ULong get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : ULong.valueOf(string);
        }

        @Override
        final ULong get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : ULong.valueOf(string);
        }

        @Override
        final ULong get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : ULong.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 3;
        }
    }

    static final class DefaultUIntegerBinding<U>
    extends AbstractBinding<UInteger, U> {
        private static final long serialVersionUID = 1437279656720185207L;

        DefaultUIntegerBinding(DataType<UInteger> dataType, Converter<UInteger, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, UInteger value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, UInteger value) throws SQLException {
            ctx.statement().setLong(ctx.index(), value.longValue());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, UInteger value) throws SQLException {
            ctx.output().writeLong(value.longValue());
        }

        @Override
        final UInteger get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : UInteger.valueOf(string);
        }

        @Override
        final UInteger get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : UInteger.valueOf(string);
        }

        @Override
        final UInteger get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : UInteger.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return -5;
        }
    }

    static final class DefaultUByteBinding<U>
    extends AbstractBinding<UByte, U> {
        private static final long serialVersionUID = -101167998250685198L;

        DefaultUByteBinding(DataType<UByte> dataType, Converter<UByte, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, UByte value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, UByte value) throws SQLException {
            ctx.statement().setShort(ctx.index(), value.shortValue());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, UByte value) throws SQLException {
            ctx.output().writeShort(value.shortValue());
        }

        @Override
        final UByte get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            String string = ctx.resultSet().getString(ctx.index());
            return string == null ? null : UByte.valueOf(string);
        }

        @Override
        final UByte get0(BindingGetStatementContext<U> ctx) throws SQLException {
            String string = ctx.statement().getString(ctx.index());
            return string == null ? null : UByte.valueOf(string);
        }

        @Override
        final UByte get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            String string = ctx.input().readString();
            return string == null ? null : UByte.valueOf(string);
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 5;
        }
    }

    static final class DefaultTimestampBinding<U>
    extends AbstractBinding<Timestamp, U> {
        private static final long serialVersionUID = 289387167549159015L;
        private static final Set<SQLDialect> INLINE_AS_STRING_LITERAL = SQLDialect.supportedBy(SQLDialect.SQLITE);

        DefaultTimestampBinding(DataType<Timestamp> dataType, Converter<Timestamp, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Timestamp value) {
            if (INLINE_AS_STRING_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(DefaultTimestampBinding.escape(value, ctx.render()))).sql('\'');
            } else if (ctx.family() == SQLDialect.DERBY) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP)).sql("('")).sql(DefaultTimestampBinding.escape(value, ctx.render()))).sql("')");
            } else if (ctx.family() == SQLDialect.CUBRID) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_DATETIME)).sql(" '")).sql(DefaultTimestampBinding.escape(value, ctx.render()))).sql('\'');
            } else if (REQUIRE_JDBC_DATE_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql("{ts '")).sql(DefaultTimestampBinding.escape(value, ctx.render()))).sql("'}");
            } else {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP)).sql(" '")).sql(this.format(value, ctx.render()))).sql('\'');
            }
        }

        private final String format(Timestamp value, RenderContext render) {
            if (render.family() == SQLDialect.POSTGRES) {
                if (value.getTime() == 9223372036825200000L) {
                    return "infinity";
                }
                if (value.getTime() == -9223372036832400000L) {
                    return "-infinity";
                }
            }
            return DefaultTimestampBinding.escape(value, render);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Timestamp value) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setTimestamp(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Timestamp value) throws SQLException {
            ctx.output().writeTimestamp(value);
        }

        @Override
        final Timestamp get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                String timestamp = ctx.resultSet().getString(ctx.index());
                return timestamp == null ? null : new Timestamp(DefaultBinding.parse(Timestamp.class, timestamp));
            }
            return ctx.resultSet().getTimestamp(ctx.index());
        }

        @Override
        final Timestamp get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getTimestamp(ctx.index());
        }

        @Override
        final Timestamp get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readTimestamp();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 93;
        }
    }

    static final class DefaultTimeBinding<U>
    extends AbstractBinding<Time, U> {
        private static final long serialVersionUID = -2563220967846617288L;
        private static final Set<SQLDialect> INLINE_AS_STRING_LITERAL = SQLDialect.supportedBy(SQLDialect.SQLITE);

        DefaultTimeBinding(DataType<Time> dataType, Converter<Time, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Time value) {
            if (INLINE_AS_STRING_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(new SimpleDateFormat("HH:mm:ss").format(value))).sql('\'');
            } else if (ctx.family() == SQLDialect.DERBY) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIME)).sql("('")).sql(DefaultTimeBinding.escape(value, ctx.render()))).sql("')");
            } else if (REQUIRE_JDBC_DATE_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql("{t '")).sql(DefaultTimeBinding.escape(value, ctx.render()))).sql("'}");
            } else {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIME)).sql(" '")).sql(DefaultTimeBinding.escape(value, ctx.render()))).sql('\'');
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Time value) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setTime(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Time value) throws SQLException {
            ctx.output().writeTime(value);
        }

        @Override
        final Time get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                String time = ctx.resultSet().getString(ctx.index());
                return time == null ? null : new Time(DefaultBinding.parse(Time.class, time));
            }
            return ctx.resultSet().getTime(ctx.index());
        }

        @Override
        final Time get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getTime(ctx.index());
        }

        @Override
        final Time get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readTime();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 92;
        }
    }

    static final class DefaultNStringBinding<U>
    extends AbstractBinding<String, U> {
        private static final long serialVersionUID = 4232459541239942932L;
        private final DefaultStringBinding<U> fallback;

        DefaultNStringBinding(DataType<String> dataType, Converter<String, U> converter) {
            super(dataType, converter);
            this.fallback = new DefaultStringBinding<U>(dataType, converter);
        }

        @Override
        void sqlInline0(BindingSQLContext<U> ctx, String value) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                this.fallback.sqlInline0(ctx, value);
            } else {
                ctx.render().sql('N');
                super.sqlInline0(ctx, value);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, String value) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                this.fallback.set0(ctx, value);
            } else {
                ctx.statement().setNString(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, String value) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                this.fallback.set0(ctx, value);
            }
            ctx.output().writeNString(value);
        }

        @Override
        final String get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                return this.fallback.get0((BindingGetResultSetContext)ctx);
            }
            return ctx.resultSet().getNString(ctx.index());
        }

        @Override
        final String get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                return this.fallback.get0((BindingGetStatementContext)ctx);
            }
            return ctx.statement().getNString(ctx.index());
        }

        @Override
        final String get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            if (NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
                return this.fallback.get0((BindingGetSQLInputContext)ctx);
            }
            return ctx.input().readNString();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            if (NO_SUPPORT_NVARCHAR.contains((Object)configuration.dialect())) {
                return this.fallback.sqltype(statement, configuration);
            }
            return -9;
        }
    }

    static final class DefaultStringBinding<U>
    extends AbstractBinding<String, U> {
        private static final long serialVersionUID = 4232459541239942932L;

        DefaultStringBinding(DataType<String> dataType, Converter<String, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, String value) throws SQLException {
            ctx.statement().setString(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, String value) throws SQLException {
            ctx.output().writeString(value);
        }

        @Override
        final String get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getString(ctx.index());
        }

        @Override
        final String get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getString(ctx.index());
        }

        @Override
        final String get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readString();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultShortBinding<U>
    extends AbstractBinding<Short, U> {
        private static final long serialVersionUID = 8935720621737085226L;

        DefaultShortBinding(DataType<Short> dataType, Converter<Short, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Short value) {
            ctx.render().sql(value.shortValue());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Short value) throws SQLException {
            ctx.statement().setShort(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Short value) throws SQLException {
            ctx.output().writeShort(value);
        }

        @Override
        final Short get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Short.valueOf(ctx.resultSet().getShort(ctx.index())));
        }

        @Override
        final Short get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Short.valueOf(ctx.statement().getShort(ctx.index())));
        }

        @Override
        final Short get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Short.valueOf(ctx.input().readShort()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 5;
        }
    }

    static final class DefaultResultBinding<U>
    extends AbstractBinding<Result<?>, U> {
        private static final long serialVersionUID = -2148875780733374224L;

        DefaultResultBinding(DataType<Result<?>> dataType, Converter<Result<?>, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Result<?> value) throws SQLException {
            throw new UnsupportedOperationException("Cannot bind a value of type Result to a PreparedStatement");
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Result<?> value) throws SQLException {
            throw new UnsupportedOperationException("Cannot bind a value of type Result to a SQLOutput");
        }

        @Override
        final Result<?> get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            ResultSet nested = Convert.convert(ctx.resultSet().getObject(ctx.index()), ResultSet.class);
            return DSL.using(ctx.configuration()).fetch(nested);
        }

        @Override
        final Result<?> get0(BindingGetStatementContext<U> ctx) throws SQLException {
            ResultSet nested = Convert.convert(ctx.statement().getObject(ctx.index()), ResultSet.class);
            return DSL.using(ctx.configuration()).fetch(nested);
        }

        @Override
        final Result<?> get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            throw new UnsupportedOperationException("Cannot get a value of type Result from a SQLInput");
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            switch (configuration.family()) {
                case H2: {
                    return -10;
                }
            }
            return 1111;
        }
    }

    static final class DefaultRecordBinding<U>
    extends AbstractBinding<Record, U> {
        private static final long serialVersionUID = 2547994476924120818L;
        private static final Set<SQLDialect> REQUIRE_RECORD_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES);

        DefaultRecordBinding(DataType<Record> dataType, Converter<Record, U> converter) {
            super(dataType, converter);
        }

        @Override
        void sqlBind0(BindingSQLContext<U> ctx, Record value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (REQUIRE_RECORD_CAST.contains((Object)ctx.dialect()) && value != null) {
                DefaultRecordBinding.pgRenderRecordCast(ctx.render(), value);
            }
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Record value) throws SQLException {
            if (REQUIRE_RECORD_CAST.contains((Object)ctx.dialect())) {
                ctx.render().visit(DSL.inline(PostgresUtils.toPGString(value)));
                DefaultRecordBinding.pgRenderRecordCast(ctx.render(), value);
            } else {
                ctx.render().sql("[UDT]");
            }
        }

        @Override
        final void register0(BindingRegisterContext<U> ctx) throws SQLException {
            super.register0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Record value) throws SQLException {
            if (REQUIRE_RECORD_CAST.contains((Object)ctx.dialect()) && value != null) {
                ctx.statement().setString(ctx.index(), PostgresUtils.toPGString(value));
            } else {
                ctx.statement().setObject(ctx.index(), value);
            }
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Record value) throws SQLException {
            if (!(value instanceof UDTRecord)) {
                throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
            }
            ctx.output().writeObject((UDTRecord)value);
        }

        @Override
        final Record get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: {
                    return DefaultRecordBinding.pgNewRecord(this.dataType.getType(), null, ctx.resultSet().getObject(ctx.index()));
                }
            }
            return (Record)ctx.resultSet().getObject(ctx.index(), DefaultBinding.typeMap(this.dataType.getType(), ctx.configuration()));
        }

        @Override
        final Record get0(BindingGetStatementContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: {
                    return DefaultRecordBinding.pgNewRecord(this.dataType.getType(), null, ctx.statement().getObject(ctx.index()));
                }
            }
            return (Record)ctx.statement().getObject(ctx.index(), DefaultBinding.typeMap(this.dataType.getType(), ctx.configuration()));
        }

        @Override
        final Record get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return (Record)ctx.input().readObject();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 2002;
        }

        static final void pgRenderRecordCast(RenderContext render, Record value) {
            if (value instanceof UDTRecord) {
                ((RenderContext)render.sql("::")).visit(((UDTRecord)value).getUDT().getQualifiedName());
            } else if (value instanceof TableRecord) {
                ((RenderContext)render.sql("::")).visit(((TableRecord)value).getTable().getQualifiedName());
            }
        }

        private static final <T> T pgFromString(Class<T> type, String string) {
            return DefaultRecordBinding.pgFromString(Converters.identity(type), string);
        }

        private static final <T> T pgFromString(Converter<?, T> converter, String string) {
            Class<?> type = Reflect.wrapper(converter.toType());
            if (string == null) {
                return null;
            }
            if (type != Blob.class) {
                if (type == Boolean.class) {
                    return (T)Convert.convert((Object)string, Boolean.class);
                }
                if (type == BigInteger.class) {
                    return (T)new BigInteger(string);
                }
                if (type == BigDecimal.class) {
                    return (T)new BigDecimal(string);
                }
                if (type == Byte.class) {
                    return (T)Byte.valueOf(string);
                }
                if (type == byte[].class) {
                    return (T)PostgresUtils.toBytes(string);
                }
                if (type != Clob.class) {
                    if (type == java.sql.Date.class) {
                        return (T)java.sql.Date.valueOf(string);
                    }
                    if (type == Double.class) {
                        return (T)Double.valueOf(string);
                    }
                    if (type == Float.class) {
                        return (T)Float.valueOf(string);
                    }
                    if (type == Integer.class) {
                        return (T)Integer.valueOf(string);
                    }
                    if (type == Long.class) {
                        return (T)Long.valueOf(string);
                    }
                    if (type == Short.class) {
                        return (T)Short.valueOf(string);
                    }
                    if (type == String.class) {
                        return (T)string;
                    }
                    if (type == Time.class) {
                        return (T)Time.valueOf(string);
                    }
                    if (type == Timestamp.class) {
                        return (T)Timestamp.valueOf(string);
                    }
                    if (type == LocalTime.class) {
                        return (T)LocalTime.parse(string);
                    }
                    if (type == LocalDate.class) {
                        return (T)LocalDate.parse(string);
                    }
                    if (type == LocalDateTime.class) {
                        return (T)LocalDateTime.parse(string);
                    }
                    if (type == OffsetTime.class) {
                        return (T)OffsetDateTimeParser.offsetTime(string);
                    }
                    if (type == OffsetDateTime.class) {
                        return (T)OffsetDateTimeParser.offsetDateTime(string);
                    }
                    if (type == Instant.class) {
                        return (T)OffsetDateTimeParser.offsetDateTime(string).toInstant();
                    }
                    if (type == UByte.class) {
                        return (T)UByte.valueOf(string);
                    }
                    if (type == UShort.class) {
                        return (T)UShort.valueOf(string);
                    }
                    if (type == UInteger.class) {
                        return (T)UInteger.valueOf(string);
                    }
                    if (type == ULong.class) {
                        return (T)ULong.valueOf(string);
                    }
                    if (type == UUID.class) {
                        return (T)UUID.fromString(string);
                    }
                    if (type.isArray()) {
                        return (T)DefaultRecordBinding.pgNewArray(type, string);
                    }
                    if (EnumType.class.isAssignableFrom(type)) {
                        return (T)DefaultEnumTypeBinding.getEnumType(type, string);
                    }
                    if (Record.class.isAssignableFrom(type)) {
                        return (T)DefaultRecordBinding.pgNewRecord(type, null, string);
                    }
                    if (type == Object.class) {
                        return (T)string;
                    }
                    if (type != converter.fromType()) {
                        Converter<?, ?> c2 = converter;
                        return c2.from(DefaultRecordBinding.pgFromString(c2.fromType(), string));
                    }
                }
            }
            throw new UnsupportedOperationException("Class " + type + " is not supported");
        }

        static final Record pgNewRecord(Class<?> type, AbstractRow fields, Object object) {
            if (object == null) {
                return null;
            }
            final List<String> values = PostgresUtils.toPGObject(object.toString());
            if (fields == null && Record.class.isAssignableFrom(type)) {
                fields = Tools.row0(Tools.fields(values.size(), SQLDataType.VARCHAR));
            }
            return Tools.newRecord(true, type, fields).operate(new RecordOperation<Record, RuntimeException>(){

                @Override
                public Record operate(Record record) {
                    Row row = record.fieldsRow();
                    for (int i = 0; i < row.size(); ++i) {
                        DefaultRecordBinding.pgSetValue(record, row.field(i), (String)values.get(i));
                    }
                    return record;
                }
            });
        }

        private static final <T> void pgSetValue(Record record, Field<T> field, String value) {
            record.set(field, DefaultRecordBinding.pgFromString(field.getConverter(), value));
        }

        private static final Object[] pgNewArray(Class<?> type, String string) {
            if (string == null) {
                return null;
            }
            try {
                Class<?> component = type.getComponentType();
                List<String> values = PostgresUtils.toPGArray(string);
                if (values.isEmpty()) {
                    return (Object[])Array.newInstance(component, 0);
                }
                Object[] result = (Object[])Array.newInstance(component, values.size());
                for (int i = 0; i < values.size(); ++i) {
                    result[i] = DefaultRecordBinding.pgFromString(type.getComponentType(), values.get(i));
                }
                return result;
            }
            catch (Exception e) {
                throw new DataTypeException("Error while creating array", e);
            }
        }
    }

    static final class DefaultRowIdBinding<U>
    extends AbstractBinding<RowId, U> {
        private static final long serialVersionUID = 5929968691245507756L;

        DefaultRowIdBinding(DataType<RowId> dataType, Converter<RowId, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, RowId value) throws SQLException {
            ctx.statement().setObject(ctx.index(), value.value());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, RowId value) throws SQLException {
            throw new DataTypeException("Type " + this.dataType + " is not supported");
        }

        @Override
        final RowId get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return new RowIdImpl(ctx.resultSet().getObject(ctx.index()));
        }

        @Override
        final RowId get0(BindingGetStatementContext<U> ctx) throws SQLException {
            throw new DataTypeException("Type " + this.dataType + " is not supported");
        }

        @Override
        final RowId get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            throw new DataTypeException("Type " + this.dataType + " is not supported");
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return -8;
        }
    }

    static final class DefaultOtherBinding<U>
    extends AbstractBinding<Object, U> {
        private static final long serialVersionUID = -650741489151706822L;

        DefaultOtherBinding(DataType<Object> dataType, Converter<Object, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Object value) throws SQLException {
            AbstractBinding b2 = (AbstractBinding)DefaultBinding.binding(DefaultDataType.getDataType(ctx.dialect(), value.getClass()));
            if (b2 instanceof DefaultOtherBinding) {
                ctx.statement().setObject(ctx.index(), value);
            } else {
                b2.set0(ctx, b2.dataType.convert(value));
            }
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            ctx.statement().setObject(ctx.index(), null);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Object value) throws SQLException {
            throw new DataTypeException("Type " + this.dataType + " is not supported");
        }

        @Override
        final Object get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return DefaultOtherBinding.unlob(ctx.resultSet().getObject(ctx.index()));
        }

        @Override
        final Object get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return DefaultOtherBinding.unlob(ctx.statement().getObject(ctx.index()));
        }

        @Override
        final Object get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return DefaultOtherBinding.unlob(ctx.input().readObject());
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 1111;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Object unlob(Object object) throws SQLException {
            if (object instanceof Blob) {
                Blob blob = (Blob)object;
                try {
                    byte[] byArray = blob.getBytes(1L, (int)blob.length());
                    return byArray;
                }
                finally {
                    JDBCUtils.safeFree(blob);
                }
            }
            if (object instanceof Clob) {
                Clob clob = (Clob)object;
                try {
                    String string = clob.getSubString(1L, (int)clob.length());
                    return string;
                }
                finally {
                    JDBCUtils.safeFree(clob);
                }
            }
            return object;
        }
    }

    static final class DefaultInstantBinding<U>
    extends AbstractBinding<Instant, U> {
        private static final long serialVersionUID = -1850495302106551527L;
        private static final Converter<OffsetDateTime, Instant> CONVERTER = Converter.ofNullable(OffsetDateTime.class, Instant.class, (Function<OffsetDateTime, Instant> & Serializable)o -> o.toInstant(), (Function<Instant, OffsetDateTime> & Serializable)i -> OffsetDateTime.ofInstant(i, ZoneOffset.UTC));
        private final DefaultOffsetDateTimeBinding<U> delegate = new DefaultOffsetDateTimeBinding(SQLDataType.OFFSETDATETIME, Converters.of(CONVERTER, this.converter()));

        DefaultInstantBinding(DataType<Instant> dataType, Converter<Instant, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Instant value) throws SQLException {
            this.delegate.sqlInline0(ctx, CONVERTER.to(value));
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Instant value) throws SQLException {
            this.delegate.set0(ctx, CONVERTER.to(value));
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Instant value) throws SQLException {
            this.delegate.set0(ctx, CONVERTER.to(value));
        }

        @Override
        final Instant get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return CONVERTER.from((OffsetDateTime)this.delegate.get0((BindingGetResultSetContext)ctx));
        }

        @Override
        final Instant get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return CONVERTER.from((OffsetDateTime)this.delegate.get0((BindingGetStatementContext)ctx));
        }

        @Override
        final Instant get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return CONVERTER.from((OffsetDateTime)this.delegate.get0((BindingGetSQLInputContext)ctx));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) throws SQLException {
            return this.delegate.sqltype(statement, configuration);
        }
    }

    static final class DefaultOffsetTimeBinding<U>
    extends AbstractBinding<OffsetTime, U> {
        private static final long serialVersionUID = 8991629916239335071L;

        DefaultOffsetTimeBinding(DataType<OffsetTime> dataType, Converter<OffsetTime, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, OffsetTime value) {
            switch (ctx.family()) {
                case HSQLDB: {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIME)).sql(" '")).sql(DefaultOffsetTimeBinding.escape(DefaultOffsetTimeBinding.format(value), ctx.render()))).sql('\'');
                    break;
                }
                case SQLITE: {
                    ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(DefaultOffsetTimeBinding.escape(DefaultOffsetTimeBinding.format(value), ctx.render()))).sql('\'');
                    break;
                }
                default: {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIME_WITH_TIME_ZONE)).sql(" '")).sql(DefaultOffsetTimeBinding.escape(DefaultOffsetTimeBinding.format(value), ctx.render()))).sql('\'');
                }
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, OffsetTime value) throws SQLException {
            if (Boolean.FALSE.equals(ctx.settings().isBindOffsetTimeType())) {
                String string = DefaultOffsetTimeBinding.format(value);
                ctx.statement().setString(ctx.index(), string);
            } else {
                ctx.statement().setObject(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, OffsetTime value) throws SQLException {
            throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
        }

        @Override
        final OffsetTime get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetTimeType())) {
                return ctx.resultSet().getObject(ctx.index(), OffsetTime.class);
            }
            return OffsetDateTimeParser.offsetTime(ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final OffsetTime get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetTimeType())) {
                return ctx.statement().getObject(ctx.index(), OffsetTime.class);
            }
            return OffsetDateTimeParser.offsetTime(ctx.statement().getString(ctx.index()));
        }

        @Override
        final OffsetTime get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            if (!Boolean.FALSE.equals(configuration.settings().isBindOffsetTimeType())) {
                return 2013;
            }
            return 12;
        }

        private static final String format(OffsetTime val) {
            return StringUtils.replace(val.format(DateTimeFormatter.ISO_OFFSET_TIME), "Z", "+00:00");
        }
    }

    static final class DefaultOffsetDateTimeBinding<U>
    extends AbstractBinding<OffsetDateTime, U> {
        private static final long serialVersionUID = 2775682497765456476L;
        private static final DateTimeFormatter F_TIMESTAMPTZ = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendOffset("+HH:MM", "+00:00").toFormatter();
        private static final DateTimeFormatter ERA = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnnZZZZZ G", Locale.US);

        DefaultOffsetDateTimeBinding(DataType<OffsetDateTime> dataType, Converter<OffsetDateTime, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, OffsetDateTime value) {
            SQLDialect family = ctx.family();
            switch (family) {
                case HSQLDB: {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP)).sql(" '")).sql(DefaultOffsetDateTimeBinding.escape(DefaultOffsetDateTimeBinding.format(value, family), ctx.render()))).sql('\'');
                    break;
                }
                case SQLITE: {
                    ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(DefaultOffsetDateTimeBinding.escape(DefaultOffsetDateTimeBinding.format(value, family), ctx.render()))).sql('\'');
                    break;
                }
                default: {
                    ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_TIMESTAMP_WITH_TIME_ZONE)).sql(" '")).sql(DefaultOffsetDateTimeBinding.escape(DefaultOffsetDateTimeBinding.format(value, family), ctx.render()))).sql('\'');
                }
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, OffsetDateTime value) throws SQLException {
            SQLDialect family = ctx.family();
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                ctx.statement().setObject(ctx.index(), value);
            } else {
                ctx.statement().setString(ctx.index(), DefaultOffsetDateTimeBinding.format(value, family));
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, OffsetDateTime value) throws SQLException {
            if (Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
            }
            ctx.output().writeObject(value, JDBCType.TIMESTAMP_WITH_TIMEZONE);
        }

        @Override
        final OffsetDateTime get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                return ctx.resultSet().getObject(ctx.index(), OffsetDateTime.class);
            }
            return OffsetDateTimeParser.offsetDateTime(ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final OffsetDateTime get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                return ctx.statement().getObject(ctx.index(), OffsetDateTime.class);
            }
            return OffsetDateTimeParser.offsetDateTime(ctx.statement().getString(ctx.index()));
        }

        @Override
        final OffsetDateTime get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isBindOffsetDateTimeType())) {
                return ctx.input().readObject(OffsetDateTime.class);
            }
            throw new UnsupportedOperationException("Type " + this.dataType + " is not supported");
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            if (!Boolean.FALSE.equals(configuration.settings().isBindOffsetDateTimeType())) {
                return 2014;
            }
            return 12;
        }

        private static final String format(OffsetDateTime val, SQLDialect family) {
            if (family == SQLDialect.POSTGRES) {
                if (val.toEpochSecond() * 1000L == 9223372036825200000L) {
                    return "infinity";
                }
                if (val.toEpochSecond() * 1000L == -9223372036832400000L) {
                    return "-infinity";
                }
            }
            if (family == SQLDialect.POSTGRES && val.getYear() <= 0) {
                return DefaultOffsetDateTimeBinding.formatEra(val);
            }
            return val.format(F_TIMESTAMPTZ);
        }

        private static final String formatISO(OffsetDateTime val) {
            return val.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        private static final String formatEra(OffsetDateTime val) {
            return val.format(ERA);
        }
    }

    static final class OffsetDateTimeParser {
        OffsetDateTimeParser() {
        }

        static final OffsetTime offsetTime(String string) {
            if (string == null) {
                return null;
            }
            int[] position = new int[]{0};
            return OffsetTime.of(OffsetDateTimeParser.parseLocalTime(string, position), OffsetDateTimeParser.parseOffset(string, position));
        }

        static final OffsetDateTime offsetDateTime(String string) {
            if (string == null) {
                return null;
            }
            int[] position = new int[]{0};
            LocalDate d = OffsetDateTimeParser.parseLocalDate(string, position);
            OffsetDateTimeParser.parseAnyChar(string, position, " T");
            LocalTime t = OffsetDateTimeParser.parseLocalTime(string, position);
            ZoneOffset offset = OffsetDateTimeParser.parseOffset(string, position);
            return OffsetDateTimeParser.parseBCIf(string, position) ? OffsetDateTime.of(d.withYear(1 - d.getYear()), t, offset) : OffsetDateTime.of(d, t, offset);
        }

        static final LocalDate parseLocalDate(String string, int[] position) {
            int year = OffsetDateTimeParser.parseInt(string, position, 10);
            OffsetDateTimeParser.parseChar(string, position, '-');
            int month = OffsetDateTimeParser.parseInt(string, position, 2);
            OffsetDateTimeParser.parseChar(string, position, '-');
            int day = OffsetDateTimeParser.parseInt(string, position, 2);
            return LocalDate.of(year, month, day);
        }

        static final LocalTime parseLocalTime(String string, int[] position) {
            int hour = OffsetDateTimeParser.parseInt(string, position, 2);
            if (hour == 24) {
                hour %= 24;
            }
            OffsetDateTimeParser.parseChar(string, position, ':');
            int minute = OffsetDateTimeParser.parseInt(string, position, 2);
            int second = 0;
            int nano = 0;
            if (OffsetDateTimeParser.parseCharIf(string, position, ':')) {
                second = OffsetDateTimeParser.parseInt(string, position, 2);
                if (OffsetDateTimeParser.parseCharIf(string, position, '.')) {
                    nano = OffsetDateTimeParser.parseInt(string, position, 9, true);
                }
            }
            return LocalTime.of(hour, minute, second, nano);
        }

        private static final ZoneOffset parseOffset(String string, int[] position) {
            int offsetHours = 0;
            int offsetMinutes = 0;
            int offsetSeconds = 0;
            if (!OffsetDateTimeParser.parseCharIf(string, position, 'Z')) {
                boolean plus;
                while (OffsetDateTimeParser.parseCharIf(string, position, ' ')) {
                }
                boolean minus = OffsetDateTimeParser.parseCharIf(string, position, '-');
                boolean bl = plus = !minus && OffsetDateTimeParser.parseCharIf(string, position, '+');
                if (minus || plus) {
                    offsetHours = OffsetDateTimeParser.parseInt(string, position, 1);
                    if (Character.isDigit(string.charAt(position[0]))) {
                        offsetHours = offsetHours * 10 + OffsetDateTimeParser.parseInt(string, position, 1);
                    }
                    if (OffsetDateTimeParser.parseCharIf(string, position, ':')) {
                        offsetMinutes = OffsetDateTimeParser.parseInt(string, position, 2);
                    }
                    if (OffsetDateTimeParser.parseCharIf(string, position, ':')) {
                        offsetSeconds = OffsetDateTimeParser.parseInt(string, position, 2);
                    }
                    if (minus) {
                        offsetHours = -offsetHours;
                        offsetMinutes = -offsetMinutes;
                        offsetSeconds = -offsetSeconds;
                    }
                }
            }
            return ZoneOffset.ofHoursMinutesSeconds(offsetHours, offsetMinutes, offsetSeconds);
        }

        private static final void parseAnyChar(String string, int[] position, String expected) {
            for (int i = 0; i < expected.length(); ++i) {
                if (string.charAt(position[0]) != expected.charAt(i)) continue;
                position[0] = position[0] + 1;
                return;
            }
            throw new IllegalArgumentException("Expected any of \"" + expected + "\" at position " + position[0] + " in " + string);
        }

        private static final boolean parseBCIf(String string, int[] position) {
            return OffsetDateTimeParser.parseCharIf(string, position, ' ') && OffsetDateTimeParser.parseCharIf(string, position, 'B') && OffsetDateTimeParser.parseCharIf(string, position, 'C');
        }

        private static final boolean parseCharIf(String string, int[] position, char expected) {
            boolean result;
            boolean bl = result = string.length() > position[0] && string.charAt(position[0]) == expected;
            if (result) {
                position[0] = position[0] + 1;
            }
            return result;
        }

        private static final void parseChar(String string, int[] position, char expected) {
            if (!OffsetDateTimeParser.parseCharIf(string, position, expected)) {
                throw new IllegalArgumentException("Expected '" + expected + "' at position " + position[0] + " in " + string);
            }
        }

        private static final int parseInt(String string, int[] position, int maxLength) {
            return OffsetDateTimeParser.parseInt(string, position, maxLength, false);
        }

        private static final int parseInt(String string, int[] position, int maxLength, boolean rightPad) {
            int digit;
            int length;
            int result = 0;
            int pos = position[0];
            for (length = 0; length < maxLength && pos + length < string.length() && (digit = string.charAt(pos + length) - 48) >= 0 && digit < 10; ++length) {
                result = result * 10 + digit;
            }
            if (rightPad && length < maxLength && result > 0) {
                for (int i = length; i < maxLength; ++i) {
                    result *= 10;
                }
            }
            position[0] = pos + length;
            return result;
        }
    }

    static final class DefaultLongBinding<U>
    extends AbstractBinding<Long, U> {
        private static final long serialVersionUID = 7360911614219750448L;

        DefaultLongBinding(DataType<Long> dataType, Converter<Long, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Long value) {
            ctx.render().sql(value);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Long value) throws SQLException {
            ctx.statement().setLong(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Long value) throws SQLException {
            ctx.output().writeLong(value);
        }

        @Override
        final Long get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Long.valueOf(ctx.resultSet().getLong(ctx.index())));
        }

        @Override
        final Long get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Long.valueOf(ctx.statement().getLong(ctx.index())));
        }

        @Override
        final Long get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Long.valueOf(ctx.input().readLong()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return -5;
        }
    }

    static final class DefaultIntegerBinding<U>
    extends AbstractBinding<Integer, U> {
        private static final long serialVersionUID = 1356528214897599147L;

        DefaultIntegerBinding(DataType<Integer> dataType, Converter<Integer, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Integer value) {
            ctx.render().sql(value);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Integer value) throws SQLException {
            ctx.statement().setInt(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Integer value) throws SQLException {
            ctx.output().writeInt(value);
        }

        @Override
        final Integer get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Integer.valueOf(ctx.resultSet().getInt(ctx.index())));
        }

        @Override
        final Integer get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Integer.valueOf(ctx.statement().getInt(ctx.index())));
        }

        @Override
        final Integer get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Integer.valueOf(ctx.input().readInt()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 4;
        }
    }

    static final class DefaultFloatBinding<U>
    extends AbstractBinding<Float, U> {
        private static final long serialVersionUID = -2468794191255859536L;
        private static final Set<SQLDialect> REQUIRE_NAN_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES);

        DefaultFloatBinding(DataType<Float> dataType, Converter<Float, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Float value) {
            if (value.isNaN() || value.isInfinite()) {
                if (REQUIRE_NAN_CAST.contains((Object)ctx.dialect())) {
                    ((RenderContext)ctx.render().visit(DSL.inline(value.toString()))).sql("::float4");
                } else if (ctx.family() == SQLDialect.HSQLDB) {
                    ctx.render().visit(DSL.sqrt(DSL.inline(-1)));
                } else {
                    ctx.render().visit(new Cast.CastNative<Double>(DSL.inline(value.toString()), SQLDataType.DOUBLE));
                }
            } else {
                ctx.render().sql(value.floatValue());
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Float value) throws SQLException {
            ctx.statement().setFloat(ctx.index(), value.floatValue());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Float value) throws SQLException {
            ctx.output().writeFloat(value.floatValue());
        }

        @Override
        final Float get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Float.valueOf(ctx.resultSet().getFloat(ctx.index())));
        }

        @Override
        final Float get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Float.valueOf(ctx.statement().getFloat(ctx.index())));
        }

        @Override
        final Float get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Float.valueOf(ctx.input().readFloat()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 6;
        }
    }

    static final class DefaultEnumTypeBinding<U>
    extends AbstractBinding<EnumType, U> {
        private static final long serialVersionUID = -5858761464381778695L;
        private static final Set<SQLDialect> REQUIRE_ENUM_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES);

        DefaultEnumTypeBinding(DataType<EnumType> dataType, Converter<EnumType, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, EnumType value) throws SQLException {
            String literal = value.getLiteral();
            if (literal == null) {
                DefaultBinding.binding(SQLDataType.VARCHAR).sql(new DefaultBindingSQLContext<String>(ctx.configuration(), ctx.data(), ctx.render(), literal));
            } else {
                DefaultBinding.binding(SQLDataType.VARCHAR).sql(new DefaultBindingSQLContext<String>(ctx.configuration(), ctx.data(), ctx.render(), literal));
            }
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, EnumType value) throws SQLException {
            super.sqlBind0(ctx, value);
            if (REQUIRE_ENUM_CAST.contains((Object)ctx.dialect())) {
                DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.dataType.getType());
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, EnumType value) throws SQLException {
            ctx.statement().setString(ctx.index(), value.getLiteral());
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, EnumType value) throws SQLException {
            ctx.output().writeString(value.getLiteral());
        }

        @Override
        final EnumType get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return DefaultEnumTypeBinding.getEnumType(this.dataType.getType(), ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final EnumType get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return DefaultEnumTypeBinding.getEnumType(this.dataType.getType(), ctx.statement().getString(ctx.index()));
        }

        @Override
        final EnumType get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return DefaultEnumTypeBinding.getEnumType(this.dataType.getType(), ctx.input().readString());
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }

        static final void pgRenderEnumCast(RenderContext render, Class<?> type) {
            Class<?> enumType = type.isArray() ? type.getComponentType() : type;
            EnumType[] enums = Tools.enums(enumType);
            if (enums == null || enums.length == 0) {
                throw new IllegalArgumentException("Not a valid EnumType : " + type);
            }
            Schema schema = enums[0].getSchema();
            if (schema != null) {
                render.sql("::");
                schema = DSL.using(render.configuration()).map(schema);
                if (schema != null && Boolean.TRUE.equals(render.configuration().settings().isRenderSchema())) {
                    render.visit(schema);
                    render.sql('.');
                }
                render.visit(DSL.name(enums[0].getName()));
            }
            if (type.isArray()) {
                render.sql("[]");
            }
        }

        static final <E extends EnumType> E getEnumType(Class<? extends E> type, String literal) {
            try {
                EnumType[] list;
                for (EnumType e : list = Tools.enums(type)) {
                    if (!e.getLiteral().equals(literal)) continue;
                    return (E)e;
                }
            }
            catch (Exception e) {
                throw new DataTypeException("Unknown enum literal found : " + literal);
            }
            return null;
        }
    }

    static final class DefaultDoubleBinding<U>
    extends AbstractBinding<Double, U> {
        private static final long serialVersionUID = -615723070592774059L;
        private static final Set<SQLDialect> REQUIRE_NAN_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES);

        DefaultDoubleBinding(DataType<Double> dataType, Converter<Double, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Double value) {
            if (value.isNaN() || value.isInfinite()) {
                if (REQUIRE_NAN_CAST.contains((Object)ctx.dialect())) {
                    ((RenderContext)ctx.render().visit(DSL.inline(value.toString()))).sql("::float8");
                } else if (ctx.family() == SQLDialect.HSQLDB) {
                    ctx.render().visit(DSL.sqrt(DSL.inline(-1)));
                } else {
                    ctx.render().visit(new Cast.CastNative<Double>(DSL.inline(value.toString()), SQLDataType.DOUBLE));
                }
            } else {
                ctx.render().sql(value);
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Double value) throws SQLException {
            ctx.statement().setDouble(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Double value) throws SQLException {
            ctx.output().writeDouble(value);
        }

        @Override
        final Double get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Double.valueOf(ctx.resultSet().getDouble(ctx.index())));
        }

        @Override
        final Double get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Double.valueOf(ctx.statement().getDouble(ctx.index())));
        }

        @Override
        final Double get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Double.valueOf(ctx.input().readDouble()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 8;
        }
    }

    static final class DefaultDayToSecondBinding<U>
    extends AbstractBinding<DayToSecond, U> {
        private static final long serialVersionUID = 4378118707359663541L;
        private static final Set<SQLDialect> REQUIRE_PG_INTERVAL_SYNTAX = SQLDialect.supportedBy(SQLDialect.POSTGRES);
        private static final Set<SQLDialect> REQUIRE_STANDARD_INTERVAL = SQLDialect.supportedBy(SQLDialect.H2);

        DefaultDayToSecondBinding(DataType<DayToSecond> dataType, Converter<DayToSecond, U> converter) {
            super(dataType, converter);
        }

        @Override
        void sqlInline0(BindingSQLContext<U> ctx, DayToSecond value) throws SQLException {
            if (REQUIRE_PG_INTERVAL_SYNTAX.contains((Object)ctx.dialect())) {
                int sign = value.getSign();
                int days = sign * value.getDays();
                ((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(days >= 0 ? (char)'+' : '-')).sql(Math.abs(days))).sql(' ')).sql(sign * value.getHours())).sql(':')).sql(sign * value.getMinutes())).sql(':')).sql(sign * value.getSeconds())).sql('.')).sql(StringUtils.leftPad(Integer.toString(value.getNano()), 9, '0'))).sql('\'');
            } else {
                ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(value.toString())).sql('\'');
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, DayToSecond value) throws SQLException {
            if (REQUIRE_PG_INTERVAL_SYNTAX.contains((Object)ctx.dialect())) {
                ctx.statement().setObject(ctx.index(), PostgresUtils.toPGInterval(value));
            } else {
                ctx.statement().setString(ctx.index(), this.renderDTS(ctx, value));
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, DayToSecond value) throws SQLException {
            ctx.output().writeString(this.renderDTS(ctx, value));
        }

        @Override
        final DayToSecond get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL_SYNTAX.contains((Object)ctx.dialect())) {
                Object object = ctx.resultSet().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toDayToSecond(object);
            }
            return this.parseDTS(ctx, ctx.resultSet().getString(ctx.index()));
        }

        @Override
        final DayToSecond get0(BindingGetStatementContext<U> ctx) throws SQLException {
            if (REQUIRE_PG_INTERVAL_SYNTAX.contains((Object)ctx.dialect())) {
                Object object = ctx.statement().getObject(ctx.index());
                return object == null ? null : PostgresUtils.toDayToSecond(object);
            }
            return this.parseDTS(ctx, ctx.statement().getString(ctx.index()));
        }

        @Override
        final DayToSecond get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return this.parseDTS(ctx, ctx.input().readString());
        }

        private final DayToSecond parseDTS(Scope scope, String string) {
            if (string == null) {
                return null;
            }
            if (REQUIRE_STANDARD_INTERVAL.contains((Object)scope.dialect()) && string.startsWith("INTERVAL")) {
                return (DayToSecond)((Param)scope.dsl().parser().parseField(string)).getValue();
            }
            return DayToSecond.valueOf(string);
        }

        private final String renderDTS(Scope scope, DayToSecond dts) {
            if (dts == null) {
                return null;
            }
            if (REQUIRE_STANDARD_INTERVAL.contains((Object)scope.dialect())) {
                return "INTERVAL '" + dts.toString() + "' DAY TO SECOND";
            }
            return dts.toString();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 12;
        }
    }

    static final class DefaultDateBinding<U>
    extends AbstractBinding<java.sql.Date, U> {
        private static final long serialVersionUID = -4797649501187223237L;
        private static final Set<SQLDialect> INLINE_AS_STRING_LITERAL = SQLDialect.supportedBy(SQLDialect.SQLITE);

        DefaultDateBinding(DataType<java.sql.Date> dataType, Converter<java.sql.Date, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, java.sql.Date value) {
            if (INLINE_AS_STRING_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(DefaultDateBinding.escape(value, ctx.render()))).sql('\'');
            } else if (ctx.family() == SQLDialect.DERBY) {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_DATE)).sql("('")).sql(DefaultDateBinding.escape(value, ctx.render()))).sql("')");
            } else if (REQUIRE_JDBC_DATE_LITERAL.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql("{d '")).sql(DefaultDateBinding.escape(value, ctx.render()))).sql("'}");
            } else {
                ((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_DATE)).sql(" '")).sql(this.format(value, ctx.render()))).sql('\'');
            }
        }

        private final String format(java.sql.Date value, RenderContext render) {
            if (render.family() == SQLDialect.POSTGRES) {
                if (value.getTime() == 9223372036825200000L) {
                    return "infinity";
                }
                if (value.getTime() == -9223372036832400000L) {
                    return "-infinity";
                }
            }
            if (value.getYear() + 1900 >= 10000) {
                return value.getYear() + 1900 + "-" + StringUtils.leftPad("" + (value.getMonth() + 1), 2, '0') + "-" + StringUtils.leftPad("" + value.getDate(), 2, '0');
            }
            return DefaultDateBinding.escape(value, render);
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, java.sql.Date value) throws SQLException {
            super.sqlBind0(ctx, value);
        }

        @Override
        final void register0(BindingRegisterContext<U> ctx) throws SQLException {
            super.register0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, java.sql.Date value) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setDate(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, java.sql.Date value) throws SQLException {
            ctx.output().writeDate(value);
        }

        @Override
        final java.sql.Date get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            SQLDialect family = ctx.family();
            if (family == SQLDialect.SQLITE) {
                String date = ctx.resultSet().getString(ctx.index());
                return date == null ? null : new java.sql.Date(DefaultBinding.parse(java.sql.Date.class, date));
            }
            return ctx.resultSet().getDate(ctx.index());
        }

        @Override
        final java.sql.Date get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getDate(ctx.index());
        }

        @Override
        final java.sql.Date get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readDate();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 91;
        }
    }

    static final class DefaultClobBinding<U>
    extends AbstractBinding<Clob, U> {
        private static final long serialVersionUID = -3890447233590678873L;

        DefaultClobBinding(DataType<Clob> dataType, Converter<Clob, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Clob value) throws SQLException {
            ctx.statement().setClob(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Clob value) throws SQLException {
            ctx.output().writeClob(value);
        }

        @Override
        final Clob get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getClob(ctx.index());
        }

        @Override
        final Clob get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getClob(ctx.index());
        }

        @Override
        final Clob get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readClob();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 2005;
        }
    }

    static final class DefaultBytesBinding<U>
    extends AbstractBinding<byte[], U> {
        private static final long serialVersionUID = -727202499908007757L;
        private static final Set<SQLDialect> INLINE_AS_X_APOS = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
        private static final Set<SQLDialect> REQUIRE_BYTEA_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES);

        DefaultBytesBinding(DataType<byte[]> dataType, Converter<byte[], U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, byte[] value) {
            if (INLINE_AS_X_APOS.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql("X'")).sql(Tools.convertBytesToHex(value))).sql('\'');
            } else if (ctx.dialect() == SQLDialect.DERBY) {
                ((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)ctx.render().visit(Keywords.K_CAST)).sql("(X'")).sql(Tools.convertBytesToHex(value))).sql("' ")).visit(Keywords.K_AS)).sql(' ')).visit(SQLDataType.BLOB)).sql(')');
            } else if (REQUIRE_BYTEA_CAST.contains((Object)ctx.dialect())) {
                ((RenderContext)((RenderContext)ctx.render().sql("E'")).sql(PostgresUtils.toPGString(value))).sql("'::bytea");
            } else {
                ((RenderContext)((RenderContext)ctx.render().sql("X'")).sql(Tools.convertBytesToHex(value))).sql('\'');
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, byte[] value) throws SQLException {
            ctx.statement().setBytes(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, byte[] value) throws SQLException {
            ctx.output().writeBytes(value);
        }

        @Override
        final byte[] get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getBytes(ctx.index());
        }

        @Override
        final byte[] get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getBytes(ctx.index());
        }

        @Override
        final byte[] get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readBytes();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            switch (configuration.family()) {
                case POSTGRES: {
                    return -2;
                }
            }
            return 2004;
        }
    }

    static final class DefaultByteBinding<U>
    extends AbstractBinding<Byte, U> {
        private static final long serialVersionUID = -7328193812163714614L;

        DefaultByteBinding(DataType<Byte> dataType, Converter<Byte, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Byte value) {
            ctx.render().sql(value.byteValue());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Byte value) throws SQLException {
            ctx.statement().setByte(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Byte value) throws SQLException {
            ctx.output().writeByte(value);
        }

        @Override
        final Byte get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), Byte.valueOf(ctx.resultSet().getByte(ctx.index())));
        }

        @Override
        final Byte get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), Byte.valueOf(ctx.statement().getByte(ctx.index())));
        }

        @Override
        final Byte get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), Byte.valueOf(ctx.input().readByte()));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return -6;
        }
    }

    static final class DefaultBooleanBinding<U>
    extends AbstractBinding<Boolean, U> {
        private static final long serialVersionUID = -533762957890251203L;
        private static final Set<SQLDialect> BIND_AS_1_0 = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.SQLITE);

        DefaultBooleanBinding(DataType<Boolean> dataType, Converter<Boolean, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Boolean value) {
            if (BIND_AS_1_0.contains((Object)ctx.dialect())) {
                ctx.render().sql(value != false ? "1" : "0");
            } else {
                ctx.render().visit(value != false ? Keywords.K_TRUE : Keywords.K_FALSE);
            }
        }

        @Override
        final void register0(BindingRegisterContext<U> ctx) throws SQLException {
            super.register0(ctx);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Boolean value) throws SQLException {
            switch (ctx.family()) {
                default: 
            }
            ctx.statement().setBoolean(ctx.index(), value);
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            super.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Boolean value) throws SQLException {
            ctx.output().writeBoolean(value);
        }

        @Override
        final Boolean get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.resultSet(), (Boolean)ctx.resultSet().getBoolean(ctx.index()));
        }

        @Override
        final Boolean get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.statement(), (Boolean)ctx.statement().getBoolean(ctx.index()));
        }

        @Override
        final Boolean get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return JDBCUtils.wasNull(ctx.input(), (Boolean)ctx.input().readBoolean());
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) throws SQLException {
            switch (configuration.family()) {
                default: 
            }
            return 16;
        }
    }

    static final class DefaultBlobBinding<U>
    extends AbstractBinding<Blob, U> {
        private static final long serialVersionUID = -4605427469676162501L;

        DefaultBlobBinding(DataType<Blob> dataType, Converter<Blob, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Blob value) throws SQLException {
            ctx.statement().setBlob(ctx.index(), value);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Blob value) throws SQLException {
            ctx.output().writeBlob(value);
        }

        @Override
        final Blob get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return ctx.resultSet().getBlob(ctx.index());
        }

        @Override
        final Blob get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getBlob(ctx.index());
        }

        @Override
        final Blob get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readBlob();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            switch (configuration.family()) {
                case POSTGRES: {
                    return -2;
                }
            }
            return 2004;
        }
    }

    static final class DefaultBigIntegerBinding<U>
    extends AbstractBinding<BigInteger, U> {
        private static final long serialVersionUID = -3857031689661809421L;
        private static final Set<SQLDialect> BIND_AS_STRING = SQLDialect.supportedBy(SQLDialect.SQLITE);

        DefaultBigIntegerBinding(DataType<BigInteger> dataType, Converter<BigInteger, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, BigInteger value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, BigInteger value) throws SQLException {
            if (BIND_AS_STRING.contains((Object)ctx.dialect())) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setBigDecimal(ctx.index(), new BigDecimal(value));
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, BigInteger value) throws SQLException {
            ctx.output().writeBigDecimal(new BigDecimal(value));
        }

        @Override
        final BigInteger get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigInteger.class);
            }
            BigDecimal b2 = ctx.resultSet().getBigDecimal(ctx.index());
            return b2 == null ? null : b2.toBigInteger();
        }

        @Override
        final BigInteger get0(BindingGetStatementContext<U> ctx) throws SQLException {
            BigDecimal d = ctx.statement().getBigDecimal(ctx.index());
            return d == null ? null : d.toBigInteger();
        }

        @Override
        final BigInteger get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            BigDecimal d = ctx.input().readBigDecimal();
            return d == null ? null : d.toBigInteger();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 3;
        }
    }

    static final class DefaultBigDecimalBinding<U>
    extends AbstractBinding<BigDecimal, U> {
        private static final long serialVersionUID = -8912971184035434281L;
        private static final Set<SQLDialect> BIND_AS_STRING = SQLDialect.supportedBy(SQLDialect.SQLITE);

        DefaultBigDecimalBinding(DataType<BigDecimal> dataType, Converter<BigDecimal, U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, BigDecimal value) {
            ctx.render().sql(value.toString());
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, BigDecimal value) throws SQLException {
            if (BIND_AS_STRING.contains((Object)ctx.dialect())) {
                ctx.statement().setString(ctx.index(), value.toString());
            } else {
                ctx.statement().setBigDecimal(ctx.index(), value);
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, BigDecimal value) throws SQLException {
            ctx.output().writeBigDecimal(value);
        }

        @Override
        final BigDecimal get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            if (ctx.family() == SQLDialect.SQLITE) {
                return Convert.convert((Object)ctx.resultSet().getString(ctx.index()), BigDecimal.class);
            }
            return ctx.resultSet().getBigDecimal(ctx.index());
        }

        @Override
        final BigDecimal get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return ctx.statement().getBigDecimal(ctx.index());
        }

        @Override
        final BigDecimal get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return ctx.input().readBigDecimal();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 3;
        }
    }

    static final class DefaultArrayBinding<U>
    extends AbstractBinding<Object[], U> {
        private static final long serialVersionUID = 6875984626674331432L;
        private static final Set<SQLDialect> REQUIRES_ARRAY_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES);

        DefaultArrayBinding(DataType<Object[]> dataType, Converter<Object[], U> converter) {
            super(dataType, converter);
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, Object[] value) throws SQLException {
            String separator = "";
            if (ctx.family() == SQLDialect.H2) {
                ctx.render().sql('(');
                for (Object o : value) {
                    ctx.render().sql(separator);
                    DefaultBinding.binding(this.dataType.getArrayComponentDataType()).sql(new DefaultBindingSQLContext<Object>(ctx.configuration(), ctx.data(), ctx.render(), o));
                    separator = ", ";
                }
                ctx.render().sql(')');
            } else if (REQUIRES_ARRAY_CAST.contains((Object)ctx.dialect())) {
                Class<Object> arrayType = this.dataType.getType() == Object[].class ? this.deriveArrayTypeFromComponentType(value) : this.dataType.getType();
                ctx.render().visit(DSL.cast(DSL.inline(PostgresUtils.toPGArrayString(value)), arrayType));
            } else {
                boolean squareBrackets = true;
                ctx.render().visit(Keywords.K_ARRAY);
                ctx.render().sql(squareBrackets ? (char)'[' : '(');
                for (Object o : value) {
                    ctx.render().sql(separator);
                    DefaultBinding.binding(this.dataType.getArrayComponentDataType()).sql(new DefaultBindingSQLContext<Object>(ctx.configuration(), ctx.data(), ctx.render(), o));
                    separator = ", ";
                }
                ctx.render().sql(squareBrackets ? (char)']' : ')');
                if (REQUIRES_ARRAY_CAST.contains((Object)ctx.dialect()) && this.dataType.getArrayComponentDataType().isEnum()) {
                    DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.dataType.getType());
                }
            }
        }

        private final Class<?> deriveArrayTypeFromComponentType(Object[] value) {
            for (Object o : value) {
                if (o == null) continue;
                return Array.newInstance(o.getClass(), 0).getClass();
            }
            return String[].class;
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, Object[] value) throws SQLException {
            super.sqlBind0(ctx, value);
            switch (ctx.family()) {
                case POSTGRES: {
                    if (EnumType.class.isAssignableFrom(this.dataType.getType().getComponentType())) {
                        DefaultEnumTypeBinding.pgRenderEnumCast(ctx.render(), this.dataType.getType());
                        break;
                    }
                    ((RenderContext)ctx.render().sql("::")).sql(this.dataType.getCastTypeName(ctx.render().configuration()));
                }
            }
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, Object[] value) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: {
                    ctx.statement().setString(ctx.index(), PostgresUtils.toPGArrayString(value));
                    break;
                }
                case HSQLDB: {
                    Object[] a2 = value;
                    Class<Object> t = this.dataType.getType();
                    if (t == UUID[].class) {
                        a2 = Convert.convertArray(a2, byte[][].class);
                        t = byte[][].class;
                    }
                    ctx.statement().setArray(ctx.index(), new MockArray<Object>(ctx.family(), a2, t));
                    break;
                }
                case H2: {
                    ctx.statement().setObject(ctx.index(), value);
                    break;
                }
                default: {
                    throw new SQLDialectNotSupportedException("Cannot bind ARRAY types in dialect " + (Object)((Object)ctx.family()));
                }
            }
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, Object[] value) throws SQLException {
            ctx.output().writeArray(new MockArray<Object>(ctx.family(), value, this.dataType.getType()));
        }

        @Override
        final Object[] get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            switch (ctx.family()) {
                case POSTGRES: {
                    return (Object[])DefaultArrayBinding.pgGetArray(ctx, ctx.resultSet(), this.dataType, ctx.index());
                }
            }
            return DefaultArrayBinding.convertArray(ctx.resultSet().getArray(ctx.index()), this.dataType.getType());
        }

        @Override
        final Object[] get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return DefaultArrayBinding.convertArray(ctx.statement().getObject(ctx.index()), this.dataType.getType());
        }

        @Override
        final Object[] get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            java.sql.Array array = ctx.input().readArray();
            return array == null ? null : (Object[])array.getArray();
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) {
            return 2003;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final <T> T pgGetArray(Scope ctx, ResultSet rs, DataType<T> dataType, int index) throws SQLException {
            java.sql.Array array = null;
            try {
                array = rs.getArray(index);
                if (array == null) {
                    T t = null;
                    return t;
                }
                if (byte[][].class == dataType.getType()) {
                    throw new ControlFlowSignal("GOTO the next array deserialisation strategy");
                }
                Object[] objectArray = DefaultArrayBinding.convertArray(array, dataType.getType());
                return (T)objectArray;
            }
            finally {
                JDBCUtils.safeFree(array);
            }
        }

        private static final Object[] convertArray(Object array, Class<? extends Object[]> type) throws SQLException {
            if (array instanceof Object[]) {
                return Convert.convert(array, type);
            }
            if (array instanceof java.sql.Array) {
                return DefaultArrayBinding.convertArray((java.sql.Array)array, type);
            }
            return null;
        }

        private static final Object[] convertArray(java.sql.Array array, Class<? extends Object[]> type) throws SQLException {
            if (array != null) {
                return Convert.convert(array.getArray(), type);
            }
            return null;
        }
    }

    static final class DelegatingBinding<X, T, U>
    extends AbstractBinding<X, U> {
        private static final long serialVersionUID = 9222783475194108822L;
        private final Converter<T, X> delegatingConverter;
        private final AbstractBinding<T, U> delegatingBinding;

        DelegatingBinding(DataType<X> originalDataType, Converter<T, X> delegatingConverter, Converter<X, U> originalConverter, AbstractBinding<T, U> delegatingBinding) {
            super(originalDataType, originalConverter);
            this.delegatingConverter = delegatingConverter;
            this.delegatingBinding = delegatingBinding;
        }

        @Override
        final void sqlInline0(BindingSQLContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.sqlInline0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final void sqlBind0(BindingSQLContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.sqlBind0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final void set0(BindingSetStatementContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.set0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            this.delegatingBinding.setNull0(ctx);
        }

        @Override
        final void set0(BindingSetSQLOutputContext<U> ctx, X value) throws SQLException {
            this.delegatingBinding.set0(ctx, this.delegatingConverter.to(value));
        }

        @Override
        final X get0(BindingGetResultSetContext<U> ctx) throws SQLException {
            return this.delegatingConverter.from(this.delegatingBinding.get0(ctx));
        }

        @Override
        final X get0(BindingGetStatementContext<U> ctx) throws SQLException {
            return this.delegatingConverter.from(this.delegatingBinding.get0(ctx));
        }

        @Override
        final X get0(BindingGetSQLInputContext<U> ctx) throws SQLException {
            return this.delegatingConverter.from(this.delegatingBinding.get0(ctx));
        }

        @Override
        final int sqltype(Statement statement, Configuration configuration) throws SQLException {
            return this.delegatingBinding.sqltype(statement, configuration);
        }
    }

    static abstract class AbstractBinding<T, U>
    implements Binding<T, U> {
        private static final long serialVersionUID = -7965247586545864991L;
        static final Set<SQLDialect> NEEDS_PRECISION_SCALE_ON_BIGDECIMAL = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB);
        static final Set<SQLDialect> REQUIRES_JSON_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES);
        static final Set<SQLDialect> NO_SUPPORT_ENUM_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES);
        static final Set<SQLDialect> NO_SUPPORT_NVARCHAR = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.SQLITE);
        final DataType<T> dataType;
        final Converter<T, U> converter;
        final boolean attachable;

        AbstractBinding(DataType<T> dataType, Converter<T, U> converter) {
            this.dataType = dataType;
            this.converter = converter;
            this.attachable = Attachable.class.isAssignableFrom(converter.toType()) || !Modifier.isFinal(converter.toType().getModifiers());
        }

        @Override
        public final Converter<T, U> converter() {
            return this.converter;
        }

        private final boolean shouldCast(BindingSQLContext<U> ctx, T converted) {
            if (ctx.render().paramType() != ParamType.INLINED && !(converted instanceof EnumType)) {
                switch (ctx.family()) {
                    case DERBY: 
                    case FIREBIRD: 
                    case H2: 
                    case HSQLDB: 
                    case CUBRID: 
                    case POSTGRES: {
                        return true;
                    }
                }
            }
            if (this.dataType.isInterval()) {
                switch (ctx.family()) {
                    case H2: 
                    case HSQLDB: 
                    case POSTGRES: {
                        return true;
                    }
                }
            }
            if (this.dataType.isJSON()) {
                switch (ctx.family()) {
                    case POSTGRES: {
                        return true;
                    }
                }
            }
            return false;
        }

        private final void sqlCast(BindingSQLContext<U> ctx, T converted) throws SQLException {
            DataType<T> sqlDataType = this.dataType.getSQLDataType();
            SQLDialect family = ctx.family();
            if (converted != null && this.dataType.getType() == BigDecimal.class && NEEDS_PRECISION_SCALE_ON_BIGDECIMAL.contains((Object)ctx.dialect())) {
                int precision;
                int scale = ((BigDecimal)converted).scale();
                if (scale >= (precision = ((BigDecimal)converted).precision())) {
                    precision = scale + 1;
                }
                this.sqlCast(ctx, converted, this.dataType, null, precision, scale);
            } else if (SQLDataType.ROWID == sqlDataType) {
                this.sql(ctx, converted);
            } else if (SQLDataType.OTHER == sqlDataType) {
                if (converted != null) {
                    this.sqlCast(ctx, converted, DefaultDataType.getDataType(family, converted.getClass()), null, null, null);
                } else {
                    this.sqlCast(ctx, converted, DefaultDataType.getDataType(family, String.class), null, null, null);
                }
            } else if (REQUIRES_JSON_CAST.contains((Object)ctx.dialect()) && (sqlDataType == null || !sqlDataType.isTemporal() && sqlDataType != SQLDataType.UUID && sqlDataType != SQLDataType.JSON && sqlDataType != SQLDataType.JSONB)) {
                this.sql(ctx, converted);
            } else if (SQLDialect.FIREBIRD == family && (sqlDataType == SQLDataType.VARCHAR || sqlDataType == SQLDataType.CHAR)) {
                if (this.dataType.lengthDefined()) {
                    this.sqlCast(ctx, converted, this.dataType, this.dataType.length(), null, null);
                } else {
                    this.sqlCast(ctx, converted, this.dataType, AbstractBinding.getValueLength((String)converted), null, null);
                }
            } else if (!NO_SUPPORT_ENUM_CAST.contains((Object)ctx.dialect()) && this.dataType.isEnum()) {
                this.sqlCast(ctx, converted, Tools.emulateEnumType(this.dataType), this.dataType.lengthDefined() ? Integer.valueOf(this.dataType.length()) : null, this.dataType.precisionDefined() ? Integer.valueOf(this.dataType.precision()) : null, this.dataType.scaleDefined() ? Integer.valueOf(this.dataType.scale()) : null);
            } else {
                this.sqlCast(ctx, converted, this.dataType, this.dataType.lengthDefined() ? Integer.valueOf(this.dataType.length()) : null, this.dataType.precisionDefined() ? Integer.valueOf(this.dataType.precision()) : null, this.dataType.scaleDefined() ? Integer.valueOf(this.dataType.scale()) : null);
            }
        }

        private static final int getValueLength(String string) {
            if (string == null) {
                return 1;
            }
            int length = string.length();
            for (int i = 0; i < length; ++i) {
                if (string.charAt(i) <= '\u007f') continue;
                return Math.min(32672, 4 * length);
            }
            return Math.min(32672, length);
        }

        private final void sqlCast(BindingSQLContext<U> ctx, T converted, DataType<?> t, Integer length, Integer precision, Integer scale) throws SQLException {
            ((RenderContext)ctx.render().visit(Keywords.K_CAST)).sql('(');
            this.sql(ctx, converted);
            ((RenderContext)((RenderContext)((RenderContext)((RenderContext)ctx.render().sql(' ')).visit(Keywords.K_AS)).sql(' ')).sql(DefaultDataType.set(t, length, precision, scale).getCastTypeName(ctx.configuration()))).sql(')');
        }

        @Override
        public final void sql(BindingSQLContext<U> ctx) throws SQLException {
            T converted = this.converter().to(ctx.value());
            switch (ctx.render().castMode()) {
                case NEVER: {
                    this.sql(ctx, converted);
                    return;
                }
                case ALWAYS: {
                    this.sqlCast(ctx, converted);
                    return;
                }
            }
            if (this.shouldCast(ctx, converted)) {
                this.sqlCast(ctx, converted);
            } else {
                this.sql(ctx, converted);
            }
        }

        private final void sql(BindingSQLContext<U> ctx, T value) throws SQLException {
            if (ctx.render().paramType() == ParamType.INLINED) {
                if (value == null) {
                    ctx.render().visit(Keywords.K_NULL);
                } else {
                    this.sqlInline0(ctx, value);
                }
            } else {
                this.sqlBind0(ctx, value);
            }
        }

        static final String escape(Object val, Context<?> context) {
            String result = val.toString();
            if (Tools.needsBackslashEscaping(context.configuration())) {
                result = StringUtils.replace(result, "\\", "\\\\");
            }
            return StringUtils.replace(result, "'", "''");
        }

        @Override
        public final void register(BindingRegisterContext<U> ctx) throws SQLException {
            if (!Boolean.FALSE.equals(ctx.settings().isExecuteLogging()) && log.isTraceEnabled()) {
                log.trace((Object)("Registering variable " + ctx.index()), "" + this.dataType);
            }
            this.register0(ctx);
        }

        @Override
        public final void set(BindingSetStatementContext<U> ctx) throws SQLException {
            T value = this.converter().to(ctx.value());
            if (!Boolean.FALSE.equals(ctx.settings().isExecuteLogging()) && log.isTraceEnabled()) {
                if (value != null && value.getClass().isArray() && value.getClass() != byte[].class) {
                    log.trace((Object)("Binding variable " + ctx.index()), Arrays.asList((Object[])value) + " (" + this.dataType + ")");
                } else {
                    log.trace((Object)("Binding variable " + ctx.index()), value + " (" + this.dataType + ")");
                }
            }
            if (value == null) {
                this.setNull0(ctx);
            } else {
                this.set0(ctx, value);
            }
        }

        @Override
        public final void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
            T value = this.converter().to(ctx.value());
            if (value == null) {
                ctx.output().writeObject(null);
            } else {
                this.set0(ctx, value);
            }
        }

        @Override
        public final void get(BindingGetResultSetContext<U> ctx) throws SQLException {
            U value = this.converter().from(this.get0(ctx));
            if (this.attachable) {
                value = AbstractBinding.attach(value, ctx.configuration());
            }
            ctx.value(value);
        }

        @Override
        public final void get(BindingGetStatementContext<U> ctx) throws SQLException {
            U value = this.converter().from(this.get0(ctx));
            if (this.attachable) {
                value = AbstractBinding.attach(value, ctx.configuration());
            }
            ctx.value(value);
        }

        @Override
        public final void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
            U value = this.converter().from(this.get0(ctx));
            if (this.attachable) {
                value = AbstractBinding.attach(value, ctx.configuration());
            }
            ctx.value(value);
        }

        private static final <U> U attach(U value, Configuration configuration) {
            if (value instanceof Attachable && Tools.attachRecords(configuration)) {
                ((Attachable)value).attach(configuration);
            }
            return value;
        }

        void setNull0(BindingSetStatementContext<U> ctx) throws SQLException {
            ctx.statement().setNull(ctx.index(), this.sqltype(ctx.statement(), ctx.configuration()));
        }

        void register0(BindingRegisterContext<U> ctx) throws SQLException {
            ctx.statement().registerOutParameter(ctx.index(), this.sqltype(ctx.statement(), ctx.configuration()));
        }

        void sqlInline0(BindingSQLContext<U> ctx, T value) throws SQLException {
            ((RenderContext)((RenderContext)ctx.render().sql('\'')).sql(AbstractBinding.escape(value, ctx.render()), true)).sql('\'');
        }

        void sqlBind0(BindingSQLContext<U> ctx, T value) throws SQLException {
            ctx.render().sql(ctx.variable());
        }

        abstract void set0(BindingSetStatementContext<U> var1, T var2) throws SQLException;

        abstract void set0(BindingSetSQLOutputContext<U> var1, T var2) throws SQLException;

        abstract T get0(BindingGetResultSetContext<U> var1) throws SQLException;

        abstract T get0(BindingGetStatementContext<U> var1) throws SQLException;

        abstract T get0(BindingGetSQLInputContext<U> var1) throws SQLException;

        abstract int sqltype(Statement var1, Configuration var2) throws SQLException;

        public String toString() {
            return "AbstractBinding [type=" + this.dataType + ", converter=" + this.converter + "]";
        }
    }
}

