/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.impl.AbstractAggregateFunction;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Term;
import com.craftaro.third_party.org.jooq.impl.Tools;

class DefaultAggregateFunction<T>
extends AbstractAggregateFunction<T> {
    private static final long serialVersionUID = 347252741712134044L;
    private final Term term;

    DefaultAggregateFunction(String name, DataType<T> type, Field<?> ... arguments) {
        this(false, name, type, arguments);
    }

    DefaultAggregateFunction(Name name, DataType<T> type, Field<?> ... arguments) {
        this(false, name, type, arguments);
    }

    DefaultAggregateFunction(Term term, DataType<T> type, Field<?> ... arguments) {
        this(false, term, type, arguments);
    }

    DefaultAggregateFunction(boolean distinct, String name, DataType<T> type, Field<?> ... arguments) {
        this(distinct, DSL.unquotedName(name), type, arguments);
    }

    DefaultAggregateFunction(boolean distinct, Name name, DataType<T> type, Field<?> ... arguments) {
        super(distinct, name, type, arguments);
        this.term = null;
    }

    DefaultAggregateFunction(boolean distinct, Term term, DataType<T> type, Field<?> ... arguments) {
        super(distinct, term.toName(), type, arguments);
        this.term = term;
    }

    @Override
    public void accept(Context<?> ctx) {
        this.toSQLArguments(ctx);
        this.acceptKeepDenseRankOrderByClause(ctx);
        this.acceptWithinGroupClause(ctx);
        this.acceptFilterClause(ctx);
        this.acceptOverClause(ctx);
    }

    private final void acceptKeepDenseRankOrderByClause(Context<?> ctx) {
        if (!Tools.isEmpty(this.keepDenseRankOrderBy)) {
            ctx.sql(' ').visit(Keywords.K_KEEP).sql(" (").visit(Keywords.K_DENSE_RANK).sql(' ').visit(this.first ? Keywords.K_FIRST : Keywords.K_LAST).sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.keepDenseRankOrderBy).sql(')');
        }
    }

    final void acceptWithinGroupClause(Context<?> ctx) {
        if (this.withinGroupOrderBy != null) {
            ctx.sql(' ').visit(Keywords.K_WITHIN_GROUP).sql(" (").visit(Keywords.K_ORDER_BY).sql(' ');
            if (this.withinGroupOrderBy.isEmpty()) {
                ctx.visit(Keywords.K_NULL);
            } else {
                ctx.visit(this.withinGroupOrderBy);
            }
            ctx.sql(')');
        }
    }

    private final void toSQLArguments(Context<?> ctx) {
        this.toSQLFunctionName(ctx);
        ctx.sql('(');
        this.acceptArguments0(ctx);
        ctx.sql(')');
    }

    private final void toSQLFunctionName(Context<?> ctx) {
        if (this.term != null) {
            ctx.sql(this.term.translate(ctx.dialect()));
        } else {
            ctx.visit(this.getQualifiedName());
        }
    }
}

