/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Check;
import com.craftaro.third_party.org.jooq.Comment;
import com.craftaro.third_party.org.jooq.Constraint;
import com.craftaro.third_party.org.jooq.ConstraintEnforcementStep;
import com.craftaro.third_party.org.jooq.CreateDomainAsStep;
import com.craftaro.third_party.org.jooq.CreateDomainConstraintStep;
import com.craftaro.third_party.org.jooq.CreateDomainDefaultStep;
import com.craftaro.third_party.org.jooq.CreateSequenceFlagsStep;
import com.craftaro.third_party.org.jooq.CreateTableConstraintStep;
import com.craftaro.third_party.org.jooq.CreateViewAsStep;
import com.craftaro.third_party.org.jooq.DDLExportConfiguration;
import com.craftaro.third_party.org.jooq.DDLFlag;
import com.craftaro.third_party.org.jooq.DSLContext;
import com.craftaro.third_party.org.jooq.Domain;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.ForeignKey;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Key;
import com.craftaro.third_party.org.jooq.Meta;
import com.craftaro.third_party.org.jooq.Named;
import com.craftaro.third_party.org.jooq.Queries;
import com.craftaro.third_party.org.jooq.Query;
import com.craftaro.third_party.org.jooq.Schema;
import com.craftaro.third_party.org.jooq.Sequence;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TableOptions;
import com.craftaro.third_party.org.jooq.UniqueKey;
import com.craftaro.third_party.org.jooq.impl.Comparators;
import com.craftaro.third_party.org.jooq.impl.CreateViewImpl;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.tools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class DDL {
    private final DSLContext ctx;
    private final DDLExportConfiguration configuration;

    DDL(DSLContext ctx, DDLExportConfiguration configuration) {
        this.ctx = ctx;
        this.configuration = configuration;
    }

    private final List<Query> createTableOrView(Table<?> table, Collection<? extends Constraint> constraints) {
        boolean temporary = table.getType() == TableOptions.TableType.TEMPORARY;
        boolean view = table.getType().isView();
        TableOptions.OnCommit onCommit = table.getOptions().onCommit();
        if (view) {
            ArrayList<Query> result = new ArrayList<Query>();
            result.add(this.applyAs(this.configuration.createViewIfNotExists() ? this.ctx.createViewIfNotExists(table, table.fields()) : (this.configuration.createOrReplaceView() ? this.ctx.createOrReplaceView(table, table.fields()) : this.ctx.createView(table, table.fields())), table.getOptions()));
            if (!constraints.isEmpty() && this.configuration.includeConstraintsOnViews()) {
                result.addAll(this.alterTableAddConstraints(table));
            }
            return result;
        }
        CreateTableConstraintStep s0 = (this.configuration.createTableIfNotExists() ? (temporary ? this.ctx.createTemporaryTableIfNotExists(table) : this.ctx.createTableIfNotExists(table)) : (temporary ? this.ctx.createTemporaryTable(table) : this.ctx.createTable(table))).columns(this.sortIf(Arrays.asList(table.fields()), !this.configuration.respectColumnOrder())).constraints(constraints);
        if (temporary && onCommit != null) {
            switch (table.getOptions().onCommit()) {
                case DELETE_ROWS: {
                    return Arrays.asList(s0.onCommitDeleteRows());
                }
                case PRESERVE_ROWS: {
                    return Arrays.asList(s0.onCommitPreserveRows());
                }
                case DROP: {
                    return Arrays.asList(s0.onCommitDrop());
                }
            }
            throw new IllegalStateException("Unsupported flag: " + (Object)((Object)onCommit));
        }
        return Arrays.asList(s0);
    }

    private final Query applyAs(CreateViewAsStep q, TableOptions options) {
        if (options.select() != null) {
            return q.as(options.select());
        }
        if (StringUtils.isBlank(options.source())) {
            return q.as("");
        }
        Query[] queries = this.ctx.parser().parse(options.source()).queries();
        if (queries.length > 0 && queries[0] instanceof CreateViewImpl) {
            return q.as(((CreateViewImpl)queries[0]).$select());
        }
        return q.as("");
    }

    final Query createSequence(Sequence<?> sequence) {
        CreateSequenceFlagsStep result;
        CreateSequenceFlagsStep createSequenceFlagsStep = result = this.configuration.createSequenceIfNotExists() ? this.ctx.createSequenceIfNotExists(sequence) : this.ctx.createSequence(sequence);
        if (sequence.getStartWith() != null) {
            result = result.startWith(sequence.getStartWith());
        } else if (this.configuration.defaultSequenceFlags()) {
            result = result.startWith(1);
        }
        if (sequence.getIncrementBy() != null) {
            result = result.incrementBy(sequence.getIncrementBy());
        } else if (this.configuration.defaultSequenceFlags()) {
            result = result.incrementBy(1);
        }
        if (sequence.getMinvalue() != null) {
            result = result.minvalue(sequence.getMinvalue());
        } else if (this.configuration.defaultSequenceFlags()) {
            result = result.noMinvalue();
        }
        if (sequence.getMaxvalue() != null) {
            result = result.maxvalue(sequence.getMaxvalue());
        } else if (this.configuration.defaultSequenceFlags()) {
            result = result.noMaxvalue();
        }
        if (sequence.getCycle()) {
            result = result.cycle();
        } else if (this.configuration.defaultSequenceFlags()) {
            result = result.noCycle();
        }
        if (sequence.getCache() != null) {
            result = result.cache(sequence.getCache());
        } else if (this.configuration.defaultSequenceFlags()) {
            result = result.noCache();
        }
        return result;
    }

    final Query createDomain(Domain<?> domain) {
        CreateDomainDefaultStep s3;
        CreateDomainAsStep s1 = this.configuration.createDomainIfNotExists() ? this.ctx.createDomainIfNotExists(domain) : this.ctx.createDomain(domain);
        CreateDomainDefaultStep s2 = s1.as(domain.getDataType());
        CreateDomainConstraintStep createDomainConstraintStep = s3 = domain.getDataType().defaulted() ? s2.default_(domain.getDataType().default_()) : s2;
        if (domain.getChecks().isEmpty()) {
            return s3;
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (Check<?> check : domain.getChecks()) {
            constraints.add(check.constraint());
        }
        return s3.constraints(constraints);
    }

    final List<Query> createTableOrView(Table<?> table) {
        return this.createTableOrView(table, this.constraints(table));
    }

    private final List<Query> createIndex(Table<?> table) {
        ArrayList<Query> result = new ArrayList<Query>();
        if (this.configuration.flags().contains((Object)DDLFlag.INDEX)) {
            for (Index i : this.sortIf(table.getIndexes(), !this.configuration.respectIndexOrder())) {
                result.add((this.configuration.createIndexIfNotExists() ? (i.getUnique() ? this.ctx.createUniqueIndexIfNotExists(i) : this.ctx.createIndexIfNotExists(i)) : (i.getUnique() ? this.ctx.createUniqueIndex(i) : this.ctx.createIndex(i))).on(i.getTable(), i.getFields()));
            }
        }
        return result;
    }

    private final List<Query> alterTableAddConstraints(Table<?> table) {
        return this.alterTableAddConstraints(table, this.constraints(table));
    }

    private final List<Query> alterTableAddConstraints(Table<?> table, List<Constraint> constraints) {
        ArrayList<Query> result = new ArrayList<Query>(constraints.size());
        for (Constraint constraint : constraints) {
            result.add(this.ctx.alterTable(table).add(constraint));
        }
        return result;
    }

    private final List<Constraint> constraints(Table<?> table) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        result.addAll(this.primaryKeys(table));
        result.addAll(this.uniqueKeys(table));
        result.addAll(this.foreignKeys(table));
        result.addAll(this.checks(table));
        return result;
    }

    private final List<Constraint> primaryKeys(Table<?> table) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        if (this.configuration.flags().contains((Object)DDLFlag.PRIMARY_KEY) && (table.getType() != TableOptions.TableType.VIEW || this.configuration.includeConstraintsOnViews())) {
            for (UniqueKey<?> key : table.getKeys()) {
                if (!key.isPrimary()) continue;
                result.add(this.enforced(DSL.constraint(key.getUnqualifiedName()).primaryKey(key.getFieldsArray()), key.enforced()));
            }
        }
        return result;
    }

    private final List<Constraint> uniqueKeys(Table<?> table) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        if (this.configuration.flags().contains((Object)DDLFlag.UNIQUE) && (table.getType() != TableOptions.TableType.VIEW || this.configuration.includeConstraintsOnViews())) {
            for (UniqueKey<?> key : this.sortKeysIf(table.getKeys(), !this.configuration.respectConstraintOrder())) {
                if (key.isPrimary()) continue;
                result.add(this.enforced(DSL.constraint(key.getUnqualifiedName()).unique(key.getFieldsArray()), key.enforced()));
            }
        }
        return result;
    }

    private final List<Constraint> foreignKeys(Table<?> table) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        if (this.configuration.flags().contains((Object)DDLFlag.FOREIGN_KEY) && (table.getType() != TableOptions.TableType.VIEW || this.configuration.includeConstraintsOnViews())) {
            for (ForeignKey<?, ?> key : this.sortKeysIf(table.getReferences(), !this.configuration.respectConstraintOrder())) {
                result.add(this.enforced(DSL.constraint(key.getUnqualifiedName()).foreignKey(key.getFieldsArray()).references(key.getKey().getTable(), key.getKeyFieldsArray()), key.enforced()));
            }
        }
        return result;
    }

    private final List<Constraint> checks(Table<?> table) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        if (this.configuration.flags().contains((Object)DDLFlag.CHECK) && (table.getType() != TableOptions.TableType.VIEW || this.configuration.includeConstraintsOnViews())) {
            for (Check<?> check : this.sortIf(table.getChecks(), !this.configuration.respectConstraintOrder())) {
                result.add(this.enforced(DSL.constraint(check.getUnqualifiedName()).check(check.condition()), check.enforced()));
            }
        }
        return result;
    }

    final Queries queries(Table<?> ... tables) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Table<?> table : tables) {
            if (this.configuration.flags().contains((Object)DDLFlag.TABLE)) {
                queries.addAll(this.createTableOrView(table));
            } else {
                queries.addAll(this.alterTableAddConstraints(table));
            }
            queries.addAll(this.createIndex(table));
            queries.addAll(this.commentOn(table));
        }
        return this.ctx.queries(queries);
    }

    private final List<Query> commentOn(Table<?> table) {
        ArrayList<Query> result = new ArrayList<Query>();
        if (this.configuration.flags().contains((Object)DDLFlag.COMMENT)) {
            Comment tComment = table.getCommentPart();
            if (!StringUtils.isEmpty(tComment.getComment())) {
                if (table.getType().isView()) {
                    result.add(this.ctx.commentOnView(table).is(tComment));
                } else {
                    result.add(this.ctx.commentOnTable(table).is(tComment));
                }
            }
            for (Field<?> field : this.sortIf(Arrays.asList(table.fields()), !this.configuration.respectColumnOrder())) {
                Comment fComment = field.getCommentPart();
                if (StringUtils.isEmpty(fComment.getComment())) continue;
                result.add(this.ctx.commentOnColumn(field).is(fComment));
            }
        }
        return result;
    }

    final Queries queries(Meta meta) {
        ArrayList<Query> queries = new ArrayList<Query>();
        List<Schema> schemas = this.sortIf(meta.getSchemas(), !this.configuration.respectSchemaOrder());
        for (Schema schema : schemas) {
            if (!this.configuration.flags().contains((Object)DDLFlag.SCHEMA) || schema.getUnqualifiedName().empty()) continue;
            if (this.configuration.createSchemaIfNotExists()) {
                queries.add(this.ctx.createSchemaIfNotExists(schema.getUnqualifiedName()));
                continue;
            }
            queries.add(this.ctx.createSchema(schema.getUnqualifiedName()));
        }
        if (this.configuration.flags().contains((Object)DDLFlag.TABLE)) {
            for (Schema schema : schemas) {
                for (Table<?> table : this.sortIf(schema.getTables(), !this.configuration.respectTableOrder())) {
                    ArrayList<Constraint> constraints = new ArrayList<Constraint>();
                    constraints.addAll(this.primaryKeys(table));
                    constraints.addAll(this.uniqueKeys(table));
                    constraints.addAll(this.checks(table));
                    queries.addAll(this.createTableOrView(table, constraints));
                }
            }
        } else {
            for (Schema schema : schemas) {
                if (this.configuration.flags().contains((Object)DDLFlag.PRIMARY_KEY)) {
                    for (Table<?> table : this.sortIf(schema.getTables(), !this.configuration.respectTableOrder())) {
                        for (Constraint constraint : this.sortIf(this.primaryKeys(table), !this.configuration.respectConstraintOrder())) {
                            queries.add(this.ctx.alterTable(table).add(constraint));
                        }
                    }
                }
                if (this.configuration.flags().contains((Object)DDLFlag.UNIQUE)) {
                    for (Table<?> table : this.sortIf(schema.getTables(), !this.configuration.respectTableOrder())) {
                        for (Constraint constraint : this.sortIf(this.uniqueKeys(table), !this.configuration.respectConstraintOrder())) {
                            queries.add(this.ctx.alterTable(table).add(constraint));
                        }
                    }
                }
                if (!this.configuration.flags().contains((Object)DDLFlag.CHECK)) continue;
                for (Table table : this.sortIf(schema.getTables(), !this.configuration.respectTableOrder())) {
                    for (Constraint constraint : this.sortIf(this.checks(table), !this.configuration.respectConstraintOrder())) {
                        queries.add(this.ctx.alterTable(table).add(constraint));
                    }
                }
            }
        }
        if (this.configuration.flags().contains((Object)DDLFlag.FOREIGN_KEY)) {
            for (Schema schema : schemas) {
                for (Table<?> table : this.sortIf(schema.getTables(), !this.configuration.respectTableOrder())) {
                    for (Constraint constraint : this.foreignKeys(table)) {
                        queries.add(this.ctx.alterTable(table).add(constraint));
                    }
                }
            }
        }
        if (this.configuration.flags().contains((Object)DDLFlag.DOMAIN)) {
            for (Schema schema : schemas) {
                for (Domain domain : this.sortIf(schema.getDomains(), !this.configuration.respectDomainOrder())) {
                    queries.add(this.createDomain(domain));
                }
            }
        }
        if (this.configuration.flags().contains((Object)DDLFlag.SEQUENCE)) {
            for (Schema schema : schemas) {
                for (Sequence sequence : this.sortIf(schema.getSequences(), !this.configuration.respectSequenceOrder())) {
                    queries.add(this.createSequence(sequence));
                }
            }
        }
        if (this.configuration.flags().contains((Object)DDLFlag.COMMENT)) {
            for (Schema schema : schemas) {
                for (Table table : this.sortIf(schema.getTables(), !this.configuration.respectTableOrder())) {
                    queries.addAll(this.commentOn(table));
                }
            }
        }
        if (this.configuration.flags().contains((Object)DDLFlag.INDEX)) {
            for (Schema schema : schemas) {
                for (Table table : this.sortIf(schema.getTables(), !this.configuration.respectTableOrder())) {
                    queries.addAll(this.createIndex(table));
                }
            }
        }
        return this.ctx.queries(queries);
    }

    private final <K extends Key<?>> List<K> sortKeysIf(List<K> input, boolean sort) {
        if (sort) {
            ArrayList<K> result = new ArrayList<K>(input);
            Collections.sort(result, Comparators.KEY_COMP);
            Collections.sort(result, Comparators.NAMED_COMP);
            return result;
        }
        return input;
    }

    private final <N extends Named> List<N> sortIf(List<N> input, boolean sort) {
        if (sort) {
            ArrayList<N> result = new ArrayList<N>(input);
            Collections.sort(result, Comparators.NAMED_COMP);
            return result;
        }
        return input;
    }

    private final Constraint enforced(ConstraintEnforcementStep check, boolean enforced) {
        return check;
    }
}

