/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Comment;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Constraint;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.CreateTableColumnStep;
import com.craftaro.third_party.org.jooq.CreateTableWithDataStep;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.EnumType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.Nullability;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.SQL;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Select;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TableLike;
import com.craftaro.third_party.org.jooq.TableOptions;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.ConstraintImpl;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.SortFieldList;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class CreateTableImpl
extends AbstractRowCountQuery
implements CreateTableWithDataStep,
CreateTableColumnStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> NO_SUPPORT_WITH_DATA = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_CTAS_COLUMN_NAMES = SQLDialect.supportedBy(SQLDialect.H2);
    private static final Set<SQLDialect> EMULATE_INDEXES_IN_BLOCK = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> EMULATE_SOME_ENUM_TYPES_AS_CHECK = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private static final Set<SQLDialect> EMULATE_STORED_ENUM_TYPES_AS_CHECK = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.SQLITE);
    private static final Set<SQLDialect> REQUIRES_WITH_DATA = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final Set<SQLDialect> WRAP_SELECT_IN_PARENS = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final Set<SQLDialect> SUPPORT_TEMPORARY = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> EMULATE_COMMENT_IN_BLOCK = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> REQUIRE_EXECUTE_IMMEDIATE = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> NO_SUPPORT_NULLABLE_PRIMARY_KEY = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Table<?> table;
    private Select<?> select;
    private Boolean withData;
    private final List<Field<?>> columnFields;
    private final List<DataType<?>> columnTypes;
    private final List<Constraint> constraints;
    private final List<Index> indexes;
    private final boolean temporary;
    private final boolean ifNotExists;
    private TableOptions.OnCommit onCommit;
    private Comment comment;
    private SQL storage;

    CreateTableImpl(Configuration configuration, Table<?> table, boolean temporary, boolean ifNotExists) {
        super(configuration);
        this.table = table;
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.columnFields = new ArrayList();
        this.columnTypes = new ArrayList();
        this.constraints = new ArrayList<Constraint>();
        this.indexes = new ArrayList<Index>();
    }

    final Table<?> $table() {
        return this.table;
    }

    final boolean $temporary() {
        return this.temporary;
    }

    final TableOptions.OnCommit $onCommit() {
        return this.onCommit;
    }

    final Select<?> $select() {
        return this.select;
    }

    final List<Field<?>> $columnFields() {
        return this.columnFields;
    }

    final List<DataType<?>> $columnTypes() {
        return this.columnTypes;
    }

    final List<Constraint> $constraints() {
        return this.constraints;
    }

    final List<Index> $indexes() {
        return this.indexes;
    }

    final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    final Comment $comment() {
        return this.comment;
    }

    public final CreateTableImpl as(Select<? extends Record> s) {
        this.select = s;
        return this;
    }

    @Override
    public final CreateTableImpl withData() {
        this.withData = true;
        return this;
    }

    @Override
    public final CreateTableImpl withNoData() {
        this.withData = false;
        return this;
    }

    @Override
    public final CreateTableImpl column(Field<?> field) {
        return this.column((Field)field, field.getDataType());
    }

    @Override
    public final CreateTableImpl columns(Field<?> ... fields) {
        return this.columns(Arrays.asList(fields));
    }

    @Override
    public final CreateTableImpl columns(Name ... fields) {
        return this.columns((Field[])Tools.fieldsByName(fields));
    }

    @Override
    public final CreateTableImpl columns(String ... fields) {
        return this.columns((Field[])Tools.fieldsByName(fields));
    }

    @Override
    public final CreateTableImpl columns(Collection<? extends Field<?>> fields) {
        for (Field<?> field : fields) {
            this.column((Field)field);
        }
        return this;
    }

    @Override
    public final <T> CreateTableImpl column(Field<T> field, DataType<T> type) {
        this.columnFields.add(field);
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableImpl column(Name field, DataType<?> type) {
        this.columnFields.add(DSL.field(field, type));
        this.columnTypes.add(type);
        return this;
    }

    @Override
    public final CreateTableImpl column(String field, DataType<?> type) {
        return this.column(DSL.name(field), (DataType)type);
    }

    @Override
    public final CreateTableImpl constraint(Constraint c2) {
        return this.constraints(Arrays.asList(c2));
    }

    @Override
    public final CreateTableImpl constraints(Constraint ... c2) {
        return this.constraints(Arrays.asList(c2));
    }

    @Override
    public final CreateTableImpl constraints(Collection<? extends Constraint> c2) {
        this.constraints.addAll(c2);
        return this;
    }

    @Override
    public final CreateTableImpl index(Index i) {
        return this.indexes(Arrays.asList(i));
    }

    @Override
    public final CreateTableImpl indexes(Index ... i) {
        return this.indexes(Arrays.asList(i));
    }

    @Override
    public final CreateTableImpl indexes(Collection<? extends Index> i) {
        this.indexes.addAll(i);
        return this;
    }

    @Override
    public final CreateTableImpl onCommitDeleteRows() {
        this.onCommit = TableOptions.OnCommit.DELETE_ROWS;
        return this;
    }

    @Override
    public final CreateTableImpl onCommitPreserveRows() {
        this.onCommit = TableOptions.OnCommit.PRESERVE_ROWS;
        return this;
    }

    @Override
    public final CreateTableImpl onCommitDrop() {
        this.onCommit = TableOptions.OnCommit.DROP;
        return this;
    }

    @Override
    public final CreateTableImpl comment(String c2) {
        return this.comment(DSL.comment(c2));
    }

    @Override
    public final CreateTableImpl comment(Comment c2) {
        this.comment = c2;
        return this;
    }

    @Override
    public final CreateTableImpl storage(SQL sql) {
        this.storage = sql;
        return this;
    }

    @Override
    public final CreateTableImpl storage(String sql) {
        return this.storage(DSL.sql(sql));
    }

    @Override
    public final CreateTableImpl storage(String sql, Object ... bindings) {
        return this.storage(DSL.sql(sql, bindings));
    }

    @Override
    public final CreateTableImpl storage(String sql, QueryPart ... parts) {
        return this.storage(DSL.sql(sql, parts));
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_TABLE);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_TABLE);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean i;
        boolean c2 = this.comment != null && EMULATE_COMMENT_IN_BLOCK.contains((Object)ctx.dialect());
        boolean bl = i = !this.indexes.isEmpty() && EMULATE_INDEXES_IN_BLOCK.contains((Object)ctx.dialect());
        if (c2 || i) {
            Tools.begin(ctx);
            if (REQUIRE_EXECUTE_IMMEDIATE.contains((Object)ctx.dialect())) {
                Tools.beginExecuteImmediate(ctx);
            }
            this.accept1(ctx);
            if (REQUIRE_EXECUTE_IMMEDIATE.contains((Object)ctx.dialect())) {
                Tools.endExecuteImmediate(ctx);
            } else {
                ctx.sql(';');
            }
            if (c2) {
                ctx.formatSeparator();
                if (REQUIRE_EXECUTE_IMMEDIATE.contains((Object)ctx.dialect())) {
                    Tools.beginExecuteImmediate(ctx);
                }
                ctx.visit(DSL.commentOnTable(this.table).is(this.comment));
                if (REQUIRE_EXECUTE_IMMEDIATE.contains((Object)ctx.dialect())) {
                    Tools.endExecuteImmediate(ctx);
                } else {
                    ctx.sql(';');
                }
            }
            if (i) {
                for (Index index : this.indexes) {
                    ctx.formatSeparator();
                    if (REQUIRE_EXECUTE_IMMEDIATE.contains((Object)ctx.dialect())) {
                        Tools.beginExecuteImmediate(ctx);
                    }
                    if ("".equals(index.getName())) {
                        ctx.visit(DSL.createIndex().on(index.getTable(), index.getFields()));
                    } else {
                        ctx.visit(DSL.createIndex(index.getUnqualifiedName()).on(index.getTable(), index.getFields()));
                    }
                    if (REQUIRE_EXECUTE_IMMEDIATE.contains((Object)ctx.dialect())) {
                        Tools.endExecuteImmediate(ctx);
                        continue;
                    }
                    ctx.sql(';');
                }
            }
            Tools.end(ctx);
            return;
        }
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE);
        if (this.select != null) {
            this.acceptCreateTableAsSelect(ctx);
        } else {
            this.toSQLCreateTable(ctx);
            this.toSQLOnCommit(ctx);
        }
        if (this.comment != null && !EMULATE_COMMENT_IN_BLOCK.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_COMMENT).sql(' ').visit(this.comment);
        }
        if (this.storage != null && ctx.configuration().data("com.craftaro.third_party.org.jooq.ddl.ignore-storage-clauses") == null) {
            ctx.formatSeparator().visit(this.storage);
        }
        ctx.end(Clause.CREATE_TABLE);
    }

    private void toSQLCreateTable(Context<?> ctx) {
        this.toSQLCreateTableName(ctx);
        if (!(this.columnFields.isEmpty() || this.select != null && NO_SUPPORT_CTAS_COLUMN_NAMES.contains((Object)ctx.dialect()))) {
            DataType<EnumType> type;
            int i;
            ctx.sql(" (").start(Clause.CREATE_TABLE_COLUMNS).formatIndentStart().formatNewLine();
            Field<?> identity = null;
            boolean qualify = ctx.qualify();
            ctx.qualify(false);
            for (i = 0; i < this.columnFields.size(); ++i) {
                type = this.columnType(ctx, i);
                if (identity == null && type.identity()) {
                    identity = this.columnFields.get(i);
                }
                ctx.visit(this.columnFields.get(i));
                if (this.select == null) {
                    ctx.sql(' ');
                    Tools.toSQLDDLTypeDeclarationForAddition(ctx, type);
                }
                if (i >= this.columnFields.size() - 1) continue;
                ctx.sql(',').formatSeparator();
            }
            ctx.qualify(qualify);
            ctx.end(Clause.CREATE_TABLE_COLUMNS).start(Clause.CREATE_TABLE_CONSTRAINTS);
            if (!this.constraints.isEmpty()) {
                for (Constraint constraint : this.constraints) {
                    if (ctx.family() == SQLDialect.SQLITE && this.matchingPrimaryKey(constraint, identity)) continue;
                    ctx.sql(',').formatSeparator().visit(constraint);
                }
            }
            if (EMULATE_SOME_ENUM_TYPES_AS_CHECK.contains((Object)ctx.dialect())) {
                for (i = 0; i < this.columnFields.size(); ++i) {
                    type = this.columnTypes.get(i);
                    if (!EnumType.class.isAssignableFrom(type.getType())) continue;
                    DataType<EnumType> enumType = type;
                    if (!EMULATE_STORED_ENUM_TYPES_AS_CHECK.contains((Object)ctx.dialect()) && Tools.storedEnumType(enumType)) continue;
                    Field<Field<String>> field = this.columnFields.get(i);
                    ctx.sql(',').formatSeparator().visit(DSL.constraint(this.table.getName() + "_" + field.getName() + "_chk").check(field.in((Collection<?>)Tools.inline(Tools.enumLiterals(enumType.getType())))));
                }
            }
            ctx.end(Clause.CREATE_TABLE_CONSTRAINTS);
            if (!this.indexes.isEmpty() && !EMULATE_INDEXES_IN_BLOCK.contains((Object)ctx.dialect())) {
                ctx.qualify(false);
                for (Index index : this.indexes) {
                    ctx.sql(',').formatSeparator();
                    if (index.getUnique()) {
                        ctx.visit(Keywords.K_UNIQUE).sql(' ');
                    }
                    ctx.visit(Keywords.K_INDEX);
                    if (!"".equals(index.getName())) {
                        ctx.sql(' ').visit(index.getUnqualifiedName());
                    }
                    ctx.sql(" (").visit(new SortFieldList(index.getFields())).sql(')');
                }
                ctx.qualify(qualify);
            }
            ctx.formatIndentEnd().formatNewLine().sql(')');
        }
    }

    private final DataType<?> columnType(Context<?> ctx, int i) {
        DataType<?> type = this.columnTypes.get(i);
        if (NO_SUPPORT_NULLABLE_PRIMARY_KEY.contains((Object)ctx.dialect()) && type.nullability() == Nullability.DEFAULT && this.isPrimaryKey(i)) {
            type = type.nullable(false);
        }
        return type;
    }

    private final boolean isPrimaryKey(int i) {
        for (Constraint constraint : this.constraints) {
            if (!(constraint instanceof ConstraintImpl) || ((ConstraintImpl)constraint).$primaryKey() == null) continue;
            for (Field<?> field : ((ConstraintImpl)constraint).$primaryKey()) {
                if (!field.equals(this.columnFields.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean matchingPrimaryKey(Constraint constraint, Field<?> identity) {
        if (constraint instanceof ConstraintImpl) {
            return ((ConstraintImpl)constraint).matchingPrimaryKey(identity);
        }
        return false;
    }

    private final void acceptCreateTableAsSelect(Context<?> ctx) {
        this.toSQLCreateTable(ctx);
        this.toSQLOnCommit(ctx);
        ctx.formatSeparator().visit(Keywords.K_AS);
        if (WRAP_SELECT_IN_PARENS.contains((Object)ctx.dialect())) {
            ctx.sql(" (").formatIndentStart().formatNewLine();
        } else {
            ctx.formatSeparator();
        }
        if (Boolean.FALSE.equals(this.withData) && NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_SELECT_NO_DATA, true);
        }
        ctx.start(Clause.CREATE_TABLE_AS);
        if (!this.columnFields.isEmpty() && NO_SUPPORT_CTAS_COLUMN_NAMES.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.select(DSL.asterisk()).from((TableLike<?>)this.select.asTable(DSL.table(DSL.name("t")), this.columnFields.toArray(Tools.EMPTY_FIELD))));
        } else {
            ctx.visit(this.select);
        }
        ctx.end(Clause.CREATE_TABLE_AS);
        if (Boolean.FALSE.equals(this.withData) && NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_SELECT_NO_DATA);
        }
        if (WRAP_SELECT_IN_PARENS.contains((Object)ctx.dialect())) {
            ctx.formatIndentEnd().formatNewLine().sql(')');
        }
        if (Boolean.FALSE.equals(this.withData) && !NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_WITH_NO_DATA);
        } else if (Boolean.TRUE.equals(this.withData) && !NO_SUPPORT_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_WITH_DATA);
        } else if (REQUIRES_WITH_DATA.contains((Object)ctx.dialect())) {
            ctx.formatSeparator().visit(Keywords.K_WITH_DATA);
        }
    }

    private final void toSQLCreateTableName(Context<?> ctx) {
        ctx.start(Clause.CREATE_TABLE_NAME).visit(Keywords.K_CREATE).sql(' ');
        if (this.temporary) {
            if (SUPPORT_TEMPORARY.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_TEMPORARY).sql(' ');
            } else {
                ctx.visit(Keywords.K_GLOBAL_TEMPORARY).sql(' ');
            }
        }
        ctx.visit(Keywords.K_TABLE).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.table).end(Clause.CREATE_TABLE_NAME);
    }

    private final void toSQLOnCommit(Context<?> ctx) {
        if (this.temporary && this.onCommit != null) {
            switch (this.onCommit) {
                case DELETE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DELETE_ROWS);
                    break;
                }
                case PRESERVE_ROWS: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_PRESERVE_ROWS);
                    break;
                }
                case DROP: {
                    ctx.formatSeparator().visit(Keywords.K_ON_COMMIT_DROP);
                }
            }
        }
    }
}

