/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.CreateSchemaFinalStep;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Schema;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class CreateSchemaImpl
extends AbstractRowCountQuery
implements CreateSchemaFinalStep {
    private static final long serialVersionUID = 1L;
    private final Schema schema;
    private final boolean createSchemaIfNotExists;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_SCHEMA};
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    CreateSchemaImpl(Configuration configuration, Schema schema, boolean createSchemaIfNotExists) {
        super(configuration);
        this.schema = schema;
        this.createSchemaIfNotExists = createSchemaIfNotExists;
    }

    final Schema $schema() {
        return this.schema;
    }

    final boolean $createSchemaIfNotExists() {
        return this.createSchemaIfNotExists;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        this.accept0(ctx);
    }

    private final void accept0(Context<?> ctx) {
        if (this.createSchemaIfNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_SCHEMA);
            this.accept1(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_SCHEMA);
        } else {
            this.accept1(ctx);
        }
    }

    private final void accept1(Context<?> ctx) {
        this.accept2(ctx);
    }

    private final void accept2(Context<?> ctx) {
        ctx.start(Clause.CREATE_SCHEMA_NAME).visit(Keywords.K_CREATE);
        ctx.sql(' ').visit(Keywords.K_SCHEMA);
        if (this.createSchemaIfNotExists && this.supportsIfNotExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_NOT_EXISTS);
        }
        ctx.sql(' ').visit(this.schema).end(Clause.CREATE_SCHEMA_NAME);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

