/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.CreateIndexIncludeStep;
import com.craftaro.third_party.org.jooq.CreateIndexStep;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Keyword;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.OrderField;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.SQL;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.SortField;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.QueryPartList;
import com.craftaro.third_party.org.jooq.impl.QueryPartListView;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

final class CreateIndexImpl
extends AbstractRowCountQuery
implements CreateIndexStep,
CreateIndexIncludeStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_INDEX};
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> SUPPORT_UNNAMED_INDEX = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private static final Set<SQLDialect> SUPPORT_INCLUDE = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private static final Set<SQLDialect> SUPPORT_UNIQUE_INCLUDE = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private final Index index;
    private final boolean unique;
    private final boolean ifNotExists;
    private Table<?> table;
    private SortField<?>[] sortFields;
    private Field<?>[] include;
    private Condition where;
    private boolean excludeNullKeys;

    CreateIndexImpl(Configuration configuration, Index index, boolean unique, boolean ifNotExists) {
        super(configuration);
        this.index = index;
        this.unique = unique;
        this.ifNotExists = ifNotExists;
        if (index != null) {
            this.table = index.getTable();
            this.sortFields = index.getFields().toArray(Tools.EMPTY_SORTFIELD);
            this.where = index.getWhere();
        }
    }

    final Index $index() {
        return this.index;
    }

    final boolean $unique() {
        return this.unique;
    }

    final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    final Table<?> $table() {
        return this.table;
    }

    final SortField<?>[] $sortFields() {
        return this.sortFields;
    }

    final Field<?>[] $include() {
        return this.include;
    }

    @Override
    public final CreateIndexImpl on(Table<?> t, OrderField<?> ... f) {
        this.table = t;
        this.sortFields = Tools.sortFields(f);
        return this;
    }

    @Override
    public final CreateIndexImpl on(Table<?> t, Collection<? extends OrderField<?>> f) {
        return this.on((Table)t, (OrderField[])f.toArray(Tools.EMPTY_ORDERFIELD));
    }

    @Override
    public final CreateIndexImpl on(Name tableName, Name ... fieldNames) {
        return this.on((Table)DSL.table(tableName), Tools.fieldsByName(fieldNames));
    }

    @Override
    public final CreateIndexImpl on(Name tableName, Collection<? extends Name> fieldNames) {
        return this.on(tableName, fieldNames.toArray(Tools.EMPTY_NAME));
    }

    @Override
    public final CreateIndexImpl on(String tableName, String ... fieldNames) {
        return this.on((Table)DSL.table(DSL.name(tableName)), Tools.fieldsByName(fieldNames));
    }

    @Override
    public final CreateIndexImpl on(String tableName, Collection<? extends String> fieldNames) {
        return this.on(tableName, fieldNames.toArray(Tools.EMPTY_STRING));
    }

    @Override
    public final CreateIndexImpl include(Field<?> ... f) {
        this.include = f;
        return this;
    }

    @Override
    public final CreateIndexImpl include(Name ... f) {
        return this.include((Field[])Tools.fieldsByName(f));
    }

    @Override
    public final CreateIndexImpl include(String ... f) {
        return this.include((Field[])Tools.fieldsByName(f));
    }

    @Override
    public final CreateIndexImpl include(Collection<? extends Field<?>> f) {
        return this.include((Field[])f.toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final CreateIndexImpl where(Condition condition) {
        this.where = condition;
        return this;
    }

    @Override
    public final CreateIndexImpl where(Condition ... conditions) {
        this.where = DSL.and(conditions);
        return this;
    }

    @Override
    public final CreateIndexImpl where(Collection<? extends Condition> conditions) {
        this.where = DSL.and(conditions);
        return this;
    }

    @Override
    public final CreateIndexImpl where(Field<Boolean> field) {
        return this.where(DSL.condition(field));
    }

    @Override
    public final CreateIndexImpl where(SQL sql) {
        return this.where(DSL.condition(sql));
    }

    @Override
    public final CreateIndexImpl where(String sql) {
        return this.where(DSL.condition(sql));
    }

    @Override
    public final CreateIndexImpl where(String sql, Object ... bindings) {
        return this.where(DSL.condition(sql, bindings));
    }

    @Override
    public final CreateIndexImpl where(String sql, QueryPart ... parts) {
        return this.where(DSL.condition(sql, parts));
    }

    @Override
    public final CreateIndexImpl excludeNullKeys() {
        this.excludeNullKeys = true;
        return this;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_INDEX);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_INDEX);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_CREATE);
        if (this.unique) {
            ctx.sql(' ').visit(Keywords.K_UNIQUE);
        }
        ctx.sql(' ').visit(Keywords.K_INDEX).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        if (this.index != null) {
            ctx.visit(this.index).sql(' ');
        } else if (!SUPPORT_UNNAMED_INDEX.contains((Object)ctx.dialect())) {
            ctx.visit(this.generatedName()).sql(' ');
        }
        boolean supportsInclude = this.unique ? SUPPORT_UNIQUE_INCLUDE.contains((Object)ctx.dialect()) : SUPPORT_INCLUDE.contains((Object)ctx.dialect());
        boolean supportsFieldsBeforeTable = false;
        QueryPartList list = new QueryPartList();
        list.addAll((Collection<OrderField<?>>)Arrays.asList(this.sortFields));
        if (!supportsInclude && !this.unique && this.include != null) {
            list.addAll((Collection<OrderField<?>>)Arrays.asList(this.include));
        }
        ctx.visit(Keywords.K_ON).sql(' ').visit(this.table);
        ctx.sql('(').qualify(false).visit(list).qualify(true).sql(')');
        if (supportsInclude && this.include != null) {
            Keyword keyword = Keywords.K_INCLUDE;
            ctx.formatSeparator().visit(keyword).sql(" (").qualify(false).visit(QueryPartListView.wrap((QueryPart[])this.include)).qualify(true).sql(')');
        }
        Condition c2 = this.where;
        if (this.excludeNullKeys && c2 == null) {
            Condition condition = c2 = this.sortFields.length == 1 ? Tools.field(this.sortFields[0]).isNotNull() : DSL.row(Tools.fields(this.sortFields)).isNotNull();
        }
        if (c2 != null && ctx.configuration().data("com.craftaro.third_party.org.jooq.ddl.ignore-storage-clauses") == null) {
            ctx.formatSeparator().visit(Keywords.K_WHERE).sql(' ').qualify(false).visit(c2).qualify(true);
        }
    }

    private final Name generatedName() {
        Name t = this.table.getQualifiedName();
        StringBuilder sb = new StringBuilder(this.table.getName());
        for (SortField<?> f : this.sortFields) {
            sb.append('_').append(f.getName());
        }
        sb.append("_idx");
        if (t.qualified()) {
            return t.qualifier().append(sb.toString());
        }
        return DSL.name(sb.toString());
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

