/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Catalog;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.CreateDatabaseFinalStep;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class CreateDatabaseImpl
extends AbstractRowCountQuery
implements CreateDatabaseFinalStep {
    private static final long serialVersionUID = 1L;
    private final Catalog database;
    private final boolean createDatabaseIfNotExists;
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.POSTGRES);

    CreateDatabaseImpl(Configuration configuration, Catalog database, boolean createDatabaseIfNotExists) {
        super(configuration);
        this.database = database;
        this.createDatabaseIfNotExists = createDatabaseIfNotExists;
    }

    final Catalog $database() {
        return this.database;
    }

    final boolean $createDatabaseIfNotExists() {
        return this.createDatabaseIfNotExists;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.createDatabaseIfNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_DATABASE);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_DATABASE);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_CREATE).sql(' ').visit(Keywords.K_DATABASE);
        if (this.createDatabaseIfNotExists && this.supportsIfNotExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_NOT_EXISTS);
        }
        ctx.sql(' ').visit(this.database);
    }
}

