/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.impl.AbstractCondition;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Tools;

final class ContainsIgnoreCase
extends AbstractCondition {
    private static final long serialVersionUID = 1795491010886118843L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private final Field<?> lhs;
    private final Field<?> rhs;
    private final boolean leftWildcard;
    private final boolean rightWildcard;

    ContainsIgnoreCase(Field<?> field, Field<?> rhs, boolean leftWildcard, boolean rightWildcard) {
        this.lhs = field;
        this.rhs = rhs;
        this.leftWildcard = leftWildcard;
        this.rightWildcard = rightWildcard;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.condition(ctx.configuration()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private final Condition condition(Configuration configuration) {
        Field[] array = new Field[1 + (this.leftWildcard ? 1 : 0) + (this.rightWildcard ? 1 : 0)];
        int i = 0;
        if (this.leftWildcard) {
            array[i++] = DSL.inline("%");
        }
        array[i++] = Tools.escapeForLike(this.rhs, configuration);
        if (this.rightWildcard) {
            array[i++] = DSL.inline("%");
        }
        return this.lhs.likeIgnoreCase(DSL.concat(array), '!');
    }
}

