/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Comment;
import com.craftaro.third_party.org.jooq.CommentOnFinalStep;
import com.craftaro.third_party.org.jooq.CommentOnIsStep;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import java.util.Set;

class CommentOnImpl
extends AbstractRowCountQuery
implements CommentOnIsStep,
CommentOnFinalStep {
    private static final long serialVersionUID = 2665659331902435568L;
    private static final Set<SQLDialect> SUPPORTS_COMMENT_ON_VIEW = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES);
    private final Table<?> table;
    private final boolean isView;
    private final Field<?> field;
    private Comment comment;

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView) {
        super(configuration);
        this.table = table;
        this.isView = isView;
        this.field = null;
    }

    CommentOnImpl(Configuration configuration, Field<?> field) {
        super(configuration);
        this.table = null;
        this.isView = false;
        this.field = field;
    }

    final Table<?> $table() {
        return this.table;
    }

    final boolean $isView() {
        return this.isView;
    }

    final Field<?> $field() {
        return this.field;
    }

    final Comment $comment() {
        return this.comment;
    }

    @Override
    public final CommentOnImpl is(String c2) {
        return this.is(DSL.comment(c2));
    }

    @Override
    public final CommentOnImpl is(Comment c2) {
        this.comment = c2;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                if (this.table != null) {
                    this.acceptMySQL(ctx);
                    break;
                }
                this.acceptDefault(ctx);
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptMySQL(Context<?> ctx) {
        ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.table).sql(' ').visit(Keywords.K_COMMENT).sql(" = ").visit(this.comment);
    }

    private final void acceptDefault(Context<?> ctx) {
        ctx.visit(Keywords.K_COMMENT).sql(' ').visit(Keywords.K_ON).sql(' ');
        if (this.table != null) {
            ctx.visit(this.isView && SUPPORTS_COMMENT_ON_VIEW.contains((Object)ctx.dialect()) ? Keywords.K_VIEW : Keywords.K_TABLE).sql(' ').visit(this.table);
        } else if (this.field != null) {
            ctx.visit(Keywords.K_COLUMN).sql(' ').visit(this.field);
        } else {
            throw new IllegalStateException();
        }
        ctx.sql(' ').visit(Keywords.K_IS).sql(' ').visit(this.comment);
    }
}

