/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Binding;
import com.craftaro.third_party.org.jooq.BindingGetResultSetContext;
import com.craftaro.third_party.org.jooq.BindingGetSQLInputContext;
import com.craftaro.third_party.org.jooq.BindingGetStatementContext;
import com.craftaro.third_party.org.jooq.BindingRegisterContext;
import com.craftaro.third_party.org.jooq.BindingSQLContext;
import com.craftaro.third_party.org.jooq.BindingSetSQLOutputContext;
import com.craftaro.third_party.org.jooq.BindingSetStatementContext;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Converter;
import com.craftaro.third_party.org.jooq.Converters;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.DefaultExecuteContext;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.tools.jdbc.JDBCUtils;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobBinding
implements Binding<String, String> {
    private static final long serialVersionUID = 358789452467943117L;

    @Override
    public final Converter<String, String> converter() {
        return Converters.identity(String.class);
    }

    @Override
    public final void sql(BindingSQLContext<String> ctx) throws SQLException {
        ctx.render().visit(DSL.val((Object)ctx.value(), SQLDataType.CLOB));
    }

    @Override
    public final void register(BindingRegisterContext<String> ctx) throws SQLException {
        ctx.statement().registerOutParameter(ctx.index(), 2005);
    }

    @Override
    public final void set(BindingSetStatementContext<String> ctx) throws SQLException {
        ctx.statement().setClob(ctx.index(), ctx.autoFree(this.newClob(ctx.configuration(), ctx.value())));
    }

    @Override
    public final void set(BindingSetSQLOutputContext<String> ctx) throws SQLException {
        ctx.output().writeClob(ctx.autoFree(this.newClob(ctx.configuration(), ctx.value())));
    }

    @Override
    public final void get(BindingGetResultSetContext<String> ctx) throws SQLException {
        Clob clob = ctx.resultSet().getClob(ctx.index());
        try {
            ctx.value(clob == null ? null : clob.getSubString(1L, (int)clob.length()));
        }
        finally {
            JDBCUtils.safeFree(clob);
        }
    }

    @Override
    public final void get(BindingGetStatementContext<String> ctx) throws SQLException {
        Clob clob = ctx.statement().getClob(ctx.index());
        try {
            ctx.value(clob == null ? null : clob.getSubString(1L, (int)clob.length()));
        }
        finally {
            JDBCUtils.safeFree(clob);
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<String> ctx) throws SQLException {
        Clob clob = ctx.input().readClob();
        try {
            ctx.value(clob == null ? null : clob.getSubString(1L, (int)clob.length()));
        }
        finally {
            JDBCUtils.safeFree(clob);
        }
    }

    private final Clob newClob(Configuration configuration, String string) throws SQLException {
        switch (configuration.family()) {
            default: 
        }
        Clob clob = DefaultExecuteContext.localConnection().createClob();
        clob.setString(1L, string);
        return clob;
    }
}

