/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Keyword;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.RenderContext;
import com.craftaro.third_party.org.jooq.impl.AbstractField;
import com.craftaro.third_party.org.jooq.impl.AbstractQueryPart;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import java.math.BigDecimal;

final class Cast<T>
extends AbstractField<T> {
    private static final long serialVersionUID = -6776617606751542856L;
    private final Field<?> field;

    public Cast(Field<?> field, DataType<T> type) {
        super(Names.N_CAST, type);
        this.field = field;
    }

    private final DataType<T> getSQLDataType() {
        return this.getDataType().getSQLDataType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                ctx.visit(new CastDerby());
                break;
            }
            default: {
                ctx.visit(new CastNative(this.field, this.getDataType()));
            }
        }
    }

    static class CastNative<T>
    extends AbstractQueryPart {
        private static final long serialVersionUID = -8497561014419483312L;
        private final QueryPart expression;
        private final DataType<T> type;
        private final Keyword typeAsKeyword;

        CastNative(QueryPart expression, DataType<T> type) {
            this.expression = expression;
            this.type = type;
            this.typeAsKeyword = null;
        }

        CastNative(QueryPart expression, Keyword typeAsKeyword) {
            this.expression = expression;
            this.type = null;
            this.typeAsKeyword = typeAsKeyword;
        }

        @Override
        public void accept(Context<?> ctx) {
            RenderContext.CastMode castMode = ctx.castMode();
            ctx.visit(Keywords.K_CAST).sql('(').castMode(RenderContext.CastMode.NEVER).visit(this.expression).castMode(castMode).sql(' ').visit(Keywords.K_AS).sql(' ');
            if (this.typeAsKeyword != null) {
                ctx.visit(this.typeAsKeyword);
            } else {
                ctx.sql(this.type.getCastTypeName(ctx.configuration()));
            }
            ctx.sql(')');
        }
    }

    private final class CastDerby
    extends CastNative<T> {
        private static final long serialVersionUID = -8737153188122391258L;

        CastDerby() {
            super((QueryPart)Cast.this.field, Cast.this.getDataType());
        }

        private final Field<Boolean> asDecodeNumberToBoolean() {
            return DSL.choose(Cast.this.field).when((Field<Integer>)DSL.inline(0), DSL.inline(false)).when(DSL.inline((Integer)null), DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
        }

        private final Field<Boolean> asDecodeVarcharToBoolean() {
            Field s = Cast.this.field;
            return DSL.when(s.equal(DSL.inline("0")), DSL.inline(false)).when(DSL.lower(s).equal(DSL.inline("false")), DSL.inline(false)).when(DSL.lower(s).equal(DSL.inline("f")), DSL.inline(false)).when(s.isNull(), DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
        }

        @Override
        public final void accept(Context<?> ctx) {
            DataType type = Cast.this.getSQLDataType();
            if (Cast.this.field.getDataType().isNumeric() && type.isString() && !SQLDataType.CHAR.equals(type)) {
                ctx.visit(Keywords.K_TRIM).sql('(').visit(new CastNative(new CastNative<String>((QueryPart)Cast.this.field, SQLDataType.CHAR(38)), Cast.this.getDataType())).sql(')');
            } else if (Cast.this.field.getDataType().isString() && (SQLDataType.FLOAT.equals(type) || SQLDataType.DOUBLE.equals(type) || SQLDataType.REAL.equals(type))) {
                ctx.visit(new CastNative(new CastNative<BigDecimal>((QueryPart)Cast.this.field, SQLDataType.DECIMAL), Cast.this.getDataType()));
            } else if (Cast.this.field.getDataType().isNumeric() && SQLDataType.BOOLEAN.equals(type)) {
                ctx.visit(this.asDecodeNumberToBoolean());
            } else if (Cast.this.field.getDataType().isString() && SQLDataType.BOOLEAN.equals(type)) {
                ctx.visit(this.asDecodeVarcharToBoolean());
            } else {
                super.accept(ctx);
            }
        }
    }
}

