/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Block;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Statement;
import com.craftaro.third_party.org.jooq.conf.ParamType;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.NullStatement;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class BlockImpl
extends AbstractRowCountQuery
implements Block {
    private static final long serialVersionUID = 6881305779639901498L;
    private static final Set<SQLDialect> REQUIRES_EXECUTE_IMMEDIATE_ON_DDL = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> SUPPORTS_NULL_STATEMENT = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private final Collection<? extends Statement> statements;
    final boolean alwaysWrapInBeginEnd;
    static final String STATEMENT_VARIABLES = "com.craftaro.third_party.org.jooq.impl.BlockImpl.statement-variables";

    BlockImpl(Configuration configuration, Collection<? extends Statement> statements, boolean alwaysWrapInBeginEnd) {
        super(configuration);
        this.statements = statements;
        this.alwaysWrapInBeginEnd = alwaysWrapInBeginEnd;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                if (Tools.increment(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) {
                    ctx.paramType(ParamType.INLINED).visit(Keywords.K_EXECUTE_BLOCK).sql(' ').visit(Keywords.K_AS).sql(' ');
                    ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
                }
                this.accept0(ctx);
                Tools.decrement(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING);
                break;
            }
            case POSTGRES: {
                if (Tools.increment(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) {
                    ctx.paramType(ParamType.INLINED).visit(Keywords.K_DO).sql(" $$").formatSeparator();
                    ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
                }
                this.accept0(ctx);
                if (!Tools.decrement(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) break;
                ctx.formatSeparator().sql("$$");
                break;
            }
            case H2: {
                String name = BlockImpl.randomName();
                if (Tools.increment(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) {
                    ctx.paramType(ParamType.INLINED).visit(Keywords.K_CREATE).sql(' ').visit(Keywords.K_ALIAS).sql(' ').sql(name).sql(' ').visit(Keywords.K_AS).sql(" $$").formatIndentStart().formatSeparator().sql("void x(Connection c) throws SQLException ");
                    ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
                }
                this.accept0(ctx);
                if (!Tools.decrement(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) break;
                ctx.formatIndentEnd().formatSeparator().sql("$$;").formatSeparator().visit(Keywords.K_CALL).sql(' ').sql(name).sql("();").formatSeparator().visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_ALIAS).sql(' ').sql(name).sql(';');
                break;
            }
            case MYSQL: {
                String name = BlockImpl.randomName();
                if (Tools.increment(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) {
                    ctx.paramType(ParamType.INLINED).visit(Keywords.K_CREATE).sql(' ').visit(Keywords.K_PROCEDURE).sql(' ').sql(name).sql("()").formatIndentStart().formatSeparator();
                    ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
                }
                this.accept0(ctx);
                if (!Tools.decrement(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) break;
                ctx.formatIndentEnd().formatSeparator().visit(Keywords.K_CALL).sql(' ').sql(name).sql("();").formatSeparator().visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_PROCEDURE).sql(' ').sql(name).sql(';');
                break;
            }
            default: {
                Tools.increment(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING);
                this.accept0(ctx);
                Tools.decrement(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING);
            }
        }
    }

    private static final String randomName() {
        return "block_" + System.currentTimeMillis() + "_" + (long)(1.0E7 * Math.random());
    }

    private final void accept0(Context<?> ctx) {
        boolean wrapInBeginEnd = this.alwaysWrapInBeginEnd;
        BlockImpl.acceptDeclarations(ctx, new ArrayList<Statement>(this.statements), wrapInBeginEnd);
    }

    private static final void acceptDeclarations(Context<?> ctx, List<Statement> statements, boolean wrapInBeginEnd) {
        BlockImpl.acceptNonDeclarations(ctx, statements, wrapInBeginEnd);
    }

    private static final void semicolonAfterStatement(Context<?> ctx, Statement s) {
        if (s instanceof Block) {
            return;
        }
        ctx.sql(';');
    }

    private static final void acceptNonDeclarations(Context<?> ctx, List<Statement> statements, boolean wrapInBeginEnd) {
        if (wrapInBeginEnd) {
            BlockImpl.begin(ctx);
        }
        if (statements.isEmpty()) {
            switch (ctx.family()) {
                default: 
            }
        } else {
            for (int i = 0; i < statements.size(); ++i) {
                Statement s = statements.get(i);
                if (s instanceof NullStatement && !SUPPORTS_NULL_STATEMENT.contains((Object)ctx.dialect())) continue;
                ctx.formatSeparator();
                ctx.visit(s);
                BlockImpl.semicolonAfterStatement(ctx, s);
            }
        }
        if (wrapInBeginEnd) {
            BlockImpl.end(ctx);
        }
    }

    private static final void begin(Context<?> ctx) {
        if (ctx.family() == SQLDialect.H2) {
            ctx.sql('{');
        } else {
            ctx.visit(Keywords.K_BEGIN);
        }
        if (ctx.family() == SQLDialect.MARIADB && Tools.toplevel(ctx.data(), Tools.DataKey.DATA_BLOCK_NESTING)) {
            ctx.sql(' ').visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_ATOMIC);
        }
        ctx.formatIndentStart();
    }

    private static final void end(Context<?> ctx) {
        ctx.formatIndentEnd().formatSeparator();
        if (ctx.family() == SQLDialect.H2) {
            ctx.sql('}');
        } else {
            ctx.visit(Keywords.K_END);
        }
        switch (ctx.family()) {
            case FIREBIRD: 
            case H2: {
                break;
            }
            default: {
                ctx.sql(';');
            }
        }
    }
}

