/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Binding;
import com.craftaro.third_party.org.jooq.BindingGetResultSetContext;
import com.craftaro.third_party.org.jooq.BindingGetSQLInputContext;
import com.craftaro.third_party.org.jooq.BindingGetStatementContext;
import com.craftaro.third_party.org.jooq.BindingRegisterContext;
import com.craftaro.third_party.org.jooq.BindingSQLContext;
import com.craftaro.third_party.org.jooq.BindingSetSQLOutputContext;
import com.craftaro.third_party.org.jooq.BindingSetStatementContext;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Converter;
import com.craftaro.third_party.org.jooq.Converters;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.DefaultExecuteContext;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.tools.jdbc.JDBCUtils;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobBinding
implements Binding<byte[], byte[]> {
    private static final long serialVersionUID = 358789452467943117L;

    @Override
    public final Converter<byte[], byte[]> converter() {
        return Converters.identity(byte[].class);
    }

    @Override
    public final void sql(BindingSQLContext<byte[]> ctx) throws SQLException {
        ctx.render().visit(DSL.val((Object)ctx.value(), SQLDataType.BLOB));
    }

    @Override
    public final void register(BindingRegisterContext<byte[]> ctx) throws SQLException {
        ctx.statement().registerOutParameter(ctx.index(), 2004);
    }

    @Override
    public final void set(BindingSetStatementContext<byte[]> ctx) throws SQLException {
        ctx.statement().setBlob(ctx.index(), ctx.autoFree(this.newBlob(ctx.configuration(), ctx.value())));
    }

    @Override
    public final void set(BindingSetSQLOutputContext<byte[]> ctx) throws SQLException {
        ctx.output().writeBlob(ctx.autoFree(this.newBlob(ctx.configuration(), ctx.value())));
    }

    @Override
    public final void get(BindingGetResultSetContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.resultSet().getBlob(ctx.index());
        try {
            ctx.value(blob == null ? null : blob.getBytes(1L, (int)blob.length()));
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }

    @Override
    public final void get(BindingGetStatementContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.statement().getBlob(ctx.index());
        try {
            ctx.value(blob == null ? null : blob.getBytes(1L, (int)blob.length()));
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<byte[]> ctx) throws SQLException {
        Blob blob = ctx.input().readBlob();
        try {
            ctx.value(blob == null ? null : blob.getBytes(1L, (int)blob.length()));
        }
        finally {
            JDBCUtils.safeFree(blob);
        }
    }

    private final Blob newBlob(Configuration configuration, byte[] bytes) throws SQLException {
        switch (configuration.family()) {
            default: 
        }
        Blob blob = DefaultExecuteContext.localConnection().createBlob();
        blob.setBytes(1L, bytes);
        return blob;
    }
}

