/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.ExecuteListener;
import com.craftaro.third_party.org.jooq.Query;
import com.craftaro.third_party.org.jooq.conf.SettingsTools;
import com.craftaro.third_party.org.jooq.exception.ControlFlowSignal;
import com.craftaro.third_party.org.jooq.impl.AbstractBatch;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.DefaultExecuteContext;
import com.craftaro.third_party.org.jooq.impl.ExecuteListeners;
import com.craftaro.third_party.org.jooq.impl.SettingsEnabledPreparedStatement;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.sql.Connection;
import java.sql.SQLException;

final class BatchMultiple
extends AbstractBatch {
    private static final long serialVersionUID = -7337667281292354043L;
    private final Query[] queries;

    public BatchMultiple(Configuration configuration, Query ... queries) {
        super(configuration);
        this.queries = queries;
    }

    @Override
    public final int size() {
        return this.queries.length;
    }

    @Override
    public final int[] execute() {
        return BatchMultiple.execute(this.configuration, this.queries);
    }

    static int[] execute(Configuration configuration, Query[] queries) {
        DefaultExecuteContext ctx = new DefaultExecuteContext(configuration, queries);
        ExecuteListener listener = ExecuteListeners.get(ctx);
        Connection connection = ctx.connection();
        try {
            int i;
            listener.start(ctx);
            if (ctx.statement() == null) {
                ctx.statement(new SettingsEnabledPreparedStatement(connection));
            }
            String[] batchSQL = ctx.batchSQL();
            for (i = 0; i < queries.length; ++i) {
                ctx.sql(null);
                listener.renderStart(ctx);
                batchSQL[i] = DSL.using(configuration).renderInlined(queries[i]);
                ctx.sql(batchSQL[i]);
                listener.renderEnd(ctx);
            }
            for (i = 0; i < queries.length; ++i) {
                ctx.sql(batchSQL[i]);
                listener.prepareStart(ctx);
                ctx.statement().addBatch(batchSQL[i]);
                listener.prepareEnd(ctx);
            }
            int t = SettingsTools.getQueryTimeout(0, ctx.settings());
            if (t != 0) {
                ctx.statement().setQueryTimeout(t);
            }
            listener.executeStart(ctx);
            int[] result = ctx.statement().executeBatch();
            int[] batchRows = ctx.batchRows();
            for (int i2 = 0; i2 < batchRows.length && i2 < result.length; ++i2) {
                batchRows[i2] = result[i2];
            }
            listener.executeEnd(ctx);
            int[] nArray = result;
            return nArray;
        }
        catch (ControlFlowSignal e) {
            throw e;
        }
        catch (RuntimeException e) {
            ctx.exception(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException e) {
            ctx.sqlException(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Tools.safeClose(listener, ctx);
        }
    }
}

