/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.Param;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.Select;
import com.craftaro.third_party.org.jooq.SelectFieldOrAsterisk;
import com.craftaro.third_party.org.jooq.SelectSelectStep;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TableOptions;
import com.craftaro.third_party.org.jooq.impl.AbstractTable;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Fields;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.RecordImplN;

final class ArrayTableEmulation
extends AbstractTable<Record> {
    private static final long serialVersionUID = 2392515064450536343L;
    private final Object[] array;
    private final Fields<Record> field;
    private final Name alias;
    private final Name fieldAlias;
    private transient Table<Record> table;

    ArrayTableEmulation(Object[] array) {
        this(array, Names.N_ARRAY_TABLE, null);
    }

    ArrayTableEmulation(Object[] array, Name alias) {
        this(array, alias, null);
    }

    ArrayTableEmulation(Object[] array, Name alias, Name fieldAlias) {
        super(TableOptions.expression(), alias);
        this.array = array;
        this.alias = alias;
        this.fieldAlias = fieldAlias == null ? Names.N_COLUMN_VALUE : fieldAlias;
        this.field = new Fields(DSL.field(DSL.name(alias.last(), this.fieldAlias.last()), DSL.getDataType(array.getClass().getComponentType())));
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final Table<Record> as(Name as) {
        return new ArrayTableEmulation(this.array, as);
    }

    @Override
    public final Table<Record> as(Name as, Name ... fieldAliases) {
        if (fieldAliases == null) {
            return new ArrayTableEmulation(this.array, as);
        }
        if (fieldAliases.length == 1) {
            return new ArrayTableEmulation(this.array, as, fieldAliases[0]);
        }
        throw new IllegalArgumentException("Array table simulations can only have a single field alias");
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    @Override
    final Fields<Record> fields0() {
        return this.field;
    }

    private final Table<Record> table(Configuration configuration) {
        if (this.table == null) {
            Select<Record> select = null;
            for (Object element : this.array) {
                Param val = DSL.val(element, this.field.fields[0].getDataType());
                SelectSelectStep<Record> subselect = DSL.using(configuration).select(val.as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]);
                select = select == null ? subselect : select.unionAll(subselect);
            }
            if (select == null) {
                select = DSL.using(configuration).select(DSL.one().as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]).where((Condition)DSL.falseCondition());
            }
            this.table = select.asTable(this.alias);
        }
        return this.table;
    }
}

