/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.Param;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TableOptions;
import com.craftaro.third_party.org.jooq.UDTRecord;
import com.craftaro.third_party.org.jooq.exception.DataTypeException;
import com.craftaro.third_party.org.jooq.impl.AbstractTable;
import com.craftaro.third_party.org.jooq.impl.ArrayTableEmulation;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Fields;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.RecordImplN;
import com.craftaro.third_party.org.jooq.util.h2.H2DataType;
import java.util.ArrayList;

final class ArrayTable
extends AbstractTable<Record> {
    private static final long serialVersionUID = 2380426377794577041L;
    private final Field<?> array;
    private final Fields<Record> field;
    private final Name alias;
    private final Name[] fieldAliases;

    ArrayTable(Field<?> array) {
        this(array, Names.N_ARRAY_TABLE);
    }

    ArrayTable(Field<?> array, Name alias) {
        this(array, alias, new Name[]{Names.N_COLUMN_VALUE});
    }

    ArrayTable(Field<?> array, Name alias, Name[] fieldAliases) {
        super(TableOptions.expression(), alias);
        Class arrayType = array.getDataType().getType().isArray() ? array.getDataType().getType().getComponentType() : Object.class;
        this.array = array;
        this.alias = alias;
        this.fieldAliases = fieldAliases;
        this.field = ArrayTable.init(arrayType, alias);
    }

    private static final Fields<Record> init(Class<?> arrayType, Name alias) {
        ArrayList result = new ArrayList();
        if (UDTRecord.class.isAssignableFrom(arrayType)) {
            try {
                UDTRecord record = (UDTRecord)arrayType.newInstance();
                for (Field<?> f : record.fields()) {
                    result.add(DSL.field(DSL.name(alias.last(), f.getName()), f.getDataType()));
                }
            }
            catch (Exception e) {
                throw new DataTypeException("Bad UDT Type : " + arrayType, e);
            }
        } else {
            result.add(DSL.field(DSL.name(alias.last(), "COLUMN_VALUE"), DSL.getDataType(arrayType)));
        }
        return new Fields<Record>(result);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final Table<Record> as(Name as) {
        return new ArrayTable(this.array, as);
    }

    @Override
    public final Table<Record> as(Name as, Name ... fields) {
        return new ArrayTable(this.array, as, fields);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    private final Table<Record> table(Configuration configuration) {
        switch (configuration.family()) {
            case H2: {
                return new H2ArrayTable().as(this.alias);
            }
            case HSQLDB: 
            case POSTGRES: {
                return new PostgresHSQLDBTable().as(this.alias, this.fieldAliases);
            }
        }
        if (this.array.getDataType().getType().isArray() && this.array instanceof Param) {
            return this.emulate();
        }
        return DSL.table("{0}", new QueryPart[]{this.array}).as(this.alias);
    }

    private final Table<Record> emulate() {
        return new ArrayTableEmulation((Object[])((Param)this.array).getValue()).as(this.alias, this.fieldAliases);
    }

    @Override
    final Fields<Record> fields0() {
        return this.field;
    }

    private abstract class DialectArrayTable
    extends AbstractTable<Record> {
        private static final long serialVersionUID = 2662639259338694177L;

        DialectArrayTable() {
            super(TableOptions.expression(), ArrayTable.this.alias);
        }

        @Override
        public final Class<? extends Record> getRecordType() {
            return RecordImplN.class;
        }

        @Override
        final Fields<Record> fields0() {
            return ArrayTable.this.fields0();
        }
    }

    private class H2ArrayTable
    extends DialectArrayTable {
        private static final long serialVersionUID = 8679404596822098711L;

        private H2ArrayTable() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(Keywords.K_TABLE).sql('(').visit(ArrayTable.this.fieldAliases == null || ArrayTable.this.fieldAliases.length == 0 ? Names.N_COLUMN_VALUE : ArrayTable.this.fieldAliases[0]).sql(' ');
            if (ArrayTable.this.array.getDataType().getType() == Object[].class) {
                ctx.sql(H2DataType.VARCHAR.getTypeName());
            } else {
                ctx.sql(ArrayTable.this.array.getDataType().getTypeName());
            }
            ctx.sql(" = ").visit(ArrayTable.this.array).sql(')');
        }
    }

    private class PostgresHSQLDBTable
    extends DialectArrayTable {
        private static final long serialVersionUID = 6989279597964488457L;

        private PostgresHSQLDBTable() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(Keywords.K_UNNEST).sql('(').visit(ArrayTable.this.array).sql(")");
        }
    }
}

