/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.AlterIndexFinalStep;
import com.craftaro.third_party.org.jooq.AlterIndexOnStep;
import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class AlterIndexImpl
extends AbstractRowCountQuery
implements AlterIndexOnStep,
AlterIndexFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_INDEX};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> SUPPORT_RENAME_INDEX = SQLDialect.supportedBy(SQLDialect.DERBY);
    private final Index index;
    private final boolean ifExists;
    private Table<?> on;
    private Index renameTo;

    AlterIndexImpl(Configuration configuration, Index index) {
        this(configuration, index, false);
    }

    AlterIndexImpl(Configuration configuration, Index index, boolean ifExists) {
        super(configuration);
        this.index = index;
        this.ifExists = ifExists;
    }

    final Index $index() {
        return this.index;
    }

    final boolean $ifExists() {
        return this.ifExists;
    }

    final Table<?> $on() {
        return this.on;
    }

    final Index $renameTo() {
        return this.renameTo;
    }

    @Override
    public final AlterIndexImpl on(Table<?> table) {
        this.on = table;
        return this;
    }

    @Override
    public final AlterIndexImpl on(String tableName) {
        return this.on(DSL.name(tableName));
    }

    @Override
    public final AlterIndexImpl on(Name tableName) {
        return this.on((Table)DSL.table(tableName));
    }

    @Override
    public final AlterIndexImpl renameTo(String newName) {
        return this.renameTo(DSL.name(newName));
    }

    @Override
    public final AlterIndexImpl renameTo(Name newName) {
        return this.renameTo(DSL.index(newName));
    }

    @Override
    public final AlterIndexImpl renameTo(Index newName) {
        this.renameTo = newName;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.ALTER_INDEX);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.ALTER_INDEX);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean renameIndex = SUPPORT_RENAME_INDEX.contains((Object)ctx.dialect());
        boolean qualify = ctx.qualify();
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.on).sql(' ').visit(Keywords.K_RENAME_INDEX).sql(' ').qualify(false).visit(this.index).sql(' ').visit(Keywords.K_TO).sql(' ').visit(this.renameTo).qualify(qualify);
                break;
            }
            default: {
                ctx.start(Clause.ALTER_INDEX_INDEX).visit(renameIndex ? Keywords.K_RENAME_INDEX : Keywords.K_ALTER_INDEX);
                if (this.ifExists && this.supportsIfExists(ctx)) {
                    ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
                }
                ctx.sql(' ');
                if (this.on != null) {
                    ctx.visit(this.on).sql('.').visit(this.index.getUnqualifiedName());
                } else {
                    ctx.visit(this.index);
                }
                ctx.end(Clause.ALTER_INDEX_INDEX).formatIndentStart().formatSeparator();
                if (this.renameTo != null) {
                    ctx.start(Clause.ALTER_INDEX_RENAME).qualify(false).visit(renameIndex ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').visit(this.renameTo).qualify(qualify).end(Clause.ALTER_INDEX_RENAME);
                }
                ctx.formatIndentEnd();
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

