/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.BindContext;
import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DSLContext;
import com.craftaro.third_party.org.jooq.ForeignKey;
import com.craftaro.third_party.org.jooq.JoinType;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.QueryPartInternal;
import com.craftaro.third_party.org.jooq.RenderContext;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.VisitContext;
import com.craftaro.third_party.org.jooq.VisitListener;
import com.craftaro.third_party.org.jooq.VisitListenerProvider;
import com.craftaro.third_party.org.jooq.conf.InvocationOrder;
import com.craftaro.third_party.org.jooq.conf.ParamCastMode;
import com.craftaro.third_party.org.jooq.conf.ParamType;
import com.craftaro.third_party.org.jooq.conf.RenderImplicitJoinType;
import com.craftaro.third_party.org.jooq.conf.Settings;
import com.craftaro.third_party.org.jooq.conf.SettingsTools;
import com.craftaro.third_party.org.jooq.conf.StatementType;
import com.craftaro.third_party.org.jooq.impl.AbstractScope;
import com.craftaro.third_party.org.jooq.impl.ScopeStack;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.tools.StringUtils;
import java.sql.PreparedStatement;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class AbstractContext<C extends Context<C>>
extends AbstractScope
implements Context<C> {
    final PreparedStatement stmt;
    boolean declareFields;
    boolean declareTables;
    boolean declareAliases;
    boolean declareWindows;
    boolean declareCTE;
    int subquery;
    BitSet subqueryScopedNestedSetOperations;
    int stringLiteral;
    String stringLiteralEscapedApos = "'";
    int index;
    int scopeMarking;
    final ScopeStack<QueryPart, ScopeStackElement> scopeStack;
    private final VisitListener[] visitListenersStart;
    private final VisitListener[] visitListenersEnd;
    private final Deque<Clause> visitClauses;
    private final DefaultVisitContext visitContext;
    private final Deque<QueryPart> visitParts;
    final ParamType forcedParamType;
    final boolean castModeOverride;
    RenderContext.CastMode castMode;
    ParamType paramType = ParamType.INDEXED;
    boolean quote = true;
    boolean qualifySchema = true;
    boolean qualifyCatalog = true;

    AbstractContext(Configuration configuration, PreparedStatement stmt) {
        super(configuration);
        VisitListener[] visitListeners;
        this.stmt = stmt;
        VisitListenerProvider[] providers = configuration.visitListenerProviders();
        boolean useInternalVisitListener = false;
        VisitListener[] visitListenerArray = providers.length > 0 || useInternalVisitListener ? new VisitListener[providers.length + (useInternalVisitListener ? 1 : 0)] : (visitListeners = null);
        if (visitListeners != null) {
            for (int i = 0; i < providers.length; ++i) {
                visitListeners[i] = providers[i].provide();
            }
            this.visitContext = new DefaultVisitContext();
            this.visitParts = new ArrayDeque<QueryPart>();
            this.visitClauses = new ArrayDeque<Clause>();
            this.visitListenersStart = configuration.settings().getVisitListenerStartInvocationOrder() != InvocationOrder.REVERSE ? visitListeners : (VisitListener[])Tools.reverse((Object[])visitListeners.clone());
            this.visitListenersEnd = configuration.settings().getVisitListenerEndInvocationOrder() != InvocationOrder.REVERSE ? visitListeners : (VisitListener[])Tools.reverse((Object[])visitListeners.clone());
        } else {
            this.visitContext = null;
            this.visitParts = null;
            this.visitClauses = null;
            this.visitListenersStart = null;
            this.visitListenersEnd = null;
        }
        this.forcedParamType = SettingsTools.getStatementType(this.settings()) == StatementType.STATIC_STATEMENT ? ParamType.INLINED : (SettingsTools.getParamType(this.settings()) == ParamType.FORCE_INDEXED ? ParamType.INDEXED : null);
        ParamCastMode m = this.settings().getParamCastMode();
        boolean bl = this.castModeOverride = m != ParamCastMode.DEFAULT && m != null;
        this.castMode = m == ParamCastMode.ALWAYS ? RenderContext.CastMode.ALWAYS : (m == ParamCastMode.NEVER ? RenderContext.CastMode.NEVER : RenderContext.CastMode.DEFAULT);
        this.scopeStack = new ScopeStack(new ScopeStack.Constructor<ScopeStackElement>(){

            @Override
            public ScopeStackElement create(int scopeLevel) {
                return new ScopeStackElement(scopeLevel);
            }
        });
    }

    @Override
    public final C visit(QueryPart part) {
        if (part != null) {
            QueryPart replacement;
            Clause[] clauses;
            Clause[] clauseArray = clauses = Tools.isNotEmpty(this.visitListenersStart) ? this.clause(part) : null;
            if (clauses != null) {
                for (int i = 0; i < clauses.length; ++i) {
                    this.start(clauses[i]);
                }
            }
            if ((replacement = this.start(part)) != null) {
                QueryPartInternal internal = (QueryPartInternal)replacement;
                if (this.declareFields() && !internal.declaresFields()) {
                    boolean aliases = this.declareAliases();
                    this.declareFields(false);
                    this.visit0(internal);
                    this.declareFields(true);
                    this.declareAliases(aliases);
                } else if (this.declareTables() && !internal.declaresTables()) {
                    boolean aliases = this.declareAliases();
                    this.declareTables(false);
                    this.visit0(internal);
                    this.declareTables(true);
                    this.declareAliases(aliases);
                } else if (this.declareWindows() && !internal.declaresWindows()) {
                    this.declareWindows(false);
                    this.visit0(internal);
                    this.declareWindows(true);
                } else if (this.declareCTE() && !internal.declaresCTE()) {
                    this.declareCTE(false);
                    this.visit0(internal);
                    this.declareCTE(true);
                } else if (!this.castModeOverride && this.castMode() != RenderContext.CastMode.DEFAULT && !internal.generatesCast()) {
                    RenderContext.CastMode previous = this.castMode();
                    this.castMode(RenderContext.CastMode.DEFAULT);
                    this.visit0(internal);
                    this.castMode(previous);
                } else {
                    this.visit0(internal);
                }
            }
            this.end(replacement);
            if (clauses != null) {
                for (int i = clauses.length - 1; i >= 0; --i) {
                    this.end(clauses[i]);
                }
            }
        }
        return (C)this;
    }

    protected abstract void visit0(QueryPartInternal var1);

    private final Clause[] clause(QueryPart part) {
        if (part instanceof QueryPartInternal && !Boolean.TRUE.equals(this.data((Object)Tools.BooleanDataKey.DATA_OMIT_CLAUSE_EVENT_EMISSION))) {
            return ((QueryPartInternal)part).clauses(this);
        }
        return null;
    }

    @Override
    public final C start(Clause clause) {
        if (clause != null && this.visitClauses != null) {
            this.visitClauses.addLast(clause);
            for (VisitListener listener : this.visitListenersStart) {
                listener.clauseStart(this.visitContext);
            }
        }
        return (C)this;
    }

    @Override
    public final C end(Clause clause) {
        if (clause != null && this.visitClauses != null) {
            for (VisitListener listener : this.visitListenersEnd) {
                listener.clauseEnd(this.visitContext);
            }
            if (this.visitClauses.removeLast() != clause) {
                throw new IllegalStateException("Mismatch between visited clauses!");
            }
        }
        return (C)this;
    }

    private final QueryPart start(QueryPart part) {
        if (this.visitParts != null) {
            this.visitParts.addLast(part);
            for (VisitListener listener : this.visitListenersStart) {
                listener.visitStart(this.visitContext);
            }
            return this.visitParts.peekLast();
        }
        return part;
    }

    private final void end(QueryPart part) {
        if (this.visitParts != null) {
            for (VisitListener listener : this.visitListenersEnd) {
                listener.visitEnd(this.visitContext);
            }
            if (this.visitParts.removeLast() != part) {
                throw new RuntimeException("Mismatch between visited query parts");
            }
        }
    }

    @Override
    public final boolean declareFields() {
        return this.declareFields;
    }

    @Override
    public final C declareFields(boolean d) {
        this.declareFields = d;
        this.declareAliases(d);
        return (C)this;
    }

    @Override
    public final boolean declareTables() {
        return this.declareTables;
    }

    @Override
    public final C declareTables(boolean d) {
        this.declareTables = d;
        this.declareAliases(d);
        return (C)this;
    }

    @Override
    public final boolean declareAliases() {
        return this.declareAliases;
    }

    @Override
    public final C declareAliases(boolean d) {
        this.declareAliases = d;
        return (C)this;
    }

    @Override
    public final boolean declareWindows() {
        return this.declareWindows;
    }

    @Override
    public final C declareWindows(boolean d) {
        this.declareWindows = d;
        return (C)this;
    }

    @Override
    public final boolean declareCTE() {
        return this.declareCTE;
    }

    @Override
    public final C declareCTE(boolean d) {
        this.declareCTE = d;
        return (C)this;
    }

    @Override
    public final int subqueryLevel() {
        return this.subquery;
    }

    @Override
    public final boolean subquery() {
        return this.subquery > 0;
    }

    final C subquery0(boolean s, boolean setOperation) {
        if (s) {
            ++this.subquery;
            if (!setOperation && Boolean.TRUE.equals(this.data((Object)Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS))) {
                this.data().remove((Object)Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS);
                if (this.subqueryScopedNestedSetOperations == null) {
                    this.subqueryScopedNestedSetOperations = new BitSet();
                }
                this.subqueryScopedNestedSetOperations.set(this.subquery);
            }
            this.scopeStart();
        } else {
            this.scopeEnd();
            if (!setOperation) {
                if (this.subqueryScopedNestedSetOperations != null && this.subqueryScopedNestedSetOperations.get(this.subquery)) {
                    this.data((Object)Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS, true);
                } else {
                    this.data().remove((Object)Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS);
                }
            }
            --this.subquery;
        }
        return (C)this;
    }

    @Override
    public final C subquery(boolean s) {
        return this.subquery0(s, false);
    }

    @Override
    public final C scopeStart() {
        this.scopeStack.scopeStart();
        this.scopeStart0();
        return (C)this;
    }

    @Override
    public final C scopeRegister(QueryPart part) {
        return this.scopeRegister(part, false);
    }

    @Override
    public C scopeRegister(QueryPart part, boolean forceNew) {
        return (C)this;
    }

    @Override
    public final C scopeMarkStart(QueryPart part) {
        if (this.scopeStack.inScope() && this.scopeMarking++ == 0) {
            this.scopeMarkStart0(part);
        }
        return (C)this;
    }

    @Override
    public final C scopeMarkEnd(QueryPart part) {
        if (this.scopeStack.inScope() && --this.scopeMarking == 0) {
            this.scopeMarkEnd0(part);
        }
        return (C)this;
    }

    @Override
    public final C scopeEnd() {
        this.scopeEnd0();
        this.scopeStack.scopeEnd();
        return (C)this;
    }

    void scopeStart0() {
    }

    void scopeMarkStart0(QueryPart part) {
    }

    void scopeMarkEnd0(QueryPart part) {
    }

    void scopeEnd0() {
    }

    @Override
    public final boolean stringLiteral() {
        return this.stringLiteral > 0;
    }

    @Override
    public final C stringLiteral(boolean s) {
        if (s) {
            ++this.stringLiteral;
            this.stringLiteralEscapedApos = this.stringLiteralEscapedApos + this.stringLiteralEscapedApos;
        } else {
            --this.stringLiteral;
            this.stringLiteralEscapedApos = this.stringLiteralEscapedApos.substring(0, this.stringLiteralEscapedApos.length() / 2);
        }
        return (C)this;
    }

    @Override
    public final int nextIndex() {
        return ++this.index;
    }

    @Override
    public final int peekIndex() {
        return this.index + 1;
    }

    @Override
    public final ParamType paramType() {
        return this.forcedParamType != null ? this.forcedParamType : this.paramType;
    }

    @Override
    public final C paramType(ParamType p) {
        this.paramType = p == null ? ParamType.INDEXED : p;
        return (C)this;
    }

    @Override
    public final C paramTypeIf(ParamType p, boolean condition) {
        if (condition) {
            this.paramType(p);
        }
        return (C)this;
    }

    @Override
    public final boolean quote() {
        return this.quote;
    }

    @Override
    public final C quote(boolean q) {
        this.quote = q;
        return (C)this;
    }

    @Override
    public final boolean qualify() {
        return this.qualifySchema();
    }

    @Override
    public final C qualify(boolean q) {
        return this.qualifySchema(q);
    }

    @Override
    public final boolean qualifySchema() {
        return this.qualifySchema;
    }

    @Override
    public final C qualifySchema(boolean q) {
        this.qualifySchema = q;
        return (C)this;
    }

    @Override
    public final boolean qualifyCatalog() {
        return this.qualifyCatalog;
    }

    @Override
    public final C qualifyCatalog(boolean q) {
        this.qualifyCatalog = q;
        return (C)this;
    }

    @Override
    public final RenderContext.CastMode castMode() {
        return this.castMode;
    }

    @Override
    public final C castMode(RenderContext.CastMode mode) {
        this.castMode = mode;
        return (C)this;
    }

    @Override
    public final C castModeIf(RenderContext.CastMode mode, boolean condition) {
        if (condition) {
            this.castMode(mode);
        }
        return (C)this;
    }

    @Override
    @Deprecated
    public final Boolean cast() {
        switch (this.castMode) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public final C castModeSome(SQLDialect ... dialects) {
        return (C)this;
    }

    @Override
    public final PreparedStatement statement() {
        return this.stmt;
    }

    void toString(StringBuilder sb) {
        sb.append("bind index   [");
        sb.append(this.index);
        sb.append("]");
        sb.append("\ncast mode    [");
        sb.append((Object)this.castMode);
        sb.append("]");
        sb.append("\ndeclaring    [");
        if (this.declareFields) {
            sb.append("fields");
            if (this.declareAliases) {
                sb.append(" and aliases");
            }
        } else if (this.declareTables) {
            sb.append("tables");
            if (this.declareAliases) {
                sb.append(" and aliases");
            }
        } else if (this.declareWindows) {
            sb.append("windows");
        } else if (this.declareCTE) {
            sb.append("cte");
        } else {
            sb.append("-");
        }
        sb.append("]\nsubquery     [");
        sb.append(this.subquery);
        sb.append("]");
    }

    class ScopeStackElement {
        final int scopeLevel;
        int[] positions;
        int indent;
        JoinNode joinNode;

        ScopeStackElement(int scopeLevel) {
            this.scopeLevel = scopeLevel;
        }

        public String toString() {
            return Arrays.toString(this.positions) + ": " + this.joinNode;
        }
    }

    class JoinNode {
        final Table<?> table;
        final Map<ForeignKey<?, ?>, JoinNode> children;

        JoinNode(Table<?> table) {
            this.table = table;
            this.children = new LinkedHashMap();
        }

        public Table<?> joinTree() {
            Table<?> result = this.table;
            for (Map.Entry<ForeignKey<?, ?>, JoinNode> e : this.children.entrySet()) {
                JoinType type;
                switch (StringUtils.defaultIfNull(AbstractContext.this.settings().getRenderImplicitJoinType(), RenderImplicitJoinType.DEFAULT)) {
                    case INNER_JOIN: {
                        type = JoinType.JOIN;
                        break;
                    }
                    case LEFT_JOIN: {
                        type = JoinType.LEFT_OUTER_JOIN;
                        break;
                    }
                    default: {
                        type = e.getKey().nullable() ? JoinType.LEFT_OUTER_JOIN : JoinType.JOIN;
                    }
                }
                result = result.join(e.getValue().joinTree(), type).onKey(e.getKey());
            }
            return result;
        }

        public String toString() {
            return this.joinTree().toString();
        }
    }

    private class DefaultVisitContext
    implements VisitContext {
        private DefaultVisitContext() {
        }

        @Override
        public final Map<Object, Object> data() {
            return AbstractContext.this.data();
        }

        @Override
        public final Object data(Object key) {
            return AbstractContext.this.data(key);
        }

        @Override
        public final Object data(Object key, Object value) {
            return AbstractContext.this.data(key, value);
        }

        @Override
        public final Configuration configuration() {
            return AbstractContext.this.configuration();
        }

        @Override
        public final DSLContext dsl() {
            return AbstractContext.this.dsl();
        }

        @Override
        public final Settings settings() {
            return Tools.settings(this.configuration());
        }

        @Override
        public final SQLDialect dialect() {
            return Tools.configuration(this.configuration()).dialect();
        }

        @Override
        public final SQLDialect family() {
            return this.dialect().family();
        }

        @Override
        public final Clause clause() {
            return (Clause)((Object)AbstractContext.this.visitClauses.peekLast());
        }

        @Override
        public final Clause[] clauses() {
            return AbstractContext.this.visitClauses.toArray(Tools.EMPTY_CLAUSE);
        }

        @Override
        public final int clausesLength() {
            return AbstractContext.this.visitClauses.size();
        }

        @Override
        public final QueryPart queryPart() {
            return (QueryPart)AbstractContext.this.visitParts.peekLast();
        }

        @Override
        public final void queryPart(QueryPart part) {
            AbstractContext.this.visitParts.pollLast();
            AbstractContext.this.visitParts.addLast(part);
        }

        @Override
        public final QueryPart[] queryParts() {
            return AbstractContext.this.visitParts.toArray(Tools.EMPTY_QUERYPART);
        }

        @Override
        public final int queryPartsLength() {
            return AbstractContext.this.visitParts.size();
        }

        @Override
        public final Context<?> context() {
            return AbstractContext.this;
        }

        @Override
        public final RenderContext renderContext() {
            return this.context() instanceof RenderContext ? (RenderContext)this.context() : null;
        }

        @Override
        public final BindContext bindContext() {
            return this.context() instanceof BindContext ? (BindContext)this.context() : null;
        }
    }
}

