/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.AggregateFunction;
import com.craftaro.third_party.org.jooq.ArrayAggOrderByStep;
import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.OrderField;
import com.craftaro.third_party.org.jooq.OrderedAggregateFunction;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.SQL;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.WindowBeforeOverStep;
import com.craftaro.third_party.org.jooq.impl.AbstractWindowFunction;
import com.craftaro.third_party.org.jooq.impl.ConditionProviderImpl;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.F1;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.QueryPartCollectionView;
import com.craftaro.third_party.org.jooq.impl.QueryPartList;
import com.craftaro.third_party.org.jooq.impl.SortFieldList;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

abstract class AbstractAggregateFunction<T>
extends AbstractWindowFunction<T>
implements AggregateFunction<T>,
OrderedAggregateFunction<T>,
ArrayAggOrderByStep<T> {
    private static final long serialVersionUID = -8613744948308064895L;
    static final Set<SQLDialect> SUPPORT_FILTER = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    static final Set<SQLDialect> SUPPORT_DISTINCT_RVE = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.POSTGRES);
    static final Field<Integer> ASTERISK = DSL.field("*", Integer.class);
    final QueryPartList<Field<?>> arguments;
    final boolean distinct;
    Condition filter;
    SortFieldList withinGroupOrderBy;
    SortFieldList keepDenseRankOrderBy;
    boolean first;

    AbstractAggregateFunction(boolean distinct, Name name, DataType<T> type, Field<?> ... arguments) {
        super(name, type);
        this.distinct = distinct;
        this.arguments = new QueryPartList((QueryPart[])arguments);
    }

    final void acceptArguments(Context<?> ctx) {
        ctx.visit(this.getQualifiedName());
        ctx.sql('(');
        this.acceptArguments0(ctx);
        ctx.sql(')');
    }

    final void acceptArguments0(Context<?> ctx) {
        this.acceptArguments1(ctx, this.arguments);
    }

    final void acceptArguments1(Context<?> ctx, QueryPartCollectionView<Field<?>> args) {
        if (this.distinct) {
            ctx.visit(Keywords.K_DISTINCT).sql(' ');
            if (args.size() > 1 && SUPPORT_DISTINCT_RVE.contains((Object)ctx.dialect())) {
                ctx.sql('(');
            }
        }
        if (!args.isEmpty()) {
            this.acceptArguments2(ctx, args);
        }
        if (this.distinct && args.size() > 1 && SUPPORT_DISTINCT_RVE.contains((Object)ctx.dialect())) {
            ctx.sql(')');
        }
    }

    final void acceptArguments2(Context<?> ctx, QueryPartCollectionView<Field<?>> args) {
        if (this.filter == null || SUPPORT_FILTER.contains((Object)ctx.dialect())) {
            ctx.visit(args);
        } else {
            ctx.visit(args.map(new F1<Field<?>, Field<?>>(){

                @Override
                public Field<?> apply(Field<?> arg) {
                    return DSL.when(AbstractAggregateFunction.this.filter, arg == ASTERISK ? DSL.one() : arg);
                }
            }));
        }
    }

    final void acceptFilterClause(Context<?> ctx) {
        AbstractAggregateFunction.acceptFilterClause(ctx, this.filter);
    }

    static final void acceptFilterClause(Context<?> ctx, Condition filter) {
        if (filter != null && SUPPORT_FILTER.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_FILTER).sql(" (").visit(Keywords.K_WHERE).sql(' ').visit(filter).sql(')');
        }
    }

    final void acceptOrderBy(Context<?> ctx) {
        if (!Tools.isEmpty(this.withinGroupOrderBy)) {
            ctx.sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.withinGroupOrderBy);
        }
    }

    final QueryPartList<Field<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition c2) {
        this.filter = c2;
        return this;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition ... conditions) {
        return this.filterWhere(Arrays.asList(conditions));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Collection<? extends Condition> conditions) {
        ConditionProviderImpl c2 = new ConditionProviderImpl();
        c2.addConditions(conditions);
        return this.filterWhere((Condition)c2);
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Field<Boolean> field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Boolean field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(SQL sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, Object ... bindings) {
        return this.filterWhere(DSL.condition(sql, bindings));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, QueryPart ... parts) {
        return this.filterWhere(DSL.condition(sql, parts));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(OrderField<?> ... fields) {
        return this.withinGroupOrderBy(Arrays.asList(fields));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(Collection<? extends OrderField<?>> fields) {
        if (this.withinGroupOrderBy == null) {
            this.withinGroupOrderBy = new SortFieldList();
        }
        this.withinGroupOrderBy.addAll(Tools.sortFields(fields));
        return this;
    }

    @Override
    public AbstractAggregateFunction<T> orderBy(OrderField<?> ... fields) {
        if (this.windowSpecification != null) {
            super.orderBy((OrderField[])fields);
        } else {
            this.withinGroupOrderBy((OrderField[])fields);
        }
        return this;
    }

    @Override
    public AbstractAggregateFunction<T> orderBy(Collection<? extends OrderField<?>> fields) {
        if (this.windowSpecification != null) {
            this.windowSpecification.orderBy((Collection)fields);
        } else {
            this.withinGroupOrderBy((Collection)fields);
        }
        return this;
    }
}

