/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.exception;

import com.craftaro.third_party.org.jooq.exception.ExceptionTools;
import com.craftaro.third_party.org.jooq.exception.SQLStateClass;
import com.craftaro.third_party.org.jooq.exception.SQLStateSubclass;
import java.sql.SQLException;

public class DataAccessException
extends RuntimeException {
    private static final long serialVersionUID = 491834858363345767L;

    public DataAccessException(String message) {
        super(message);
    }

    public DataAccessException(String message, Throwable cause) {
        super(message, cause);
    }

    public String sqlState() {
        SQLException e = this.getCause(SQLException.class);
        if (e != null) {
            return e.getSQLState();
        }
        return "00000";
    }

    public SQLStateClass sqlStateClass() {
        SQLException e = this.getCause(SQLException.class);
        if (e != null) {
            if (e.getSQLState() != null) {
                return SQLStateClass.fromCode(e.getSQLState());
            }
            if (e.getSQLState() == null && "org.sqlite.SQLiteException".equals(e.getClass().getName())) {
                return SQLStateClass.fromSQLiteVendorCode(e.getErrorCode());
            }
        }
        return SQLStateClass.NONE;
    }

    public SQLStateSubclass sqlStateSubclass() {
        SQLException e = this.getCause(SQLException.class);
        if (e != null) {
            return SQLStateSubclass.fromCode(e.getSQLState());
        }
        return SQLStateSubclass.NONE;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return super.getStackTrace();
    }

    public <T extends Throwable> T getCause(Class<? extends T> type) {
        return ExceptionTools.getCause(this, type);
    }
}

