/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq;

import com.craftaro.third_party.org.jooq.CLIUtil;
import com.craftaro.third_party.org.jooq.DSLContext;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.conf.RenderKeywordCase;
import com.craftaro.third_party.org.jooq.conf.RenderNameCase;
import com.craftaro.third_party.org.jooq.conf.RenderQuotedNames;
import com.craftaro.third_party.org.jooq.conf.Settings;
import com.craftaro.third_party.org.jooq.conf.TransformUnneededArithmeticExpressions;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.ParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParserCLI {
    private static final Pattern FLAG = Pattern.compile("^/([\\w\\-]+)(?:\\s+(\\w+))?\\s*$");

    public static final void main(final String ... args) throws Exception {
        CLIUtil.main("https://www.jooq.org/doc/latest/manual/sql-building/sql-parser/sql-parser-cli/", new Runnable(){

            @Override
            public void run() {
                Settings settings = new Settings();
                Args a2 = ParserCLI.parse(args);
                ParserCLI.settings(a2, settings);
                DSLContext ctx = ParserCLI.ctx(a2, settings);
                if (a2.interactive || args == null || args.length == 0) {
                    ParserCLI.interactiveMode(ctx, a2);
                } else if (!a2.done) {
                    if (a2.toDialect == null || a2.sql == null) {
                        System.out.println("Mandatory arguments: -T and -s. Use -h for help");
                        throw new RuntimeException();
                    }
                    ParserCLI.render(ctx, a2);
                }
            }
        });
    }

    private static final DSLContext ctx(Args a2, Settings settings) {
        return DSL.using(a2.toDialect, settings);
    }

    private static final void settings(Args a2, Settings settings) {
        if (a2.formatted) {
            settings.setRenderFormatted(true);
        }
        if (a2.keywords != null) {
            settings.setRenderKeywordCase(a2.keywords);
        }
        if (a2.name != null) {
            settings.setRenderNameCase(a2.name);
        }
        if (a2.quoted != null) {
            settings.setRenderQuotedNames(a2.quoted);
        }
        if (a2.fromDialect != null) {
            settings.setParseDialect(a2.fromDialect);
        }
        if (a2.transformAnsiJoinToTableLists) {
            settings.setTransformAnsiJoinToTableLists(true);
        }
        if (a2.transformTableListsToAnsiJoin) {
            settings.setTransformTableListsToAnsiJoin(true);
        }
        if (a2.transformUnneededArithmetic != null) {
            settings.setTransformUnneededArithmeticExpressions(a2.transformUnneededArithmetic);
        }
        if (a2.transformRownum) {
            settings.setTransformRownum(a2.transformRownum);
        }
    }

    private static final void interactiveMode(DSLContext ctx, Args a2) {
        Scanner scan = new Scanner(System.in);
        System.out.print("> ");
        do {
            String line = scan.nextLine();
            a2.history.add(line);
            if (a2.sql == null && line.startsWith("/")) {
                if ("/q".equals(line) || "/quit".equals(line) || "/e".equals(line) || "/exit".equals(line)) {
                    System.out.println("Bye");
                    break;
                }
                if ("/?".equals(line) || "/h".equals(line) || "/help".equals(line)) {
                    ParserCLI.helpInteractive();
                } else if ("/d".equals(line) || "/display".equals(line)) {
                    ParserCLI.displayArguments(a2);
                } else {
                    Matcher matcher = FLAG.matcher(line);
                    if (matcher.find()) {
                        String flag = matcher.group(1);
                        String arg = matcher.group(2);
                        if (flag != null) {
                            if ("f".equals(flag) || "formatted".equals(flag)) {
                                if (arg != null) {
                                    a2.formatted = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayFormatted(a2);
                            } else if ("k".equals(flag) || "keyword".equals(flag)) {
                                try {
                                    if (arg != null) {
                                        a2.keywords = RenderKeywordCase.valueOf(arg.toUpperCase());
                                    }
                                    ParserCLI.displayKeywords(a2);
                                }
                                catch (IllegalArgumentException e) {
                                    ParserCLI.invalid(arg, RenderKeywordCase.class);
                                }
                            } else if ("i".equals(flag) || "identifier".equals(flag)) {
                                try {
                                    if (arg != null) {
                                        a2.name = RenderNameCase.valueOf(arg.toUpperCase());
                                    }
                                    ParserCLI.displayIdentifiers(a2);
                                }
                                catch (IllegalArgumentException e) {
                                    ParserCLI.invalid(arg, RenderNameCase.class);
                                }
                            } else if ("Q".equals(flag) || "quoted".equals(flag)) {
                                try {
                                    if (arg != null) {
                                        a2.quoted = RenderQuotedNames.valueOf(arg.toUpperCase());
                                    }
                                    ParserCLI.displayQuoted(a2);
                                }
                                catch (IllegalArgumentException e) {
                                    ParserCLI.invalid(arg, RenderQuotedNames.class);
                                }
                            } else if ("F".equals(flag) || "from-dialect".equals(flag)) {
                                try {
                                    if (arg != null) {
                                        a2.fromDialect = SQLDialect.valueOf(arg.toUpperCase());
                                    }
                                    ParserCLI.displayFromDialect(a2);
                                }
                                catch (IllegalArgumentException e) {
                                    ParserCLI.invalid(arg, SQLDialect.class);
                                }
                            } else if ("transform-ansi-join-to-table-lists".equals(flag)) {
                                if (arg != null) {
                                    a2.transformAnsiJoinToTableLists = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayTransformAnsiJoinToTablesLists(a2);
                            } else if ("transform-rownum".equals(flag)) {
                                if (arg != null) {
                                    a2.transformRownum = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayTransformRownum(a2);
                            } else if ("transform-table-lists-to-ansi-join".equals(flag)) {
                                if (arg != null) {
                                    a2.transformTableListsToAnsiJoin = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayTransformTableListsToAnsiJoin(a2);
                            } else if ("transform-unneeded-arithmetic".equals(flag)) {
                                try {
                                    if (arg != null) {
                                        a2.transformUnneededArithmetic = TransformUnneededArithmeticExpressions.valueOf(arg.toUpperCase());
                                    }
                                    ParserCLI.displayTransformUnneededArithmetic(a2);
                                }
                                catch (IllegalArgumentException e) {
                                    ParserCLI.invalid(arg, TransformUnneededArithmeticExpressions.class);
                                }
                            } else if ("t".equals(flag) || "T".equals(flag) || "to-dialect".equals(flag)) {
                                try {
                                    if (arg != null) {
                                        a2.toDialect = SQLDialect.valueOf(arg.toUpperCase());
                                    }
                                    ParserCLI.displayToDialect(a2);
                                }
                                catch (IllegalArgumentException e) {
                                    ParserCLI.invalid(arg, SQLDialect.class);
                                }
                            }
                        }
                    } else {
                        System.out.println("Unrecognised command: " + line);
                        System.out.println("Type /h for help");
                    }
                }
                ParserCLI.settings(a2, ctx.settings());
                ctx = ParserCLI.ctx(a2, ctx.settings());
            }
            if (a2.sql != null || !line.startsWith("/")) {
                a2.sql = a2.sql == null ? line : a2.sql + "\n" + line;
                if (a2.sql.trim().endsWith(";")) {
                    ParserCLI.render(ctx, a2);
                    a2.sql = null;
                    System.out.println();
                }
            }
            System.out.print("> ");
        } while (scan.hasNextLine());
    }

    private static final void displayArguments(Args a2) {
        ParserCLI.displayFormatted(a2);
        ParserCLI.displayFromDialect(a2);
        ParserCLI.displayToDialect(a2);
        ParserCLI.displayKeywords(a2);
        ParserCLI.displayIdentifiers(a2);
        ParserCLI.displayQuoted(a2);
        ParserCLI.displayTransformAnsiJoinToTablesLists(a2);
        ParserCLI.displayTransformTableListsToAnsiJoin(a2);
        ParserCLI.displayTransformUnneededArithmetic(a2);
    }

    private static void displayIdentifiers(Args a2) {
        System.out.println("Identifiers                        : " + (Object)((Object)a2.name));
    }

    private static void displayQuoted(Args a2) {
        System.out.println("Quoted                             : " + (Object)((Object)a2.quoted));
    }

    private static void displayKeywords(Args a2) {
        System.out.println("Keywords                           : " + (Object)((Object)a2.keywords));
    }

    private static void displayToDialect(Args a2) {
        System.out.println("To dialect                         : " + (Object)((Object)a2.toDialect));
    }

    private static void displayFromDialect(Args a2) {
        System.out.println("From dialect                       : " + (Object)((Object)a2.fromDialect));
    }

    private static void displayFormatted(Args a2) {
        System.out.println("Formatted                          : " + a2.formatted);
    }

    private static void displayTransformAnsiJoinToTablesLists(Args a2) {
        System.out.println("Transform ANSI join to table lists : " + a2.transformAnsiJoinToTableLists);
    }

    private static void displayTransformRownum(Args a2) {
        System.out.println("Transform ROWNUM                   : " + a2.transformRownum);
    }

    private static void displayTransformTableListsToAnsiJoin(Args a2) {
        System.out.println("Transform table lists to ANSI join : " + a2.transformTableListsToAnsiJoin);
    }

    private static void displayTransformUnneededArithmetic(Args a2) {
        System.out.println("Transform unneeded arithmetic      : " + (Object)((Object)a2.transformUnneededArithmetic));
    }

    private static final void render(DSLContext ctx, Args a2) {
        String sql = a2.sql.trim();
        try {
            System.out.println(ctx.render(ctx.parser().parse(a2.sql)));
        }
        catch (ParserException e1) {
            ParserException e = e1;
            if (!sql.matches("^(?is:(?:ALTER|BEGIN|COMMENT|CREATE|DECLARE|DELETE|DESCRIBE|DROP|GRANT|INSERT|MERGE|RENAME|REVOKE|SELECT|SET|SHOW|TRUNCATE|UPDATE|USE).*)$")) {
                try {
                    System.out.println(ctx.render(ctx.parser().parseField(a2.sql)));
                }
                catch (ParserException e2) {
                    e = e1.position() >= e2.position() ? e1 : e2;
                }
            }
            System.out.println(e.getMessage());
        }
    }

    private static final Args parse(String[] args) {
        Args result = new Args();
        for (int i = 0; i < args.length; ++i) {
            if ("-f".equals(args[i]) || "--formatted".equals(args[i])) {
                result.formatted = true;
                continue;
            }
            if ("-k".equals(args[i]) || "--keyword".equals(args[i])) {
                try {
                    result.keywords = RenderKeywordCase.valueOf(args[++i].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ParserCLI.invalid(args[i], RenderKeywordCase.class);
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("Flag -k / --keyword requires <RenderKeywordCase> argument");
                    throw e;
                }
            }
            if ("-i".equals(args[i]) || "--identifier".equals(args[i])) {
                try {
                    result.keywords = RenderKeywordCase.valueOf(args[++i].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ParserCLI.invalid(args[i], RenderKeywordCase.class);
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("Flag -i / --identifier requires <RenderNameCase> argument");
                    throw e;
                }
            }
            if ("-Q".equals(args[i]) || "--quoted".equals(args[i])) {
                try {
                    result.quoted = RenderQuotedNames.valueOf(args[++i].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ParserCLI.invalid(args[i], RenderQuotedNames.class);
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("Flag -Q / --quoted requires <RenderQuotedNames> argument");
                    throw e;
                }
            }
            if ("-F".equals(args[i]) || "--from-dialect".equals(args[i])) {
                try {
                    result.fromDialect = SQLDialect.valueOf(args[++i].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ParserCLI.invalid(args[i], SQLDialect.class);
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("Flag -F / --from-dialect requires <SQLDialect> argument");
                    throw e;
                }
            }
            if ("-t".equals(args[i]) || "-T".equals(args[i]) || "--to-dialect".equals(args[i])) {
                try {
                    result.toDialect = SQLDialect.valueOf(args[++i].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ParserCLI.invalid(args[i], SQLDialect.class);
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("Flag -T / --to-dialect requires <SQLDialect> argument");
                    throw e;
                }
            }
            if ("--transform-ansi-join-to-table-lists".equals(args[i])) {
                result.transformAnsiJoinToTableLists = true;
                continue;
            }
            if ("--transform-rownum".equals(args[i])) {
                result.transformRownum = true;
                continue;
            }
            if ("--transform-table-lists-to-ansi-join".equals(args[i])) {
                result.transformTableListsToAnsiJoin = true;
                continue;
            }
            if ("--transform-unneeded-arithmetic".equals(args[i])) {
                try {
                    result.transformUnneededArithmetic = TransformUnneededArithmeticExpressions.valueOf(args[++i].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ParserCLI.invalid(args[i], TransformUnneededArithmeticExpressions.class);
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("Flag --transform-unneeded-arithmetic requires <TransformUnneededArithmeticExpressions> argument");
                    throw e;
                }
            }
            if ("-s".equals(args[i]) || "--sql".equals(args[i])) {
                try {
                    result.sql = args[++i];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("Flag -s / --sql requires <String> argument");
                    throw e;
                }
            }
            if ("-I".equals(args[i]) || "--interactive".equals(args[i])) {
                result.interactive = true;
                continue;
            }
            if ("-h".equals(args[i]) || "--help".equals(args[i])) {
                ParserCLI.help();
                result.done = true;
                continue;
            }
            System.out.println("Unknown flag: " + args[i] + ". Use -h or --help");
            throw new RuntimeException();
        }
        return result;
    }

    private static final void invalid(String string, Class<? extends Enum<?>> type) {
        System.out.println("Invalid " + type.getSimpleName() + ": " + string);
        System.out.println("Possible values:");
        for (Enum<?> e : type.getEnumConstants()) {
            System.out.println("  " + e.name());
        }
    }

    private static final void help() {
        System.out.println("Usage:");
        System.out.println("  -f / --formatted                                              Format output SQL");
        System.out.println("  -h / --help                                                   Display this help");
        System.out.println("  -k / --keyword                            <RenderKeywordCase> Specify the output keyword case (org.jooq.conf.RenderKeywordCase)");
        System.out.println("  -i / --identifier                         <RenderNameCase>    Specify the output identifier case (org.jooq.conf.RenderNameCase)");
        System.out.println("  -Q / --quoted                             <RenderQuotedNames> Specify the output identifier quoting (org.jooq.conf.RenderQuotedNames)");
        System.out.println("  -F / --from-dialect                       <SQLDialect>        Specify the input dialect (org.jooq.SQLDialect)");
        System.out.println("  -T / --to-dialect                         <SQLDialect>        Specify the output dialect (org.jooq.SQLDialect)");
        System.out.println("  -s / --sql                                <String>            Specify the input SQL string");
        System.out.println("");
        System.out.println("Commercial distribution only features:");
        System.out.println("  --transform-ansi-join-to-table-lists      <boolean>");
        System.out.println("  --transform-rownum                        <boolean>");
        System.out.println("  --transform-table-lists-to-ansi-join      <boolean>");
        System.out.println("  --transform-unneeded-arithmetic           <TransformUnneededArithmeticExpressions>");
        System.out.println("");
        System.out.println("  -I / --interactive                                            Start interactive mode");
    }

    private static final void helpInteractive() {
        System.out.println("Usage:");
        System.out.println("  /d  or  /display                                             Display arguments");
        System.out.println("  /f  or  /formatted                       <boolean>           Format output SQL");
        System.out.println("  /h  or  /help                                                Display this help");
        System.out.println("  /k  or  /keyword                         <RenderKeywordCase> Specify the output keyword case (org.jooq.conf.RenderKeywordCase)");
        System.out.println("  /i  or  /identifier                      <RenderNameCase>    Specify the output identifier case (org.jooq.conf.RenderNameCase)");
        System.out.println("  /Q  or  /quoted                          <RenderQuotedNames> Specify the output identifier quoting (org.jooq.conf.RenderQuotedNames)");
        System.out.println("  /F  or  /from-dialect                    <SQLDialect>        Specify the input dialect (org.jooq.SQLDialect)");
        System.out.println("  /T  or  /to-dialect                      <SQLDialect>        Specify the output dialect (org.jooq.SQLDialect)");
        System.out.println("                                           <String>            Specify the input SQL string");
        System.out.println("");
        System.out.println("Commercial distribution only features:");
        System.out.println("  /transform-ansi-join-to-table-lists      <boolean>");
        System.out.println("  /transform-rownum                        <boolean>");
        System.out.println("  /transform-table-lists-to-ansi-join      <boolean>");
        System.out.println("  /transform-unneeded-arithmetic           <TransformUnneededArithmeticExpressions>");
        System.out.println("");
        System.out.println("  /q  or  /quit                                                Quit");
        System.out.println("  /e  or  /exit                                                Also quit");
    }

    public static final class Args {
        List<String> history = new ArrayList<String>();
        String sql;
        RenderKeywordCase keywords = RenderKeywordCase.LOWER;
        RenderNameCase name = RenderNameCase.LOWER;
        RenderQuotedNames quoted = RenderQuotedNames.EXPLICIT_DEFAULT_UNQUOTED;
        SQLDialect toDialect = SQLDialect.DEFAULT;
        SQLDialect fromDialect = SQLDialect.DEFAULT;
        boolean formatted;
        boolean interactive;
        boolean done;
        boolean transformAnsiJoinToTableLists;
        boolean transformRownum;
        boolean transformTableListsToAnsiJoin;
        TransformUnneededArithmeticExpressions transformUnneededArithmetic = TransformUnneededArithmeticExpressions.NEVER;
    }
}

