/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq;

import com.craftaro.third_party.org.jooq.tools.StringUtils;

public final class JSONFormat {
    public static final JSONFormat DEFAULT_FOR_RESULTS = new JSONFormat();
    public static final JSONFormat DEFAULT_FOR_RECORDS = new JSONFormat().header(false);
    final boolean format;
    final String newline;
    final int indent;
    final String[] indented;
    final boolean header;
    final RecordFormat recordFormat;
    final boolean wrapSingleColumnRecords;
    final boolean quoteNested;

    public JSONFormat() {
        this(false, "\n", 2, null, true, RecordFormat.ARRAY, true, false);
    }

    private JSONFormat(boolean format, String newline, int indent, String[] indented, boolean header, RecordFormat recordFormat, boolean wrapSingleColumnRecords, boolean quoteNested) {
        String[] stringArray;
        this.format = format;
        this.newline = newline;
        this.indent = indent;
        if (indented != null) {
            stringArray = indented;
        } else {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "";
            stringArray2[1] = format ? StringUtils.rightPad("", indent * 1) : "";
            stringArray2[2] = format ? StringUtils.rightPad("", indent * 2) : "";
            stringArray = stringArray2;
            stringArray2[3] = format ? StringUtils.rightPad("", indent * 3) : "";
        }
        this.indented = stringArray;
        this.header = header;
        this.recordFormat = recordFormat;
        this.wrapSingleColumnRecords = wrapSingleColumnRecords;
        this.quoteNested = quoteNested;
    }

    public final JSONFormat format(boolean newFormat) {
        return new JSONFormat(newFormat, this.newline, this.indent, null, this.header, this.recordFormat, this.wrapSingleColumnRecords, this.quoteNested);
    }

    public final boolean format() {
        return this.format;
    }

    public final JSONFormat newline(String newNewline) {
        return new JSONFormat(this.format, newNewline, this.indent, this.indented, this.header, this.recordFormat, this.wrapSingleColumnRecords, this.quoteNested);
    }

    public final String newline() {
        return this.format ? this.newline : "";
    }

    public final JSONFormat indent(int newIndent) {
        return new JSONFormat(this.format, this.newline, newIndent, null, this.header, this.recordFormat, this.wrapSingleColumnRecords, this.quoteNested);
    }

    public final int indent() {
        return this.indent;
    }

    public final String indentString(int level) {
        if (level < this.indented.length) {
            return this.indented[level];
        }
        if (this.format) {
            return StringUtils.rightPad("", this.indent * level);
        }
        return "";
    }

    public final JSONFormat header(boolean newHeader) {
        return new JSONFormat(this.format, this.newline, this.indent, this.indented, newHeader, this.recordFormat, this.wrapSingleColumnRecords, this.quoteNested);
    }

    public final boolean header() {
        return this.header;
    }

    public final JSONFormat recordFormat(RecordFormat newRecordFormat) {
        return new JSONFormat(this.format, this.newline, this.indent, this.indented, this.header, newRecordFormat, this.wrapSingleColumnRecords, this.quoteNested);
    }

    public final RecordFormat recordFormat() {
        return this.recordFormat;
    }

    public final JSONFormat wrapSingleColumnRecords(boolean newWrapSingleColumnRecords) {
        return new JSONFormat(this.format, this.newline, this.indent, this.indented, this.header, this.recordFormat, newWrapSingleColumnRecords, this.quoteNested);
    }

    public final boolean wrapSingleColumnRecords() {
        return this.wrapSingleColumnRecords;
    }

    public final JSONFormat quoteNested(boolean newQuoteNested) {
        return new JSONFormat(this.format, this.newline, this.indent, this.indented, this.header, this.recordFormat, this.wrapSingleColumnRecords, newQuoteNested);
    }

    public final boolean quoteNested() {
        return this.quoteNested;
    }

    public static enum RecordFormat {
        ARRAY,
        OBJECT;

    }
}

