/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq;

import com.craftaro.third_party.org.jooq.Converters;
import com.craftaro.third_party.org.jooq.impl.AbstractConverter;
import java.io.Serializable;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public interface Converter<T, U>
extends Serializable {
    public U from(T var1);

    public T to(U var1);

    @NotNull
    public Class<T> fromType();

    @NotNull
    public Class<U> toType();

    @NotNull
    default public Converter<U, T> inverse() {
        return Converters.inverse(this);
    }

    @NotNull
    default public <X> Converter<T, X> andThen(Converter<? super U, X> converter) {
        return Converters.of(this, converter);
    }

    @NotNull
    default public Converter<T[], U[]> forArrays() {
        return Converters.forArrays(this);
    }

    @NotNull
    public static <T, U> Converter<T, U> of(Class<T> fromType, Class<U> toType, final Function<? super T, ? extends U> from, final Function<? super U, ? extends T> to) {
        return new AbstractConverter<T, U>(fromType, toType){
            private static final long serialVersionUID = 8782437631959970693L;

            @Override
            public final U from(T t) {
                return from.apply(t);
            }

            @Override
            public final T to(U u) {
                return to.apply(u);
            }
        };
    }

    @NotNull
    public static <T, U> Converter<T, U> ofNullable(Class<T> fromType, Class<U> toType, Function<? super T, ? extends U> from, Function<? super U, ? extends T> to) {
        Function fromS = from instanceof Serializable ? (Function<Object, Object> & Serializable)t -> t == null ? null : from.apply(t) : t -> t == null ? null : from.apply(t);
        Function toS = to instanceof Serializable ? (Function<Object, Object> & Serializable)u -> u == null ? null : to.apply((Object)u) : u -> u == null ? null : to.apply((Object)u);
        return Converter.of(fromType, toType, fromS, toS);
    }
}

