/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq;

import com.craftaro.third_party.org.jooq.Keyword;
import com.craftaro.third_party.org.jooq.impl.DSL;

public enum Comparator {
    IN("in", false, true),
    NOT_IN("not in", false, true),
    EQUALS("=", true, true),
    NOT_EQUALS("<>", true, true),
    LESS("<", true, true),
    LESS_OR_EQUAL("<=", true, true),
    GREATER(">", true, true),
    GREATER_OR_EQUAL(">=", true, true),
    IS_DISTINCT_FROM("is distinct from", false, false),
    IS_NOT_DISTINCT_FROM("is not distinct from", false, false),
    LIKE("like", false, false),
    NOT_LIKE("not like", false, false),
    SIMILAR_TO("similar to", false, false),
    NOT_SIMILAR_TO("not similar to", false, false),
    LIKE_IGNORE_CASE("ilike", false, false),
    NOT_LIKE_IGNORE_CASE("not ilike", false, false);

    private final String sql;
    private final Keyword keyword;
    private final boolean supportsQuantifier;
    private final boolean supportsSubselect;

    private Comparator(String sql, boolean supportsQuantifier, boolean supportsSubselect) {
        this.sql = sql;
        this.keyword = DSL.keyword(sql);
        this.supportsQuantifier = supportsQuantifier;
        this.supportsSubselect = supportsSubselect;
    }

    public String toSQL() {
        return this.sql;
    }

    public Keyword toKeyword() {
        return this.keyword;
    }

    public Comparator inverse() {
        switch (this) {
            case EQUALS: {
                return NOT_EQUALS;
            }
            case GREATER: {
                return LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return LESS;
            }
            case IN: {
                return NOT_IN;
            }
            case IS_DISTINCT_FROM: {
                return IS_NOT_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return IS_DISTINCT_FROM;
            }
            case LESS: {
                return GREATER_OR_EQUAL;
            }
            case LESS_OR_EQUAL: {
                return GREATER;
            }
            case LIKE: {
                return NOT_LIKE;
            }
            case LIKE_IGNORE_CASE: {
                return NOT_LIKE_IGNORE_CASE;
            }
            case NOT_EQUALS: {
                return EQUALS;
            }
            case NOT_IN: {
                return IN;
            }
            case NOT_LIKE: {
                return LIKE;
            }
            case NOT_LIKE_IGNORE_CASE: {
                return LIKE_IGNORE_CASE;
            }
            case NOT_SIMILAR_TO: {
                return SIMILAR_TO;
            }
            case SIMILAR_TO: {
                return NOT_SIMILAR_TO;
            }
        }
        throw new IllegalStateException();
    }

    public Comparator mirror() {
        switch (this) {
            case EQUALS: {
                return EQUALS;
            }
            case GREATER: {
                return LESS;
            }
            case GREATER_OR_EQUAL: {
                return LESS_OR_EQUAL;
            }
            case IS_DISTINCT_FROM: {
                return IS_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return IS_NOT_DISTINCT_FROM;
            }
            case LESS: {
                return GREATER;
            }
            case LESS_OR_EQUAL: {
                return GREATER_OR_EQUAL;
            }
            case NOT_EQUALS: {
                return NOT_EQUALS;
            }
        }
        return null;
    }

    @Deprecated
    public boolean supportsQuantifier() {
        return this.supportsQuantifier;
    }

    @Deprecated
    public boolean supportsSubselect() {
        return this.supportsSubselect;
    }
}

