/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.value;

import com.craftaro.third_party.org.h2.api.IntervalQualifier;
import com.craftaro.third_party.org.h2.engine.CastDataProvider;
import com.craftaro.third_party.org.h2.engine.SysProperties;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.result.ResultInterface;
import com.craftaro.third_party.org.h2.result.SimpleResult;
import com.craftaro.third_party.org.h2.store.DataHandler;
import com.craftaro.third_party.org.h2.util.Bits;
import com.craftaro.third_party.org.h2.util.DateTimeUtils;
import com.craftaro.third_party.org.h2.util.IntervalUtils;
import com.craftaro.third_party.org.h2.util.JdbcUtils;
import com.craftaro.third_party.org.h2.util.StringUtils;
import com.craftaro.third_party.org.h2.util.geometry.GeoJsonUtils;
import com.craftaro.third_party.org.h2.value.CompareMode;
import com.craftaro.third_party.org.h2.value.DataType;
import com.craftaro.third_party.org.h2.value.ExtTypeInfo;
import com.craftaro.third_party.org.h2.value.ExtTypeInfoEnum;
import com.craftaro.third_party.org.h2.value.ExtTypeInfoGeometry;
import com.craftaro.third_party.org.h2.value.TypeInfo;
import com.craftaro.third_party.org.h2.value.ValueArray;
import com.craftaro.third_party.org.h2.value.ValueBoolean;
import com.craftaro.third_party.org.h2.value.ValueByte;
import com.craftaro.third_party.org.h2.value.ValueBytes;
import com.craftaro.third_party.org.h2.value.ValueDate;
import com.craftaro.third_party.org.h2.value.ValueDecimal;
import com.craftaro.third_party.org.h2.value.ValueDouble;
import com.craftaro.third_party.org.h2.value.ValueEnum;
import com.craftaro.third_party.org.h2.value.ValueFloat;
import com.craftaro.third_party.org.h2.value.ValueGeometry;
import com.craftaro.third_party.org.h2.value.ValueInt;
import com.craftaro.third_party.org.h2.value.ValueInterval;
import com.craftaro.third_party.org.h2.value.ValueJavaObject;
import com.craftaro.third_party.org.h2.value.ValueJson;
import com.craftaro.third_party.org.h2.value.ValueLobDb;
import com.craftaro.third_party.org.h2.value.ValueLong;
import com.craftaro.third_party.org.h2.value.ValueNull;
import com.craftaro.third_party.org.h2.value.ValueResultSet;
import com.craftaro.third_party.org.h2.value.ValueRow;
import com.craftaro.third_party.org.h2.value.ValueShort;
import com.craftaro.third_party.org.h2.value.ValueString;
import com.craftaro.third_party.org.h2.value.ValueStringFixed;
import com.craftaro.third_party.org.h2.value.ValueStringIgnoreCase;
import com.craftaro.third_party.org.h2.value.ValueTime;
import com.craftaro.third_party.org.h2.value.ValueTimeTimeZone;
import com.craftaro.third_party.org.h2.value.ValueTimestamp;
import com.craftaro.third_party.org.h2.value.ValueTimestampTimeZone;
import com.craftaro.third_party.org.h2.value.ValueUuid;
import com.craftaro.third_party.org.h2.value.VersionedValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import java.util.UUID;

public abstract class Value
extends VersionedValue {
    public static final int UNKNOWN = -1;
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int DECIMAL = 6;
    public static final int DOUBLE = 7;
    public static final int FLOAT = 8;
    public static final int TIME = 9;
    public static final int DATE = 10;
    public static final int TIMESTAMP = 11;
    public static final int BYTES = 12;
    public static final int STRING = 13;
    public static final int STRING_IGNORECASE = 14;
    public static final int BLOB = 15;
    public static final int CLOB = 16;
    public static final int ARRAY = 17;
    public static final int RESULT_SET = 18;
    public static final int JAVA_OBJECT = 19;
    public static final int UUID = 20;
    public static final int STRING_FIXED = 21;
    public static final int GEOMETRY = 22;
    public static final int TIMESTAMP_TZ = 24;
    public static final int ENUM = 25;
    public static final int INTERVAL_YEAR = 26;
    public static final int INTERVAL_MONTH = 27;
    public static final int INTERVAL_DAY = 28;
    public static final int INTERVAL_HOUR = 29;
    public static final int INTERVAL_MINUTE = 30;
    public static final int INTERVAL_SECOND = 31;
    public static final int INTERVAL_YEAR_TO_MONTH = 32;
    public static final int INTERVAL_DAY_TO_HOUR = 33;
    public static final int INTERVAL_DAY_TO_MINUTE = 34;
    public static final int INTERVAL_DAY_TO_SECOND = 35;
    public static final int INTERVAL_HOUR_TO_MINUTE = 36;
    public static final int INTERVAL_HOUR_TO_SECOND = 37;
    public static final int INTERVAL_MINUTE_TO_SECOND = 38;
    public static final int ROW = 39;
    public static final int JSON = 40;
    public static final int TIME_TZ = 41;
    public static final int TYPE_COUNT = 42;
    private static SoftReference<Value[]> softCache;
    private static final BigDecimal MAX_LONG_DECIMAL;
    public static final BigDecimal MIN_LONG_DECIMAL;

    static void rangeCheck(long l, long l2, long l3) {
        if ((l | l2) < 0L || l2 > l3 - l) {
            if (l < 0L || l > l3) {
                throw DbException.getInvalidValueException("offset", l + 1L);
            }
            throw DbException.getInvalidValueException("length", l2);
        }
    }

    public String getSQL() {
        return this.getSQL(new StringBuilder()).toString();
    }

    public abstract StringBuilder getSQL(StringBuilder var1);

    public abstract TypeInfo getType();

    public abstract int getValueType();

    public int getMemory() {
        return 24;
    }

    public abstract String getString();

    public abstract Object getObject();

    public abstract void set(PreparedStatement var1, int var2) throws SQLException;

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static int getOrder(int n) {
        switch (n) {
            case -1: {
                return 1000;
            }
            case 0: {
                return 2000;
            }
            case 13: {
                return 10000;
            }
            case 16: {
                return 11000;
            }
            case 21: {
                return 12000;
            }
            case 14: {
                return 13000;
            }
            case 1: {
                return 20000;
            }
            case 2: {
                return 21000;
            }
            case 3: {
                return 22000;
            }
            case 4: {
                return 23000;
            }
            case 5: {
                return 24000;
            }
            case 6: {
                return 25000;
            }
            case 8: {
                return 26000;
            }
            case 7: {
                return 27000;
            }
            case 26: {
                return 28000;
            }
            case 27: {
                return 28100;
            }
            case 32: {
                return 28200;
            }
            case 28: {
                return 29000;
            }
            case 29: {
                return 29100;
            }
            case 33: {
                return 29200;
            }
            case 30: {
                return 29300;
            }
            case 36: {
                return 29400;
            }
            case 34: {
                return 29500;
            }
            case 31: {
                return 29600;
            }
            case 38: {
                return 29700;
            }
            case 37: {
                return 29800;
            }
            case 35: {
                return 29900;
            }
            case 9: {
                return 30000;
            }
            case 41: {
                return 30500;
            }
            case 10: {
                return 31000;
            }
            case 11: {
                return 32000;
            }
            case 24: {
                return 34000;
            }
            case 12: {
                return 40000;
            }
            case 15: {
                return 41000;
            }
            case 19: {
                return 42000;
            }
            case 20: {
                return 43000;
            }
            case 22: {
                return 44000;
            }
            case 25: {
                return 45000;
            }
            case 40: {
                return 46000;
            }
            case 17: {
                return 50000;
            }
            case 39: {
                return 51000;
            }
            case 18: {
                return 52000;
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getDataTypeOrder(n);
        }
        throw DbException.throwInternalError("type:" + n);
    }

    public static int getHigherOrder(int n, int n2) {
        int n3;
        if (n == -1 || n2 == -1) {
            if (n == n2) {
                throw DbException.get(50004, "?, ?");
            }
            if (n == 0) {
                throw DbException.get(50004, "NULL, ?");
            }
            if (n2 == 0) {
                throw DbException.get(50004, "?, NULL");
            }
        }
        if (n == n2) {
            return n;
        }
        int n4 = Value.getOrder(n);
        return n4 > (n3 = Value.getOrder(n2)) ? n : n2;
    }

    public static TypeInfo getHigherType(TypeInfo typeInfo, TypeInfo typeInfo2) {
        int n = typeInfo.getValueType();
        int n2 = typeInfo2.getValueType();
        int n3 = Value.getHigherOrder(n, n2);
        long l = Math.max(typeInfo.getPrecision(), typeInfo2.getPrecision());
        int n4 = Math.max(typeInfo.getScale(), typeInfo2.getScale());
        ExtTypeInfo extTypeInfo = typeInfo.getExtTypeInfo();
        ExtTypeInfo extTypeInfo2 = n3 == n && extTypeInfo != null ? extTypeInfo : (n3 == n2 ? typeInfo2.getExtTypeInfo() : null);
        return TypeInfo.getTypeInfo(n3, l, n4, extTypeInfo2);
    }

    static Value cache(Value value) {
        if (SysProperties.OBJECT_CACHE) {
            int n;
            Value value2;
            Value[] valueArray;
            int n2 = value.hashCode();
            if (softCache == null || (valueArray = softCache.get()) == null) {
                valueArray = new Value[SysProperties.OBJECT_CACHE_SIZE];
                softCache = new SoftReference<Value[]>(valueArray);
            }
            if ((value2 = valueArray[n = n2 & SysProperties.OBJECT_CACHE_SIZE - 1]) != null && value2.getValueType() == value.getValueType() && value.equals(value2)) {
                return value2;
            }
            valueArray[n] = value;
        }
        return value;
    }

    public static void clearCache() {
        softCache = null;
    }

    public boolean getBoolean() {
        return ((ValueBoolean)this.convertTo(1)).getBoolean();
    }

    public Date getDate(TimeZone timeZone) {
        return ((ValueDate)this.convertTo(10)).getDate(timeZone);
    }

    public Time getTime(TimeZone timeZone) {
        return ((ValueTime)this.convertTo(9)).getTime(timeZone);
    }

    public Timestamp getTimestamp(TimeZone timeZone) {
        return ((ValueTimestamp)this.convertTo(11)).getTimestamp(timeZone);
    }

    public byte[] getBytes() {
        return ((ValueBytes)this.convertTo(12)).getBytes();
    }

    public byte[] getBytesNoCopy() {
        return ((ValueBytes)this.convertTo(12)).getBytesNoCopy();
    }

    public byte getByte() {
        return ((ValueByte)this.convertTo(2)).getByte();
    }

    public short getShort() {
        return ((ValueShort)this.convertTo(3)).getShort();
    }

    public BigDecimal getBigDecimal() {
        return ((ValueDecimal)this.convertTo(6)).getBigDecimal();
    }

    public double getDouble() {
        return ((ValueDouble)this.convertTo(7)).getDouble();
    }

    public float getFloat() {
        return ((ValueFloat)this.convertTo(8)).getFloat();
    }

    public int getInt() {
        return ((ValueInt)this.convertTo(4)).getInt();
    }

    public long getLong() {
        return ((ValueLong)this.convertTo(5)).getLong();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytesNoCopy());
    }

    public InputStream getInputStream(long l, long l2) {
        byte[] byArray = this.getBytesNoCopy();
        long l3 = l - 1L;
        Value.rangeCheck(l3, l2, byArray.length);
        return new ByteArrayInputStream(byArray, (int)l3, (int)l2);
    }

    public Reader getReader() {
        return new StringReader(this.getString());
    }

    public Reader getReader(long l, long l2) {
        String string = this.getString();
        long l3 = l - 1L;
        Value.rangeCheck(l3, l2, string.length());
        int n = (int)l3;
        return new StringReader(string.substring(n, n + (int)l2));
    }

    public Value add(Value value) {
        throw this.getUnsupportedExceptionForOperation("+");
    }

    public int getSignum() {
        throw this.getUnsupportedExceptionForOperation("SIGNUM");
    }

    public Value negate() {
        throw this.getUnsupportedExceptionForOperation("NEG");
    }

    public Value subtract(Value value) {
        throw this.getUnsupportedExceptionForOperation("-");
    }

    public Value divide(Value value) {
        throw this.getUnsupportedExceptionForOperation("/");
    }

    public Value multiply(Value value) {
        throw this.getUnsupportedExceptionForOperation("*");
    }

    public Value modulus(Value value) {
        throw this.getUnsupportedExceptionForOperation("%");
    }

    public final Value convertTo(int n) {
        return this.convertTo(n, null, null, false, null);
    }

    private Value convertToEnum(ExtTypeInfo extTypeInfo) {
        return this.convertTo(25, extTypeInfo, null, false, null);
    }

    public final Value convertTo(int n, CastDataProvider castDataProvider, boolean bl) {
        return this.convertTo(n, null, castDataProvider, bl, null);
    }

    public final Value convertTo(TypeInfo typeInfo, CastDataProvider castDataProvider, boolean bl, Object object) {
        return this.convertTo(typeInfo.getValueType(), typeInfo.getExtTypeInfo(), castDataProvider, bl, object);
    }

    protected Value convertTo(int n, ExtTypeInfo extTypeInfo, CastDataProvider castDataProvider, boolean bl, Object object) {
        if (this.getValueType() == n) {
            if (extTypeInfo != null) {
                return extTypeInfo.cast(this);
            }
            return this;
        }
        try {
            switch (n) {
                case 0: {
                    return ValueNull.INSTANCE;
                }
                case 1: {
                    return this.convertToBoolean();
                }
                case 2: {
                    return this.convertToByte(object);
                }
                case 3: {
                    return this.convertToShort(object);
                }
                case 4: {
                    return this.convertToInt(object);
                }
                case 5: {
                    return this.convertToLong(object);
                }
                case 6: {
                    return this.convertToDecimal();
                }
                case 7: {
                    return this.convertToDouble();
                }
                case 8: {
                    return this.convertToFloat();
                }
                case 10: {
                    return this.convertToDate();
                }
                case 9: {
                    return this.convertToTime(castDataProvider, bl);
                }
                case 41: {
                    return this.convertToTimeTimeZone(castDataProvider, bl);
                }
                case 11: {
                    return this.convertToTimestamp(castDataProvider, bl);
                }
                case 24: {
                    return this.convertToTimestampTimeZone(castDataProvider, bl);
                }
                case 12: {
                    return this.convertToBytes(castDataProvider);
                }
                case 13: {
                    return ValueString.get(this.convertToString(castDataProvider));
                }
                case 14: {
                    return ValueStringIgnoreCase.get(this.convertToString(castDataProvider));
                }
                case 21: {
                    return ValueStringFixed.get(this.convertToString(castDataProvider));
                }
                case 19: {
                    return this.convertToJavaObject();
                }
                case 25: {
                    return this.convertToEnumInternal((ExtTypeInfoEnum)extTypeInfo);
                }
                case 15: {
                    return this.convertToBlob();
                }
                case 16: {
                    return this.convertToClob();
                }
                case 20: {
                    return this.convertToUuid();
                }
                case 22: {
                    return this.convertToGeometry((ExtTypeInfoGeometry)extTypeInfo);
                }
                case 26: 
                case 27: 
                case 32: {
                    return this.convertToIntervalYearMonth(n);
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    return this.convertToIntervalDayTime(n);
                }
                case 40: {
                    return this.convertToJson();
                }
                case 17: {
                    return this.convertToArray();
                }
                case 39: {
                    return this.convertToRow();
                }
                case 18: {
                    return this.convertToResultSet();
                }
            }
            if (JdbcUtils.customDataTypesHandler != null) {
                return JdbcUtils.customDataTypesHandler.convert(this, n);
            }
            throw this.getDataConversionError(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw DbException.get(22018, numberFormatException, this.getString());
        }
    }

    private ValueBoolean convertToBoolean() {
        switch (this.getValueType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ValueBoolean.get(this.getSignum() != 0);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                throw this.getDataConversionError(1);
            }
        }
        String string = this.getString();
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y")) {
            return ValueBoolean.TRUE;
        }
        if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n")) {
            return ValueBoolean.FALSE;
        }
        return ValueBoolean.get(new BigDecimal(string).signum() != 0);
    }

    private ValueByte convertToByte(Object object) {
        switch (this.getValueType()) {
            case 1: {
                return ValueByte.get(this.getBoolean() ? (byte)1 : 0);
            }
            case 3: 
            case 4: 
            case 25: {
                return ValueByte.get(Value.convertToByte(this.getInt(), object));
            }
            case 5: {
                return ValueByte.get(Value.convertToByte(this.getLong(), object));
            }
            case 6: {
                return ValueByte.get(Value.convertToByte(Value.convertToLong(this.getBigDecimal(), object), object));
            }
            case 7: {
                return ValueByte.get(Value.convertToByte(Value.convertToLong(this.getDouble(), object), object));
            }
            case 8: {
                return ValueByte.get(Value.convertToByte(Value.convertToLong(this.getFloat(), object), object));
            }
            case 12: {
                return ValueByte.get((byte)Integer.parseInt(this.getString(), 16));
            }
            case 24: {
                throw this.getDataConversionError(2);
            }
        }
        return ValueByte.get(Byte.parseByte(this.getString().trim()));
    }

    private ValueShort convertToShort(Object object) {
        switch (this.getValueType()) {
            case 1: {
                return ValueShort.get(this.getBoolean() ? (short)1 : 0);
            }
            case 2: {
                return ValueShort.get(this.getByte());
            }
            case 4: 
            case 25: {
                return ValueShort.get(Value.convertToShort(this.getInt(), object));
            }
            case 5: {
                return ValueShort.get(Value.convertToShort(this.getLong(), object));
            }
            case 6: {
                return ValueShort.get(Value.convertToShort(Value.convertToLong(this.getBigDecimal(), object), object));
            }
            case 7: {
                return ValueShort.get(Value.convertToShort(Value.convertToLong(this.getDouble(), object), object));
            }
            case 8: {
                return ValueShort.get(Value.convertToShort(Value.convertToLong(this.getFloat(), object), object));
            }
            case 12: {
                return ValueShort.get((short)Integer.parseInt(this.getString(), 16));
            }
            case 24: {
                throw this.getDataConversionError(3);
            }
        }
        return ValueShort.get(Short.parseShort(this.getString().trim()));
    }

    private ValueInt convertToInt(Object object) {
        switch (this.getValueType()) {
            case 1: {
                return ValueInt.get(this.getBoolean() ? 1 : 0);
            }
            case 2: 
            case 3: 
            case 25: {
                return ValueInt.get(this.getInt());
            }
            case 5: {
                return ValueInt.get(Value.convertToInt(this.getLong(), object));
            }
            case 6: {
                return ValueInt.get(Value.convertToInt(Value.convertToLong(this.getBigDecimal(), object), object));
            }
            case 7: {
                return ValueInt.get(Value.convertToInt(Value.convertToLong(this.getDouble(), object), object));
            }
            case 8: {
                return ValueInt.get(Value.convertToInt(Value.convertToLong(this.getFloat(), object), object));
            }
            case 12: {
                return ValueInt.get((int)Long.parseLong(this.getString(), 16));
            }
            case 24: {
                throw this.getDataConversionError(4);
            }
        }
        return ValueInt.get(Integer.parseInt(this.getString().trim()));
    }

    private ValueLong convertToLong(Object object) {
        switch (this.getValueType()) {
            case 1: {
                return ValueLong.get(this.getBoolean() ? 1L : 0L);
            }
            case 2: 
            case 3: 
            case 4: 
            case 25: {
                return ValueLong.get(this.getInt());
            }
            case 6: {
                return ValueLong.get(Value.convertToLong(this.getBigDecimal(), object));
            }
            case 7: {
                return ValueLong.get(Value.convertToLong(this.getDouble(), object));
            }
            case 8: {
                return ValueLong.get(Value.convertToLong(this.getFloat(), object));
            }
            case 12: {
                byte[] byArray = this.getBytes();
                if (byArray.length == 8) {
                    return ValueLong.get(Bits.readLong(byArray, 0));
                }
                return ValueLong.get(Long.parseLong(this.getString(), 16));
            }
            case 24: {
                throw this.getDataConversionError(5);
            }
        }
        return ValueLong.get(Long.parseLong(this.getString().trim()));
    }

    private ValueDecimal convertToDecimal() {
        switch (this.getValueType()) {
            case 1: {
                return (ValueDecimal)(this.getBoolean() ? ValueDecimal.ONE : ValueDecimal.ZERO);
            }
            case 2: 
            case 3: 
            case 4: 
            case 25: {
                return ValueDecimal.get(BigDecimal.valueOf(this.getInt()));
            }
            case 5: {
                return ValueDecimal.get(BigDecimal.valueOf(this.getLong()));
            }
            case 7: 
            case 8: {
                return ValueDecimal.get(this.getBigDecimal());
            }
            case 24: {
                throw this.getDataConversionError(6);
            }
        }
        return ValueDecimal.get(new BigDecimal(this.getString().trim()));
    }

    private ValueDouble convertToDouble() {
        switch (this.getValueType()) {
            case 1: {
                return this.getBoolean() ? ValueDouble.ONE : ValueDouble.ZERO;
            }
            case 2: 
            case 3: 
            case 4: {
                return ValueDouble.get(this.getInt());
            }
            case 5: {
                return ValueDouble.get(this.getLong());
            }
            case 6: {
                return ValueDouble.get(this.getBigDecimal().doubleValue());
            }
            case 8: {
                return ValueDouble.get(this.getFloat());
            }
            case 24: 
            case 25: {
                throw this.getDataConversionError(7);
            }
        }
        return ValueDouble.get(Double.parseDouble(this.getString().trim()));
    }

    private ValueFloat convertToFloat() {
        switch (this.getValueType()) {
            case 1: {
                return this.getBoolean() ? ValueFloat.ONE : ValueFloat.ZERO;
            }
            case 2: 
            case 3: 
            case 4: {
                return ValueFloat.get(this.getInt());
            }
            case 5: {
                return ValueFloat.get(this.getLong());
            }
            case 6: {
                return ValueFloat.get(this.getBigDecimal().floatValue());
            }
            case 7: {
                return ValueFloat.get((float)this.getDouble());
            }
            case 24: 
            case 25: {
                throw this.getDataConversionError(8);
            }
        }
        return ValueFloat.get(Float.parseFloat(this.getString().trim()));
    }

    private ValueDate convertToDate() {
        switch (this.getValueType()) {
            case 11: {
                return ValueDate.fromDateValue(((ValueTimestamp)this).getDateValue());
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                long l = valueTimestampTimeZone.getTimeNanos();
                long l2 = DateTimeUtils.getEpochSeconds(valueTimestampTimeZone.getDateValue(), l, valueTimestampTimeZone.getTimeZoneOffsetSeconds());
                return ValueDate.fromDateValue(DateTimeUtils.dateValueFromLocalSeconds(l2 + (long)DateTimeUtils.getTimeZoneOffset(l2)));
            }
            case 9: 
            case 25: 
            case 41: {
                throw this.getDataConversionError(10);
            }
        }
        return ValueDate.parse(this.getString().trim());
    }

    private ValueTime convertToTime(CastDataProvider castDataProvider, boolean bl) {
        switch (this.getValueType()) {
            case 41: {
                return ValueTime.fromNanos(this.getLocalTimeNanos(castDataProvider, bl));
            }
            case 11: {
                return ValueTime.fromNanos(((ValueTimestamp)this).getTimeNanos());
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                long l = valueTimestampTimeZone.getTimeNanos();
                long l2 = DateTimeUtils.getEpochSeconds(valueTimestampTimeZone.getDateValue(), l, valueTimestampTimeZone.getTimeZoneOffsetSeconds());
                return ValueTime.fromNanos(DateTimeUtils.nanosFromLocalSeconds(l2 + (long)DateTimeUtils.getTimeZoneOffset(l2)) + l % 1000000000L);
            }
            case 10: 
            case 25: {
                throw this.getDataConversionError(9);
            }
        }
        return ValueTime.parse(this.getString().trim());
    }

    private ValueTimeTimeZone convertToTimeTimeZone(CastDataProvider castDataProvider, boolean bl) {
        switch (this.getValueType()) {
            case 9: {
                ValueTime valueTime = (ValueTime)this;
                int n = bl ? DateTimeUtils.getTimeZoneOffset(0L) : castDataProvider.currentTimestamp().getTimeZoneOffsetSeconds();
                return ValueTimeTimeZone.fromNanos(valueTime.getNanos(), n);
            }
            case 11: {
                ValueTimestamp valueTimestamp = (ValueTimestamp)this;
                long l = valueTimestamp.getTimeNanos();
                return ValueTimeTimeZone.fromNanos(l, DateTimeUtils.getTimeZoneOffset(valueTimestamp.getDateValue(), l));
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                return ValueTimeTimeZone.fromNanos(valueTimestampTimeZone.getTimeNanos(), valueTimestampTimeZone.getTimeZoneOffsetSeconds());
            }
            case 10: 
            case 25: {
                throw this.getDataConversionError(41);
            }
        }
        return ValueTimeTimeZone.parse(this.getString().trim());
    }

    private ValueTimestamp convertToTimestamp(CastDataProvider castDataProvider, boolean bl) {
        switch (this.getValueType()) {
            case 9: {
                return ValueTimestamp.fromDateValueAndNanos(bl ? 1008673L : castDataProvider.currentTimestamp().getDateValue(), ((ValueTime)this).getNanos());
            }
            case 41: {
                return ValueTimestamp.fromDateValueAndNanos(bl ? 1008673L : castDataProvider.currentTimestamp().getDateValue(), this.getLocalTimeNanos(castDataProvider, bl));
            }
            case 10: {
                return ValueTimestamp.fromDateValueAndNanos(((ValueDate)this).getDateValue(), 0L);
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                long l = valueTimestampTimeZone.getTimeNanos();
                long l2 = DateTimeUtils.getEpochSeconds(valueTimestampTimeZone.getDateValue(), l, valueTimestampTimeZone.getTimeZoneOffsetSeconds());
                l2 += (long)DateTimeUtils.getTimeZoneOffset(l2);
                return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromLocalSeconds(l2), DateTimeUtils.nanosFromLocalSeconds(l2) + l % 1000000000L);
            }
            case 25: {
                throw this.getDataConversionError(11);
            }
        }
        return ValueTimestamp.parse(this.getString().trim(), castDataProvider);
    }

    private long getLocalTimeNanos(CastDataProvider castDataProvider, boolean bl) {
        ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)this;
        int n = bl ? DateTimeUtils.getTimeZoneOffset(0L) : castDataProvider.currentTimestamp().getTimeZoneOffsetSeconds();
        return DateTimeUtils.normalizeNanosOfDay(valueTimeTimeZone.getNanos() + (long)(valueTimeTimeZone.getTimeZoneOffsetSeconds() - n) * 86400000000000L);
    }

    private ValueTimestampTimeZone convertToTimestampTimeZone(CastDataProvider castDataProvider, boolean bl) {
        switch (this.getValueType()) {
            case 9: {
                return DateTimeUtils.timestampTimeZoneFromLocalDateValueAndNanos(bl ? 1008673L : castDataProvider.currentTimestamp().getDateValue(), ((ValueTime)this).getNanos());
            }
            case 41: {
                ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)this;
                return ValueTimestampTimeZone.fromDateValueAndNanos(bl ? 1008673L : castDataProvider.currentTimestamp().getDateValue(), valueTimeTimeZone.getNanos(), valueTimeTimeZone.getTimeZoneOffsetSeconds());
            }
            case 10: {
                return DateTimeUtils.timestampTimeZoneFromLocalDateValueAndNanos(((ValueDate)this).getDateValue(), 0L);
            }
            case 11: {
                ValueTimestamp valueTimestamp = (ValueTimestamp)this;
                return DateTimeUtils.timestampTimeZoneFromLocalDateValueAndNanos(valueTimestamp.getDateValue(), valueTimestamp.getTimeNanos());
            }
            case 25: {
                throw this.getDataConversionError(24);
            }
        }
        return ValueTimestampTimeZone.parse(this.getString().trim());
    }

    private ValueBytes convertToBytes(CastDataProvider castDataProvider) {
        switch (this.getValueType()) {
            case 15: 
            case 19: 
            case 22: 
            case 40: {
                return ValueBytes.getNoCopy(this.getBytesNoCopy());
            }
            case 20: {
                return ValueBytes.getNoCopy(this.getBytes());
            }
            case 2: {
                return ValueBytes.getNoCopy(new byte[]{this.getByte()});
            }
            case 3: {
                short s = this.getShort();
                return ValueBytes.getNoCopy(new byte[]{(byte)(s >> 8), (byte)s});
            }
            case 4: {
                byte[] byArray = new byte[4];
                Bits.writeInt(byArray, 0, this.getInt());
                return ValueBytes.getNoCopy(byArray);
            }
            case 5: {
                byte[] byArray = new byte[8];
                Bits.writeLong(byArray, 0, this.getLong());
                return ValueBytes.getNoCopy(byArray);
            }
            case 24: 
            case 25: {
                throw this.getDataConversionError(12);
            }
        }
        String string = this.getString();
        return ValueBytes.getNoCopy(castDataProvider != null && castDataProvider.getMode().charToBinaryInUtf8 ? string.getBytes(StandardCharsets.UTF_8) : StringUtils.convertHexToBytes(string.trim()));
    }

    private String convertToString(CastDataProvider castDataProvider) {
        String string = this.getValueType() == 12 && castDataProvider != null && castDataProvider.getMode().charToBinaryInUtf8 ? new String(this.getBytesNoCopy(), StandardCharsets.UTF_8) : this.getString();
        return string;
    }

    private ValueJavaObject convertToJavaObject() {
        switch (this.getValueType()) {
            case 12: 
            case 15: {
                return ValueJavaObject.getNoCopy(null, this.getBytesNoCopy(), this.getDataHandler());
            }
            case 22: {
                return ValueJavaObject.getNoCopy(this.getObject(), null, this.getDataHandler());
            }
            case 24: 
            case 25: {
                throw this.getDataConversionError(19);
            }
        }
        return ValueJavaObject.getNoCopy(null, StringUtils.convertHexToBytes(this.getString().trim()), this.getDataHandler());
    }

    private ValueEnum convertToEnumInternal(ExtTypeInfoEnum extTypeInfoEnum) {
        switch (this.getValueType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return extTypeInfoEnum.getValue(this.getInt());
            }
            case 13: 
            case 14: 
            case 21: {
                return extTypeInfoEnum.getValue(this.getString());
            }
            case 19: {
                Object object = JdbcUtils.deserialize(this.getBytesNoCopy(), this.getDataHandler());
                if (object instanceof String) {
                    return extTypeInfoEnum.getValue((String)object);
                }
                if (!(object instanceof Integer)) break;
                return extTypeInfoEnum.getValue((Integer)object);
            }
        }
        throw this.getDataConversionError(25);
    }

    private ValueLobDb convertToBlob() {
        switch (this.getValueType()) {
            case 12: 
            case 22: 
            case 40: {
                return ValueLobDb.createSmallLob(15, this.getBytesNoCopy());
            }
            case 20: {
                return ValueLobDb.createSmallLob(15, this.getBytes());
            }
            case 24: {
                throw this.getDataConversionError(15);
            }
        }
        return ValueLobDb.createSmallLob(15, StringUtils.convertHexToBytes(this.getString().trim()));
    }

    private ValueLobDb convertToClob() {
        return ValueLobDb.createSmallLob(16, this.getString().getBytes(StandardCharsets.UTF_8));
    }

    private ValueUuid convertToUuid() {
        switch (this.getValueType()) {
            case 12: {
                return ValueUuid.get(this.getBytesNoCopy());
            }
            case 19: {
                Object object = JdbcUtils.deserialize(this.getBytesNoCopy(), this.getDataHandler());
                if (object instanceof UUID) {
                    return ValueUuid.get((UUID)object);
                }
            }
            case 24: {
                throw this.getDataConversionError(20);
            }
        }
        return ValueUuid.get(this.getString());
    }

    private Value convertToGeometry(ExtTypeInfoGeometry extTypeInfoGeometry) {
        ValueGeometry valueGeometry;
        switch (this.getValueType()) {
            case 12: {
                valueGeometry = ValueGeometry.getFromEWKB(this.getBytesNoCopy());
                break;
            }
            case 19: {
                Object object = JdbcUtils.deserialize(this.getBytesNoCopy(), this.getDataHandler());
                if (DataType.isGeometry(object)) {
                    valueGeometry = ValueGeometry.getFromGeometry(object);
                    break;
                }
            }
            case 24: {
                throw this.getDataConversionError(22);
            }
            case 40: {
                Integer n;
                int n2 = 0;
                if (extTypeInfoGeometry != null && (n = extTypeInfoGeometry.getSrid()) != null) {
                    n2 = n;
                }
                try {
                    valueGeometry = ValueGeometry.get(GeoJsonUtils.geoJsonToEwkb(this.getBytesNoCopy(), n2));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw DbException.get(22018, this.getTraceSQL());
                }
            }
            default: {
                valueGeometry = ValueGeometry.get(this.getString());
            }
        }
        return extTypeInfoGeometry != null ? extTypeInfoGeometry.cast(valueGeometry) : valueGeometry;
    }

    private ValueInterval convertToIntervalYearMonth(int n) {
        switch (this.getValueType()) {
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return (ValueInterval)IntervalUtils.parseFormattedInterval(IntervalQualifier.valueOf(n - 26), string).convertTo(n);
                }
                catch (Exception exception) {
                    throw DbException.get(22007, exception, "INTERVAL", string);
                }
            }
            case 26: 
            case 27: 
            case 32: {
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(n - 26), IntervalUtils.intervalToAbsolute((ValueInterval)this));
            }
        }
        throw this.getDataConversionError(n);
    }

    private ValueInterval convertToIntervalDayTime(int n) {
        switch (this.getValueType()) {
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return (ValueInterval)IntervalUtils.parseFormattedInterval(IntervalQualifier.valueOf(n - 26), string).convertTo(n);
                }
                catch (Exception exception) {
                    throw DbException.get(22007, exception, "INTERVAL", string);
                }
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(n - 26), IntervalUtils.intervalToAbsolute((ValueInterval)this));
            }
        }
        throw this.getDataConversionError(n);
    }

    private ValueJson convertToJson() {
        switch (this.getValueType()) {
            case 1: {
                return ValueJson.get(this.getBoolean());
            }
            case 2: 
            case 3: 
            case 4: {
                return ValueJson.get(this.getInt());
            }
            case 5: {
                return ValueJson.get(this.getLong());
            }
            case 6: 
            case 7: 
            case 8: {
                return ValueJson.get(this.getBigDecimal());
            }
            case 12: 
            case 15: {
                return ValueJson.fromJson(this.getBytesNoCopy());
            }
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                return ValueJson.get(this.getString());
            }
            case 22: {
                ValueGeometry valueGeometry = (ValueGeometry)this;
                return ValueJson.getInternal(GeoJsonUtils.ewkbToGeoJson(valueGeometry.getBytesNoCopy(), valueGeometry.getDimensionSystem()));
            }
        }
        throw this.getDataConversionError(40);
    }

    private ValueArray convertToArray() {
        Value[] valueArray;
        switch (this.getValueType()) {
            case 39: {
                valueArray = ((ValueRow)this).getList();
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                valueArray = new Value[]{ValueString.get(this.getString())};
                break;
            }
            default: {
                valueArray = new Value[]{this};
            }
        }
        return ValueArray.get(valueArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value convertToRow() {
        Value[] valueArray;
        if (this.getValueType() == 18) {
            ResultInterface resultInterface = ((ValueResultSet)this).getResult();
            if (!resultInterface.hasNext()) return ValueNull.INSTANCE;
            valueArray = resultInterface.currentRow();
            if (!resultInterface.hasNext()) return ValueRow.get(valueArray);
            throw DbException.get(90053);
        }
        valueArray = new Value[]{this};
        return ValueRow.get(valueArray);
    }

    private ValueResultSet convertToResultSet() {
        SimpleResult simpleResult = new SimpleResult();
        if (this.getValueType() == 39) {
            Value[] valueArray = ((ValueRow)this).getList();
            int n = 0;
            while (n < valueArray.length) {
                Value value = valueArray[n++];
                String string = "C" + n;
                simpleResult.addColumn(string, string, value.getType());
            }
            simpleResult.addRow(valueArray);
        } else {
            simpleResult.addColumn("X", "X", this.getType());
            simpleResult.addRow(this);
        }
        return ValueResultSet.get(simpleResult);
    }

    DbException getDataConversionError(int n) {
        DataType dataType = DataType.getDataType(this.getValueType());
        DataType dataType2 = DataType.getDataType(n);
        throw DbException.get(22018, (dataType != null ? dataType.name : "type=" + this.getValueType()) + " to " + (dataType2 != null ? dataType2.name : "type=" + n));
    }

    public abstract int compareTypeSafe(Value var1, CompareMode var2, CastDataProvider var3);

    public final int compareTo(Value value, CastDataProvider castDataProvider, CompareMode compareMode) {
        int n;
        if (this == value) {
            return 0;
        }
        if (this == ValueNull.INSTANCE) {
            return -1;
        }
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        Value value2 = this;
        int n2 = value2.getValueType();
        if (n2 != (n = value.getValueType()) || n2 == 25) {
            int n3 = Value.getHigherOrder(n2, n);
            if (n3 == 25) {
                ExtTypeInfoEnum extTypeInfoEnum = ExtTypeInfoEnum.getEnumeratorsForBinaryOperation(value2, value);
                value2 = value2.convertToEnum(extTypeInfoEnum);
                value = value.convertToEnum(extTypeInfoEnum);
            } else {
                value2 = value2.convertTo(n3, castDataProvider, true);
                value = value.convertTo(n3, castDataProvider, true);
            }
        }
        return value2.compareTypeSafe(value, compareMode, castDataProvider);
    }

    public int compareWithNull(Value value, boolean bl, CastDataProvider castDataProvider, CompareMode compareMode) {
        int n;
        if (this == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
            return Integer.MIN_VALUE;
        }
        Value value2 = this;
        int n2 = value2.getValueType();
        if (n2 != (n = value.getValueType()) || n2 == 25) {
            int n3 = Value.getHigherOrder(n2, n);
            if (n3 == 25) {
                ExtTypeInfoEnum extTypeInfoEnum = ExtTypeInfoEnum.getEnumeratorsForBinaryOperation(value2, value);
                value2 = value2.convertToEnum(extTypeInfoEnum);
                value = value.convertToEnum(extTypeInfoEnum);
            } else {
                value2 = value2.convertTo(n3, castDataProvider, true);
                value = value.convertTo(n3, castDataProvider, true);
            }
        }
        return value2.compareTypeSafe(value, compareMode, castDataProvider);
    }

    public boolean containsNull() {
        return false;
    }

    public Value convertScale(boolean bl, int n) {
        return this;
    }

    public Value convertPrecision(long l) {
        return this;
    }

    private static byte convertToByte(long l, Object object) {
        if (l > 127L || l < -128L) {
            throw DbException.get(22004, Long.toString(l), Value.getColumnName(object));
        }
        return (byte)l;
    }

    private static short convertToShort(long l, Object object) {
        if (l > 32767L || l < -32768L) {
            throw DbException.get(22004, Long.toString(l), Value.getColumnName(object));
        }
        return (short)l;
    }

    public static int convertToInt(long l, Object object) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw DbException.get(22004, Long.toString(l), Value.getColumnName(object));
        }
        return (int)l;
    }

    private static long convertToLong(double d, Object object) {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw DbException.get(22004, Double.toString(d), Value.getColumnName(object));
        }
        return Math.round(d);
    }

    private static long convertToLong(BigDecimal bigDecimal, Object object) {
        if (bigDecimal.compareTo(MAX_LONG_DECIMAL) > 0 || bigDecimal.compareTo(MIN_LONG_DECIMAL) < 0) {
            throw DbException.get(22004, bigDecimal.toString(), Value.getColumnName(object));
        }
        return bigDecimal.setScale(0, RoundingMode.HALF_UP).longValue();
    }

    private static String getColumnName(Object object) {
        return object == null ? "" : object.toString();
    }

    public Value copy(DataHandler dataHandler, int n) {
        return this;
    }

    public boolean isLinkedToTable() {
        return false;
    }

    public void remove() {
    }

    public boolean checkPrecision(long l) {
        return this.getType().getPrecision() <= l;
    }

    public String getTraceSQL() {
        return this.getSQL(new StringBuilder()).toString();
    }

    public String toString() {
        return this.getTraceSQL();
    }

    protected final DbException getUnsupportedExceptionForOperation(String string) {
        return DbException.getUnsupportedException(DataType.getDataType((int)this.getValueType()).name + " " + string);
    }

    public int getTableId() {
        return 0;
    }

    public byte[] getSmall() {
        return null;
    }

    public Value copyToTemp() {
        return this;
    }

    public Value copyToResult() {
        return this;
    }

    public ResultInterface getResult() {
        SimpleResult simpleResult = new SimpleResult();
        simpleResult.addColumn("X", "X", this.getType());
        simpleResult.addRow(this);
        return simpleResult;
    }

    protected DataHandler getDataHandler() {
        return null;
    }

    static {
        MAX_LONG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
        MIN_LONG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);
    }
}

