/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.util;

import com.craftaro.third_party.org.h2.engine.SysProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public final class MemoryUnmapper {
    private static final boolean ENABLED;
    private static final Object UNSAFE;
    private static final Method INVOKE_CLEANER;

    public static boolean unmap(ByteBuffer byteBuffer) {
        if (!ENABLED) {
            return false;
        }
        try {
            if (INVOKE_CLEANER != null) {
                INVOKE_CLEANER.invoke(UNSAFE, byteBuffer);
                return true;
            }
            Method method = byteBuffer.getClass().getMethod("cleaner", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)byteBuffer, new Object[0]);
            if (object != null) {
                Method method2 = object.getClass().getMethod("clean", new Class[0]);
                method2.invoke(object, new Object[0]);
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private MemoryUnmapper() {
    }

    static {
        boolean bl = SysProperties.NIO_CLEANER_HACK;
        Object object = null;
        Method method = null;
        if (bl) {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field field = clazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                object = field.get(null);
                method = clazz.getMethod("invokeCleaner", ByteBuffer.class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                object = null;
            }
            catch (Throwable throwable) {
                bl = false;
                object = null;
            }
        }
        ENABLED = bl;
        UNSAFE = object;
        INVOKE_CLEANER = method;
    }
}

