/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.table;

import com.craftaro.third_party.org.h2.command.Prepared;
import com.craftaro.third_party.org.h2.command.ddl.CreateTableData;
import com.craftaro.third_party.org.h2.command.dml.AllColumnsForPlan;
import com.craftaro.third_party.org.h2.command.dml.Query;
import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.engine.DbObject;
import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.engine.User;
import com.craftaro.third_party.org.h2.expression.Alias;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.ExpressionColumn;
import com.craftaro.third_party.org.h2.expression.ExpressionVisitor;
import com.craftaro.third_party.org.h2.expression.Parameter;
import com.craftaro.third_party.org.h2.index.Index;
import com.craftaro.third_party.org.h2.index.IndexType;
import com.craftaro.third_party.org.h2.index.ViewIndex;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.result.ResultInterface;
import com.craftaro.third_party.org.h2.result.Row;
import com.craftaro.third_party.org.h2.result.SortOrder;
import com.craftaro.third_party.org.h2.schema.Schema;
import com.craftaro.third_party.org.h2.schema.SchemaObject;
import com.craftaro.third_party.org.h2.table.Column;
import com.craftaro.third_party.org.h2.table.IndexColumn;
import com.craftaro.third_party.org.h2.table.PlanItem;
import com.craftaro.third_party.org.h2.table.Table;
import com.craftaro.third_party.org.h2.table.TableFilter;
import com.craftaro.third_party.org.h2.table.TableType;
import com.craftaro.third_party.org.h2.util.ColumnNamer;
import com.craftaro.third_party.org.h2.util.StringUtils;
import com.craftaro.third_party.org.h2.util.Utils;
import com.craftaro.third_party.org.h2.value.TypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TableView
extends Table {
    private static final long ROW_COUNT_APPROXIMATION = 100L;
    private String querySQL;
    private ArrayList<Table> tables;
    private Column[] columnTemplates;
    private Query viewQuery;
    private ViewIndex index;
    private boolean allowRecursive;
    private DbException createException;
    private long lastModificationCheck;
    private long maxDataModificationId;
    private User owner;
    private Query topQuery;
    private ResultInterface recursiveResult;
    private boolean isRecursiveQueryDetected;
    private boolean isTableExpression;

    public TableView(Schema schema, int n, String string, String string2, ArrayList<Parameter> arrayList, Column[] columnArray, Session session, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(schema, n, string, false, true);
        this.setTemporary(bl4);
        this.init(string2, arrayList, columnArray, session, bl, bl2, bl3);
    }

    public void replace(String string, Column[] columnArray, Session session, boolean bl, boolean bl2, boolean bl3) {
        String string2 = this.querySQL;
        Column[] columnArray2 = this.columnTemplates;
        boolean bl4 = this.allowRecursive;
        this.init(string, null, columnArray, session, bl, bl3, this.isTableExpression);
        DbException dbException = this.recompile(session, bl2, true);
        if (dbException != null) {
            this.init(string2, null, columnArray2, session, bl4, bl3, this.isTableExpression);
            this.recompile(session, true, false);
            throw dbException;
        }
    }

    private synchronized void init(String string, ArrayList<Parameter> arrayList, Column[] columnArray, Session session, boolean bl, boolean bl2, boolean bl3) {
        this.querySQL = string;
        this.columnTemplates = columnArray;
        this.allowRecursive = bl;
        this.isRecursiveQueryDetected = false;
        this.isTableExpression = bl3;
        this.index = new ViewIndex(this, string, arrayList, bl);
        this.initColumnsAndTables(session, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query compileViewQuery(Session session, String string, boolean bl, String string2) {
        Prepared prepared;
        session.setParsingCreateView(true, string2);
        try {
            prepared = session.prepare(string, false, bl);
        }
        finally {
            session.setParsingCreateView(false, string2);
        }
        if (!(prepared instanceof Query)) {
            throw DbException.getSyntaxError(string, 0);
        }
        Query query = (Query)prepared;
        if (this.isTableExpression && this.allowRecursive) {
            query.setNeverLazy(true);
        }
        return query;
    }

    public synchronized DbException recompile(Session session, boolean bl, boolean bl2) {
        block4: {
            try {
                this.compileViewQuery(session, this.querySQL, false, this.getName());
            }
            catch (DbException dbException) {
                if (bl) break block4;
                return dbException;
            }
        }
        ArrayList<TableView> arrayList = new ArrayList<TableView>(this.getDependentViews());
        this.initColumnsAndTables(session, false);
        for (TableView tableView : arrayList) {
            DbException dbException = tableView.recompile(session, bl, false);
            if (dbException == null || bl) continue;
            return dbException;
        }
        if (bl2) {
            TableView.clearIndexCaches(this.database);
        }
        return bl ? null : this.createException;
    }

    private void initColumnsAndTables(Session session, boolean bl) {
        Column[] columnArray;
        block13: {
            this.removeCurrentViewFromOtherTables();
            this.setTableExpression(this.isTableExpression);
            try {
                Query query = this.compileViewQuery(session, this.querySQL, bl, this.getName());
                this.querySQL = query.getPlanSQL(true);
                this.tables = new ArrayList<Table>(query.getTables());
                ArrayList<Expression> arrayList = query.getExpressions();
                ColumnNamer columnNamer = new ColumnNamer(session);
                int n = query.getColumnCount();
                ArrayList<Column> arrayList2 = new ArrayList<Column>(n);
                for (int i = 0; i < n; ++i) {
                    Expression expression;
                    Expression expression2 = arrayList.get(i);
                    String string = null;
                    TypeInfo typeInfo = TypeInfo.TYPE_UNKNOWN;
                    if (this.columnTemplates != null && this.columnTemplates.length > i) {
                        string = this.columnTemplates[i].getName();
                        typeInfo = this.columnTemplates[i].getType();
                    }
                    if (string == null) {
                        string = expression2.getAlias();
                    }
                    string = columnNamer.getColumnName(expression2, i, string);
                    if (typeInfo.getValueType() == -1) {
                        typeInfo = expression2.getType();
                    }
                    Column column = new Column(string, typeInfo);
                    column.setTable(this, i);
                    ExpressionColumn expressionColumn = null;
                    if (expression2 instanceof ExpressionColumn) {
                        expressionColumn = (ExpressionColumn)expression2;
                    } else if (expression2 instanceof Alias && (expression = expression2.getNonAliasExpression()) instanceof ExpressionColumn) {
                        expressionColumn = (ExpressionColumn)expression;
                    }
                    if (expressionColumn != null && (expression = expressionColumn.getColumn().getCheckConstraint(session, string)) != null) {
                        column.addCheckConstraint(session, expression);
                    }
                    arrayList2.add(column);
                }
                columnArray = arrayList2.toArray(new Column[0]);
                this.createException = null;
                this.viewQuery = query;
            }
            catch (DbException dbException) {
                dbException.addSQL(this.getCreateSQL());
                this.createException = dbException;
                if (this.isRecursiveQueryExceptionDetected(this.createException)) {
                    this.isRecursiveQueryDetected = true;
                }
                this.tables = Utils.newSmallArrayList();
                columnArray = new Column[]{};
                if (!this.allowRecursive || this.columnTemplates == null) break block13;
                columnArray = new Column[this.columnTemplates.length];
                for (int i = 0; i < this.columnTemplates.length; ++i) {
                    columnArray[i] = this.columnTemplates[i].getClone();
                }
                this.index.setRecursive(true);
                this.createException = null;
            }
        }
        this.setColumns(columnArray);
        if (this.getId() != 0) {
            this.addDependentViewToTables();
        }
    }

    @Override
    public boolean isView() {
        return true;
    }

    public boolean isInvalid() {
        return this.createException != null;
    }

    @Override
    public PlanItem getBestPlanItem(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        CacheKey cacheKey = new CacheKey(nArray, this);
        Map<Object, ViewIndex> map = session.getViewIndexCache(this.topQuery != null);
        ViewIndex viewIndex = map.get(cacheKey);
        if (viewIndex == null || viewIndex.isExpired()) {
            viewIndex = new ViewIndex(this, this.index, session, nArray, tableFilterArray, n, sortOrder);
            map.put(cacheKey, viewIndex);
        }
        PlanItem planItem = new PlanItem();
        planItem.cost = viewIndex.getCost(session, nArray, tableFilterArray, n, sortOrder, allColumnsForPlan);
        planItem.setIndex(viewIndex);
        return planItem;
    }

    @Override
    public boolean isQueryComparable() {
        if (!super.isQueryComparable()) {
            return false;
        }
        for (Table table : this.tables) {
            if (table.isQueryComparable()) continue;
            return false;
        }
        return this.topQuery == null || this.topQuery.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR);
    }

    public Query getTopQuery() {
        return this.topQuery;
    }

    @Override
    public String getDropSQL() {
        return "DROP VIEW IF EXISTS " + this.getSQL(true) + " CASCADE";
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQL(false, true, string);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean bl, boolean bl2) {
        return this.getCreateSQL(bl, bl2, this.getSQL(true));
    }

    private String getCreateSQL(boolean bl, boolean bl2, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        if (bl) {
            stringBuilder.append("OR REPLACE ");
        }
        if (bl2) {
            stringBuilder.append("FORCE ");
        }
        stringBuilder.append("VIEW ");
        if (this.isTableExpression) {
            stringBuilder.append("TABLE_EXPRESSION ");
        }
        stringBuilder.append(string);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        if (this.columns != null && this.columns.length > 0) {
            stringBuilder.append('(');
            Column.writeColumns(stringBuilder, this.columns, true);
            stringBuilder.append(')');
        } else if (this.columnTemplates != null) {
            stringBuilder.append('(');
            Column.writeColumns(stringBuilder, this.columnTemplates, true);
            stringBuilder.append(')');
        }
        return stringBuilder.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public TableType getTableType() {
        return TableType.VIEW;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.removeCurrentViewFromOtherTables();
        super.removeChildrenAndResources(session);
        this.database.removeMeta(session, this.getId());
        this.querySQL = null;
        this.index = null;
        TableView.clearIndexCaches(this.database);
        this.invalidate();
    }

    public static void clearIndexCaches(Database database) {
        for (Session session : database.getSessions(true)) {
            session.clearViewIndexCache();
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        if (this.isTemporary() && this.querySQL != null) {
            stringBuilder.append("(\n");
            return StringUtils.indent(stringBuilder, this.querySQL, 4, true).append(')');
        }
        return super.getSQL(stringBuilder, bl);
    }

    public String getQuery() {
        return this.querySQL;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.getBestPlanItem(session, null, null, -1, null, null).getIndex();
    }

    @Override
    public Index getScanIndex(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        if (this.createException != null) {
            String string = this.createException.getMessage();
            throw DbException.get(90109, this.createException, this.getSQL(false), string);
        }
        PlanItem planItem = this.getBestPlanItem(session, nArray, tableFilterArray, n, sortOrder, allColumnsForPlan);
        return planItem.getIndex();
    }

    @Override
    public boolean canReference() {
        return false;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null) {
            return Long.MAX_VALUE;
        }
        if (this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        long l = this.database.getModificationDataId();
        if (l > this.lastModificationCheck && this.maxDataModificationId <= l) {
            this.maxDataModificationId = this.viewQuery.getMaxDataModificationId();
            this.lastModificationCheck = l;
        }
        return this.maxDataModificationId;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    private void removeCurrentViewFromOtherTables() {
        if (this.tables != null) {
            for (Table table : this.tables) {
                table.removeDependentView(this);
            }
            this.tables.clear();
        }
    }

    private void addDependentViewToTables() {
        for (Table table : this.tables) {
            table.addDependentView(this);
        }
    }

    private void setOwner(User user) {
        this.owner = user;
    }

    public User getOwner() {
        return this.owner;
    }

    public static TableView createTempView(Session session, User user, String string, Query query, Query query2) {
        Schema schema = session.getDatabase().getMainSchema();
        String string2 = query.getPlanSQL(true);
        TableView tableView = new TableView(schema, 0, string, string2, query.getParameters(), null, session, false, true, false, true);
        if (tableView.createException != null) {
            throw tableView.createException;
        }
        tableView.setTopQuery(query2);
        tableView.setOwner(user);
        tableView.setTemporary(true);
        return tableView;
    }

    private void setTopQuery(Query query) {
        this.topQuery = query;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public int getParameterOffset(ArrayList<Parameter> arrayList) {
        int n;
        int n2 = n = this.topQuery == null ? -1 : TableView.getMaxParameterIndex(this.topQuery.getParameters());
        if (arrayList != null) {
            n = Math.max(n, TableView.getMaxParameterIndex(arrayList));
        }
        return n + 1;
    }

    private static int getMaxParameterIndex(ArrayList<Parameter> arrayList) {
        int n = -1;
        for (Parameter parameter : arrayList) {
            n = Math.max(n, parameter.getIndex());
        }
        return n;
    }

    public boolean isRecursive() {
        return this.allowRecursive;
    }

    @Override
    public boolean isDeterministic() {
        if (this.allowRecursive || this.viewQuery == null) {
            return false;
        }
        return this.viewQuery.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR);
    }

    public void setRecursiveResult(ResultInterface resultInterface) {
        if (this.recursiveResult != null) {
            this.recursiveResult.close();
        }
        this.recursiveResult = resultInterface;
    }

    public ResultInterface getRecursiveResult() {
        return this.recursiveResult;
    }

    @Override
    public void addDependencies(HashSet<DbObject> hashSet) {
        super.addDependencies(hashSet);
        if (this.tables != null) {
            for (Table table : this.tables) {
                if (TableType.VIEW == table.getTableType()) continue;
                table.addDependencies(hashSet);
            }
        }
    }

    public boolean isRecursiveQueryDetected() {
        return this.isRecursiveQueryDetected;
    }

    private boolean isRecursiveQueryExceptionDetected(DbException dbException) {
        if (dbException == null) {
            return false;
        }
        if (dbException.getErrorCode() != 42102) {
            return false;
        }
        return dbException.getMessage().contains("\"" + this.getName() + "\"");
    }

    public List<Table> getTables() {
        return this.tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableView createTableViewMaybeRecursive(Schema schema, int n, String string, String string2, ArrayList<Parameter> arrayList, Column[] columnArray, Session session, boolean bl, boolean bl2, boolean bl3, Database database) {
        List<Column> list;
        Object object;
        Table table = TableView.createShadowTableForRecursiveTableExpression(bl3, session, string, schema, Arrays.asList(columnArray), database);
        String[] stringArray = new String[]{null};
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Column column : columnArray) {
            arrayList2.add(column.getName());
        }
        try {
            object = session.prepare(string2, false, false);
            if (!bl3) {
                ((Prepared)object).setSession(session);
            }
            list = TableView.createQueryColumnTemplateList(arrayList2.toArray(new String[1]), (Query)object, stringArray);
        }
        finally {
            TableView.destroyShadowTableForRecursiveExpression(bl3, session, table);
        }
        object = new TableView(schema, n, string, string2, arrayList, list.toArray(columnArray), session, true, bl, bl2, bl3);
        if (!((TableView)object).isRecursiveQueryDetected()) {
            if (!bl3) {
                database.addSchemaObject(session, (SchemaObject)object);
                ((TableView)object).lock(session, true, true);
                session.getDatabase().removeSchemaObject(session, (SchemaObject)object);
                ((TableView)object).removeChildrenAndResources(session);
            } else {
                session.removeLocalTempTable((Table)object);
            }
            object = new TableView(schema, n, string, string2, arrayList, columnArray, session, false, bl, bl2, bl3);
        }
        return object;
    }

    public static List<Column> createQueryColumnTemplateList(String[] stringArray, Query query, String[] stringArray2) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        query.prepare();
        stringArray2[0] = StringUtils.cache(query.getPlanSQL(true));
        ColumnNamer columnNamer = new ColumnNamer(query.getSession());
        ArrayList<Expression> arrayList2 = query.getExpressions();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Expression expression = arrayList2.get(i);
            String string = columnNamer.getColumnName(expression, i, stringArray);
            arrayList.add(new Column(string, expression.getType()));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table createShadowTableForRecursiveTableExpression(boolean bl, Session session, String string, Schema schema, List<Column> list, Database database) {
        CreateTableData createTableData = new CreateTableData();
        createTableData.id = database.allocateObjectId();
        createTableData.columns = new ArrayList<Column>(list);
        createTableData.tableName = string;
        createTableData.temporary = bl;
        createTableData.persistData = true;
        createTableData.persistIndexes = !bl;
        createTableData.create = true;
        createTableData.session = session;
        Table table = schema.createTable(createTableData);
        if (!bl) {
            database.unlockMeta(session);
            Session session2 = session;
            synchronized (session2) {
                database.addSchemaObject(session, table);
            }
        } else {
            session.addLocalTempTable(table);
        }
        return table;
    }

    public static void destroyShadowTableForRecursiveExpression(boolean bl, Session session, Table table) {
        if (table != null) {
            if (!bl) {
                table.lock(session, true, true);
                session.getDatabase().removeSchemaObject(session, table);
            } else {
                session.removeLocalTempTable(table);
            }
            session.getDatabase().unlockMeta(session);
        }
    }

    private static final class CacheKey {
        private final int[] masks;
        private final TableView view;

        CacheKey(int[] nArray, TableView tableView) {
            this.masks = nArray;
            this.view = tableView;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + Arrays.hashCode(this.masks);
            n = 31 * n + this.view.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.view != cacheKey.view) {
                return false;
            }
            return Arrays.equals(this.masks, cacheKey.masks);
        }
    }
}

