/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.mvstore.db;

import com.craftaro.third_party.org.h2.command.dml.AllColumnsForPlan;
import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.index.BaseIndex;
import com.craftaro.third_party.org.h2.index.Cursor;
import com.craftaro.third_party.org.h2.index.IndexType;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.mvstore.MVMap;
import com.craftaro.third_party.org.h2.mvstore.MVStore;
import com.craftaro.third_party.org.h2.mvstore.db.MVIndex;
import com.craftaro.third_party.org.h2.mvstore.db.MVTable;
import com.craftaro.third_party.org.h2.mvstore.db.ValueDataType;
import com.craftaro.third_party.org.h2.mvstore.tx.Transaction;
import com.craftaro.third_party.org.h2.mvstore.tx.TransactionMap;
import com.craftaro.third_party.org.h2.result.Row;
import com.craftaro.third_party.org.h2.result.SearchRow;
import com.craftaro.third_party.org.h2.result.SortOrder;
import com.craftaro.third_party.org.h2.table.Column;
import com.craftaro.third_party.org.h2.table.IndexColumn;
import com.craftaro.third_party.org.h2.table.TableFilter;
import com.craftaro.third_party.org.h2.value.CompareMode;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueArray;
import com.craftaro.third_party.org.h2.value.ValueLong;
import com.craftaro.third_party.org.h2.value.ValueNull;
import com.craftaro.third_party.org.h2.value.VersionedValue;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public final class MVSecondaryIndex
extends BaseIndex
implements MVIndex {
    final MVTable mvTable;
    private final int keyColumns;
    private final TransactionMap<Value, Value> dataMap;

    public MVSecondaryIndex(Database database, MVTable mVTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(mVTable, n, string, indexColumnArray, indexType);
        this.mvTable = mVTable;
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(indexColumnArray);
        }
        this.keyColumns = indexColumnArray.length + 1;
        String string2 = "index." + this.getId();
        assert (database.isStarting() || !database.getStore().getMvStore().getMetaMap().containsKey("name." + string2));
        int[] nArray = new int[this.keyColumns];
        for (int i = 0; i < indexColumnArray.length; ++i) {
            nArray[i] = indexColumnArray[i].sortType;
        }
        nArray[this.keyColumns - 1] = 0;
        ValueDataType valueDataType = new ValueDataType(database, nArray);
        ValueDataType valueDataType2 = new ValueDataType();
        Transaction transaction = this.mvTable.getTransactionBegin();
        this.dataMap = transaction.openMap(string2, valueDataType, valueDataType2);
        this.dataMap.map.setVolatile(!mVTable.isPersistData() || !indexType.isPersistent());
        transaction.commit();
        if (!valueDataType.equals(this.dataMap.getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type, expected " + valueDataType + " but got " + this.dataMap.getKeyType() + " for index " + string);
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        MVMap<ValueArray, Value> mVMap = this.openMap(string);
        for (Row row : list) {
            ValueArray valueArray = this.convertToKey(row, null);
            mVMap.append(valueArray, ValueNull.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBufferedRows(List<String> list) {
        Object object;
        int n = list.size();
        PriorityQueue<Source> priorityQueue = new PriorityQueue<Source>(n, new Source.Comparator(this.database, this.database.getCompareMode()));
        for (String object2 : list) {
            Iterator<Object> iterator = this.openMap(object2).keyIterator(null);
            if (!iterator.hasNext()) continue;
            priorityQueue.offer(new Source(iterator));
        }
        try {
            while (!priorityQueue.isEmpty()) {
                object = (Source)priorityQueue.poll();
                ValueArray valueArray = ((Source)object).next();
                SearchRow searchRow = this.convertToSearchRow(valueArray);
                if (this.indexType.isUnique() && !this.mayHaveNullDuplicates(searchRow)) {
                    this.checkUnique(this.dataMap, valueArray, Long.MIN_VALUE);
                }
                this.dataMap.putCommitted(valueArray, ValueNull.INSTANCE);
                if (!((Source)object).hasNext()) continue;
                priorityQueue.offer((Source)object);
            }
        }
        finally {
            object = this.database.getStore().getMvStore();
            for (String string : list) {
                ((MVStore)object).removeMap(string);
            }
        }
    }

    private MVMap<ValueArray, Value> openMap(String string) {
        int[] nArray = new int[this.keyColumns];
        for (int i = 0; i < this.indexColumns.length; ++i) {
            nArray[i] = this.indexColumns[i].sortType;
        }
        nArray[this.keyColumns - 1] = 0;
        ValueDataType valueDataType = new ValueDataType(this.database, nArray);
        ValueDataType valueDataType2 = new ValueDataType();
        MVMap.BasicBuilder basicBuilder = ((MVMap.Builder)new MVMap.Builder().singleWriter().keyType(valueDataType)).valueType(valueDataType2);
        Object m = this.database.getStore().getMvStore().openMap(string, basicBuilder);
        if (!valueDataType.equals(((MVMap)m).getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type, expected " + valueDataType + " but got " + ((MVMap)m).getKeyType() + " for map " + string);
        }
        return m;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        boolean bl;
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        ValueArray valueArray = this.convertToKey(row, null);
        boolean bl2 = bl = this.indexType.isUnique() && !this.mayHaveNullDuplicates(row);
        if (bl) {
            this.checkUnique(transactionMap, valueArray, Long.MIN_VALUE);
        }
        try {
            transactionMap.put(valueArray, ValueNull.INSTANCE);
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
        if (bl) {
            this.checkUnique(transactionMap, valueArray, row.getKey());
        }
    }

    private void checkUnique(TransactionMap<Value, Value> transactionMap, ValueArray valueArray, long l) {
        Iterator<Value> iterator = transactionMap.keyIteratorUncommitted(MVSecondaryIndex.convertToKey(valueArray, ValueLong.MIN), MVSecondaryIndex.convertToKey(valueArray, ValueLong.MAX));
        while (iterator.hasNext()) {
            ValueArray valueArray2 = (ValueArray)iterator.next();
            Value[] valueArray3 = valueArray2.getList();
            Value value = valueArray3[valueArray3.length - 1];
            long l2 = value.getLong();
            if (l == l2) continue;
            if (transactionMap.getImmediate(valueArray2) != null) {
                throw this.getDuplicateKeyException(value.toString());
            }
            throw DbException.get(90131, this.table.getName());
        }
    }

    @Override
    public void remove(Session session, Row row) {
        ValueArray valueArray = this.convertToKey(row, null);
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        try {
            Value value = transactionMap.remove(valueArray);
            if (value == null) {
                StringBuilder stringBuilder = new StringBuilder();
                this.getSQL(stringBuilder, false).append(": ").append(row.getKey());
                throw DbException.get(90112, stringBuilder.toString());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
    }

    @Override
    public void update(Session session, Row row, Row row2) {
        if (!this.rowsAreEqual(row, row2)) {
            super.update(session, row, row2);
        }
    }

    private boolean rowsAreEqual(SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == searchRow2) {
            return true;
        }
        for (int n : this.columnIds) {
            Value value = searchRow.getValue(n);
            Value value2 = searchRow2.getValue(n);
            if (!(value == null ? value2 != null : !value.equals(value2))) continue;
            return false;
        }
        return searchRow.getKey() == searchRow2.getKey();
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, false, searchRow2);
    }

    private Cursor find(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) {
        ValueArray valueArray = this.convertToKey(searchRow, bl ? ValueLong.MAX : ValueLong.MIN);
        ValueArray valueArray2 = this.convertToKey(searchRow2, ValueLong.MAX);
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return new MVStoreCursor(session, transactionMap.keyIterator(valueArray, valueArray2));
    }

    private static ValueArray convertToKey(ValueArray valueArray, ValueLong valueLong) {
        Value[] valueArray2 = (Value[])valueArray.getList().clone();
        valueArray2[valueArray2.length - 1] = valueLong;
        return ValueArray.get(valueArray2);
    }

    private ValueArray convertToKey(SearchRow searchRow, ValueLong valueLong) {
        if (searchRow == null) {
            return null;
        }
        Value[] valueArray = new Value[this.keyColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int n = column.getColumnId();
            Value value = searchRow.getValue(n);
            if (value == null) continue;
            valueArray[i] = value.convertTo(column.getType(), this.database, true, null);
        }
        valueArray[this.keyColumns - 1] = valueLong != null ? valueLong : ValueLong.get(searchRow.getKey());
        return ValueArray.get(valueArray);
    }

    SearchRow convertToSearchRow(ValueArray valueArray) {
        Value[] valueArray2 = valueArray.getList();
        Row row = this.mvTable.getTemplateRow();
        row.setKey(valueArray2[valueArray2.length - 1].getLong());
        Column[] columnArray = this.getColumns();
        for (int i = 0; i < valueArray2.length - 1; ++i) {
            Column column = columnArray[i];
            int n = column.getColumnId();
            Value value = valueArray2[i];
            row.setValue(n, value);
        }
        return row;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        try {
            return 10L * this.getCostRangeIndex(nArray, this.dataMap.sizeAsLongMax(), tableFilterArray, n, sortOrder, false, allColumnsForPlan);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public void remove(Session session) {
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            Transaction transaction = session.getTransaction();
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        transactionMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        Value value;
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        Value value2 = value = bl ? transactionMap.firstKey() : transactionMap.lastKey();
        while (true) {
            if (value == null) {
                return new MVStoreCursor(session, Collections.emptyIterator());
            }
            if (((ValueArray)value).getList()[0] != ValueNull.INSTANCE) break;
            value = bl ? transactionMap.higherKey(value) : transactionMap.lowerKey(value);
        }
        MVStoreCursor mVStoreCursor = new MVStoreCursor(session, Collections.singletonList(value).iterator());
        mVStoreCursor.next();
        return mVStoreCursor;
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return transactionMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, true, searchRow2);
    }

    @Override
    public void checkRename() {
    }

    private TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction transaction = session.getTransaction();
        return this.dataMap.getInstance(transaction);
    }

    public MVMap<Value, VersionedValue> getMVMap() {
        return this.dataMap.map;
    }

    final class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Value> it;
        private ValueArray current;
        private Row row;

        MVStoreCursor(Session session, Iterator<Value> iterator) {
            this.session = session;
            this.it = iterator;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                Value[] valueArray = this.current.getList();
                this.row = MVSecondaryIndex.this.mvTable.getRow(this.session, valueArray[valueArray.length - 1].getLong());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.current == null ? null : MVSecondaryIndex.this.convertToSearchRow(this.current);
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? (ValueArray)this.it.next() : null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }

    private static final class Source {
        private final Iterator<ValueArray> iterator;
        ValueArray currentRowData;

        public Source(Iterator<ValueArray> iterator) {
            this.iterator = iterator;
            this.currentRowData = iterator.next();
        }

        public boolean hasNext() {
            boolean bl = this.iterator.hasNext();
            if (bl) {
                this.currentRowData = this.iterator.next();
            }
            return bl;
        }

        public ValueArray next() {
            return this.currentRowData;
        }

        public static final class Comparator
        implements java.util.Comparator<Source> {
            private final Database database;
            private final CompareMode compareMode;

            public Comparator(Database database, CompareMode compareMode) {
                this.database = database;
                this.compareMode = compareMode;
            }

            @Override
            public int compare(Source source, Source source2) {
                return source.currentRowData.compareTo(source2.currentRowData, this.database, this.compareMode);
            }
        }
    }
}

