/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.expression.condition;

import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.ExpressionVisitor;
import com.craftaro.third_party.org.h2.expression.ValueExpression;
import com.craftaro.third_party.org.h2.expression.condition.Comparison;
import com.craftaro.third_party.org.h2.expression.condition.Condition;
import com.craftaro.third_party.org.h2.expression.condition.ConditionIn;
import com.craftaro.third_party.org.h2.expression.condition.ConditionInConstantSet;
import com.craftaro.third_party.org.h2.expression.condition.ConditionNot;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.table.ColumnResolver;
import com.craftaro.third_party.org.h2.table.TableFilter;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueBoolean;
import com.craftaro.third_party.org.h2.value.ValueNull;

public class ConditionAndOr
extends Condition {
    public static final int AND = 0;
    public static final int OR = 1;
    private final int andOrType;
    private Expression left;
    private Expression right;
    private Expression added;

    public ConditionAndOr(int n, Expression expression, Expression expression2) {
        if (expression == null || expression2 == null) {
            DbException.throwInternalError(expression + " " + expression2);
        }
        this.andOrType = n;
        this.left = expression;
        this.right = expression2;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl);
        switch (this.andOrType) {
            case 0: {
                stringBuilder.append("\n    AND ");
                break;
            }
            case 1: {
                stringBuilder.append("\n    OR ");
                break;
            }
            default: {
                throw DbException.throwInternalError("andOrType=" + this.andOrType);
            }
        }
        return this.right.getSQL(stringBuilder, bl).append(')');
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (this.andOrType == 0) {
            this.left.createIndexConditions(session, tableFilter);
            this.right.createIndexConditions(session, tableFilter);
            if (this.added != null) {
                this.added.createIndexConditions(session, tableFilter);
            }
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        Expression expression;
        Expression expression2 = this.left.getNotIfPossible(session);
        if (expression2 == null) {
            expression2 = new ConditionNot(this.left);
        }
        if ((expression = this.right.getNotIfPossible(session)) == null) {
            expression = new ConditionNot(this.right);
        }
        int n = this.andOrType == 0 ? 1 : 0;
        return new ConditionAndOr(n, expression2, expression);
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        switch (this.andOrType) {
            case 0: {
                if (value != ValueNull.INSTANCE && !value.getBoolean()) {
                    return ValueBoolean.FALSE;
                }
                Value value2 = this.right.getValue(session);
                if (value2 != ValueNull.INSTANCE && !value2.getBoolean()) {
                    return ValueBoolean.FALSE;
                }
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return ValueBoolean.TRUE;
            }
            case 1: {
                if (value.getBoolean()) {
                    return ValueBoolean.TRUE;
                }
                Value value3 = this.right.getValue(session);
                if (value3.getBoolean()) {
                    return ValueBoolean.TRUE;
                }
                if (value == ValueNull.INSTANCE || value3 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return ValueBoolean.FALSE;
            }
        }
        throw DbException.throwInternalError("type=" + this.andOrType);
    }

    @Override
    public Expression optimize(Session session) {
        Expression expression;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        int n = this.left.getCost();
        int n2 = this.right.getCost();
        if (n2 < n) {
            expression = this.left;
            this.left = this.right;
            this.right = expression;
        }
        switch (this.andOrType) {
            case 0: {
                if (!session.getDatabase().getSettings().optimizeTwoEquals || !(this.left instanceof Comparison) || !(this.right instanceof Comparison) || (expression = ((Comparison)this.left).getAdditionalAnd(session, (Comparison)this.right)) == null) break;
                this.added = expression.optimize(session);
                break;
            }
            case 1: {
                if (!session.getDatabase().getSettings().optimizeOr) break;
                if (this.left instanceof Comparison && this.right instanceof Comparison) {
                    expression = ((Comparison)this.left).optimizeOr(session, (Comparison)this.right);
                } else if (this.left instanceof ConditionIn && this.right instanceof Comparison) {
                    expression = ((ConditionIn)this.left).getAdditional((Comparison)this.right);
                } else if (this.right instanceof ConditionIn && this.left instanceof Comparison) {
                    expression = ((ConditionIn)this.right).getAdditional((Comparison)this.left);
                } else if (this.left instanceof ConditionInConstantSet && this.right instanceof Comparison) {
                    expression = ((ConditionInConstantSet)this.left).getAdditional(session, (Comparison)this.right);
                } else if (this.right instanceof ConditionInConstantSet && this.left instanceof Comparison) {
                    expression = ((ConditionInConstantSet)this.right).getAdditional(session, (Comparison)this.left);
                } else {
                    if (!(this.left instanceof ConditionAndOr) || !(this.right instanceof ConditionAndOr)) break;
                    expression = ConditionAndOr.optimizeConditionAndOr((ConditionAndOr)this.left, (ConditionAndOr)this.right);
                }
                if (expression == null) break;
                return expression.optimize(session);
            }
        }
        return ConditionAndOr.optimizeConstant(session, this, this.andOrType, this.left, this.right);
    }

    static Expression optimizeConstant(Session session, Expression expression, int n, Expression expression2, Expression expression3) {
        Value value;
        Value value2 = expression2.isConstant() ? expression2.getValue(session) : null;
        Value value3 = value = expression3.isConstant() ? expression3.getValue(session) : null;
        if (value2 == null && value == null) {
            return expression;
        }
        if (value2 != null && value != null) {
            return ValueExpression.getBoolean(expression.getValue(session));
        }
        switch (n) {
            case 0: {
                if (value2 != null) {
                    if (value2 != ValueNull.INSTANCE && !value2.getBoolean()) {
                        return ValueExpression.getBoolean(false);
                    }
                    if (!value2.getBoolean()) break;
                    return ConditionAndOr.castToBoolean(session, expression3);
                }
                if (value == null) break;
                if (value != ValueNull.INSTANCE && !value.getBoolean()) {
                    return ValueExpression.getBoolean(false);
                }
                if (!value.getBoolean()) break;
                return ConditionAndOr.castToBoolean(session, expression2);
            }
            case 1: {
                if (value2 != null) {
                    if (value2.getBoolean()) {
                        return ValueExpression.getBoolean(true);
                    }
                    if (value2 == ValueNull.INSTANCE) break;
                    return ConditionAndOr.castToBoolean(session, expression3);
                }
                if (value == null) break;
                if (value.getBoolean()) {
                    return ValueExpression.getBoolean(true);
                }
                if (value == ValueNull.INSTANCE) break;
                return ConditionAndOr.castToBoolean(session, expression2);
            }
            default: {
                DbException.throwInternalError("type=" + n);
            }
        }
        return expression;
    }

    @Override
    public void addFilterConditions(TableFilter tableFilter) {
        if (this.andOrType == 0) {
            this.left.addFilterConditions(tableFilter);
            this.right.addFilterConditions(tableFilter);
        } else {
            super.addFilterConditions(tableFilter);
        }
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        this.right.mapColumns(columnResolver, n, n2);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private static Expression optimizeConditionAndOr(ConditionAndOr conditionAndOr, ConditionAndOr conditionAndOr2) {
        String string;
        if (conditionAndOr.andOrType != 0 || conditionAndOr2.andOrType != 0) {
            return null;
        }
        Expression expression = conditionAndOr.getSubexpression(0);
        Expression expression2 = conditionAndOr.getSubexpression(1);
        Expression expression3 = conditionAndOr2.getSubexpression(0);
        Expression expression4 = conditionAndOr2.getSubexpression(1);
        String string2 = expression.getSQL(true);
        if (string2.equals(string = expression3.getSQL(true))) {
            ConditionAndOr conditionAndOr3 = new ConditionAndOr(1, expression2, expression4);
            return new ConditionAndOr(0, expression, conditionAndOr3);
        }
        String string3 = expression4.getSQL(true);
        if (string2.equals(string3)) {
            ConditionAndOr conditionAndOr4 = new ConditionAndOr(1, expression2, expression3);
            return new ConditionAndOr(0, expression, conditionAndOr4);
        }
        String string4 = expression2.getSQL(true);
        if (string4.equals(string)) {
            ConditionAndOr conditionAndOr5 = new ConditionAndOr(1, expression, expression4);
            return new ConditionAndOr(0, expression2, conditionAndOr5);
        }
        if (string4.equals(string3)) {
            ConditionAndOr conditionAndOr6 = new ConditionAndOr(1, expression, expression3);
            return new ConditionAndOr(0, expression2, conditionAndOr6);
        }
        return null;
    }
}

