/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.engine;

import com.craftaro.third_party.org.h2.command.CommandInterface;
import com.craftaro.third_party.org.h2.engine.ConnectionInfo;
import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.engine.DbSettings;
import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.engine.SessionFactory;
import com.craftaro.third_party.org.h2.engine.SysProperties;
import com.craftaro.third_party.org.h2.engine.User;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.security.auth.AuthenticationException;
import com.craftaro.third_party.org.h2.security.auth.AuthenticationInfo;
import com.craftaro.third_party.org.h2.util.MathUtils;
import com.craftaro.third_party.org.h2.util.ParserUtil;
import com.craftaro.third_party.org.h2.util.ThreadDeadlockDetector;
import com.craftaro.third_party.org.h2.util.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Engine
implements SessionFactory {
    private static final Engine INSTANCE = new Engine();
    private static final Map<String, Database> DATABASES = new HashMap<String, Database>();
    private volatile long wrongPasswordDelay = SysProperties.DELAY_WRONG_PASSWORD_MIN;
    private boolean jmx;

    private Engine() {
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            ThreadDeadlockDetector.init();
        }
    }

    public static Engine getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session openSession(ConnectionInfo connectionInfo, boolean bl, boolean bl2, String string) {
        Object object;
        Database database;
        String string2 = connectionInfo.getName();
        connectionInfo.removeProperty("NO_UPGRADE", false);
        boolean bl3 = connectionInfo.getProperty("OPEN_NEW", false);
        boolean bl4 = false;
        User user = null;
        Object object2 = DATABASES;
        synchronized (object2) {
            database = bl3 || connectionInfo.isUnnamedInMemory() ? null : DATABASES.get(string2);
            if (database == null) {
                boolean bl5;
                object = connectionInfo.getProperty("MV_STORE");
                boolean bl6 = bl5 = object == null ? Database.exists(string2) : Database.exists(string2, Utils.parseBoolean((String)object, true, false));
                if (!bl5) {
                    if (bl) {
                        throw DbException.get(90146, string2);
                    }
                    if (bl2) {
                        throw DbException.get(90149, string2);
                    }
                }
                database = new Database(connectionInfo, string);
                bl4 = true;
                if (database.getAllUsers().isEmpty()) {
                    user = new User(database, database.allocateObjectId(), connectionInfo.getUserName(), false);
                    user.setAdmin(true);
                    user.setUserPasswordHash(connectionInfo.getUserPasswordHash());
                    database.setMasterUser(user);
                }
                if (!connectionInfo.isUnnamedInMemory()) {
                    DATABASES.put(string2, database);
                }
            }
        }
        if (bl4) {
            database.opened();
        }
        if (database.isClosing()) {
            return null;
        }
        if (user == null) {
            if (database.validateFilePasswordHash(string, connectionInfo.getFilePasswordHash())) {
                if (connectionInfo.getProperty("AUTHREALM") == null) {
                    user = database.findUser(connectionInfo.getUserName());
                    if (user != null && !user.validateUserPasswordHash(connectionInfo.getUserPasswordHash())) {
                        user = null;
                    }
                } else {
                    object2 = database.getAuthenticator();
                    if (object2 == null) {
                        throw DbException.get(90144, string2);
                    }
                    try {
                        object = new AuthenticationInfo(connectionInfo);
                        user = database.getAuthenticator().authenticate((AuthenticationInfo)object, database);
                    }
                    catch (AuthenticationException authenticationException) {
                        database.getTrace(2).error(authenticationException, "an error occurred during authentication; user: \"" + connectionInfo.getUserName() + "\"");
                    }
                }
            }
            if (bl4 && (user == null || !user.isAdmin())) {
                database.setEventListener(null);
            }
        }
        if (user == null) {
            object2 = DbException.get(28000);
            database.getTrace(2).error((Throwable)object2, "wrong user or password; user: \"" + connectionInfo.getUserName() + "\"");
            database.removeSession(null);
            throw object2;
        }
        connectionInfo.cleanAuthenticationInfo();
        Engine.checkClustering(connectionInfo, database);
        object2 = database.createSession(user, connectionInfo.getNetworkConnectionInfo());
        if (object2 == null) {
            return null;
        }
        if (connectionInfo.getProperty("JMX", false)) {
            try {
                Utils.callStaticMethod("com.craftaro.third_party.org.h2.jmx.DatabaseInfo.registerMBean", connectionInfo, database);
            }
            catch (Exception exception) {
                database.removeSession((Session)object2);
                throw DbException.get(50100, exception, "JMX");
            }
            this.jmx = true;
        }
        return object2;
    }

    @Override
    public Session createSession(ConnectionInfo connectionInfo) {
        return INSTANCE.createSessionAndValidate(connectionInfo);
    }

    private Session createSessionAndValidate(ConnectionInfo connectionInfo) {
        try {
            Session session = this.openSession(connectionInfo);
            this.validateUserAndPassword(true);
            return session;
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 28000) {
                this.validateUserAndPassword(false);
            }
            throw dbException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Session openSession(ConnectionInfo connectionInfo) {
        Session session;
        boolean bl = connectionInfo.removeProperty("IFEXISTS", false);
        boolean bl2 = connectionInfo.removeProperty("FORBID_CREATION", false);
        boolean bl3 = connectionInfo.removeProperty("IGNORE_UNKNOWN_SETTINGS", false);
        String string = connectionInfo.removeProperty("CIPHER", null);
        String string2 = connectionInfo.removeProperty("INIT", null);
        long l = System.nanoTime();
        while ((session = this.openSession(connectionInfo, bl, bl2, string)) == null) {
            if (System.nanoTime() - l > 60000000000L) {
                throw DbException.get(90020, "Waited for database closing longer than 1 minute");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                throw DbException.get(90121);
            }
        }
        Session session2 = session;
        synchronized (session2) {
            block16: {
                session.setAllowLiterals(true);
                DbSettings dbSettings = DbSettings.getDefaultSettings();
                for (String string3 : connectionInfo.getKeys()) {
                    if (dbSettings.containsKey(string3)) continue;
                    String string4 = connectionInfo.getProperty(string3);
                    if (!ParserUtil.isSimpleIdentifier(string3, false, false)) {
                        throw DbException.get(90113, string3);
                    }
                    try {
                        CommandInterface commandInterface = session.prepareCommand("SET " + string3 + ' ' + string4, Integer.MAX_VALUE);
                        commandInterface.executeUpdate(null);
                    }
                    catch (DbException dbException) {
                        if (dbException.getErrorCode() == 90040) {
                            session.getTrace().error(dbException, "admin rights required; user: \"" + connectionInfo.getUserName() + "\"");
                        } else {
                            session.getTrace().error(dbException, "");
                        }
                        if (bl3) continue;
                        session.close();
                        throw dbException;
                    }
                }
                if (string2 != null) {
                    try {
                        CommandInterface commandInterface = session.prepareCommand(string2, Integer.MAX_VALUE);
                        commandInterface.executeUpdate(null);
                    }
                    catch (DbException dbException) {
                        if (bl3) break block16;
                        session.close();
                        throw dbException;
                    }
                }
            }
            session.setAllowLiterals(false);
            session.commit(true);
        }
        return session;
    }

    private static void checkClustering(ConnectionInfo connectionInfo, Database database) {
        String string = connectionInfo.getProperty(13, null);
        if ("''".equals(string)) {
            return;
        }
        String string2 = database.getCluster();
        if (!("''".equals(string2) || "TRUE".equals(string) || Objects.equals(string, string2))) {
            if (string2.equals("''")) {
                throw DbException.get(90093);
            }
            throw DbException.get(90094, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(String string) {
        if (this.jmx) {
            try {
                Utils.callStaticMethod("com.craftaro.third_party.org.h2.jmx.DatabaseInfo.unregisterMBean", string);
            }
            catch (Exception exception) {
                throw DbException.get(50100, exception, "JMX");
            }
        }
        Map<String, Database> map = DATABASES;
        synchronized (map) {
            DATABASES.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUserAndPassword(boolean bl) {
        int n = SysProperties.DELAY_WRONG_PASSWORD_MIN;
        if (bl) {
            long l = this.wrongPasswordDelay;
            if (l > (long)n && l > 0L) {
                Engine engine = INSTANCE;
                synchronized (engine) {
                    l = MathUtils.secureRandomInt((int)l);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.wrongPasswordDelay = n;
                }
            }
        } else {
            Engine engine = INSTANCE;
            synchronized (engine) {
                long l = this.wrongPasswordDelay;
                int n2 = SysProperties.DELAY_WRONG_PASSWORD_MAX;
                if (n2 <= 0) {
                    n2 = Integer.MAX_VALUE;
                }
                this.wrongPasswordDelay += this.wrongPasswordDelay;
                if (this.wrongPasswordDelay > (long)n2 || this.wrongPasswordDelay < 0L) {
                    this.wrongPasswordDelay = n2;
                }
                if (n > 0) {
                    l += Math.abs(MathUtils.secureRandomLong() % 100L);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw DbException.get(28000);
            }
        }
    }
}

