/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.command.dml;

import com.craftaro.third_party.org.h2.command.dml.Select;
import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.ExpressionColumn;
import com.craftaro.third_party.org.h2.table.Column;
import com.craftaro.third_party.org.h2.table.ColumnResolver;
import com.craftaro.third_party.org.h2.table.TableFilter;
import com.craftaro.third_party.org.h2.util.ColumnNamer;
import com.craftaro.third_party.org.h2.value.Value;
import java.util.ArrayList;

public class SelectListColumnResolver
implements ColumnResolver {
    private final Select select;
    private final Expression[] expressions;
    private final Column[] columns;

    SelectListColumnResolver(Select select) {
        this.select = select;
        int n = select.getColumnCount();
        this.columns = new Column[n];
        this.expressions = new Expression[n];
        ArrayList<Expression> arrayList = select.getExpressions();
        ColumnNamer columnNamer = new ColumnNamer(select.getSession());
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            String string = columnNamer.getColumnName(expression, i, expression.getAlias());
            Column column = new Column(string, 0);
            column.setTable(null, i);
            this.columns[i] = column;
            this.expressions[i] = expression.getNonAliasExpression();
        }
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public Column findColumn(String string) {
        Database database = this.select.getSession().getDatabase();
        for (Column column : this.columns) {
            if (!database.equalsIdentifiers(column.getName(), string)) continue;
            return column;
        }
        return null;
    }

    @Override
    public String getColumnName(Column column) {
        return column.getName();
    }

    @Override
    public boolean hasDerivedColumnList() {
        return false;
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public Select getSelect() {
        return this.select;
    }

    @Override
    public Column[] getSystemColumns() {
        return null;
    }

    @Override
    public Column getRowIdColumn() {
        return null;
    }

    @Override
    public String getTableAlias() {
        return null;
    }

    @Override
    public TableFilter getTableFilter() {
        return null;
    }

    @Override
    public Value getValue(Column column) {
        return null;
    }

    @Override
    public Expression optimize(ExpressionColumn expressionColumn, Column column) {
        return this.expressions[column.getColumnId()];
    }
}

