/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.command.ddl;

import com.craftaro.third_party.org.h2.command.ddl.DefineCommand;
import com.craftaro.third_party.org.h2.constraint.ConstraintActionType;
import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.schema.Schema;
import com.craftaro.third_party.org.h2.schema.SchemaObject;
import java.util.ArrayList;

public class DropSchema
extends DefineCommand {
    private String schemaName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropSchema(Session session) {
        super(session);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    @Override
    public int update() {
        this.session.getUser().checkSchemaAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Schema schema = database.findSchema(this.schemaName);
        if (schema == null) {
            if (!this.ifExists) {
                throw DbException.get(90079, this.schemaName);
            }
        } else {
            ArrayList<SchemaObject> arrayList;
            int n;
            if (!schema.canDrop()) {
                throw DbException.get(90090, this.schemaName);
            }
            if (this.dropAction == ConstraintActionType.RESTRICT && !schema.isEmpty() && (n = (arrayList = schema.getAll(null)).size()) > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(arrayList.get(i).getName());
                }
                throw DbException.get(90107, this.schemaName, stringBuilder.toString());
            }
            database.removeDatabaseObject(this.session, schema);
        }
        return 0;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setDropAction(ConstraintActionType constraintActionType) {
        this.dropAction = constraintActionType;
    }

    @Override
    public int getType() {
        return 42;
    }
}

