/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.com.cryptomorin.xseries.reflection.jvm;

import com.craftaro.third_party.com.cryptomorin.xseries.reflection.XReflection;
import com.craftaro.third_party.com.cryptomorin.xseries.reflection.jvm.FlaggedNamedMemberHandle;
import com.craftaro.third_party.com.cryptomorin.xseries.reflection.jvm.MemberHandle;
import com.craftaro.third_party.com.cryptomorin.xseries.reflection.jvm.classes.ClassHandle;
import com.craftaro.third_party.com.cryptomorin.xseries.reflection.parser.ReflectionParser;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ConstructorMemberHandle
extends MemberHandle {
    protected ClassHandle[] parameterTypes = new ClassHandle[0];

    public ConstructorMemberHandle(ClassHandle clazz) {
        super(clazz);
    }

    public ConstructorMemberHandle parameters(Class<?> ... parameterTypes) {
        this.parameterTypes = (ClassHandle[])Arrays.stream(parameterTypes).map(XReflection::of).toArray(ClassHandle[]::new);
        return this;
    }

    public ConstructorMemberHandle parameters(ClassHandle ... parameterTypes) {
        this.parameterTypes = parameterTypes;
        return this;
    }

    @Override
    public MethodHandle reflect() throws ReflectiveOperationException {
        if (this.isFinal) {
            throw new UnsupportedOperationException("Constructor cannot be final: " + this);
        }
        if (this.makeAccessible) {
            return this.clazz.getNamespace().getLookup().unreflectConstructor((Constructor<?>)this.reflectJvm());
        }
        Class<?>[] parameterTypes = FlaggedNamedMemberHandle.getParameters(this, this.parameterTypes);
        return this.clazz.getNamespace().getLookup().findConstructor((Class)this.clazz.unreflect(), MethodType.methodType(Void.TYPE, parameterTypes));
    }

    @Override
    public ConstructorMemberHandle signature(String declaration) {
        return new ReflectionParser(declaration).imports(this.clazz.getNamespace()).parseConstructor(this);
    }

    public Constructor<?> reflectJvm() throws ReflectiveOperationException {
        Class<?>[] parameterTypes = FlaggedNamedMemberHandle.getParameters(this, this.parameterTypes);
        return this.handleAccessible(((Class)this.clazz.unreflect()).getDeclaredConstructor(parameterTypes));
    }

    @Override
    public ConstructorMemberHandle clone() {
        ConstructorMemberHandle handle = new ConstructorMemberHandle(this.clazz);
        handle.parameterTypes = this.parameterTypes;
        handle.isFinal = this.isFinal;
        handle.makeAccessible = this.makeAccessible;
        return handle;
    }

    public String toString() {
        String str = this.getClass().getSimpleName() + '{';
        if (this.makeAccessible) {
            str = str + "protected/private ";
        }
        str = str + this.clazz.toString() + ' ';
        str = str + '(' + Arrays.stream(this.parameterTypes).map(Object::toString).collect(Collectors.joining(", ")) + ')';
        return str + '}';
    }
}

