/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.com.cryptomorin.xseries;

import com.google.common.base.Enums;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public enum XEnchantment {
    AQUA_AFFINITY("WATER_WORKER", "WATER_WORKER", "AQUA_AFFINITY", "WATER_MINE"),
    BANE_OF_ARTHROPODS("DAMAGE_ARTHROPODS", "ARDMG", "BANE_OF_ARTHROPOD", "ARTHROPOD"),
    BINDING_CURSE("BINDING_CURSE", "BIND_CURSE", "BINDING", "BIND"),
    BLAST_PROTECTION("PROTECTION_EXPLOSIONS", "BLAST_PROTECT", "EXPLOSIONS_PROTECTION", "EXPLOSION_PROTECTION", "BLAST_PROTECTION"),
    BREACH(new String[0]),
    CHANNELING("CHANNELLING", "CHANELLING", "CHANELING", "CHANNEL"),
    DENSITY(new String[0]),
    DEPTH_STRIDER("DEPTH", "STRIDER"),
    EFFICIENCY("DIG_SPEED", "MINE_SPEED", "CUT_SPEED"),
    FEATHER_FALLING("PROTECTION_FALL", "FALL_PROT", "FEATHER_FALL", "FALL_PROTECTION", "FEATHER_FALLING"),
    FIRE_ASPECT("FIRE", "MELEE_FIRE", "MELEE_FLAME"),
    FIRE_PROTECTION("PROTECTION_FIRE", "FIRE_PROT", "FIRE_PROTECT", "FIRE_PROTECTION", "FLAME_PROTECTION", "FLAME_PROTECT", "FLAME_PROT"),
    FLAME("ARROW_FIRE", "FLAME_ARROW", "FIRE_ARROW"),
    FORTUNE("LOOT_BONUS_BLOCKS", "BLOCKS_LOOT_BONUS", "FORT"),
    FROST_WALKER("FROST", "WALKER"),
    IMPALING("IMPALE", "OCEAN_DAMAGE", "OCEAN_DMG"),
    INFINITY("ARROW_INFINITE", "INF_ARROWS", "INFINITE_ARROWS", "INFINITE", "UNLIMITED", "UNLIMITED_ARROWS"),
    KNOCKBACK("K_BACK"),
    LOOTING("LOOT_BONUS_MOBS", "MOB_LOOT", "MOBS_LOOT_BONUS"),
    LOYALTY("LOYAL", "RETURN"),
    LUCK_OF_THE_SEA("LUCK", "LUCK_OF_SEA", "LUCK_OF_SEAS", "ROD_LUCK"),
    LURE("ROD_LURE"),
    MENDING(new String[0]),
    MULTISHOT("TRIPLE_SHOT"),
    PIERCING(new String[0]),
    POWER("ARROW_DAMAGE", "ARROW_POWER"),
    PROJECTILE_PROTECTION("PROTECTION_PROJECTILE", "PROJECTILE_PROTECTION", "PROJ_PROT"),
    PROTECTION("PROTECTION_ENVIRONMENTAL", "PROTECT"),
    PUNCH("ARROW_KNOCKBACK", "ARROWKB", "ARROW_PUNCH"),
    QUICK_CHARGE("QUICKCHARGE", "QUICK_DRAW", "FAST_CHARGE", "FAST_DRAW"),
    RESPIRATION("OXYGEN", "BREATH", "BREATHING"),
    RIPTIDE("RIP", "TIDE", "LAUNCH"),
    SHARPNESS("DAMAGE_ALL", "ALL_DAMAGE", "ALL_DMG", "SHARP"),
    SILK_TOUCH("SOFT_TOUCH"),
    SMITE("DAMAGE_UNDEAD", "UNDEAD_DAMAGE"),
    SOUL_SPEED("SPEED_SOUL", "SOUL_RUNNER"),
    SWEEPING_EDGE("SWEEPING", "SWEEPING_EDGE", "SWEEP_EDGE"),
    SWIFT_SNEAK("SNEAK_SWIFT"),
    THORNS("HIGHCRIT", "THORN", "HIGHERCRIT"),
    UNBREAKING("DURABILITY", "DURA"),
    VANISHING_CURSE("VANISHING_CURSE", "VANISH_CURSE", "VANISHING", "VANISH"),
    WIND_BURST(new String[0]);

    public static final XEnchantment[] VALUES;
    public static final Set<EntityType> EFFECTIVE_SMITE_ENTITIES;
    public static final Set<EntityType> EFFECTIVE_BANE_OF_ARTHROPODS_ENTITIES;
    @Nullable
    private final Enchantment enchantment;

    private XEnchantment(String ... aliases) {
        Enchantment enchantment = XEnchantment.getBukkitEnchant(this.name());
        Data.NAMES.put(this.name(), this);
        for (String legacy : aliases) {
            Data.NAMES.put(legacy, this);
            if (enchantment != null) continue;
            enchantment = XEnchantment.getBukkitEnchant(legacy);
        }
        this.enchantment = enchantment;
    }

    private static Enchantment getBukkitEnchant(String name) {
        if (Data.IS_SUPER_FLAT) {
            return (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)name.toLowerCase(Locale.ENGLISH)));
        }
        if (Data.ISFLAT) {
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name.toLowerCase(Locale.ENGLISH)));
        }
        return Enchantment.getByName((String)name);
    }

    public static boolean isSmiteEffectiveAgainst(@Nullable EntityType type) {
        return type != null && EFFECTIVE_SMITE_ENTITIES.contains(type);
    }

    public static boolean isArthropodsEffectiveAgainst(@Nullable EntityType type) {
        return type != null && EFFECTIVE_BANE_OF_ARTHROPODS_ENTITIES.contains(type);
    }

    @Nonnull
    private static String format(@Nonnull String name) {
        int len = name.length();
        char[] chs = new char[len];
        int count = 0;
        boolean appendUnderline = false;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (!(appendUnderline || count == 0 || ch != '-' && ch != ' ' && ch != '_' || chs[count] == '_')) {
                appendUnderline = true;
                continue;
            }
            if ((ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) continue;
            if (appendUnderline) {
                chs[count++] = 95;
                appendUnderline = false;
            }
            chs[count++] = (char)(ch & 0x5F);
        }
        return new String(chs, 0, count);
    }

    @Nonnull
    public static Optional<XEnchantment> matchXEnchantment(@Nonnull String enchantment) {
        if (enchantment == null || enchantment.isEmpty()) {
            throw new IllegalArgumentException("Enchantment name cannot be null or empty");
        }
        return Optional.ofNullable((XEnchantment)((Object)Data.NAMES.get(XEnchantment.format(enchantment))));
    }

    @Nonnull
    public static XEnchantment matchXEnchantment(@Nonnull Enchantment enchantment) {
        Objects.requireNonNull(enchantment, "Cannot parse XEnchantment of a null enchantment");
        return Objects.requireNonNull((XEnchantment)((Object)Data.NAMES.get(enchantment.getName())), () -> "Unsupported enchantment: " + enchantment.getName());
    }

    @Nonnull
    public ItemStack getBook(int level) {
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
        meta.addStoredEnchant(this.enchantment, level, true);
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    @Nullable
    public Enchantment getEnchant() {
        return this.enchantment;
    }

    public boolean isSupported() {
        return this.enchantment != null;
    }

    @Nullable
    public XEnchantment or(@Nullable XEnchantment alternateEnchantment) {
        return this.isSupported() ? this : alternateEnchantment;
    }

    @Nonnull
    public String toString() {
        return Arrays.stream(this.name().split("_")).map(t -> t.charAt(0) + t.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    static {
        VALUES = XEnchantment.values();
        EntityType bee = (EntityType)Enums.getIfPresent(EntityType.class, (String)"BEE").orNull();
        EntityType phantom = (EntityType)Enums.getIfPresent(EntityType.class, (String)"PHANTOM").orNull();
        EntityType drowned = (EntityType)Enums.getIfPresent(EntityType.class, (String)"DROWNED").orNull();
        EntityType witherSkeleton = (EntityType)Enums.getIfPresent(EntityType.class, (String)"WITHER_SKELETON").orNull();
        EntityType skeletonHorse = (EntityType)Enums.getIfPresent(EntityType.class, (String)"SKELETON_HORSE").orNull();
        EntityType stray = (EntityType)Enums.getIfPresent(EntityType.class, (String)"STRAY").orNull();
        EntityType husk = (EntityType)Enums.getIfPresent(EntityType.class, (String)"HUSK").orNull();
        EnumSet<EntityType> arthorposEffective = EnumSet.of(EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.SILVERFISH, EntityType.ENDERMITE);
        if (bee != null) {
            arthorposEffective.add(bee);
        }
        EFFECTIVE_BANE_OF_ARTHROPODS_ENTITIES = Collections.unmodifiableSet(arthorposEffective);
        EnumSet<EntityType> smiteEffective = EnumSet.of(EntityType.ZOMBIE, EntityType.SKELETON, EntityType.WITHER);
        if (phantom != null) {
            smiteEffective.add(phantom);
        }
        if (drowned != null) {
            smiteEffective.add(drowned);
        }
        if (witherSkeleton != null) {
            smiteEffective.add(witherSkeleton);
        }
        if (skeletonHorse != null) {
            smiteEffective.add(skeletonHorse);
        }
        if (stray != null) {
            smiteEffective.add(stray);
        }
        if (husk != null) {
            smiteEffective.add(husk);
        }
        EFFECTIVE_SMITE_ENTITIES = Collections.unmodifiableSet(smiteEffective);
    }

    private static final class Data {
        private static final boolean ISFLAT;
        private static final boolean IS_SUPER_FLAT;
        private static final Map<String, XEnchantment> NAMES;

        private Data() {
        }

        static {
            boolean superFlat;
            boolean flat;
            NAMES = new HashMap<String, XEnchantment>();
            try {
                Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
                Class<?> enchantmentClass = Class.forName("org.bukkit.enchantments.Enchantment");
                enchantmentClass.getDeclaredMethod("getByKey", namespacedKeyClass);
                flat = true;
            }
            catch (ClassNotFoundException | NoSuchMethodException ex) {
                flat = false;
            }
            try {
                Class.forName("org.bukkit.Registry");
                superFlat = true;
            }
            catch (ClassNotFoundException ex) {
                superFlat = false;
            }
            ISFLAT = flat;
            IS_SUPER_FLAT = superFlat;
        }
    }
}

