/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.world;

import com.craftaro.core.compatibility.CompatibleHand;
import com.craftaro.core.compatibility.ServerVersion;
import com.craftaro.core.nms.Nms;
import com.craftaro.core.third_party.de.tr7zw.nbtapi.NBT;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class SItemStack {
    protected final com.craftaro.core.nms.world.SItemStack sItem;
    protected final ItemStack item;

    public SItemStack(ItemStack item) {
        this.item = item;
        this.sItem = Nms.getImplementations().getWorld().getItemStack(item);
    }

    public SItemStack(CompatibleHand hand, Player player) {
        this.item = hand.getItem((LivingEntity)player);
        this.sItem = Nms.getImplementations().getWorld().getItemStack(this.item);
    }

    public ItemStack addDamage(Player player, int damage) {
        return this.addDamage(player, damage, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack addDamage(Player player, int damage, boolean respectVanillaUnbreakingEnchantments) {
        int durability;
        if (this.item == null) {
            return null;
        }
        if (this.item.getItemMeta() == null) {
            return this.item;
        }
        short maxDurability = this.item.getType().getMaxDurability();
        if (ServerVersion.isServerVersionBelow(ServerVersion.V1_11) ? NBT.readNbt(this.item).hasTag("Unbreakable") : this.item.getItemMeta().isUnbreakable()) {
            return this.item;
        }
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_13)) {
            ItemMeta meta = this.item.getItemMeta();
            if (!(meta instanceof Damageable)) return this.item;
            Damageable damageable = (Damageable)meta;
            if (respectVanillaUnbreakingEnchantments) {
                damage = SItemStack.shouldApplyDamage(meta.getEnchantLevel(Enchantment.DURABILITY), damage);
            }
            damageable.setDamage(((Damageable)meta).getDamage() + damage);
            this.item.setItemMeta(meta);
            durability = damageable.getDamage();
        } else {
            if (respectVanillaUnbreakingEnchantments) {
                damage = SItemStack.shouldApplyDamage(this.item.getEnchantmentLevel(Enchantment.DURABILITY), damage);
            }
            this.item.setDurability((short)Math.max(0, this.item.getDurability() + damage));
            durability = this.item.getDurability();
        }
        if (durability < maxDurability || player == null) return this.item;
        this.destroy(player);
        return this.item;
    }

    public void destroy(Player player) {
        this.destroy(player, 1);
    }

    public void destroy(Player player, int amount) {
        PlayerItemBreakEvent breakEvent = new PlayerItemBreakEvent(player, this.item);
        Bukkit.getServer().getPluginManager().callEvent((Event)breakEvent);
        this.sItem.breakItem(player, amount);
        XSound.ENTITY_ITEM_BREAK.play((Entity)player);
    }

    public ItemStack getItem() {
        return this.item;
    }

    private static int shouldApplyDamage(int unbreakingEnchantLevel, int damageAmount) {
        int result = 0;
        for (int i = 0; i < damageAmount; ++i) {
            if (!SItemStack.shouldApplyDamage(unbreakingEnchantLevel)) continue;
            ++result;
        }
        return result;
    }

    private static boolean shouldApplyDamage(int unbreakingEnchantLevel) {
        if (unbreakingEnchantLevel <= 0) {
            return true;
        }
        return Math.random() <= 1.0 / (double)(unbreakingEnchantLevel + 1);
    }
}

