/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.utils;

import com.craftaro.core.SongodaCore;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@Deprecated
public class ReflectionUtils {
    public static final double JAVA_VERSION = ReflectionUtils.getVersion();
    private static String system_os = System.getProperty("os.name").toLowerCase();
    private static Method j7getStackTraceElementMethod;
    private static Method j7getStackTraceDepthMethod;
    private static Method j8getJavaLangAccess;
    private static Method j8getStackTraceElementMethod;

    private static double getVersion() {
        String version = System.getProperty("java.version");
        int i = version.indexOf(46);
        if (i != -1 && (i = version.indexOf(46, i + 1)) != -1) {
            return Double.parseDouble(version.substring(0, i));
        }
        return Double.NaN;
    }

    public static File getJarFile(Class jarClass) {
        return new File(jarClass.getProtectionDomain().getCodeSource().getLocation().getPath().replace("%20", " ").replace("%25", "%"));
    }

    public static void setPrivateField(Class<?> c, Object handle, String fieldName, Object value) throws Exception {
        Field f = c.getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(handle, value);
    }

    public static Object getPrivateField(Class<?> c, Object handle, String fieldName) throws Exception {
        Field field = c.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(handle);
    }

    public static Object invokePrivateMethod(Class<?> c, String methodName, Object handle, Class[] types, Object[] parameters) throws Exception {
        Method m = c.getDeclaredMethod(methodName, types);
        m.setAccessible(true);
        return m.invoke(handle, parameters);
    }

    public static StackTraceElement getStackTraceElement(int index) {
        try {
            Throwable dummy = new Throwable();
            if (j8getStackTraceElementMethod != null) {
                return (StackTraceElement)j8getStackTraceElementMethod.invoke(j8getJavaLangAccess.invoke(null, new Object[0]), dummy, index);
            }
            if (j7getStackTraceElementMethod == null) {
                return new Throwable().getStackTrace()[index];
            }
            if (index < (Integer)j7getStackTraceDepthMethod.invoke((Object)dummy, new Object[0])) {
                return (StackTraceElement)j7getStackTraceElementMethod.invoke((Object)new Throwable(), index);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static <T extends Annotation> Map<Class<?>, T> getClassesInClassPackageByAnnotation(Class<?> clazz, Class<T> annotation) throws IOException {
        HashMap foundClasses = new HashMap();
        for (Class<?> c : ReflectionUtils.getAllClassesInClassPackage(clazz, false)) {
            T t = c.getAnnotation(annotation);
            if (t == null) continue;
            foundClasses.put(c, t);
        }
        return foundClasses;
    }

    public static List<Class<?>> getAllClassesInClassPackage(Class<?> clazz, boolean recursive) throws IOException {
        final ArrayList packageClasses = new ArrayList();
        final String clazzPackageName = clazz.getPackage().getName();
        URL dot = clazz.getResource(".");
        if (dot == null) {
            String packagePath = clazzPackageName.replace('.', '/');
            CodeSource src = clazz.getProtectionDomain().getCodeSource();
            if (src != null) {
                ZipEntry e;
                URL jar = src.getLocation();
                ZipInputStream zip = new ZipInputStream(jar.openStream());
                while ((e = zip.getNextEntry()) != null) {
                    String name = e.getName();
                    if (name.endsWith("/") || !name.startsWith(packagePath + "/") || !recursive && name.indexOf(47, packagePath.length() + 1) != -1) continue;
                    try {
                        Class<?> loadedClazz = Class.forName(name.substring(0, name.lastIndexOf(46)).replace('/', '.'));
                        packageClasses.add(loadedClazz);
                    }
                    catch (ClassNotFoundException e1) {
                        SongodaCore.getLogger().log(Level.FINE, "class not found: " + e1.getMessage());
                    }
                }
            }
            return packageClasses;
        }
        String clazzPath = clazz.getResource(".").getPath();
        if (clazzPath.startsWith("/") && system_os.contains("win")) {
            clazzPath = clazzPath.substring(1);
        }
        Path packagePath = Paths.get(clazzPath, new String[0]);
        Files.walkFileTree(packagePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String filename = file.getName(file.getNameCount() - 1).toString();
                if (filename.endsWith(".class")) {
                    String className = filename.replace(".class", "");
                    try {
                        Class<?> loadedClazz = Class.forName(clazzPackageName + "." + className);
                        packageClasses.add(loadedClazz);
                    }
                    catch (ClassNotFoundException e) {
                        SongodaCore.getLogger().log(Level.FINE, "class not found: " + e.getMessage());
                    }
                }
                return super.visitFile(file, attrs);
            }
        });
        return packageClasses;
    }

    public static List<String> getClassNamesFromPackage(Class classInPackage) throws IOException, URISyntaxException, ClassNotFoundException {
        String classPath = classInPackage.getName();
        int packageDelim = classPath.lastIndexOf(46);
        return ReflectionUtils.getClassNamesFromPackage(ReflectionUtils.getJarFile(classInPackage), classPath.substring(0, packageDelim), ITERATION.NONE);
    }

    public static List<String> getClassNamesFromPackage(String packageName) throws IOException, URISyntaxException, ClassNotFoundException {
        return ReflectionUtils.getClassNamesFromPackage(packageName, ITERATION.NONE);
    }

    public static List<String> getClassNamesFromPackage(String packageName, ITERATION iterate) throws IOException, URISyntaxException, ClassNotFoundException {
        return ReflectionUtils.getClassNamesFromPackage(null, packageName, iterate);
    }

    public static List<String> getClassNamesFromPackage(File sourceJar, String packageName, ITERATION iterate) throws IOException, URISyntaxException, ClassNotFoundException {
        URL packageURL;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> names = new ArrayList<String>();
        if (packageName.contains("/")) {
            packageURL = classLoader.getResource(packageName);
            if (packageURL == null && packageName.contains("/")) {
                int i = packageName.lastIndexOf(47);
                packageName = packageName.substring(0, i) + "." + packageName.substring(i + 1);
                packageURL = classLoader.getResource(packageName);
            }
        } else {
            packageName = packageName.replace(".", "/");
            packageURL = classLoader.getResource(packageName);
            if (sourceJar == null && packageURL == null) {
                throw new IOException("Cannot open resource '" + packageName + "'");
            }
        }
        if (sourceJar == null && packageURL == null) {
            throw new IOException("Cannot open resource '" + packageName + "'");
        }
        if (sourceJar != null || packageURL.getProtocol().equals("jar")) {
            String jarFileName;
            String string = jarFileName = sourceJar != null ? sourceJar.getAbsolutePath() : URLDecoder.decode(packageURL.getFile(), "UTF-8");
            if (jarFileName.startsWith("file:/")) {
                jarFileName = jarFileName.substring(system_os.contains("win") ? 5 : 4);
            }
            if (jarFileName.startsWith("/") && system_os.contains("win")) {
                jarFileName = jarFileName.substring(1);
            }
            if (jarFileName.contains("!")) {
                jarFileName = jarFileName.substring(0, jarFileName.indexOf("!"));
            }
            JarFile jf = new JarFile(jarFileName);
            Enumeration<JarEntry> jarEntries = jf.entries();
            ArrayList<String> loaded = new ArrayList<String>();
            while (jarEntries.hasMoreElements()) {
                String entryName = jarEntries.nextElement().getName();
                if (!entryName.startsWith(packageName) || entryName.length() <= packageName.length() || !entryName.toLowerCase().endsWith(".class")) continue;
                if (entryName.contains(".")) {
                    entryName = entryName.substring(packageName.length() + 1, entryName.lastIndexOf(46));
                }
                if (entryName.contains("/") && iterate != ITERATION.PACKAGE && iterate != ITERATION.FULL) continue;
                if (entryName.contains("$")) {
                    if (iterate != ITERATION.CLASS && iterate != ITERATION.FULL || loaded.contains(entryName = entryName.substring(0, entryName.indexOf(36)).replace('/', '.'))) continue;
                    loaded.add(entryName);
                    try {
                        Class<?> c = Class.forName(packageName.replace('/', '.') + "." + entryName);
                        for (Class<?> c2 : c.getDeclaredClasses()) {
                            names.add(entryName + "." + c2.getSimpleName());
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                names.add(entryName.replace('/', '.'));
            }
        } else {
            URI uri = new URI(packageURL.toString());
            File folder = new File(uri.getPath());
            File[] contenuti = folder.listFiles();
            ArrayList<String> loaded = new ArrayList<String>();
            for (File actual : contenuti) {
                String entryName = actual.getName();
                if (entryName.contains(".")) {
                    if ((entryName = entryName.substring(0, entryName.lastIndexOf(46))).contains("$")) {
                        if (iterate != ITERATION.CLASS && iterate != ITERATION.FULL || loaded.contains(entryName = entryName.substring(0, entryName.indexOf(36)))) continue;
                        loaded.add(entryName);
                        Class<?> c = Class.forName(packageName.replace('/', '.') + "." + entryName);
                        for (Class<?> c2 : c.getDeclaredClasses()) {
                            names.add(entryName + "." + c2.getSimpleName());
                        }
                        continue;
                    }
                    names.add(entryName);
                    continue;
                }
                if (iterate != ITERATION.PACKAGE && iterate != ITERATION.FULL) continue;
                for (String sub : ReflectionUtils.getClassNamesFromPackage(packageName + "/" + entryName, iterate)) {
                    names.add(entryName + "." + sub);
                }
            }
        }
        return names;
    }

    static {
        try {
            j7getStackTraceElementMethod = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            j7getStackTraceElementMethod.setAccessible(true);
            j7getStackTraceDepthMethod = Throwable.class.getDeclaredMethod("getStackTraceDepth", new Class[0]);
            j7getStackTraceDepthMethod.setAccessible(true);
        }
        catch (Exception ex) {
            j7getStackTraceDepthMethod = null;
            j7getStackTraceElementMethod = null;
        }
        try {
            j8getJavaLangAccess = Class.forName("sun.misc.SharedSecrets").getDeclaredMethod("getStackTraceElement", new Class[0]);
            j8getJavaLangAccess.setAccessible(true);
            j8getStackTraceElementMethod = Class.forName("sun.misc.JavaLangAccess").getDeclaredMethod("getStackTraceDepth", Throwable.class, Integer.TYPE);
            j8getStackTraceElementMethod.setAccessible(true);
        }
        catch (Exception ex) {
            j8getStackTraceElementMethod = null;
            j8getJavaLangAccess = null;
        }
    }

    public static enum ITERATION {
        NONE,
        CLASS,
        PACKAGE,
        FULL;

    }
}

