/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.utils;

import com.craftaro.core.compatibility.ClassMapping;
import com.craftaro.core.compatibility.CompatibleHand;
import com.craftaro.core.compatibility.CompatibleMaterial;
import com.craftaro.core.compatibility.MethodMapping;
import com.craftaro.core.compatibility.ServerProject;
import com.craftaro.core.compatibility.ServerVersion;
import com.craftaro.core.nms.Nms;
import com.craftaro.core.third_party.de.tr7zw.nbtapi.NBTItem;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.craftaro.third_party.org.apache.commons.lang3.StringUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

@Deprecated
public class ItemUtils {
    static boolean can_getI18NDisplayName = true;
    static Class<?> cb_ItemStack;
    static Class<?> mc_ItemStack;
    static Class<?> mc_NBTTagCompound;
    static Class<?> mc_NBTTagList;
    static Method mc_ItemStack_getTag;
    static Method mc_ItemStack_setTag;
    static Method mc_NBTTagCompound_set;
    static Method mc_NBTTagCompound_remove;
    static Method cb_CraftItemStack_asNMSCopy;
    static Method cb_CraftItemStack_asCraftMirror;

    public static String getItemName(ItemStack it) {
        if (it == null) {
            return null;
        }
        return ItemUtils.itemName(it.getType());
    }

    static String itemName(Material mat) {
        String matName = mat.name().replace("_", " ");
        StringBuilder titleCase = new StringBuilder(matName.length());
        Stream.of(matName.split(" ")).forEach(s -> {
            if ((s = s.toLowerCase()).equals("of")) {
                titleCase.append((String)s).append(" ");
            } else {
                char[] str = s.toCharArray();
                str[0] = Character.toUpperCase(str[0]);
                titleCase.append(new String(str)).append(" ");
            }
        });
        return titleCase.toString().trim();
    }

    public static String itemStackArrayToBase64(ItemStack[] items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(items.length);
            for (ItemStack item : items) {
                dataOutput.writeObject((Object)item);
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack[] itemStackArrayFromBase64(String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack[] items = new ItemStack[dataInput.readInt()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (ItemStack)dataInput.readObject();
            }
            dataInput.close();
            return items;
        }
        catch (IOException | ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack getAsCopy(ItemStack item, int qty) {
        ItemStack clone = item.clone();
        clone.setAmount(qty);
        return clone;
    }

    public static boolean hasEnoughDurability(ItemStack tool, int requiredAmount) {
        if (tool.getType().getMaxDurability() <= 1) {
            return true;
        }
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_13)) {
            if (!tool.hasItemMeta() || !(tool.getItemMeta() instanceof Damageable)) {
                return true;
            }
            Damageable damageable = (Damageable)tool.getItemMeta();
            int durabilityRemaining = tool.getType().getMaxDurability() - damageable.getDamage();
            return durabilityRemaining > requiredAmount;
        }
        return tool.getDurability() + requiredAmount <= tool.getType().getMaxDurability();
    }

    public static ItemStack addGlow(ItemStack item) {
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_11)) {
            item.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
            ItemMeta m = item.getItemMeta();
            m.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(m);
            return item;
        }
        if (ServerProject.isServer(ServerProject.PAPER) && ServerVersion.isServerVersionAtLeast(ServerVersion.V1_20_5)) {
            if (item == null || item.getType() == Material.AIR) {
                return item;
            }
            NBTItem nbtItem = new NBTItem(item);
            nbtItem.addCompound("minecraft:enchantments");
            nbtItem.applyNBT(item);
            return item;
        }
        if (item != null && item.getType() != Material.AIR && cb_CraftItemStack_asCraftMirror != null) {
            try {
                Object nmsStack = cb_CraftItemStack_asNMSCopy.invoke(null, item);
                Object tag = mc_ItemStack_getTag.invoke(nmsStack, new Object[0]);
                if (tag == null) {
                    tag = mc_NBTTagCompound.newInstance();
                }
                Object enchantmentList = mc_NBTTagList.newInstance();
                mc_NBTTagCompound_set.invoke(tag, "ench", enchantmentList);
                mc_ItemStack_setTag.invoke(nmsStack, tag);
                item = (ItemStack)cb_CraftItemStack_asCraftMirror.invoke(null, nmsStack);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Failed to set glow enchantment on item: " + item, ex);
            }
        }
        return item;
    }

    public static ItemStack removeGlow(ItemStack item) {
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_11)) {
            item.removeEnchantment(Enchantment.DURABILITY);
            return item;
        }
        if (item != null && item.getType() != Material.AIR && cb_CraftItemStack_asCraftMirror != null) {
            try {
                Object nmsStack = cb_CraftItemStack_asNMSCopy.invoke(null, item);
                Object tag = mc_ItemStack_getTag.invoke(nmsStack, new Object[0]);
                if (tag != null) {
                    mc_NBTTagCompound_remove.invoke(tag, "ench");
                    mc_ItemStack_setTag.invoke(nmsStack, tag);
                    item = (ItemStack)cb_CraftItemStack_asCraftMirror.invoke(null, nmsStack);
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Failed to set glow enchantment on item: " + item, ex);
            }
        }
        return item;
    }

    public static ItemStack getPlayerSkull(OfflinePlayer player) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        if (ServerVersion.isServerVersionBelow(ServerVersion.V1_8)) {
            return head;
        }
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_13)) {
            meta.setOwningPlayer(player);
        } else {
            meta.setOwner(player.getName());
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public static void setHeadOwner(ItemStack head, OfflinePlayer player) {
        if (ServerVersion.isServerVersionBelow(ServerVersion.V1_8) || !XMaterial.PLAYER_HEAD.isSimilar(head)) {
            return;
        }
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_13)) {
            meta.setOwningPlayer(player);
        } else {
            meta.setOwner(player.getName());
        }
    }

    public static ItemStack getCustomHead(String texture) {
        return ItemUtils.getCustomHead(null, texture);
    }

    public static ItemStack getCustomHead(String signature, String texture) {
        GameProfile gm;
        ItemStack skullItem = XMaterial.PLAYER_HEAD.parseItem();
        if (ServerVersion.isServerVersionBelow(ServerVersion.V1_8)) {
            return skullItem;
        }
        SkullMeta sm = (SkullMeta)skullItem.getItemMeta();
        if (texture.endsWith("=")) {
            gm = new GameProfile(UUID.nameUUIDFromBytes(texture.getBytes()), "CustomHead");
            if (signature == null) {
                gm.getProperties().put((Object)"textures", (Object)new Property("texture", texture.replaceAll("=", "")));
            } else {
                gm.getProperties().put((Object)"textures", (Object)new Property("textures", texture, signature));
            }
        } else {
            gm = new GameProfile(UUID.nameUUIDFromBytes(texture.getBytes()), "CustomHead");
            byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"http://textures.minecraft.net/texture/%s\"}}}", texture).getBytes());
            gm.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        }
        try {
            Field profileField = sm.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(sm, gm);
            skullItem.setItemMeta((ItemMeta)sm);
            return skullItem;
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException("Reflection error while setting head texture", ex);
        }
    }

    public static String getSkullTexture(Player player) {
        if (player == null || ServerVersion.isServerVersionBelow(ServerVersion.V1_8)) {
            return null;
        }
        return Nms.getImplementations().getPlayer().getProfile(player).getTextureValue();
    }

    public static String getSkullTexture(ItemStack item) {
        if (!XMaterial.PLAYER_HEAD.isSimilar(item) || ServerVersion.isServerVersionBelow(ServerVersion.V1_8)) {
            return null;
        }
        try {
            SkullMeta localSkullMeta = (SkullMeta)item.getItemMeta();
            Field cb_SkullMeta_profile = localSkullMeta.getClass().getDeclaredField("profile");
            cb_SkullMeta_profile.setAccessible(true);
            GameProfile profile = (GameProfile)cb_SkullMeta_profile.get(localSkullMeta);
            Iterator iterator = profile.getProperties().get((Object)"textures").iterator();
            return iterator.hasNext() ? ((Property)iterator.next()).getValue() : null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            return null;
        }
    }

    public static String getDecodedTexture(String encoded) {
        return encoded != null ? StringUtils.substringBetween(new String(Base64.getDecoder().decode(encoded)), "texture/", "\"") : null;
    }

    @Deprecated
    public static void takeActiveItem(Player player, CompatibleHand hand) {
        ItemUtils.takeActiveItem(player, hand, 1);
    }

    @Deprecated
    public static void takeActiveItem(Player player, CompatibleHand hand, int amount) {
        hand.takeItem((LivingEntity)player, amount);
    }

    public static boolean isSimilarMaterial(ItemStack is1, ItemStack is2) {
        Optional<XMaterial> mat1 = CompatibleMaterial.getMaterial(is1.getType());
        return mat1.isPresent() && mat1 == CompatibleMaterial.getMaterial(is2.getType());
    }

    public static boolean canMove(Inventory inventory, ItemStack item) {
        if (inventory.firstEmpty() != -1) {
            return true;
        }
        ItemMeta itemMeta = item.getItemMeta();
        for (ItemStack stack : inventory) {
            ItemMeta stackMeta;
            if (!ItemUtils.isSimilarMaterial(stack, item) || stack.getAmount() + item.getAmount() >= stack.getMaxStackSize() || itemMeta == null != ((stackMeta = stack.getItemMeta()) == null) || itemMeta != null && !Bukkit.getItemFactory().equals(itemMeta, stackMeta)) continue;
            return true;
        }
        return false;
    }

    public static boolean canMove(ItemStack[] contents, ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        for (ItemStack stack : contents) {
            ItemMeta stackMeta;
            if (stack == null || stack.getAmount() == 0) {
                return true;
            }
            if (!ItemUtils.isSimilarMaterial(stack, item) || stack.getAmount() + item.getAmount() >= stack.getMaxStackSize() || itemMeta == null != ((stackMeta = stack.getItemMeta()) == null) || itemMeta != null && !Bukkit.getItemFactory().equals(itemMeta, stackMeta)) continue;
            return true;
        }
        return false;
    }

    public static boolean canMoveReserved(Inventory inventory, ItemStack item, int reserved) {
        ItemMeta itemMeta = item.getItemMeta();
        ItemStack[] contents = inventory.getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemMeta stackMeta;
            ItemStack stack;
            if (i == reserved || (stack = contents[i]) != null && stack.getAmount() != 0 && (!ItemUtils.isSimilarMaterial(stack, item) || stack.getAmount() + item.getAmount() >= stack.getMaxStackSize() || itemMeta == null != ((stackMeta = stack.getItemMeta()) == null) || itemMeta != null && !Bukkit.getItemFactory().equals(itemMeta, stackMeta))) continue;
            return true;
        }
        return false;
    }

    public static boolean canMoveReserved(ItemStack[] contents, ItemStack item, int reserved) {
        ItemMeta itemMeta = item.getItemMeta();
        for (int i = 0; i < contents.length; ++i) {
            ItemMeta stackMeta;
            if (i == reserved) continue;
            ItemStack stack = contents[i];
            if (stack == null || stack.getAmount() == 0) {
                return true;
            }
            if (!ItemUtils.isSimilarMaterial(stack, item) || stack.getAmount() + item.getAmount() >= stack.getMaxStackSize() || itemMeta == null != ((stackMeta = stack.getItemMeta()) == null) || itemMeta != null && !Bukkit.getItemFactory().equals(itemMeta, stackMeta)) continue;
            return true;
        }
        return false;
    }

    public static int addAny(ItemStack item, int amountToAdd, List<ItemStack> inventory, int maxSize) {
        return ItemUtils.addAny(item, amountToAdd, inventory, maxSize, -1);
    }

    public static int addAny(ItemStack item, int amountToAdd, List<ItemStack> inventory, int maxSize, int reserved) {
        int totalAdded = 0;
        if (inventory != null && item != null && amountToAdd > 0) {
            int maxStack = item.getMaxStackSize();
            for (int i = 0; amountToAdd > 0 && i < maxSize; ++i) {
                int toAdd;
                ItemStack cacheItem;
                if (i == reserved) continue;
                ItemStack itemStack = cacheItem = i >= inventory.size() ? null : inventory.get(i);
                if (cacheItem == null || cacheItem.getAmount() == 0) {
                    toAdd = Math.min(maxStack, amountToAdd);
                    ItemStack item2 = item.clone();
                    item2.setAmount(toAdd);
                    if (i >= inventory.size()) {
                        inventory.add(item2);
                    } else {
                        inventory.set(i, item2);
                    }
                    totalAdded += toAdd;
                    amountToAdd -= toAdd;
                    continue;
                }
                if (maxStack <= cacheItem.getAmount() || !item.isSimilar(cacheItem)) continue;
                toAdd = Math.min(maxStack - cacheItem.getAmount(), amountToAdd);
                inventory.get(i).setAmount(toAdd + cacheItem.getAmount());
                totalAdded += toAdd;
                amountToAdd -= toAdd;
            }
        }
        return totalAdded;
    }

    public static boolean addItem(ItemStack item, List<ItemStack> inventory, int containerSize) {
        if (inventory == null || item == null || item.getAmount() <= 0 || containerSize <= 0) {
            return false;
        }
        return ItemUtils.addItem(item, item.getAmount(), inventory, containerSize);
    }

    public static boolean addItem(ItemStack item, List<ItemStack> inventory, int containerSize, int reserved) {
        if (inventory == null || item == null || item.getAmount() <= 0 || containerSize <= 0) {
            return false;
        }
        return ItemUtils.addItem(item, item.getAmount(), inventory, containerSize, reserved);
    }

    public static boolean addItem(ItemStack item, int amount, List<ItemStack> inventory, int containerSize, int reserved) {
        return ItemUtils.addItem(item, amount, inventory, containerSize, reserved, null);
    }

    public static boolean addItem(ItemStack item, int amount, List<ItemStack> inventory, int containerSize, int reserved, Material inventorySource) {
        ItemStack cacheItem;
        int i;
        if (inventory == null || item == null || amount <= 0 || inventorySource == null) {
            return false;
        }
        boolean[] check = null;
        if (inventorySource != Material.AIR) {
            if (inventorySource.name().contains("SHULKER_BOX") && item.getType().name().contains("SHULKER_BOX")) {
                return false;
            }
            switch (inventorySource.name()) {
                case "BREWING_STAND": {
                    check = new boolean[5];
                    String typeStr = item.getType().name().toUpperCase();
                    if (typeStr.contains("POTION") || typeStr.contains("BOTTLE")) {
                        check[2] = true;
                        check[1] = true;
                        check[0] = true;
                    }
                    if (item.getType() == Material.BLAZE_POWDER) {
                        check[4] = true;
                    } else {
                        check[3] = true;
                    }
                }
                case "SMOKER": 
                case "BLAST_FURNACE": 
                case "BURNING_FURNACE": 
                case "FURNACE": {
                    boolean isFuel;
                    check = new boolean[3];
                    boolean bl = isFuel = !item.getType().name().contains("LOG") && CompatibleMaterial.isFurnaceFuel(CompatibleMaterial.getMaterial(item.getType()).get());
                    if (isFuel) {
                        check[1] = true;
                        break;
                    }
                    check[0] = true;
                }
            }
        }
        int toAdd = item.getAmount();
        int maxStack = item.getMaxStackSize();
        if (check == null) {
            check = new boolean[containerSize];
            for (i = 0; toAdd > 0 && i < check.length; ++i) {
                check[i] = true;
            }
        }
        if (reserved >= 0 && check.length < reserved) {
            check[reserved] = false;
        }
        for (i = 0; toAdd > 0 && i < containerSize; ++i) {
            if (!check[i]) continue;
            ItemStack itemStack = cacheItem = i >= inventory.size() ? null : inventory.get(i);
            if (cacheItem == null || cacheItem.getAmount() == 0) {
                toAdd -= Math.min(maxStack, toAdd);
                check[i] = true;
                continue;
            }
            if (maxStack > cacheItem.getAmount() && item.isSimilar(cacheItem)) {
                toAdd -= Math.min(maxStack - cacheItem.getAmount(), toAdd);
                check[i] = true;
                continue;
            }
            check[i] = false;
        }
        if (toAdd <= 0) {
            toAdd = item.getAmount();
            for (i = 0; toAdd > 0 && i < containerSize; ++i) {
                int adding;
                if (!check[i]) continue;
                ItemStack itemStack = cacheItem = i >= inventory.size() ? null : inventory.get(i);
                if (cacheItem == null || cacheItem.getAmount() == 0) {
                    adding = Math.min(maxStack, toAdd);
                    ItemStack item2 = item.clone();
                    item2.setAmount(adding);
                    if (i >= inventory.size()) {
                        inventory.add(item2);
                    } else {
                        inventory.set(i, item2);
                    }
                    toAdd -= adding;
                    continue;
                }
                if (maxStack <= cacheItem.getAmount()) continue;
                adding = Math.min(maxStack - cacheItem.getAmount(), toAdd);
                inventory.get(i).setAmount(adding + cacheItem.getAmount());
                toAdd -= adding;
            }
            return true;
        }
        return false;
    }

    public static int addAny(ItemStack item, int amountToAdd, Inventory inventory) {
        int totalAdded = 0;
        if (inventory != null && item != null && amountToAdd > 0) {
            int containerSize = inventory.getSize();
            int maxStack = item.getMaxStackSize();
            for (int i = 0; amountToAdd > 0 && i < containerSize; ++i) {
                int toAdd;
                ItemStack cacheItem = inventory.getItem(i);
                if (cacheItem == null || cacheItem.getAmount() == 0) {
                    toAdd = Math.min(maxStack, amountToAdd);
                    ItemStack item2 = item.clone();
                    item2.setAmount(toAdd);
                    inventory.setItem(i, item2);
                    totalAdded += toAdd;
                    amountToAdd -= toAdd;
                    continue;
                }
                if (maxStack <= cacheItem.getAmount() || !item.isSimilar(cacheItem)) continue;
                toAdd = Math.min(maxStack - cacheItem.getAmount(), amountToAdd);
                cacheItem.setAmount(toAdd + cacheItem.getAmount());
                totalAdded += toAdd;
                amountToAdd -= toAdd;
            }
        }
        return totalAdded;
    }

    public static boolean addItem(ItemStack item, Inventory inventory) {
        if (inventory == null || item == null || item.getAmount() <= 0) {
            return false;
        }
        return ItemUtils.addItem(item, item.getAmount(), inventory, -1, null);
    }

    public static boolean addItem(ItemStack item, int amount, Inventory inventory, int reserved) {
        return ItemUtils.addItem(item, amount, inventory, reserved, null);
    }

    public static boolean addItem(ItemStack item, int amount, Inventory inventory, int reserved, Material inventorySource) {
        ItemStack cacheItem;
        int i;
        if (inventory == null || item == null || amount <= 0 || inventorySource == null) {
            return false;
        }
        boolean[] check = null;
        if (inventorySource != Material.AIR) {
            if (inventorySource.name().contains("SHULKER_BOX") && item.getType().name().contains("SHULKER_BOX")) {
                return false;
            }
            switch (inventorySource.name()) {
                case "BREWING_STAND": {
                    check = new boolean[5];
                    String typeStr = item.getType().name().toUpperCase();
                    if (typeStr.contains("POTION") || typeStr.contains("BOTTLE")) {
                        check[2] = true;
                        check[1] = true;
                        check[0] = true;
                    }
                    if (item.getType() == Material.BLAZE_POWDER) {
                        check[4] = true;
                    } else {
                        check[3] = true;
                    }
                }
                case "SMOKER": 
                case "BLAST_FURNACE": 
                case "BURNING_FURNACE": 
                case "FURNACE": {
                    boolean isFuel;
                    check = new boolean[3];
                    boolean bl = isFuel = !item.getType().name().contains("LOG") && CompatibleMaterial.isFurnaceFuel(CompatibleMaterial.getMaterial(item.getType()).get());
                    if (isFuel) {
                        check[1] = true;
                        break;
                    }
                    check[0] = true;
                }
            }
        }
        int toAdd = item.getAmount();
        int maxStack = item.getMaxStackSize();
        int containerSize = inventory.getSize();
        if (check == null) {
            check = new boolean[containerSize];
            for (i = 0; toAdd > 0 && i < check.length; ++i) {
                check[i] = true;
            }
        }
        for (i = 0; toAdd > 0 && i < containerSize; ++i) {
            if (!check[i]) continue;
            cacheItem = inventory.getItem(i);
            if (cacheItem == null || cacheItem.getAmount() == 0) {
                toAdd -= Math.min(maxStack, toAdd);
                check[i] = true;
                continue;
            }
            if (maxStack > cacheItem.getAmount() && item.isSimilar(cacheItem)) {
                toAdd -= Math.min(maxStack - cacheItem.getAmount(), toAdd);
                check[i] = true;
                continue;
            }
            check[i] = false;
        }
        if (toAdd <= 0) {
            toAdd = item.getAmount();
            for (i = 0; toAdd > 0 && i < containerSize; ++i) {
                int adding;
                if (!check[i]) continue;
                cacheItem = inventory.getItem(i);
                if (cacheItem == null || cacheItem.getAmount() == 0) {
                    adding = Math.min(maxStack, toAdd);
                    ItemStack item2 = item.clone();
                    item2.setAmount(adding);
                    inventory.setItem(i, item2);
                    toAdd -= adding;
                    continue;
                }
                if (maxStack <= cacheItem.getAmount()) continue;
                adding = Math.min(maxStack - cacheItem.getAmount(), toAdd);
                cacheItem.setAmount(adding + cacheItem.getAmount());
                toAdd -= adding;
            }
            return true;
        }
        return false;
    }

    public static XMaterial getDyeColor(char color) {
        switch (color) {
            case '0': {
                return XMaterial.BLACK_DYE;
            }
            case '1': {
                return XMaterial.BLUE_DYE;
            }
            case '2': {
                return XMaterial.GREEN_DYE;
            }
            case '3': {
                return XMaterial.CYAN_DYE;
            }
            case '4': {
                return XMaterial.BROWN_DYE;
            }
            case '5': {
                return XMaterial.PURPLE_DYE;
            }
            case '6': {
                return XMaterial.ORANGE_DYE;
            }
            case '7': {
                return XMaterial.LIGHT_GRAY_DYE;
            }
            case '8': {
                return XMaterial.GRAY_DYE;
            }
            case 'a': {
                return XMaterial.LIME_DYE;
            }
            case 'b': {
                return XMaterial.LIGHT_BLUE_DYE;
            }
            case 'c': {
                return XMaterial.RED_DYE;
            }
            case 'd': {
                return XMaterial.MAGENTA_DYE;
            }
            case 'e': {
                return XMaterial.YELLOW_DYE;
            }
            case 'f': {
                return XMaterial.WHITE_DYE;
            }
        }
        return XMaterial.STONE;
    }

    public static boolean addItem(ItemStack item, int amount, List<ItemStack> inventory, int containerSize) {
        ItemStack cacheItem;
        int i;
        if (inventory == null || item == null || amount <= 0 || containerSize <= 0) {
            return false;
        }
        int toAdd = amount;
        int maxStack = item.getMaxStackSize();
        boolean[] check = new boolean[containerSize];
        Arrays.fill(check, true);
        for (i = 0; toAdd > 0 && i < containerSize; ++i) {
            if (!check[i]) continue;
            ItemStack itemStack = cacheItem = i >= inventory.size() ? null : inventory.get(i);
            if (cacheItem == null || cacheItem.getAmount() == 0) {
                toAdd -= Math.min(maxStack, toAdd);
                check[i] = true;
                continue;
            }
            if (maxStack > cacheItem.getAmount() && item.isSimilar(cacheItem)) {
                toAdd -= Math.min(maxStack - cacheItem.getAmount(), toAdd);
                check[i] = true;
                continue;
            }
            check[i] = false;
        }
        if (toAdd <= 0) {
            toAdd = item.getAmount();
            for (i = 0; toAdd > 0 && i < containerSize; ++i) {
                int adding;
                if (!check[i]) continue;
                ItemStack itemStack = cacheItem = i >= inventory.size() ? null : inventory.get(i);
                if (cacheItem == null || cacheItem.getAmount() == 0) {
                    adding = Math.min(maxStack, toAdd);
                    ItemStack item2 = item.clone();
                    item2.setAmount(adding);
                    if (i >= inventory.size()) {
                        inventory.add(item2);
                    } else {
                        inventory.set(i, item2);
                    }
                    toAdd -= adding;
                    continue;
                }
                if (maxStack <= cacheItem.getAmount()) continue;
                adding = Math.min(maxStack - cacheItem.getAmount(), toAdd);
                inventory.get(i).setAmount(adding + cacheItem.getAmount());
                toAdd -= adding;
            }
            return true;
        }
        return false;
    }

    static {
        try {
            ItemStack.class.getMethod("getI18NDisplayName", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            can_getI18NDisplayName = false;
        }
        cb_ItemStack = ClassMapping.CRAFT_ITEM_STACK.getClazz();
        mc_ItemStack = ClassMapping.ITEM_STACK.getClazz();
        mc_NBTTagCompound = ClassMapping.NBT_TAG_COMPOUND.getClazz();
        mc_NBTTagList = ClassMapping.NBT_TAG_LIST.getClazz();
        if (cb_ItemStack != null) {
            try {
                if (ServerVersion.isServerVersionBelow(ServerVersion.V1_20)) {
                    mc_ItemStack_getTag = MethodMapping.MC_ITEM_STACK__GET_TAG.getMethod(mc_ItemStack);
                    mc_ItemStack_setTag = MethodMapping.MC_ITEM_STACK__SET_TAG.getMethod(mc_ItemStack);
                    mc_NBTTagCompound_set = MethodMapping.MC_NBT_TAG_COMPOUND__SET.getMethod(mc_NBTTagCompound);
                    mc_NBTTagCompound_remove = MethodMapping.MC_NBT_TAG_COMPOUND__REMOVE.getMethod(mc_NBTTagCompound);
                }
                cb_CraftItemStack_asNMSCopy = MethodMapping.CB_ITEM_STACK__AS_NMS_COPY.getMethod(cb_ItemStack);
                cb_CraftItemStack_asCraftMirror = MethodMapping.CB_ITEM_STACK__AS_CRAFT_MIRROR.getMethod(cb_ItemStack);
            }
            catch (Exception ex) {
                Logger.getLogger(ItemUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

